/*
 * Syncdaemon API
 *
 * Authors: Rodrigo Moya <rodrigo.moya@canonical.com>
 *
 * Copyright 2010 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef __SYNCDAEMON_DAEMON_H__
#define __SYNCDAEMON_DAEMON_H__

#include <glib-object.h>
#include "syncdaemon-authentication.h"
#include "syncdaemon-file-info.h"
#include "syncdaemon-folder-info.h"
#include "syncdaemon-interface.h"
#include "syncdaemon-share-info.h"
#include "syncdaemon-status-info.h"
#include "syncdaemon-transfer-info.h"

G_BEGIN_DECLS

#define SYNCDAEMON_TYPE_DAEMON                (syncdaemon_daemon_get_type ())
#define SYNCDAEMON_DAEMON(obj)                (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNCDAEMON_TYPE_DAEMON, SyncdaemonDaemon))
#define SYNCDAEMON_IS_DAEMON(obj)             (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNCDAEMON_TYPE_DAEMON))
#define SYNCDAEMON_DAEMON_CLASS(klass)        (G_TYPE_CHECK_CLASS_CAST ((klass), SYNCDAEMON_TYPE_DAEMON, SyncdaemonDaemonClass))
#define SYNCDAEMON_IS_DAEMON_CLASS(klass)     (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNCDAEMON_TYPE_DAEMON))
#define SYNCDAEMON_DAEMON_GET_CLASS(obj)      (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNCDAEMON_TYPE_DAEMON, SyncdaemonDaemonClass))

typedef struct _SyncdaemonDaemonPrivate SyncdaemonDaemonPrivate;

typedef struct {
	GObject parent;
	SyncdaemonDaemonPrivate *priv;
} SyncdaemonDaemon;

typedef struct {
	GObjectClass parent_class;

	/* Signals */
	void (* ready) (SyncdaemonDaemon *daemon);

	void (* connected) (SyncdaemonDaemon *daemon);
	void (* disconnected) (SyncdaemonDaemon *daemon);
	void (* status_changed) (SyncdaemonDaemon *daemon, SyncdaemonStatusInfo *status_info);

	void (* event) (SyncdaemonDaemon *daemon, GHashTable *event_dict);
	void (* error) (SyncdaemonDaemon *daemon, const gchar *signal, GHashTable *extra_args);

	void (* folder_created) (SyncdaemonDaemon *daemon, gboolean success, SyncdaemonFolderInfo *folder_info);
	void (* folder_deleted) (SyncdaemonDaemon *daemon, gboolean success, SyncdaemonFolderInfo *folder_info);
	void (* folder_subscribed) (SyncdaemonDaemon *daemon, gboolean success, SyncdaemonFolderInfo *folder_info);
	void (* folder_unsubscribed) (SyncdaemonDaemon *daemon, gboolean success, SyncdaemonFolderInfo *folder_info);

	void (* file_published) (SyncdaemonDaemon *daemon, gboolean success, SyncdaemonFileInfo *file_info);
	void (* got_published_files) (SyncdaemonDaemon *daemon, gboolean success, GSList *files);

	void (* share_created) (SyncdaemonDaemon *daemon, gboolean success, SyncdaemonShareInfo *share_info);
	void (* share_deleted) (SyncdaemonDaemon *daemon, gboolean success, SyncdaemonShareInfo *share_info);

	void (* download_started) (SyncdaemonDaemon *daemon, const gchar *path);
	void (* download_file_progress) (SyncdaemonDaemon *daemon, const gchar *path, SyncdaemonTransferInfo *tinfo);
	void (* download_finished) (SyncdaemonDaemon *daemon, const gchar *path, SyncdaemonTransferInfo *tinfo);
	void (* upload_started) (SyncdaemonDaemon *daemon, const gchar *path);
	void (* upload_file_progress) (SyncdaemonDaemon *daemon, const gchar *path, SyncdaemonTransferInfo *tinfo);
	void (* upload_finished) (SyncdaemonDaemon *daemon, const gchar *path, SyncdaemonTransferInfo *tinfo);

	void (* quota_exceeded) (SyncdaemonDaemon *daemon, GHashTable *volume_info);
} SyncdaemonDaemonClass;

GType                syncdaemon_daemon_get_type (void);

SyncdaemonDaemon    *syncdaemon_daemon_new (void);

gboolean             syncdaemon_daemon_is_ready (SyncdaemonDaemon *daemon);

gboolean             syncdaemon_daemon_connect (SyncdaemonDaemon *daemon);
gboolean             syncdaemon_daemon_disconnect (SyncdaemonDaemon *daemon);
gboolean             syncdaemon_daemon_quit (SyncdaemonDaemon *daemon);
const gchar         *syncdaemon_daemon_get_root_dir (SyncdaemonDaemon *daemon);

gboolean             syncdaemon_daemon_has_network (SyncdaemonDaemon *daemon);
SyncdaemonAuthentication *syncdaemon_daemon_get_authentication (SyncdaemonDaemon *daemon);

SyncdaemonInterface *syncdaemon_daemon_get_config_interface (SyncdaemonDaemon *daemon);
SyncdaemonInterface *syncdaemon_daemon_get_events_interface (SyncdaemonDaemon *daemon);
SyncdaemonInterface *syncdaemon_daemon_get_filesystem_interface (SyncdaemonDaemon *daemon);
SyncdaemonInterface *syncdaemon_daemon_get_folders_interface (SyncdaemonDaemon *daemon);
SyncdaemonInterface *syncdaemon_daemon_get_publicfiles_interface (SyncdaemonDaemon *daemon);
SyncdaemonInterface *syncdaemon_daemon_get_shares_interface (SyncdaemonDaemon *daemon);
SyncdaemonInterface *syncdaemon_daemon_get_status_interface (SyncdaemonDaemon *daemon);

G_END_DECLS

#endif
