# Copyright 2009-2010 Canonical Ltd.
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.

import urllib2
from twisted.trial.unittest import TestCase
from ubuntuone.api.restclient import RestClient
from oauth import oauth

class FakedResponse(object):
    """A fake response."""

    def __init__(self, *args, **kwargs):
        self.args = args
        self.kwargs = kwargs
        self.read = lambda: '{"field": "value"}'

def return_a_fake_response(*args, **kwargs):
    """Create a fake urllib2 response."""
    return FakedResponse(*args, **kwargs)

class RestClientTest(TestCase):
    """Test the RestClient object."""

    def test_call(self):
        """Tests calling a REST API method."""
        self.patch(urllib2, 'urlopen', return_a_fake_response)

        url = 'https://one.ubuntu.com/api'
        rest_client = RestClient(url)
        result = rest_client.call(url, "https",
                                  oauth.OAuthConsumer('ubuntuone', 'hammertime'),
                                  oauth.OAuthToken.from_string('oauth_token_secret=12345678ABC&oauth_token=12345678ABC'))
        self.assertTrue(result.has_key('field'))
        self.assertTrue(result['field'] == 'value')
