/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*-
 *
 * Authors: Alejandro J. Cura <alecu@canonical.com>
 *
 * Copyright (C) 2010 Canonical Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#ifndef __GSD_UBUNTUONE_H__
#define __GSD_UBUNTUONE_H__

#include <glib.h>
#include <glib-object.h>
#include <gmodule.h>

#include "gnome-settings-daemon/gnome-settings-plugin.h"
#include <libsyncdaemon/libsyncdaemon.h>

G_BEGIN_DECLS

#define GSD_TYPE_UBUNTUONE                (gsd_ubuntuone_get_type ())
#define GSD_UBUNTUONE(obj)                (G_TYPE_CHECK_INSTANCE_CAST ((obj), GSD_TYPE_UBUNTUONE, GsdUbuntuOne))
#define GSD_UBUNTUONE_CLASS(klass)        (G_TYPE_CHECK_CLASS_CAST((klass), GSD_TYPE_UBUNTUONE, GsdUbuntuOneClass))
#define GSD_IS_UBUNTUONE(obj)             (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GSD_TYPE_UBUNTUONE))
#define GSD_IS_UBUNTUONE_CLASS(klass)     (G_TYPE_CHECK_CLASS_TYPE ((klass), GSD_TYPE_UBUNTUONE))
#define GSD_UBUNTUONE_GET_CLASS(obj)      (G_TYPE_INSTANCE_GET_CLASS ((obj), GSD_TYPE_UBUNTUONE, GsdUbuntuOneClass))

typedef struct _GsdUbuntuOne GsdUbuntuOne;
typedef struct _GsdUbuntuOneClass GsdUbuntuOneClass;

struct _GsdUbuntuOne
{
	GnomeSettingsPlugin parent_instance;

	/*< private >*/
	SyncdaemonDaemon *syncdaemon;
        GHashTable *map_quota_dialogs;
};

struct _GsdUbuntuOneClass
{
	GnomeSettingsPluginClass parent_class;
};

GType gsd_ubuntuone_get_type (void);
G_MODULE_EXPORT GType register_gnome_settings_plugin (GTypeModule *module);

void gsd_ubuntuone_activate (GnomeSettingsPlugin *gsp_object);

G_END_DECLS

#endif
