/*
 * Syncdaemon API
 *
 * Authors: Rodrigo Moya <rodrigo.moya@canonical.com>
 *
 * Copyright 2010-2012 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations
 * including the two.
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * file(s) with this exception, you may extend this exception to your
 * version of the file(s), but you are not obligated to do so.  If you
 * do not wish to do so, delete this exception statement from your
 * version.  If you delete this exception statement from all source
 * files in the program, then also delete it here.
 *
 */

#ifndef __SYNCDAEMON_CREDENTIALS_H__
#define __SYNCDAEMON_CREDENTIALS_H__

#include <glib-object.h>

G_BEGIN_DECLS

#define SYNCDAEMON_TYPE_CREDENTIALS                (syncdaemon_credentials_get_type ())
#define SYNCDAEMON_CREDENTIALS(obj)                (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNCDAEMON_TYPE_CREDENTIALS, SyncdaemonCredentials))
#define SYNCDAEMON_IS_CREDENTIALS(obj)             (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNCDAEMON_TYPE_CREDENTIALS))
#define SYNCDAEMON_CREDENTIALS_CLASS(klass)        (G_TYPE_CHECK_CLASS_CAST ((klass), SYNCDAEMON_TYPE_CREDENTIALS, SyncdaemonCredentialsClass))
#define SYNCDAEMON_IS_CREDENTIALS_CLASS(klass)     (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNCDAEMON_TYPE_CREDENTIALS))
#define SYNCDAEMON_CREDENTIALS_GET_CLASS(obj)      (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNCDAEMON_TYPE_CREDENTIALS, SyncdaemonCredentialsClass))

typedef struct _SyncdaemonCredentialsPrivate SyncdaemonCredentialsPrivate;

typedef struct {
	GObject parent;
	SyncdaemonCredentialsPrivate *priv;
} SyncdaemonCredentials;

typedef struct {
	GObjectClass parent_class;
} SyncdaemonCredentialsClass;

GType                  syncdaemon_credentials_get_type (void);
SyncdaemonCredentials *syncdaemon_credentials_new (void);
SyncdaemonCredentials *syncdaemon_credentials_new_from_hash_table (GHashTable *hash);

const gchar           *syncdaemon_credentials_get_consumer_key (SyncdaemonCredentials *credentials);
void                   syncdaemon_credentials_set_consumer_key (SyncdaemonCredentials *credentials, const gchar *consumer_key);
const gchar           *syncdaemon_credentials_get_consumer_secret (SyncdaemonCredentials *credentials);
void                   syncdaemon_credentials_set_consumer_secret (SyncdaemonCredentials *credentials, const gchar *consumer_secret);
const gchar           *syncdaemon_credentials_get_token (SyncdaemonCredentials *credentials);
void                   syncdaemon_credentials_set_token (SyncdaemonCredentials *credentials, const gchar *token);
const gchar           *syncdaemon_credentials_get_token_secret (SyncdaemonCredentials *credentials);
void                   syncdaemon_credentials_set_token_secret (SyncdaemonCredentials *credentials, const gchar *token_secret);

G_END_DECLS

#endif
