var consoleService = Components.classes["@mozilla.org/consoleservice;1"]
    .getService(Components.interfaces.nsIConsoleService);
function UnityViewManager (contextManager, uwa) {
    this.contextManager = contextManager;
    this.uwa = uwa;
}

UnityViewManager.prototype.windowIsSelected = function (aWindow, window) {
    var mainWindow = window.QueryInterface(Components.interfaces.nsIInterfaceRequestor)
        .getInterface(Components.interfaces.nsIWebNavigation)
        .QueryInterface(Components.interfaces.nsIDocShellTreeItem)
        .rootTreeItem
        .QueryInterface(Components.interfaces.nsIInterfaceRequestor)
        .getInterface(Components.interfaces.nsIDOMWindow);
    
    if (mainWindow.gBrowser.contentWindow == window) {
	return true;
    } else {
	return false;
    }
}

UnityViewManager.prototype.setActiveView = function (context, window) {
	

    var activeContexts = this.contextManager.getActiveContexts(), i, activeContext;
    var mainWindow = window.QueryInterface(Components.interfaces.nsIInterfaceRequestor)
        .getInterface(Components.interfaces.nsIWebNavigation)
        .QueryInterface(Components.interfaces.nsIDocShellTreeItem)
        .rootTreeItem
        .QueryInterface(Components.interfaces.nsIInterfaceRequestor)
        .getInterface(Components.interfaces.nsIDOMWindow);

    
    for (i = 0; i < activeContexts.length; i++) {
	var activeContext = activeContexts[i];
	
	if ((context != activeContext) && (activeContext.mainWindow == mainWindow)) {
	    this.uwa.context_set_view_is_active (activeContext, 0);
	    activeContext.isActive = false;
	}
    }
    if (context == null) {
	return;
    }

    this.uwa.context_set_view_is_active (context, 1);
    context.isActive = true;

}

var EXPORTED_SYMBOLS = ["UnityViewManager"];
