/* dash-entry.c generated by valac 0.16.1, the Vala compiler
 * generated from dash-entry.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 4 -*-
 *
 * Copyright (C) 2012 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Michael Terry <michael.terry@canonical.com>
 */
/* Vala's vapi for gtk3 is broken for lookup_color (it forgets the out keyword) */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>
#include <pango/pangocairo.h>
#include <gio/gio.h>


#define TYPE_FADABLE (fadable_get_type ())
#define FADABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FADABLE, Fadable))
#define IS_FADABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FADABLE))
#define FADABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_FADABLE, FadableIface))

typedef struct _Fadable Fadable;
typedef struct _FadableIface FadableIface;

#define TYPE_FADE_TRACKER (fade_tracker_get_type ())
#define FADE_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FADE_TRACKER, FadeTracker))
#define FADE_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FADE_TRACKER, FadeTrackerClass))
#define IS_FADE_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FADE_TRACKER))
#define IS_FADE_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FADE_TRACKER))
#define FADE_TRACKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FADE_TRACKER, FadeTrackerClass))

typedef struct _FadeTracker FadeTracker;
typedef struct _FadeTrackerClass FadeTrackerClass;

#define TYPE_DASH_ENTRY (dash_entry_get_type ())
#define DASH_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DASH_ENTRY, DashEntry))
#define DASH_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DASH_ENTRY, DashEntryClass))
#define IS_DASH_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DASH_ENTRY))
#define IS_DASH_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DASH_ENTRY))
#define DASH_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DASH_ENTRY, DashEntryClass))

typedef struct _DashEntry DashEntry;
typedef struct _DashEntryClass DashEntryClass;
typedef struct _DashEntryPrivate DashEntryPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _pango_font_description_free0(var) ((var == NULL) ? NULL : (var = (pango_font_description_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _FadableIface {
	GTypeInterface parent_iface;
	FadeTracker* (*get_fade_tracker) (Fadable* self);
	void (*set_fade_tracker) (Fadable* self, FadeTracker* value);
};

struct _DashEntry {
	GtkEntry parent_instance;
	DashEntryPrivate * priv;
};

struct _DashEntryClass {
	GtkEntryClass parent_class;
};

struct _DashEntryPrivate {
	gchar* _constant_placeholder_text;
	gboolean _can_respond;
	gboolean _did_respond;
	FadeTracker* _fade_tracker;
	GdkRectangle icon_area;
};


static gpointer dash_entry_parent_class = NULL;
extern gchar* dash_entry_font;
gchar* dash_entry_font = NULL;
static FadableIface* dash_entry_fadable_parent_iface = NULL;

gboolean gtk_style_context_lookup_color (GtkStyleContext* ctx, const gchar* color_name, GdkRGBA* color);
void gtk_entry_get_icon_area (GtkEntry* entry, GtkEntryIconPosition icon_pos, GdkRectangle* icon_area);
GType fade_tracker_get_type (void) G_GNUC_CONST;
GType fadable_get_type (void) G_GNUC_CONST;
GType dash_entry_get_type (void) G_GNUC_CONST;
#define DASH_ENTRY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DASH_ENTRY, DashEntryPrivate))
enum  {
	DASH_ENTRY_DUMMY_PROPERTY,
	DASH_ENTRY_CONSTANT_PLACEHOLDER_TEXT,
	DASH_ENTRY_CAN_RESPOND,
	DASH_ENTRY_DID_RESPOND,
	DASH_ENTRY_FADE_TRACKER
};
#define DASH_ENTRY_NO_BORDER_CLASS "unity-greeter-no-border"
static gboolean dash_entry_real_draw (GtkWidget* base, cairo_t* c);
FadeTracker* fadable_get_fade_tracker (Fadable* self);
gdouble fade_tracker_get_alpha (FadeTracker* self);
const gchar* dash_entry_get_constant_placeholder_text (DashEntry* self);
static void dash_entry_draw_prompt_text (DashEntry* self, cairo_t* c);
gboolean dash_entry_get_did_respond (DashEntry* self);
static void dash_entry_draw_spinner (DashEntry* self, cairo_t* c);
static void dash_entry_real_activate (GtkEntry* base);
gboolean dash_entry_get_can_respond (DashEntry* self);
void dash_entry_set_did_respond (DashEntry* self, gboolean value);
static void dash_entry_icon_press_cb (DashEntry* self);
static void dash_entry_update_arrow (DashEntry* self);
void dash_entry_show_arrow (DashEntry* self, gboolean visible);
DashEntry* dash_entry_new (void);
DashEntry* dash_entry_construct (GType object_type);
void dash_entry_set_constant_placeholder_text (DashEntry* self, const gchar* value);
void dash_entry_set_can_respond (DashEntry* self, gboolean value);
static GObject * dash_entry_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
FadeTracker* fade_tracker_new (GtkWidget* widget);
FadeTracker* fade_tracker_construct (GType object_type, GtkWidget* widget);
void fadable_set_fade_tracker (Fadable* self, FadeTracker* value);
static void _dash_entry_update_arrow_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _dash_entry_update_arrow_gtk_editable_changed (GtkEditable* _sender, gpointer self);
static void _dash_entry_icon_press_cb_gtk_entry_icon_press (GtkEntry* _sender, GtkEntryIconPosition p0, GdkEvent* p1, gpointer self);
static void dash_entry_finalize (GObject* obj);
static void _vala_dash_entry_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_dash_entry_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean dash_entry_real_draw (GtkWidget* base, cairo_t* c) {
	DashEntry * self;
	gboolean result = FALSE;
	GtkStyleContext* _tmp0_ = NULL;
	GtkStyleContext* _tmp1_;
	GtkStyleContext* style_ctx;
	GtkStyleContext* _tmp2_;
	GtkStyleContext* _tmp3_;
	GtkStyleContext* _tmp4_;
	cairo_t* _tmp5_;
	cairo_t* _tmp6_;
	cairo_t* _tmp7_;
	cairo_t* _tmp8_;
	cairo_t* _tmp9_;
	FadeTracker* _tmp10_;
	FadeTracker* _tmp11_;
	gdouble _tmp12_;
	gdouble _tmp13_;
	cairo_t* _tmp14_;
	GtkStyleContext* _tmp15_;
	gboolean _tmp16_ = FALSE;
	guint16 _tmp17_ = 0U;
	gboolean _tmp21_;
	gboolean _tmp23_;
	gboolean _tmp24_;
	self = (DashEntry*) base;
	g_return_val_if_fail (c != NULL, FALSE);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	style_ctx = _tmp1_;
	_tmp2_ = style_ctx;
	gtk_style_context_save (_tmp2_);
	_tmp3_ = style_ctx;
	gtk_style_context_remove_class (_tmp3_, GTK_STYLE_CLASS_SPINNER);
	_tmp4_ = style_ctx;
	gtk_style_context_remove_class (_tmp4_, DASH_ENTRY_NO_BORDER_CLASS);
	_tmp5_ = c;
	cairo_save (_tmp5_);
	_tmp6_ = c;
	cairo_push_group (_tmp6_);
	_tmp7_ = c;
	GTK_WIDGET_CLASS (dash_entry_parent_class)->draw ((GtkWidget*) GTK_ENTRY (self), _tmp7_);
	_tmp8_ = c;
	cairo_pop_group_to_source (_tmp8_);
	_tmp9_ = c;
	_tmp10_ = fadable_get_fade_tracker ((Fadable*) self);
	_tmp11_ = _tmp10_;
	_tmp12_ = fade_tracker_get_alpha (_tmp11_);
	_tmp13_ = _tmp12_;
	cairo_paint_with_alpha (_tmp9_, _tmp13_);
	_tmp14_ = c;
	cairo_restore (_tmp14_);
	_tmp15_ = style_ctx;
	gtk_style_context_restore (_tmp15_);
	_tmp17_ = gtk_entry_get_text_length ((GtkEntry*) self);
	if (((gint) _tmp17_) == 0) {
		const gchar* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		_tmp18_ = self->priv->_constant_placeholder_text;
		_tmp19_ = strlen (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp16_ = _tmp20_ > 0;
	} else {
		_tmp16_ = FALSE;
	}
	_tmp21_ = _tmp16_;
	if (_tmp21_) {
		cairo_t* _tmp22_;
		_tmp22_ = c;
		dash_entry_draw_prompt_text (self, _tmp22_);
	}
	_tmp23_ = dash_entry_get_did_respond (self);
	_tmp24_ = _tmp23_;
	if (_tmp24_) {
		cairo_t* _tmp25_;
		_tmp25_ = c;
		dash_entry_draw_spinner (self, _tmp25_);
	}
	result = FALSE;
	_g_object_unref0 (style_ctx);
	return result;
}


static void dash_entry_draw_spinner (DashEntry* self, cairo_t* c) {
	GtkAllocation allocation = {0};
	GtkAllocation _tmp0_ = {0};
	GtkAllocation _tmp1_;
	gint _tmp2_;
	gint spinner_side;
	GtkAllocation _tmp3_;
	gint _tmp4_;
	gint margin;
	GtkStyleContext* _tmp5_ = NULL;
	GtkStyleContext* _tmp6_;
	GtkStyleContext* style_ctx;
	cairo_t* _tmp7_;
	GtkAllocation _tmp8_;
	gint _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp0_);
	allocation = _tmp0_;
	_tmp1_ = allocation;
	_tmp2_ = _tmp1_.height;
	spinner_side = _tmp2_ / 2;
	_tmp3_ = allocation;
	_tmp4_ = _tmp3_.height;
	margin = (_tmp4_ - spinner_side) / 2;
	_tmp5_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp6_ = _g_object_ref0 (_tmp5_);
	style_ctx = _tmp6_;
	_tmp7_ = c;
	_tmp8_ = allocation;
	_tmp9_ = _tmp8_.width;
	gtk_render_activity (style_ctx, _tmp7_, (gdouble) ((_tmp9_ - spinner_side) - margin), (gdouble) margin, (gdouble) spinner_side, (gdouble) spinner_side);
	_g_object_unref0 (style_ctx);
}


static void dash_entry_draw_prompt_text (DashEntry* self, cairo_t* c) {
	gint x = 0;
	gint y = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	cairo_t* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GdkRGBA fg = {0};
	GtkStyleContext* _tmp5_ = NULL;
	GtkStyleContext* _tmp6_;
	GtkStyleContext* context;
	GtkStyleContext* _tmp7_;
	GdkRGBA _tmp8_ = {0};
	gboolean _tmp9_ = FALSE;
	cairo_t* _tmp10_;
	GdkRGBA _tmp11_;
	gdouble _tmp12_;
	GdkRGBA _tmp13_;
	gdouble _tmp14_;
	GdkRGBA _tmp15_;
	gdouble _tmp16_;
	GdkRGBA _tmp17_;
	gdouble _tmp18_;
	const gchar* _tmp19_;
	PangoLayout* _tmp20_ = NULL;
	PangoLayout* layout;
	PangoFontDescription* _tmp21_ = NULL;
	PangoFontDescription* _tmp22_;
	cairo_t* _tmp23_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	gtk_entry_get_layout_offsets ((GtkEntry*) self, &_tmp0_, &_tmp1_);
	x = _tmp0_;
	y = _tmp1_;
	_tmp2_ = c;
	_tmp3_ = x;
	_tmp4_ = y;
	cairo_move_to (_tmp2_, (gdouble) _tmp3_, (gdouble) _tmp4_);
	memset (&fg, 0, sizeof (GdkRGBA));
	_tmp5_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp6_ = _g_object_ref0 (_tmp5_);
	context = _tmp6_;
	_tmp7_ = context;
	_tmp9_ = gtk_style_context_lookup_color (_tmp7_, "placeholder_text_color", &_tmp8_);
	fg = _tmp8_;
	if (!_tmp9_) {
		gdk_rgba_parse (&fg, "#888");
	}
	_tmp10_ = c;
	_tmp11_ = fg;
	_tmp12_ = _tmp11_.red;
	_tmp13_ = fg;
	_tmp14_ = _tmp13_.green;
	_tmp15_ = fg;
	_tmp16_ = _tmp15_.blue;
	_tmp17_ = fg;
	_tmp18_ = _tmp17_.alpha;
	cairo_set_source_rgba (_tmp10_, _tmp12_, _tmp14_, _tmp16_, _tmp18_);
	_tmp19_ = self->priv->_constant_placeholder_text;
	_tmp20_ = gtk_widget_create_pango_layout ((GtkWidget*) self, _tmp19_);
	layout = _tmp20_;
	_tmp21_ = pango_font_description_from_string ("Ubuntu 13");
	_tmp22_ = _tmp21_;
	pango_layout_set_font_description (layout, _tmp22_);
	_pango_font_description_free0 (_tmp22_);
	_tmp23_ = c;
	pango_cairo_show_layout (_tmp23_, layout);
	_g_object_unref0 (layout);
	_g_object_unref0 (context);
}


static void dash_entry_real_activate (GtkEntry* base) {
	DashEntry * self;
	gboolean _tmp0_;
	self = (DashEntry*) base;
	GTK_ENTRY_CLASS (dash_entry_parent_class)->activate (GTK_ENTRY (self));
	_tmp0_ = self->priv->_can_respond;
	if (_tmp0_) {
		dash_entry_set_did_respond (self, TRUE);
		g_signal_emit_by_name (self, "respond");
	} else {
		GtkWidget* _tmp1_ = NULL;
		_tmp1_ = gtk_widget_get_toplevel ((GtkWidget*) self);
		gtk_widget_child_focus (_tmp1_, GTK_DIR_TAB_FORWARD);
	}
}


static void dash_entry_icon_press_cb (DashEntry* self) {
	g_return_if_fail (self != NULL);
	g_signal_emit_by_name ((GtkEntry*) self, "activate");
}


static void dash_entry_update_arrow (DashEntry* self) {
	guint16 _tmp0_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_entry_get_text_length ((GtkEntry*) self);
	dash_entry_show_arrow (self, ((gint) _tmp0_) != 0);
}


void dash_entry_show_arrow (DashEntry* self, gboolean visible) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	gboolean _tmp4_;
	gboolean _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp2_ = visible;
	if (_tmp2_) {
		gboolean _tmp3_;
		_tmp3_ = self->priv->_can_respond;
		_tmp1_ = _tmp3_;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp4_ = _tmp1_;
	if (_tmp4_) {
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp5_ = dash_entry_get_did_respond (self);
		_tmp6_ = _tmp5_;
		_tmp0_ = !_tmp6_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp7_ = _tmp0_;
	if (_tmp7_) {
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		GFile* _tmp10_ = NULL;
		GFile* _tmp11_;
		GFile* file;
		GFile* _tmp12_;
		GFileIcon* _tmp13_;
		GFileIcon* icon;
		GFileIcon* _tmp14_;
		GdkRectangle _tmp15_ = {0};
		_tmp8_ = g_build_filename (PKGDATADIR, "arrow_right.png", NULL, NULL);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_file_new_for_path (_tmp9_);
		_tmp11_ = _tmp10_;
		_g_free0 (_tmp9_);
		file = _tmp11_;
		_tmp12_ = file;
		_tmp13_ = (GFileIcon*) g_file_icon_new (_tmp12_);
		icon = _tmp13_;
		_tmp14_ = icon;
		gtk_entry_set_icon_from_gicon ((GtkEntry*) self, GTK_ENTRY_ICON_SECONDARY, (GIcon*) _tmp14_);
		gtk_entry_set_icon_activatable ((GtkEntry*) self, GTK_ENTRY_ICON_SECONDARY, TRUE);
		gtk_entry_get_icon_area ((GtkEntry*) self, GTK_ENTRY_ICON_SECONDARY, &_tmp15_);
		self->priv->icon_area = _tmp15_;
		_g_object_unref0 (icon);
		_g_object_unref0 (file);
	} else {
		gtk_entry_set_icon_from_gicon ((GtkEntry*) self, GTK_ENTRY_ICON_SECONDARY, NULL);
	}
}


DashEntry* dash_entry_construct (GType object_type) {
	DashEntry * self = NULL;
	self = (DashEntry*) g_object_new (object_type, NULL);
	return self;
}


DashEntry* dash_entry_new (void) {
	return dash_entry_construct (TYPE_DASH_ENTRY);
}


const gchar* dash_entry_get_constant_placeholder_text (DashEntry* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_constant_placeholder_text;
	result = _tmp0_;
	return result;
}


void dash_entry_set_constant_placeholder_text (DashEntry* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_constant_placeholder_text);
	self->priv->_constant_placeholder_text = _tmp1_;
	g_object_notify ((GObject *) self, "constant-placeholder-text");
}


gboolean dash_entry_get_can_respond (DashEntry* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_can_respond;
	result = _tmp0_;
	return result;
}


void dash_entry_set_can_respond (DashEntry* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_can_respond = _tmp0_;
	g_object_notify ((GObject *) self, "can-respond");
}


gboolean dash_entry_get_did_respond (DashEntry* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_did_respond;
	result = _tmp0_;
	return result;
}


void dash_entry_set_did_respond (DashEntry* self, gboolean value) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_did_respond = _tmp0_;
	_tmp1_ = value;
	if (_tmp1_) {
		gtk_widget_set_state_flags ((GtkWidget*) self, GTK_STATE_FLAG_ACTIVE, FALSE);
	} else {
		gtk_widget_unset_state_flags ((GtkWidget*) self, GTK_STATE_FLAG_ACTIVE);
	}
	dash_entry_update_arrow (self);
	g_object_notify ((GObject *) self, "did-respond");
}


static FadeTracker* dash_entry_real_get_fade_tracker (Fadable* base) {
	FadeTracker* result;
	DashEntry* self;
	FadeTracker* _tmp0_;
	self = (DashEntry*) base;
	_tmp0_ = self->priv->_fade_tracker;
	result = _tmp0_;
	return result;
}


static void dash_entry_real_set_fade_tracker (Fadable* base, FadeTracker* value) {
	DashEntry* self;
	FadeTracker* _tmp0_;
	FadeTracker* _tmp1_;
	self = (DashEntry*) base;
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_fade_tracker);
	self->priv->_fade_tracker = _tmp1_;
	g_object_notify ((GObject *) self, "fade-tracker");
}


static void _dash_entry_update_arrow_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	dash_entry_update_arrow (self);
}


static void _dash_entry_update_arrow_gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	dash_entry_update_arrow (self);
}


static void _dash_entry_icon_press_cb_gtk_entry_icon_press (GtkEntry* _sender, GtkEntryIconPosition p0, GdkEvent* p1, gpointer self) {
	dash_entry_icon_press_cb (self);
}


static GObject * dash_entry_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DashEntry * self;
	FadeTracker* _tmp0_;
	FadeTracker* _tmp1_;
	const gchar* _tmp2_;
	PangoFontDescription* _tmp3_ = NULL;
	PangoFontDescription* _tmp4_;
	GtkStyleContext* _tmp5_ = NULL;
	GtkStyleContext* _tmp6_;
	GtkStyleContext* style_ctx;
	GtkCssProvider* _tmp7_;
	GtkCssProvider* no_border_provider;
	GtkStyleContext* _tmp13_;
	GtkCssProvider* _tmp14_;
	GtkStyleContext* _tmp15_;
	GtkStyleContext* _tmp16_;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (dash_entry_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DASH_ENTRY (obj);
	_tmp0_ = fade_tracker_new ((GtkWidget*) self);
	_tmp1_ = _tmp0_;
	fadable_set_fade_tracker ((Fadable*) self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	g_signal_connect_object ((GObject*) self, "notify::can-respond", (GCallback) _dash_entry_update_arrow_g_object_notify, self, 0);
	g_signal_connect_object ((GtkEditable*) self, "changed", (GCallback) _dash_entry_update_arrow_gtk_editable_changed, self, 0);
	g_signal_connect_object ((GtkEntry*) self, "icon-press", (GCallback) _dash_entry_icon_press_cb_gtk_entry_icon_press, self, 0);
	_tmp2_ = dash_entry_font;
	_tmp3_ = pango_font_description_from_string (_tmp2_);
	_tmp4_ = _tmp3_;
	gtk_widget_override_font ((GtkWidget*) self, _tmp4_);
	_pango_font_description_free0 (_tmp4_);
	_tmp5_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp6_ = _g_object_ref0 (_tmp5_);
	style_ctx = _tmp6_;
	_tmp7_ = gtk_css_provider_new ();
	no_border_provider = _tmp7_;
	{
		gchar* _tmp8_ = NULL;
		gchar* css;
		GtkCssProvider* _tmp9_;
		const gchar* _tmp10_;
		_tmp8_ = g_strdup_printf (".%s {border: 0px;}", DASH_ENTRY_NO_BORDER_CLASS);
		css = _tmp8_;
		_tmp9_ = no_border_provider;
		_tmp10_ = css;
		gtk_css_provider_load_from_data (_tmp9_, _tmp10_, (gssize) (-1), &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_free0 (css);
			goto __catch5_g_error;
		}
		_g_free0 (css);
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		GError* _tmp11_;
		const gchar* _tmp12_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		g_debug ("dash-entry.vala:84: Internal error loading spinner style: %s", _tmp12_);
		_g_error_free0 (e);
	}
	__finally5:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (no_border_provider);
		_g_object_unref0 (style_ctx);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	_tmp13_ = style_ctx;
	_tmp14_ = no_border_provider;
	gtk_style_context_add_provider (_tmp13_, (GtkStyleProvider*) _tmp14_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_tmp15_ = style_ctx;
	gtk_style_context_add_class (_tmp15_, DASH_ENTRY_NO_BORDER_CLASS);
	_tmp16_ = style_ctx;
	gtk_style_context_add_class (_tmp16_, GTK_STYLE_CLASS_SPINNER);
	_g_object_unref0 (no_border_provider);
	_g_object_unref0 (style_ctx);
	return obj;
}


static void dash_entry_class_init (DashEntryClass * klass) {
	gchar* _tmp0_;
	dash_entry_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DashEntryPrivate));
	GTK_WIDGET_CLASS (klass)->draw = dash_entry_real_draw;
	GTK_ENTRY_CLASS (klass)->activate = dash_entry_real_activate;
	G_OBJECT_CLASS (klass)->get_property = _vala_dash_entry_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dash_entry_set_property;
	G_OBJECT_CLASS (klass)->constructor = dash_entry_constructor;
	G_OBJECT_CLASS (klass)->finalize = dash_entry_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DASH_ENTRY_CONSTANT_PLACEHOLDER_TEXT, g_param_spec_string ("constant-placeholder-text", "constant-placeholder-text", "constant-placeholder-text", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DASH_ENTRY_CAN_RESPOND, g_param_spec_boolean ("can-respond", "can-respond", "can-respond", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DASH_ENTRY_DID_RESPOND, g_param_spec_boolean ("did-respond", "did-respond", "did-respond", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DASH_ENTRY_FADE_TRACKER, g_param_spec_object ("fade-tracker", "fade-tracker", "fade-tracker", TYPE_FADE_TRACKER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("respond", TYPE_DASH_ENTRY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	_tmp0_ = g_strdup ("Ubuntu 14");
	dash_entry_font = _tmp0_;
}


static void dash_entry_fadable_interface_init (FadableIface * iface) {
	dash_entry_fadable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_fade_tracker = dash_entry_real_get_fade_tracker;
	iface->set_fade_tracker = dash_entry_real_set_fade_tracker;
}


static void dash_entry_instance_init (DashEntry * self) {
	self->priv = DASH_ENTRY_GET_PRIVATE (self);
	self->priv->_can_respond = TRUE;
}


static void dash_entry_finalize (GObject* obj) {
	DashEntry * self;
	self = DASH_ENTRY (obj);
	_g_free0 (self->priv->_constant_placeholder_text);
	_g_object_unref0 (self->priv->_fade_tracker);
	G_OBJECT_CLASS (dash_entry_parent_class)->finalize (obj);
}


GType dash_entry_get_type (void) {
	static volatile gsize dash_entry_type_id__volatile = 0;
	if (g_once_init_enter (&dash_entry_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DashEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dash_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DashEntry), 0, (GInstanceInitFunc) dash_entry_instance_init, NULL };
		static const GInterfaceInfo fadable_info = { (GInterfaceInitFunc) dash_entry_fadable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType dash_entry_type_id;
		dash_entry_type_id = g_type_register_static (GTK_TYPE_ENTRY, "DashEntry", &g_define_type_info, 0);
		g_type_add_interface_static (dash_entry_type_id, TYPE_FADABLE, &fadable_info);
		g_once_init_leave (&dash_entry_type_id__volatile, dash_entry_type_id);
	}
	return dash_entry_type_id__volatile;
}


static void _vala_dash_entry_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DashEntry * self;
	self = DASH_ENTRY (object);
	switch (property_id) {
		case DASH_ENTRY_CONSTANT_PLACEHOLDER_TEXT:
		g_value_set_string (value, dash_entry_get_constant_placeholder_text (self));
		break;
		case DASH_ENTRY_CAN_RESPOND:
		g_value_set_boolean (value, dash_entry_get_can_respond (self));
		break;
		case DASH_ENTRY_DID_RESPOND:
		g_value_set_boolean (value, dash_entry_get_did_respond (self));
		break;
		case DASH_ENTRY_FADE_TRACKER:
		g_value_set_object (value, fadable_get_fade_tracker ((Fadable*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dash_entry_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DashEntry * self;
	self = DASH_ENTRY (object);
	switch (property_id) {
		case DASH_ENTRY_CONSTANT_PLACEHOLDER_TEXT:
		dash_entry_set_constant_placeholder_text (self, g_value_get_string (value));
		break;
		case DASH_ENTRY_CAN_RESPOND:
		dash_entry_set_can_respond (self, g_value_get_boolean (value));
		break;
		case DASH_ENTRY_DID_RESPOND:
		dash_entry_set_did_respond (self, g_value_get_boolean (value));
		break;
		case DASH_ENTRY_FADE_TRACKER:
		fadable_set_fade_tracker ((Fadable*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



