#!/usr/bin/python3
# -*- Mode: Python; indent-tabs-mode: nil; tab-width: 4; coding: utf-8 -*-

import logging
import sys
import unittest
from mock import patch

from UpdateManager.UpdateManager import UpdateManager
from UpdateManager.UpdatesAvailable import UpdatesAvailable
from UpdateManager import Dialogs

import os
CURDIR = os.path.dirname(os.path.abspath(__file__))


class TestStopUpdate(unittest.TestCase):

    def setUp(self):
        patcher = patch('UpdateManager.UpdateManager.UpdateManager')
        self.addCleanup(patcher.stop)
        self.manager = patcher.start()
        self.manager._check_meta_release.return_value = False
        self.manager.datadir = os.path.join(CURDIR, '..', 'data')

    def test_stop_no_updates(self):
        # install_count, need_reboot, cancelled_update
        p = UpdateManager._make_available_pane(self.manager, 0, False, True)
        self.assertIsInstance(p, Dialogs.StoppedUpdatesDialog)

    def test_no_stop_no_updates(self):
        # install_count, need_reboot, cancelled_update
        p = UpdateManager._make_available_pane(self.manager, 0, False, False)
        self.assertNotIsInstance(p, Dialogs.StoppedUpdatesDialog)

    def test_stop_updates(self):
        # install_count, need_reboot, cancelled_update
        p = UpdateManager._make_available_pane(self.manager, 1, False, True)
        self.assertIsInstance(p, UpdatesAvailable)
        self.assertIsNotNone(p.custom_header)

    def test_no_stop_updates(self):
        p = UpdateManager._make_available_pane(self.manager, 1, False, False)
        self.assertIsInstance(p, UpdatesAvailable)
        self.assertIsNone(p.custom_header)

if __name__ == '__main__':
    if len(sys.argv) > 1 and sys.argv[1] == "-v":
        logging.basicConfig(level=logging.DEBUG)
    unittest.main()
