/* l_lx_pti86.h -- created from l_lx_pti86.bin, 6546 (0x1992) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2005 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2005 Laszlo Molnar
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <mfx@users.sourceforge.net>          <ml1050@users.sourceforge.net>
 */


#define LINUX_I386PTI_LOADER_ADLER32 0x0cc7d0ff
#define LINUX_I386PTI_LOADER_CRC32   0x04a4071e

unsigned char linux_i386pti_loader[6546] = {
204,232, 28,  0,  0,  0,131,248, 70,185,210,  5,  0,  0,116, 15,   /* 0x   0 */
131,248, 73,185,210,  5,  0,  0,116,  5,185, 33,  0,  0,  0,137,   /* 0x  10 */
200,195,232,  0,  0,  0,  0,131,248,  2,185, 84,  0,  0,  0,116,   /* 0x  20 */
238,131,248,  5,185, 84,  0,  0,  0,116,228,131,248,  8,185, 84,   /* 0x  30 */
  0,  0,  0,116,218,131,248, 11,185, 84,  0,  0,  0,116,208,233,   /* 0x  40 */
198,255,255,255, 96,131,205,255,139,116, 36, 36,139,124, 36, 44,   /* 0x  50 */
235,  0,164,235,  0,138,  6, 70,136,  7, 71,  1,219,117,  7,139,   /* 0x  60 */
 30,131,238,252, 17,219,114,  0, 49,192, 64,138,  7,114,  0,184,   /* 0x  70 */
  1,  0,  0,  0,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,   /* 0x  80 */
192,  1,219,117,  7,139, 30,131,238,252, 17,219,115,  0,  1,219,   /* 0x  90 */
115,  0,117,  9,139, 30,131,238,252, 17,219,115,  0, 49,201,131,   /* 0x  a0 */
232,  3,114, 13,193,224,  8,138,  6, 70,131,240,255,116,  0,137,   /* 0x  b0 */
197,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,201,  1,219,   /* 0x  c0 */
117,  7,139, 30,131,238,252, 17,219, 17,201,117,  0, 65,  1,219,   /* 0x  d0 */
117,  7,139, 30,131,238,252, 17,219, 17,201,  1,219,117,  7,139,   /* 0x  e0 */
 30,131,238,252, 17,219,115,  0,  1,219,115,  0,117,  9,139, 30,   /* 0x  f0 */
131,238,252, 17,219,115,  0, 65, 65,131,193,  2,129,253,  0,243,   /* 0x 100 */
255,255,131,209,  1, 86,141, 52, 47,243,164, 94,233,  0,  0,  0,   /* 0x 110 */
  0,141, 20, 47,131,253,252,138,  4, 15,118,  0,138,  2, 66,136,   /* 0x 120 */
  7, 71, 73,117,247,233,  0,  0,  0,  0,139,  2,131,194,  4,137,   /* 0x 130 */
  7,131,199,  4,131,233,  4,119,241,  1,207,233,  0,  0,  0,  0,   /* 0x 140 */
235,  0,164,235,  0,138,  6, 70,136,  7, 71,  1,219,117,  7,139,   /* 0x 150 */
 30,131,238,252, 17,219,114,  0, 49,192, 64,138,  7,114,  0,184,   /* 0x 160 */
  1,  0,  0,  0,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,   /* 0x 170 */
192,  1,219,117,  7,139, 30,131,238,252, 17,219,114,  0,  1,219,   /* 0x 180 */
115, 11,117,  0,139, 30,131,238,252, 17,219,114,  0, 72,  1,219,   /* 0x 190 */
117,  7,139, 30,131,238,252, 17,219, 17,192,235,  0, 49,201,131,   /* 0x 1a0 */
232,  3,114, 17,193,224,  8,138,  6, 70,131,240,255,116,  0,209,   /* 0x 1b0 */
248,137,197,235, 11,  1,219,117,  7,139, 30,131,238,252, 17,219,   /* 0x 1c0 */
 17,201,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,201,117,   /* 0x 1d0 */
  0, 65,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,201,  1,   /* 0x 1e0 */
219,117,  7,139, 30,131,238,252, 17,219,115,  0,  1,219,115,  0,   /* 0x 1f0 */
117,  9,139, 30,131,238,252, 17,219,115,  0, 65, 65,131,193,  2,   /* 0x 200 */
129,253,  0,251,255,255,131,209,  1, 86,141, 52, 47,243,164, 94,   /* 0x 210 */
233,  0,  0,  0,  0,141, 20, 47,131,253,252,138,  4, 15,118,  0,   /* 0x 220 */
138,  2, 66,136,  7, 71, 73,117,247,233,  0,  0,  0,  0,139,  2,   /* 0x 230 */
131,194,  4,137,  7,131,199,  4,131,233,  4,119,241,  1,207,233,   /* 0x 240 */
  0,  0,  0,  0,235,  0,164,235,  0,138,  6, 70,136,  7, 71,  1,   /* 0x 250 */
219,117,  7,139, 30,131,238,252, 17,219,114,  0, 49,192, 64,138,   /* 0x 260 */
  7,114,  0,184,  1,  0,  0,  0,  1,219,117,  7,139, 30,131,238,   /* 0x 270 */
252, 17,219, 17,192,  1,219,117,  7,139, 30,131,238,252, 17,219,   /* 0x 280 */
114,  0,  1,219,115, 11,117,  0,139, 30,131,238,252, 17,219,114,   /* 0x 290 */
  0, 72,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,192,235,   /* 0x 2a0 */
  0,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,201,235,  0,   /* 0x 2b0 */
 49,201,131,232,  3,114, 17,193,224,  8,138,  6, 70,131,240,255,   /* 0x 2c0 */
116,  0,209,248,137,197,235, 11,  1,219,117,  7,139, 30,131,238,   /* 0x 2d0 */
252, 17,219,114,204, 65,  1,219,117,  7,139, 30,131,238,252, 17,   /* 0x 2e0 */
219,114,190,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,201,   /* 0x 2f0 */
  1,219,117,  7,139, 30,131,238,252, 17,219,115,  0,  1,219,115,   /* 0x 300 */
  0,117,  9,139, 30,131,238,252, 17,219,115,  0, 65, 65,131,193,   /* 0x 310 */
  2,129,253,  0,251,255,255,131,209,  2, 86,141, 52, 47,243,164,   /* 0x 320 */
 94,233,  0,  0,  0,  0,141, 20, 47,131,253,252,138,  4, 15,118,   /* 0x 330 */
  0,138,  2, 66,136,  7, 71, 73,117,247,233,  0,  0,  0,  0,139,   /* 0x 340 */
  2,131,194,  4,137,  7,131,199,  4,131,233,  4,119,241,  1,207,   /* 0x 350 */
233,  0,  0,  0,  0,255,210,  1,219,117,  2,255,210,144,232,  0,   /* 0x 360 */
  0,  0,  0,  1,219,116,  0,195,139, 30,131,238,252, 17,219,195,   /* 0x 370 */
 41,201, 17,201,114,  0, 17,201,114,  0, 17,201, 17,192, 72, 17,   /* 0x 380 */
192,131,233,  1,115,  0,141, 72, 15, 61,240,255,  0,  0,114,  0,   /* 0x 390 */
141,  4, 14, 80,233,  0,  0,  0,  0, 17,201, 17,201,131,193, 13,   /* 0x 3a0 */
235,  0,133,201,116,  0, 65,131,193,  8,235,  0, 41,201, 90, 41,   /* 0x 3b0 */
219,141, 65,  1,115,  0,114,  0,114,  0,114,  0,131,193,  2,114,   /* 0x 3c0 */
  0, 65,114,  5,233,  0,  0,  0,  0, 17,201,209,233,115,  1,164,   /* 0x 3d0 */
209,233,115,  2,102,165,243,165,141, 65,  1,235,  3,164,164,164,   /* 0x 3e0 */
 17,192,115,  0,131,232,  3,114, 11,193,224,  8,172,131,240,255,   /* 0x 3f0 */
116,  0,137,197, 17,201, 17,201,117,  0, 65, 17,201,115,  0,131,   /* 0x 400 */
193,  2,129,253,  0,243,255,255,131,209,  1, 86,141, 52, 47,131,   /* 0x 410 */
253,252,119, 19,209,233,115,  1,164,209,233,115,  2,102,165,243,   /* 0x 420 */
165, 94,233,  0,  0,  0,  0,131,253,255,117,  5,172,243,170,235,   /* 0x 430 */
240,243,164,235,236,233,  0,  0,  0,  0,139, 84, 36, 36,  3, 84,   /* 0x 440 */
 36, 40, 57,214,116,  1, 72, 43,124, 36, 44,139, 84, 36, 48,137,   /* 0x 450 */
 58,137, 68, 36, 28, 97,195,185, 84, 69, 88, 76,138,  7, 71, 44,   /* 0x 460 */
232, 60,  1,119,247,128, 63, 63,117,  0,139,  7,138, 95,  4,102,   /* 0x 470 */
193,232,  8,134,196,193,192, 16,134,196, 41,248,128,235,232,137,   /* 0x 480 */
  7,131,199,  5,136,216,226,  0,185, 84, 69, 88, 76,176,232,176,   /* 0x 490 */
233,242,174,117,  0,128, 63, 63,117,  0,139,  7,102,193,232,  8,   /* 0x 4a0 */
134,196,193,192, 16,134,196, 41,248,171,235,  0,235,  0, 90, 88,   /* 0x 4b0 */
 89,151, 96, 49,219,187, 78, 77, 82, 85,106, 15, 88,138,100, 36,   /* 0x 4c0 */
 32,106, 15, 91,138,124, 36, 32,138, 84, 36, 32,233,  0,  0,  0,   /* 0x 4d0 */
  0, 15,183, 47, 43,110, 12, 41,221,117,  0,131,237,  1,115,  0,   /* 0x 4e0 */
136, 95,255, 73,136,  7, 71,139,  7,156,102,193,232,  8,193,192,   /* 0x 4f0 */
 16,134,196,157,115,  0,176,  0, 15,200,115,  0,209,232,115,  0,   /* 0x 500 */
254,203, 75, 35, 30,125,  2,  3, 30,137,  4,156,235,  0,141, 20,   /* 0x 510 */
 24, 15,182,210, 35, 22, 59, 22,114,  2, 43, 22,139,  4,148,254,   /* 0x 520 */
203, 75, 35, 30,125,  2,  3, 30,139, 44,156,133,237,117,  0, 80,   /* 0x 530 */
139, 70,  4,254,200, 72, 35,  6,125,  2,  3,  6, 49,237,137, 70,   /* 0x 540 */
  4,135,108,132,  4, 88,137, 44,148,137,  4,156, 41,248,131,233,   /* 0x 550 */
  4,  3, 70, 16,  1,240,137,  7,131,199,  4,235,  0,235,  0, 80,   /* 0x 560 */
176,233,176,232, 80,106,  0, 83,137,230, 94,137,218,178,233,178,   /* 0x 570 */
232, 67,106,  0,254,203, 75,117,  0, 15,183,  7,131,199,  1, 60,   /* 0x 580 */
128,114,  4, 60,143,118,  0, 41,208, 43, 70,  8,131,232,  2,116,   /* 0x 590 */
  0,131,232,  1,114,  0,115,  0,122,  0,123,  0,248,235,  0,131,   /* 0x 5a0 */
233,  1,127,  0,137,231,185,  4,  1,  0,  0,139, 14,131,193,  5,   /* 0x 5b0 */
139, 14,131,193,  4, 49,192,243,171,137,252, 86, 97,151, 81, 80,   /* 0x 5c0 */
 82,195, 96,139,124, 36, 36,139, 76, 36, 40,139, 84, 36, 44,137,   /* 0x 5d0 */
254,235,  0,138,  7,131,199,  1, 60,128,114, 10, 60,143,119,  6,   /* 0x 5e0 */
128,127,254, 15,116,  0, 44,232, 60,  1,119,  0, 56, 23,117,  0,   /* 0x 5f0 */
139,  7,102,193,232,  8,193,192, 16,134,196, 41,248,  1,240,137,   /* 0x 600 */
  7,131,199,  4,131,233,  4,138,  7,131,199,  1,226,  0,131,233,   /* 0x 610 */
  1,127,  0, 97,195,  0,  0,  0, 76, 88, 80, 84, 73, 48, 48, 48,   /* 0x 620 */
  0,  0,  0,  0,  0,  0,  0,  0,  0, 39,  0,  0,  0, 76, 88, 80,   /* 0x 630 */
 84, 73, 50, 48, 48,  0,  0,  0,  0,  0, 76, 88, 80, 84, 73, 48,   /* 0x 640 */
 52, 48,  0, 84,  0,  0,  0, 76, 88, 80, 84, 73, 48, 52, 49,  0,   /* 0x 650 */
 84,  0,  0,  0, 76, 88, 80, 84, 73, 48, 52, 50,  0, 84,  0,  0,   /* 0x 660 */
  0, 76, 88, 80, 84, 73, 48, 52, 51,  0, 84,  0,  0,  0, 76, 88,   /* 0x 670 */
 80, 84, 73, 48, 53, 48,  0, 84,  0,  0,  0, 78, 50, 66, 83, 77,   /* 0x 680 */
 65, 49, 48,  0, 96,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,   /* 0x 690 */
 78, 50, 66, 68, 69, 67, 49, 48,  0,  4,  0,  0,  0, 78, 50, 66,   /* 0x 6a0 */
 70, 65, 83, 49, 48,  0, 99,  0,  0,  0,  0,  0,  0,  0,101,  0,   /* 0x 6b0 */
  0,  0, 78, 50, 66, 68, 69, 67, 49, 48,  0,  4,  0,  0,  0, 78,   /* 0x 6c0 */
 50, 66, 70, 65, 83, 49, 49,  0,101,  0,  0,  0, 78, 50, 66, 68,   /* 0x 6d0 */
 69, 67, 49, 48,  0,107,  0,  0,  0, 78, 50, 66, 83, 77, 65, 50,   /* 0x 6e0 */
 48,  0,118,  0,  0,  0,  0,  0,  0,  0,120,  0,  0,  0, 78, 50,   /* 0x 6f0 */
 66, 83, 77, 65, 49, 48,  0,  2,  0,  0,  0, 78, 50, 66, 70, 65,   /* 0x 700 */
 83, 50, 48,  0,123,  0,  0,  0,  0,  0,  0,  0,127,  0,  0,  0,   /* 0x 710 */
 78, 50, 66, 70, 65, 83, 49, 49,  0,  0,  0,  0,  0, 78, 50, 66,   /* 0x 720 */
 68, 69, 67, 50, 48,  0,132,  0,  0,  0, 78, 50, 66, 83, 77, 65,   /* 0x 730 */
 51, 48,  0,145,  0,  0,  0,  0,  0,  0,  0,158,  0,  0,  0, 78,   /* 0x 740 */
 50, 66, 68, 69, 67, 50, 48,  0,  0,  0,  0,  0, 78, 50, 66, 70,   /* 0x 750 */
 65, 83, 51, 48,  0,158,  0,  0,  0,  0,  0,  0,  0,162,  0,  0,   /* 0x 760 */
  0, 78, 50, 66, 68, 69, 67, 50, 48,  0,  0,  0,  0,  0,  0,  0,   /* 0x 770 */
  0,  0,173,  0,  0,  0, 78, 50, 66, 68, 69, 67, 50, 48,  0,  0,   /* 0x 780 */
  0,  0,  0, 78, 50, 66, 68, 69, 67, 51, 48,  0,173,  0,  0,  0,   /* 0x 790 */
  0,  0,  0,  0,191,  0,  0,  0, 78, 50, 66, 68, 69, 67, 54, 48,   /* 0x 7a0 */
  0,  0,  0,  0,  0,  0,  0,  0,  0,221,  0,  0,  0, 78, 50, 66,   /* 0x 7b0 */
 68, 69, 67, 53, 48,  0,  0,  0,  0,  0, 78, 50, 66, 83, 77, 65,   /* 0x 7c0 */
 52, 48,  0,235,  0,  0,  0,  0,  0,  0,  0,248,  0,  0,  0, 78,   /* 0x 7d0 */
 50, 66, 68, 69, 67, 51, 48,  0, 49,  0,  0,  0, 78, 50, 66, 70,   /* 0x 7e0 */
 65, 83, 52, 48,  0,248,  0,  0,  0,  0,  0,  0,  0,252,  0,  0,   /* 0x 7f0 */
  0, 78, 50, 66, 68, 69, 67, 51, 48,  0, 49,  0,  0,  0,  0,  0,   /* 0x 800 */
  0,  0,  7,  1,  0,  0, 78, 50, 66, 68, 69, 67, 51, 48,  0, 49,   /* 0x 810 */
  0,  0,  0, 78, 50, 66, 68, 85, 77, 77, 49,  0,  7,  1,  0,  0,   /* 0x 820 */
 78, 50, 66, 83, 77, 65, 53, 48,  0,  7,  1,  0,  0, 78, 50, 66,   /* 0x 830 */
 70, 65, 83, 53, 48,  0,  9,  1,  0,  0, 78, 50, 66, 68, 69, 67,   /* 0x 840 */
 53, 48,  0, 12,  1,  0,  0, 78, 50, 66, 83, 77, 65, 54, 48,  0,   /* 0x 850 */
 21,  1,  0,  0,  0,  0,  0,  0, 33,  1,  0,  0, 78, 50, 66, 68,   /* 0x 860 */
 69, 67, 49, 48,  0,  0,  0,  0,  0, 78, 50, 66, 70, 65, 83, 54,   /* 0x 870 */
 48,  0, 33,  1,  0,  0,  0,  0,  0,  0, 44,  1,  0,  0, 78, 50,   /* 0x 880 */
 66, 70, 65, 83, 54, 49,  0,  0,  0,  0,  0,  0,  0,  0,  0, 58,   /* 0x 890 */
  1,  0,  0, 78, 50, 66, 68, 69, 67, 49, 48,  0,  0,  0,  0,  0,   /* 0x 8a0 */
 78, 50, 66, 70, 65, 83, 54, 49,  0, 58,  1,  0,  0,  0,  0,  0,   /* 0x 8b0 */
  0, 80,  1,  0,  0, 78, 50, 66, 68, 69, 67, 49, 48,  0,  0,  0,   /* 0x 8c0 */
  0,  0, 78, 50, 66, 68, 69, 67, 54, 48,  0, 80,  1,  0,  0, 78,   /* 0x 8d0 */
 82, 86, 50, 66, 69, 78, 68,  0, 80,  1,  0,  0, 78, 50, 68, 83,   /* 0x 8e0 */
 77, 65, 49, 48,  0, 80,  1,  0,  0,  0,  0,  0,  0, 82,  1,  0,   /* 0x 8f0 */
  0, 78, 50, 68, 68, 69, 67, 49, 48,  0,  4,  0,  0,  0, 78, 50,   /* 0x 900 */
 68, 70, 65, 83, 49, 48,  0, 83,  1,  0,  0,  0,  0,  0,  0, 85,   /* 0x 910 */
  1,  0,  0, 78, 50, 68, 68, 69, 67, 49, 48,  0,  4,  0,  0,  0,   /* 0x 920 */
 78, 50, 68, 70, 65, 83, 49, 49,  0, 85,  1,  0,  0, 78, 50, 68,   /* 0x 930 */
 68, 69, 67, 49, 48,  0, 91,  1,  0,  0, 78, 50, 68, 83, 77, 65,   /* 0x 940 */
 50, 48,  0,102,  1,  0,  0,  0,  0,  0,  0,104,  1,  0,  0, 78,   /* 0x 950 */
 50, 68, 83, 77, 65, 49, 48,  0,  2,  0,  0,  0, 78, 50, 68, 70,   /* 0x 960 */
 65, 83, 50, 48,  0,107,  1,  0,  0,  0,  0,  0,  0,111,  1,  0,   /* 0x 970 */
  0, 78, 50, 68, 70, 65, 83, 49, 49,  0,  0,  0,  0,  0, 78, 50,   /* 0x 980 */
 68, 68, 69, 67, 50, 48,  0,116,  1,  0,  0, 78, 50, 68, 83, 77,   /* 0x 990 */
 65, 51, 48,  0,129,  1,  0,  0,  0,  0,  0,  0,142,  1,  0,  0,   /* 0x 9a0 */
 78, 50, 68, 68, 69, 67, 51, 48,  0, 16,  0,  0,  0, 78, 50, 68,   /* 0x 9b0 */
 70, 65, 83, 51, 48,  0,142,  1,  0,  0,  0,  0,  0,  0,148,  1,   /* 0x 9c0 */
  0,  0, 78, 50, 68, 68, 69, 67, 51, 48,  0, 16,  0,  0,  0,  0,   /* 0x 9d0 */
  0,  0,  0,157,  1,  0,  0, 78, 50, 68, 68, 69, 67, 51, 48,  0,   /* 0x 9e0 */
 16,  0,  0,  0, 78, 50, 68, 68, 69, 67, 51, 48,  0,157,  1,  0,   /* 0x 9f0 */
  0,  0,  0,  0,  0,173,  1,  0,  0, 78, 50, 68, 68, 69, 67, 50,   /* 0x a00 */
 48,  0,  0,  0,  0,  0,  0,  0,  0,  0,191,  1,  0,  0, 78, 50,   /* 0x a10 */
 68, 68, 69, 67, 54, 48,  0,  0,  0,  0,  0,  0,  0,  0,  0,225,   /* 0x a20 */
  1,  0,  0, 78, 50, 68, 68, 69, 67, 53, 48,  0,  0,  0,  0,  0,   /* 0x a30 */
 78, 50, 68, 83, 77, 65, 52, 48,  0,239,  1,  0,  0,  0,  0,  0,   /* 0x a40 */
  0,252,  1,  0,  0, 78, 50, 68, 68, 69, 67, 51, 48,  0, 69,  0,   /* 0x a50 */
  0,  0, 78, 50, 68, 70, 65, 83, 52, 48,  0,252,  1,  0,  0,  0,   /* 0x a60 */
  0,  0,  0,  0,  2,  0,  0, 78, 50, 68, 68, 69, 67, 51, 48,  0,   /* 0x a70 */
 69,  0,  0,  0,  0,  0,  0,  0, 11,  2,  0,  0, 78, 50, 68, 68,   /* 0x a80 */
 69, 67, 51, 48,  0, 69,  0,  0,  0, 78, 50, 68, 68, 85, 77, 77,   /* 0x a90 */
 49,  0, 11,  2,  0,  0, 78, 50, 68, 83, 77, 65, 53, 48,  0, 11,   /* 0x aa0 */
  2,  0,  0, 78, 50, 68, 70, 65, 83, 53, 48,  0, 13,  2,  0,  0,   /* 0x ab0 */
 78, 50, 68, 68, 69, 67, 53, 48,  0, 16,  2,  0,  0, 78, 50, 68,   /* 0x ac0 */
 83, 77, 65, 54, 48,  0, 25,  2,  0,  0,  0,  0,  0,  0, 37,  2,   /* 0x ad0 */
  0,  0, 78, 50, 68, 68, 69, 67, 49, 48,  0,  0,  0,  0,  0, 78,   /* 0x ae0 */
 50, 68, 70, 65, 83, 54, 48,  0, 37,  2,  0,  0,  0,  0,  0,  0,   /* 0x af0 */
 48,  2,  0,  0, 78, 50, 68, 70, 65, 83, 54, 49,  0,  0,  0,  0,   /* 0x b00 */
  0,  0,  0,  0,  0, 62,  2,  0,  0, 78, 50, 68, 68, 69, 67, 49,   /* 0x b10 */
 48,  0,  0,  0,  0,  0, 78, 50, 68, 70, 65, 83, 54, 49,  0, 62,   /* 0x b20 */
  2,  0,  0,  0,  0,  0,  0, 84,  2,  0,  0, 78, 50, 68, 68, 69,   /* 0x b30 */
 67, 49, 48,  0,  0,  0,  0,  0, 78, 50, 68, 68, 69, 67, 54, 48,   /* 0x b40 */
  0, 84,  2,  0,  0, 78, 82, 86, 50, 68, 69, 78, 68,  0, 84,  2,   /* 0x b50 */
  0,  0, 78, 50, 69, 83, 77, 65, 49, 48,  0, 84,  2,  0,  0,  0,   /* 0x b60 */
  0,  0,  0, 86,  2,  0,  0, 78, 50, 69, 68, 69, 67, 49, 48,  0,   /* 0x b70 */
  4,  0,  0,  0, 78, 50, 69, 70, 65, 83, 49, 48,  0, 87,  2,  0,   /* 0x b80 */
  0,  0,  0,  0,  0, 89,  2,  0,  0, 78, 50, 69, 68, 69, 67, 49,   /* 0x b90 */
 48,  0,  4,  0,  0,  0, 78, 50, 69, 70, 65, 83, 49, 49,  0, 89,   /* 0x ba0 */
  2,  0,  0, 78, 50, 69, 68, 69, 67, 49, 48,  0, 95,  2,  0,  0,   /* 0x bb0 */
 78, 50, 69, 83, 77, 65, 50, 48,  0,106,  2,  0,  0,  0,  0,  0,   /* 0x bc0 */
  0,108,  2,  0,  0, 78, 50, 69, 83, 77, 65, 49, 48,  0,  2,  0,   /* 0x bd0 */
  0,  0, 78, 50, 69, 70, 65, 83, 50, 48,  0,111,  2,  0,  0,  0,   /* 0x be0 */
  0,  0,  0,115,  2,  0,  0, 78, 50, 69, 70, 65, 83, 49, 49,  0,   /* 0x bf0 */
  0,  0,  0,  0, 78, 50, 69, 68, 69, 67, 50, 48,  0,120,  2,  0,   /* 0x c00 */
  0, 78, 50, 69, 83, 77, 65, 51, 48,  0,133,  2,  0,  0,  0,  0,   /* 0x c10 */
  0,  0,146,  2,  0,  0, 78, 50, 69, 68, 69, 67, 51, 48,  0, 31,   /* 0x c20 */
  0,  0,  0, 78, 50, 69, 70, 65, 83, 51, 48,  0,146,  2,  0,  0,   /* 0x c30 */
  0,  0,  0,  0,152,  2,  0,  0, 78, 50, 69, 68, 69, 67, 51, 48,   /* 0x c40 */
  0, 31,  0,  0,  0,  0,  0,  0,  0,161,  2,  0,  0, 78, 50, 69,   /* 0x c50 */
 68, 69, 67, 51, 48,  0, 31,  0,  0,  0, 78, 50, 69, 68, 69, 67,   /* 0x c60 */
 51, 48,  0,161,  2,  0,  0,  0,  0,  0,  0,177,  2,  0,  0, 78,   /* 0x c70 */
 50, 69, 68, 69, 67, 50, 48,  0,  0,  0,  0,  0,  0,  0,  0,  0,   /* 0x c80 */
192,  2,  0,  0, 78, 50, 69, 68, 69, 67, 53, 48,  0,  0,  0,  0,   /* 0x c90 */
  0,  0,  0,  0,  0,210,  2,  0,  0, 78, 50, 69, 68, 69, 67, 54,   /* 0x ca0 */
 48,  0,  0,  0,  0,  0, 78, 50, 69, 83, 77, 65, 52, 48,  0,  0,   /* 0x cb0 */
  3,  0,  0,  0,  0,  0,  0, 13,  3,  0,  0, 78, 50, 69, 68, 69,   /* 0x cc0 */
 67, 51, 48,  0, 82,  0,  0,  0, 78, 50, 69, 70, 65, 83, 52, 48,   /* 0x cd0 */
  0, 13,  3,  0,  0,  0,  0,  0,  0, 17,  3,  0,  0, 78, 50, 69,   /* 0x ce0 */
 68, 69, 67, 51, 48,  0, 82,  0,  0,  0,  0,  0,  0,  0, 28,  3,   /* 0x cf0 */
  0,  0, 78, 50, 69, 68, 69, 67, 51, 48,  0, 82,  0,  0,  0, 78,   /* 0x d00 */
 50, 69, 68, 85, 77, 77, 49,  0, 28,  3,  0,  0, 78, 50, 69, 83,   /* 0x d10 */
 77, 65, 53, 48,  0, 28,  3,  0,  0, 78, 50, 69, 70, 65, 83, 53,   /* 0x d20 */
 48,  0, 30,  3,  0,  0, 78, 50, 69, 68, 69, 67, 53, 48,  0, 33,   /* 0x d30 */
  3,  0,  0, 78, 50, 69, 83, 77, 65, 54, 48,  0, 42,  3,  0,  0,   /* 0x d40 */
  0,  0,  0,  0, 54,  3,  0,  0, 78, 50, 69, 68, 69, 67, 49, 48,   /* 0x d50 */
  0,  0,  0,  0,  0, 78, 50, 69, 70, 65, 83, 54, 48,  0, 54,  3,   /* 0x d60 */
  0,  0,  0,  0,  0,  0, 65,  3,  0,  0, 78, 50, 69, 70, 65, 83,   /* 0x d70 */
 54, 49,  0,  0,  0,  0,  0,  0,  0,  0,  0, 79,  3,  0,  0, 78,   /* 0x d80 */
 50, 69, 68, 69, 67, 49, 48,  0,  0,  0,  0,  0, 78, 50, 69, 70,   /* 0x d90 */
 65, 83, 54, 49,  0, 79,  3,  0,  0,  0,  0,  0,  0,101,  3,  0,   /* 0x da0 */
  0, 78, 50, 69, 68, 69, 67, 49, 48,  0,  0,  0,  0,  0, 78, 50,   /* 0x db0 */
 69, 68, 69, 67, 54, 48,  0,101,  3,  0,  0, 78, 82, 86, 50, 69,   /* 0x dc0 */
 69, 78, 68,  0,101,  3,  0,  0, 67, 76, 49, 83, 77, 65, 49, 66,   /* 0x dd0 */
  0,101,  3,  0,  0, 67, 76, 49, 70, 65, 83, 49, 66,  0,103,  3,   /* 0x de0 */
  0,  0, 67, 76, 49, 71, 69, 84, 49, 66,  0,109,  3,  0,  0, 67,   /* 0x df0 */
 76, 49, 69, 78, 84, 69, 82,  0,109,  3,  0,  0,  0,  0,  0,  0,   /* 0x e00 */
115,  3,  0,  0, 67, 76, 49, 83, 84, 65, 82, 84,  0,  0,  0,  0,   /* 0x e10 */
  0, 67, 76, 49, 83, 77, 65, 49, 48,  0,115,  3,  0,  0,  0,  0,   /* 0x e20 */
  0,  0,119,  3,  0,  0, 67, 76, 49, 82, 76, 79, 65, 68,  0,  0,   /* 0x e30 */
  0,  0,  0, 67, 76, 49, 82, 76, 79, 65, 68,  0,120,  3,  0,  0,   /* 0x e40 */
 67, 76, 49, 87, 73, 68, 48, 49,  0,128,  3,  0,  0, 67, 76, 49,   /* 0x e50 */
 87, 73, 68, 48, 50,  0,130,  3,  0,  0, 67, 76, 49, 87, 73, 68,   /* 0x e60 */
 48, 51,  0,132,  3,  0,  0,  0,  0,  0,  0,134,  3,  0,  0, 67,   /* 0x e70 */
 76, 49, 87, 73, 68, 49, 48,  0, 12,  0,  0,  0, 67, 76, 49, 87,   /* 0x e80 */
 73, 68, 48, 52,  0,134,  3,  0,  0, 67, 76, 49, 87, 73, 68, 48,   /* 0x e90 */
 53,  0,136,  3,  0,  0,  0,  0,  0,  0,138,  3,  0,  0, 67, 76,   /* 0x ea0 */
 49, 87, 73, 68, 49, 48,  0,  7,  0,  0,  0, 67, 76, 49, 87, 73,   /* 0x eb0 */
 68, 48, 54,  0,138,  3,  0,  0, 67, 76, 49, 87, 73, 68, 48, 55,   /* 0x ec0 */
  0,140,  3,  0,  0, 67, 76, 49, 87, 73, 68, 48, 56,  0,143,  3,   /* 0x ed0 */
  0,  0,  0,  0,  0,  0,150,  3,  0,  0, 67, 76, 49, 87, 73, 68,   /* 0x ee0 */
 48, 54,  0,  2,  0,  0,  0,  0,  0,  0,  0,160,  3,  0,  0, 67,   /* 0x ef0 */
 76, 49, 87, 73, 68, 49, 48,  0, 15,  0,  0,  0,  0,  0,  0,  0,   /* 0x f00 */
169,  3,  0,  0, 67, 76, 49, 67, 79, 80, 89, 48,  0, 18,  0,  0,   /* 0x f10 */
  0, 67, 76, 49, 87, 73, 68, 48, 57,  0,169,  3,  0,  0, 67, 76,   /* 0x f20 */
 49, 87, 73, 68, 49, 48,  0,171,  3,  0,  0,  0,  0,  0,  0,178,   /* 0x f30 */
  3,  0,  0, 67, 76, 49, 84, 79, 80, 48, 55,  0,  2,  0,  0,  0,   /* 0x f40 */
  0,  0,  0,  0,182,  3,  0,  0, 67, 76, 49, 87, 73, 68, 48, 56,   /* 0x f50 */
  0, 26,  0,  0,  0,  0,  0,  0,  0,188,  3,  0,  0, 67, 76, 49,   /* 0x f60 */
 84, 79, 80, 48, 55,  0,  2,  0,  0,  0, 67, 76, 49, 83, 84, 65,   /* 0x f70 */
 82, 84,  0,188,  3,  0,  0, 67, 76, 49, 84, 79, 80, 48, 48,  0,   /* 0x f80 */
193,  3,  0,  0, 67, 76, 49, 84, 79, 80, 48, 49,  0,196,  3,  0,   /* 0x f90 */
  0,  0,  0,  0,  0,198,  3,  0,  0, 67, 76, 49, 84, 79, 80, 48,   /* 0x fa0 */
 55,  0, 23,  0,  0,  0, 67, 76, 49, 84, 79, 80, 48, 50,  0,198,   /* 0x fb0 */
  3,  0,  0,  0,  0,  0,  0,200,  3,  0,  0, 67, 76, 49, 84, 79,   /* 0x fc0 */
 80, 48, 55,  0, 22,  0,  0,  0, 67, 76, 49, 84, 79, 80, 48, 51,   /* 0x fd0 */
  0,200,  3,  0,  0,  0,  0,  0,  0,202,  3,  0,  0, 67, 76, 49,   /* 0x fe0 */
 84, 79, 80, 48, 55,  0, 21,  0,  0,  0, 67, 76, 49, 84, 79, 80,   /* 0x ff0 */
 48, 52,  0,202,  3,  0,  0,  0,  0,  0,  0,204,  3,  0,  0, 67,   /* 0x1000 */
 76, 49, 84, 79, 80, 48, 55,  0, 20,  0,  0,  0, 67, 76, 49, 84,   /* 0x1010 */
 79, 80, 48, 53,  0,207,  3,  0,  0,  0,  0,  0,  0,209,  3,  0,   /* 0x1020 */
  0, 67, 76, 49, 84, 79, 80, 48, 54,  0,  7,  0,  0,  0, 67, 76,   /* 0x1030 */
 49, 84, 79, 80, 48, 54,  0,210,  3,  0,  0,  0,  0,  0,  0,217,   /* 0x1040 */
  3,  0,  0, 67, 76, 49, 87, 73, 68, 48, 49,  0,  0,  0,  0,  0,   /* 0x1050 */
 67, 76, 49, 84, 79, 80, 48, 55,  0,217,  3,  0,  0, 67, 76, 49,   /* 0x1060 */
 79, 70, 70, 48, 49,  0,240,  3,  0,  0, 67, 76, 49, 79, 70, 70,   /* 0x1070 */
 48, 50,  0,242,  3,  0,  0,  0,  0,  0,  0,244,  3,  0,  0, 67,   /* 0x1080 */
 76, 49, 84, 79, 80, 48, 55,  0, 23,  0,  0,  0,  0,  0,  0,  0,   /* 0x1090 */
  2,  4,  0,  0, 67, 76, 49, 67, 79, 80, 89, 48,  0, 51,  0,  0,   /* 0x10a0 */
  0, 67, 76, 49, 79, 70, 70, 48, 51,  0,  4,  4,  0,  0, 67, 76,   /* 0x10b0 */
 49, 79, 70, 70, 48, 52,  0,  6,  4,  0,  0,  0,  0,  0,  0, 10,   /* 0x10c0 */
  4,  0,  0, 67, 76, 49, 67, 79, 80, 89, 48,  0,  0,  0,  0,  0,   /* 0x10d0 */
 67, 76, 49, 76, 69, 78, 48, 48,  0, 10,  4,  0,  0, 67, 76, 49,   /* 0x10e0 */
 76, 69, 78, 48, 49,  0, 11,  4,  0,  0, 67, 76, 49, 76, 69, 78,   /* 0x10f0 */
 48, 50,  0, 13,  4,  0,  0,  0,  0,  0,  0, 15,  4,  0,  0, 67,   /* 0x1100 */
 76, 49, 76, 69, 78, 48, 48,  0,  1,  0,  0,  0, 67, 76, 49, 67,   /* 0x1110 */
 79, 80, 89, 48,  0, 18,  4,  0,  0,  0,  0,  0,  0, 55,  4,  0,   /* 0x1120 */
  0, 67, 76, 49, 84, 79, 80, 48, 48,  0,  0,  0,  0,  0, 67, 76,   /* 0x1130 */
 49, 69, 78, 68,  0, 69,  4,  0,  0, 76, 88, 80, 84, 73, 48, 57,   /* 0x1140 */
 48,  0, 69,  4,  0,  0,  0,  0,  0,  0, 74,  4,  0,  0, 76, 88,   /* 0x1150 */
 80, 84, 73, 48, 57, 49,  0,  0,  0,  0,  0, 76, 88, 80, 84, 73,   /* 0x1160 */
 48, 57, 49,  0, 74,  4,  0,  0, 67, 65, 76, 76, 84, 82, 48, 48,   /* 0x1170 */
  0,103,  4,  0,  0, 67, 84, 67, 76, 69, 86, 69, 49,  0,117,  4,   /* 0x1180 */
  0,  0,  0,  0,  0,  0,122,  4,  0,  0, 67, 65, 76, 76, 84, 82,   /* 0x1190 */
 48, 48,  0,  5,  0,  0,  0, 67, 65, 76, 76, 84, 82, 48, 49,  0,   /* 0x11a0 */
122,  4,  0,  0, 67, 84, 68, 85, 77, 77, 89, 49,  0,127,  4,  0,   /* 0x11b0 */
  0, 67, 84, 66, 83, 72, 82, 48, 49,  0,127,  4,  0,  0, 67, 84,   /* 0x11c0 */
 66, 82, 79, 82, 48, 49,  0,131,  4,  0,  0, 67, 84, 66, 83, 87,   /* 0x11d0 */
 65, 48, 49,  0,133,  4,  0,  0, 67, 65, 76, 76, 84, 82, 48, 50,   /* 0x11e0 */
  0,138,  4,  0,  0,  0,  0,  0,  0,152,  4,  0,  0, 67, 65, 76,   /* 0x11f0 */
 76, 84, 82, 48, 48,  0, 10,  0,  0,  0, 67, 65, 76, 76, 84, 82,   /* 0x1200 */
 49, 48,  0,152,  4,  0,  0, 67, 65, 76, 76, 84, 82, 69, 56,  0,   /* 0x1210 */
157,  4,  0,  0, 67, 65, 76, 76, 84, 82, 69, 57,  0,159,  4,  0,   /* 0x1220 */
  0, 67, 65, 76, 76, 84, 82, 49, 49,  0,161,  4,  0,  0,  0,  0,   /* 0x1230 */
  0,  0,165,  4,  0,  0, 67, 65, 76, 76, 84, 82, 49, 51,  0,  5,   /* 0x1240 */
  0,  0,  0, 67, 84, 67, 76, 69, 86, 69, 50,  0,165,  4,  0,  0,   /* 0x1250 */
  0,  0,  0,  0,170,  4,  0,  0, 67, 65, 76, 76, 84, 82, 49, 49,   /* 0x1260 */
  0,  0,  0,  0,  0, 67, 65, 76, 76, 84, 82, 49, 50,  0,170,  4,   /* 0x1270 */
  0,  0, 67, 84, 68, 85, 77, 77, 89, 50,  0,172,  4,  0,  0, 67,   /* 0x1280 */
 84, 66, 83, 72, 82, 49, 49,  0,172,  4,  0,  0, 67, 84, 66, 82,   /* 0x1290 */
 79, 82, 49, 49,  0,176,  4,  0,  0, 67, 84, 66, 83, 87, 65, 49,   /* 0x12a0 */
 49,  0,178,  4,  0,  0, 67, 65, 76, 76, 84, 82, 49, 51,  0,183,   /* 0x12b0 */
  4,  0,  0,  0,  0,  0,  0,188,  4,  0,  0, 67, 65, 76, 76, 84,   /* 0x12c0 */
 82, 49, 48,  0,  5,  0,  0,  0, 67, 84, 84, 72, 69, 69, 78, 68,   /* 0x12d0 */
  0,188,  4,  0,  0, 76, 88, 85, 78, 70, 48, 48, 48,  0,188,  4,   /* 0x12e0 */
  0,  0,  0,  0,  0,  0,190,  4,  0,  0, 76, 88, 85, 78, 70, 48,   /* 0x12f0 */
 49, 48,  0,  5,  0,  0,  0, 76, 88, 85, 78, 70, 48, 48, 50,  0,   /* 0x1300 */
190,  4,  0,  0, 77, 82, 85, 66, 89, 84, 69, 48,  0,195,  4,  0,   /* 0x1310 */
  0, 76, 88, 77, 82, 85, 48, 48, 53,  0,197,  4,  0,  0, 76, 88,   /* 0x1320 */
 77, 82, 85, 48, 48, 54,  0,202,  4,  0,  0, 76, 88, 77, 82, 85,   /* 0x1330 */
 48, 48, 55,  0,209,  4,  0,  0, 76, 88, 85, 78, 70, 48, 48, 56,   /* 0x1340 */
  0,216,  4,  0,  0, 76, 88, 85, 78, 70, 48, 49, 48,  0,220,  4,   /* 0x1350 */
  0,  0,  0,  0,  0,  0,225,  4,  0,  0, 76, 88, 85, 78, 70, 48,   /* 0x1360 */
 52, 50,  0,  0,  0,  0,  0, 76, 88, 74, 67, 67, 48, 49, 48,  0,   /* 0x1370 */
225,  4,  0,  0, 76, 88, 77, 82, 85, 48, 52, 53,  0,228,  4,  0,   /* 0x1380 */
  0, 76, 88, 77, 82, 85, 48, 52, 54,  0,231,  4,  0,  0, 76, 88,   /* 0x1390 */
 74, 67, 67, 48, 50, 48,  0,233,  4,  0,  0,  0,  0,  0,  0,235,   /* 0x13a0 */
  4,  0,  0, 76, 88, 85, 78, 70, 48, 51, 52,  0,  0,  0,  0,  0,   /* 0x13b0 */
 76, 88, 74, 67, 67, 48, 50, 49,  0,235,  4,  0,  0,  0,  0,  0,   /* 0x13c0 */
  0,240,  4,  0,  0, 76, 88, 85, 78, 70, 48, 51, 52,  0,  0,  0,   /* 0x13d0 */
  0,  0, 76, 88, 74, 67, 67, 48, 50, 51,  0,240,  4,  0,  0, 76,   /* 0x13e0 */
 88, 85, 78, 70, 48, 51, 55,  0,247,  4,  0,  0, 76, 88, 85, 78,   /* 0x13f0 */
 70, 51, 56, 54,  0,249,  4,  0,  0, 76, 88, 85, 78, 70, 51, 56,   /* 0x1400 */
 55,  0,250,  4,  0,  0, 76, 88, 85, 78, 70, 51, 56, 56,  0,  3,   /* 0x1410 */
  5,  0,  0,  0,  0,  0,  0,  6,  5,  0,  0, 76, 88, 85, 78, 70,   /* 0x1420 */
 48, 52, 48,  0,  0,  0,  0,  0, 76, 88, 85, 78, 70, 52, 56, 54,   /* 0x1430 */
  0,  6,  5,  0,  0, 76, 88, 85, 78, 70, 52, 56, 55,  0, 10,  5,   /* 0x1440 */
  0,  0,  0,  0,  0,  0, 12,  5,  0,  0, 76, 88, 85, 78, 70, 48,   /* 0x1450 */
 52, 48,  0,  0,  0,  0,  0, 76, 88, 77, 82, 85, 48, 54, 53,  0,   /* 0x1460 */
 12,  5,  0,  0,  0,  0,  0,  0, 16,  5,  0,  0, 76, 88, 77, 82,   /* 0x1470 */
 85, 48, 55, 48,  0,  5,  0,  0,  0, 77, 82, 85, 66, 89, 84, 69,   /* 0x1480 */
 51,  0, 16,  5,  0,  0, 77, 82, 85, 65, 82, 66, 51, 48,  0, 18,   /* 0x1490 */
  5,  0,  0, 77, 82, 85, 66, 73, 84, 83, 51,  0, 19,  5,  0,  0,   /* 0x14a0 */
 77, 82, 85, 65, 82, 66, 52, 48,  0, 21,  5,  0,  0, 76, 88, 77,   /* 0x14b0 */
 82, 85, 48, 55, 48,  0, 25,  5,  0,  0,  0,  0,  0,  0, 30,  5,   /* 0x14c0 */
  0,  0, 76, 88, 85, 78, 70, 48, 52, 48,  0,  0,  0,  0,  0, 77,   /* 0x14d0 */
 82, 85, 66, 89, 84, 69, 52,  0, 33,  5,  0,  0, 77, 82, 85, 66,   /* 0x14e0 */
 73, 84, 83, 52,  0, 36,  5,  0,  0, 77, 82, 85, 65, 82, 66, 53,   /* 0x14f0 */
 48,  0, 38,  5,  0,  0, 76, 88, 77, 82, 85, 48, 56, 48,  0, 44,   /* 0x1500 */
  5,  0,  0, 77, 82, 85, 66, 89, 84, 69, 53,  0, 47,  5,  0,  0,   /* 0x1510 */
 77, 82, 85, 65, 82, 66, 54, 48,  0, 49,  5,  0,  0, 77, 82, 85,   /* 0x1520 */
 66, 73, 84, 83, 53,  0, 50,  5,  0,  0, 77, 82, 85, 65, 82, 66,   /* 0x1530 */
 55, 48,  0, 52,  5,  0,  0, 76, 88, 77, 82, 85, 48, 57, 48,  0,   /* 0x1540 */
 56,  5,  0,  0,  0,  0,  0,  0, 63,  5,  0,  0, 76, 88, 77, 82,   /* 0x1550 */
 85, 49, 48, 48,  0, 10,  0,  0,  0, 77, 82, 85, 66, 89, 84, 69,   /* 0x1560 */
 54,  0, 67,  5,  0,  0, 77, 82, 85, 65, 82, 66, 56, 48,  0, 69,   /* 0x1570 */
  5,  0,  0, 77, 82, 85, 66, 73, 84, 83, 54,  0, 70,  5,  0,  0,   /* 0x1580 */
 77, 82, 85, 65, 82, 66, 57, 48,  0, 72,  5,  0,  0, 76, 88, 77,   /* 0x1590 */
 82, 85, 49, 48, 48,  0, 76,  5,  0,  0, 76, 88, 85, 78, 70, 48,   /* 0x15a0 */
 52, 48,  0, 92,  5,  0,  0, 76, 88, 77, 82, 85, 49, 49, 48,  0,   /* 0x15b0 */
 97,  5,  0,  0, 76, 88, 77, 82, 85, 49, 49, 49,  0,100,  5,  0,   /* 0x15c0 */
  0, 76, 88, 85, 78, 70, 48, 52, 49,  0,102,  5,  0,  0,  0,  0,   /* 0x15d0 */
  0,  0,109,  5,  0,  0, 76, 88, 85, 78, 70, 48, 51, 52,  0,  0,   /* 0x15e0 */
  0,  0,  0, 76, 88, 85, 78, 70, 48, 52, 50,  0,109,  5,  0,  0,   /* 0x15f0 */
 76, 69, 88, 69, 67, 48, 49, 54,  0,109,  5,  0,  0,  0,  0,  0,   /* 0x1600 */
  0,111,  5,  0,  0, 76, 88, 85, 78, 70, 48, 52, 50,  0,  0,  0,   /* 0x1610 */
  0,  0, 76, 88, 77, 82, 85, 48, 49, 48,  0,111,  5,  0,  0, 76,   /* 0x1620 */
 88, 74, 77, 80, 65, 48, 48,  0,112,  5,  0,  0, 76, 88, 67, 65,   /* 0x1630 */
 76, 76, 66, 48,  0,114,  5,  0,  0, 76, 88, 85, 78, 70, 48, 50,   /* 0x1640 */
 49,  0,116,  5,  0,  0, 76, 88, 77, 82, 85, 48, 50, 50,  0,122,   /* 0x1650 */
  5,  0,  0, 76, 88, 74, 77, 80, 65, 48, 49,  0,125,  5,  0,  0,   /* 0x1660 */
 76, 88, 67, 65, 76, 76, 66, 49,  0,127,  5,  0,  0, 77, 82, 85,   /* 0x1670 */
 66, 73, 84, 83, 49,  0,129,  5,  0,  0, 76, 88, 77, 82, 85, 48,   /* 0x1680 */
 51, 48,  0,130,  5,  0,  0, 77, 82, 85, 66, 89, 84, 69, 49,  0,   /* 0x1690 */
132,  5,  0,  0, 77, 82, 85, 65, 82, 66, 49, 48,  0,134,  5,  0,   /* 0x16a0 */
  0, 76, 88, 77, 82, 85, 48, 52, 48,  0,135,  5,  0,  0,  0,  0,   /* 0x16b0 */
  0,  0,137,  5,  0,  0, 76, 88, 77, 82, 85, 48, 51, 48,  0,  0,   /* 0x16c0 */
  0,  0,  0, 76, 88, 85, 78, 70, 48, 51, 48,  0,137,  5,  0,  0,   /* 0x16d0 */
 76, 88, 74, 67, 67, 48, 48, 48,  0,143,  5,  0,  0,  0,  0,  0,   /* 0x16e0 */
  0,151,  5,  0,  0, 76, 88, 74, 67, 67, 48, 49, 48,  0,  0,  0,   /* 0x16f0 */
  0,  0, 76, 88, 67, 74, 48, 77, 82, 85,  0,151,  5,  0,  0, 76,   /* 0x1700 */
 88, 67, 74, 49, 77, 82, 85,  0,153,  5,  0,  0, 76, 88, 67, 65,   /* 0x1710 */
 76, 74, 77, 80,  0,156,  5,  0,  0, 76, 88, 67, 65, 76, 76, 48,   /* 0x1720 */
 48,  0,159,  5,  0,  0,  0,  0,  0,  0,161,  5,  0,  0, 76, 88,   /* 0x1730 */
 85, 78, 70, 48, 51, 55,  0,  0,  0,  0,  0, 76, 88, 67, 65, 76,   /* 0x1740 */
 76, 48, 49,  0,161,  5,  0,  0, 76, 88, 67, 74, 50, 77, 82, 85,   /* 0x1750 */
  0,164,  5,  0,  0,  0,  0,  0,  0,166,  5,  0,  0, 76, 88, 85,   /* 0x1760 */
 78, 70, 48, 51, 55,  0,  0,  0,  0,  0, 76, 88, 67, 74, 52, 77,   /* 0x1770 */
 82, 85,  0,166,  5,  0,  0,  0,  0,  0,  0,168,  5,  0,  0, 76,   /* 0x1780 */
 88, 85, 78, 70, 48, 51, 52,  0,  0,  0,  0,  0, 76, 88, 67, 74,   /* 0x1790 */
 54, 77, 82, 85,  0,168,  5,  0,  0,  0,  0,  0,  0,170,  5,  0,   /* 0x17a0 */
  0, 76, 88, 67, 74, 56, 77, 82, 85,  0,  1,  0,  0,  0, 76, 88,   /* 0x17b0 */
 67, 74, 55, 77, 82, 85,  0,170,  5,  0,  0,  0,  0,  0,  0,172,   /* 0x17c0 */
  5,  0,  0, 76, 88, 67, 74, 56, 77, 82, 85,  0,  1,  0,  0,  0,   /* 0x17d0 */
 76, 88, 67, 74, 56, 77, 82, 85,  0,172,  5,  0,  0,  0,  0,  0,   /* 0x17e0 */
  0,175,  5,  0,  0, 76, 88, 85, 78, 70, 48, 51, 55,  0,  0,  0,   /* 0x17f0 */
  0,  0, 76, 88, 85, 78, 70, 48, 51, 52,  0,175,  5,  0,  0,  0,   /* 0x1800 */
  0,  0,  0,180,  5,  0,  0, 76, 88, 85, 78, 70, 48, 51, 48,  0,   /* 0x1810 */
  0,  0,  0,  0, 76, 88, 77, 82, 85, 48, 53, 53,  0,180,  5,  0,   /* 0x1820 */
  0, 77, 82, 85, 66, 89, 84, 69, 50,  0,182,  5,  0,  0, 77, 82,   /* 0x1830 */
 85, 66, 73, 84, 83, 50,  0,187,  5,  0,  0, 77, 82, 85, 65, 82,   /* 0x1840 */
 66, 50, 48,  0,192,  5,  0,  0, 76, 88, 77, 82, 85, 48, 53, 55,   /* 0x1850 */
  0,197,  5,  0,  0, 76, 88, 77, 82, 85, 48, 53, 56,  0,203,  5,   /* 0x1860 */
  0,  0, 76, 88, 85, 78, 70, 48, 51, 53,  0,204,  5,  0,  0, 76,   /* 0x1870 */
 88, 80, 84, 73, 49, 52, 48,  0,210,  5,  0,  0, 76, 88, 80, 84,   /* 0x1880 */
 73, 49, 52, 49,  0,210,  5,  0,  0, 76, 88, 80, 84, 73, 49, 53,   /* 0x1890 */
 48,  0,210,  5,  0,  0, 67, 75, 76, 76, 84, 82, 48, 48,  0,223,   /* 0x18a0 */
  5,  0,  0,  0,  0,  0,  0,227,  5,  0,  0, 67, 75, 76, 76, 84,   /* 0x18b0 */
 82, 50, 48,  0, 30,  0,  0,  0, 67, 75, 76, 76, 84, 82, 49, 48,   /* 0x18c0 */
  0,232,  5,  0,  0,  0,  0,  0,  0,246,  5,  0,  0, 67, 75, 76,   /* 0x18d0 */
 76, 84, 82, 50, 48,  0,  6,  0,  0,  0, 67, 75, 76, 76, 84, 82,   /* 0x18e0 */
 50, 48,  0,246,  5,  0,  0,  0,  0,  0,  0,252,  5,  0,  0, 67,   /* 0x18f0 */
 75, 76, 76, 84, 82, 52, 48,  0,  0,  0,  0,  0,  0,  0,  0,  0,   /* 0x1900 */
  0,  6,  0,  0, 67, 75, 76, 76, 84, 82, 52, 48,  0,  0,  0,  0,   /* 0x1910 */
  0, 67, 75, 76, 76, 84, 82, 51, 48,  0, 23,  6,  0,  0,  0,  0,   /* 0x1920 */
  0,  0, 30,  6,  0,  0, 67, 75, 76, 76, 84, 82, 49, 48,  0, 14,   /* 0x1930 */
  0,  0,  0, 67, 75, 76, 76, 84, 82, 52, 48,  0, 30,  6,  0,  0,   /* 0x1940 */
  0,  0,  0,  0, 35,  6,  0,  0, 67, 75, 76, 76, 84, 82, 48, 48,   /* 0x1950 */
  0,  4,  0,  0,  0, 76, 88, 80, 84, 73, 49, 54, 48,  0, 35,  6,   /* 0x1960 */
  0,  0, 76, 88, 80, 84, 73, 50, 48, 48,  0, 37,  6,  0,  0, 88,   /* 0x1970 */
 84, 72, 69, 69, 78, 68, 88,  0, 37,  6,  0,  0,255,255,255,255,   /* 0x1980 */
 37,  6                                                            /* 0x1990 */
};
