/*****************************************************************************
 *
 * utouch-frame - Touch Frame Library
 *
 * Copyright (C) 2010-2012 Canonical Ltd.
 *
 * This library is free software: you can redistribute it and/or modify it 
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranties of 
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
 * PURPOSE.  See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 ****************************************************************************/

#ifndef UTOUCH_FRAME_MTDEV_H
#define UTOUCH_FRAME_MTDEV_H

#ifdef __cplusplus
extern "C" {
#endif

/**
 * \addtogroup v1
 * @{
 *
 * \defgroup v1-mtdev MTDev
 * @{
 */

#define MTDEV_NO_LEGACY_API

#include <utouch/frame.h>
#include <evemu.h>
#include <mtdev.h>

FRAME_PUBLIC
int utouch_frame_is_supported_mtdev(const struct evemu_device *dev);

FRAME_PUBLIC
int utouch_frame_init_mtdev(utouch_frame_handle fh,
			    const struct evemu_device *dev);

FRAME_PUBLIC
const struct utouch_frame *
utouch_frame_pump_mtdev(utouch_frame_handle fh, const struct input_event *ev);

/**
 * @}
 *
 * @}
 */

#ifdef __cplusplus
}
#endif

#endif
