// ==UserScript==
// @include        http://*.deviantart.com/*
// @include        https://*.deviantart.com/*
// @include        http://*.deviantart.com/
// @include        https://*.deviantart.com/
// @include        http://deviantart.com/
// @include        https://deviantart.com/
// @require        utils.js
// ==/UserScript==

window.Unity = external.getUnityObject(1);

function setupMessages() {

    var count_notes = 0;
    var count_notices = 0;
    var count_deviations = 0;
    var count_deviantwatch = 0;
    var count_feedback = 0;
    var profile_uri = "";

    var e = document.getElementsByTagName("a");
    var i = 0;
    for (i; i < 50; i++) {
        if (e[i].title === "Notes") {
            count_notes = e[i].text;
        }
        if (e[i].title === "Notices") {
            count_notices = e[i].text;
        }
        if (e[i].title === "Deviations") {
            count_deviations = e[i].text;
        }
        if (e[i].title === "deviantWATCH Messages") {
            count_deviantwatch = e[i].text;
        }
        if (e[i].title === "Feedback Messages") {
            count_feedback = e[i].text;
        }
        if (e[i].text === "My Profile") {
            profile_uri = e[i].href;
        }
    }

    if (profile_uri) {
        Unity.Launcher.addAction(_("My Profile"), makeRedirector(profile_uri));
    }

    var submit_uri = "http://www.deviantart.com/submit/deviation";
    Unity.Launcher.addAction(_("Submit Art"), makeRedirector(submit_uri));
    
    var submit_uri = "http://www.deviantart.com/random/deviant";
    Unity.Launcher.addAction(_("Random Deviant"), makeRedirector(submit_uri));

    Unity.MessagingIndicator.addAction(_("Compose New Message"),
                                       makeRedirector("http://my.deviantart.com/notes/#new-note"));
    if (count_notes > 0) {
        Unity.MessagingIndicator.showIndicator(_("Notes"),
                                               { count: count_notes,
                                                 callback: makeRedirector("http://my.deviantart.com/notes/") });
    }
    if (count_notices > 0) {
        Unity.MessagingIndicator.showIndicator(_("Notices"),
                                               { count: count_notices,
                                                 callback: makeRedirector("http://my.deviantart.com/messages/#view=notices") });
    }
    if (count_deviations > 0) {
        Unity.MessagingIndicator.showIndicator(_("Deviations"),
                                               { count: count_deviations,
                                                 callback: makeRedirector("http://my.deviantart.com/messages/#view=deviations") });
    }

    if (count_deviantwatch > 0) {
        Unity.MessagingIndicator.showIndicator(_("DeviantWATCH"),
                                               { count: count_deviantwatch,
                                                 callback: makeRedirector("http://my.deviantart.com/messages/#view=deviantwatch") });
    }

    if (count_feedback > 0) {
        Unity.MessagingIndicator.showIndicator(_("Feedback"),
                                               { count: count_feedback,
                                                 callback: makeRedirector("http://my.deviantart.com/messages/#view=feedback") });
    }
}

Unity.init({ name: "Deviantart",
             domain: "deviantart.com",
             homepage: "http://deviantart.com",
             iconUrl: "icon://unity-webapps-deviantart",
             onInit: wrapCallback(setupMessages) });
