// ==UserScript==
// @include       http://*.mail.qq.com/cgi-bin/*
// @include       https://*.mail.qq.com/cgi-bin/*
// @require       utils.js
// ==/UserScript==

window.Unity = external.getUnityObject(1);

function isCorrectPage() {
    var i, ids = ['folder_1'];

    for (i = 0; i < ids.length; i++) {
        if (!document.getElementById(ids[i])) {
            return false;
        }
    }

    return true;
}

function messagingIndicatorSetup() {
    var container = document.getElementById('leftPanel');

    function checkMessangesCount() {
        var countElement = document.getElementById('folder_1');
        var count = countElement.textContent.match(/\d+/);

        if (count === null) {
            count = '0';
        } else {
            count = count[0];
        }

        Unity.MessagingIndicator.showIndicator(_("Inbox"), { count: count });
    }

    container.addEventListener('DOMSubtreeModified', wrapCallback(checkMessangesCount), false);

    checkMessangesCount();
}

if (isCorrectPage()) {
    Unity.init({ name: 'QQ',
		 domain: 'mail.qq.com',
		 homepage: 'http://mail.qq.com',
                 iconUrl: 'icon://unity-webapps-mail-qq-com',
                 onInit: wrapCallback(messagingIndicatorSetup) });
}
