/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.xmerge;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

class OfficeZip {
    private static final String CONTENTXML = "content.xml";
    private static final String STYLEXML = "styles.xml";
    private static final String METAXML = "meta.xml";
    private static final String SETTINGSXML = "settings.xml";
    private static final String MANIFESTXML = "META-INF/manifest.xml";
    private static final int BUFFERSIZE = 1024;
    private List entryList = new LinkedList();
    private int contentIndex = -1;
    private int styleIndex = -1;
    private int metaIndex = -1;
    private int settingsIndex = -1;
    private int manifestIndex = -1;

    OfficeZip() {
    }

    void read(InputStream is) throws IOException {
        ZipInputStream zis = new ZipInputStream(is);
        ZipEntry ze = null;
        int i = -1;
        while ((ze = zis.getNextEntry()) != null) {
            String name = ze.getName();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int len = 0;
            byte[] buffer = new byte[1024];
            while ((len = zis.read(buffer)) > 0) {
                baos.write(buffer, 0, len);
            }
            byte[] bytes = baos.toByteArray();
            Entry entry = new Entry(ze, bytes);
            this.entryList.add(entry);
            ++i;
            if (name.equalsIgnoreCase(CONTENTXML)) {
                this.contentIndex = i;
                continue;
            }
            if (name.equalsIgnoreCase(STYLEXML)) {
                this.styleIndex = i;
                continue;
            }
            if (name.equalsIgnoreCase(METAXML)) {
                this.metaIndex = i;
                continue;
            }
            if (name.equalsIgnoreCase(SETTINGSXML)) {
                this.settingsIndex = i;
                continue;
            }
            if (!name.equalsIgnoreCase(MANIFESTXML)) continue;
            this.manifestIndex = i;
        }
        zis.close();
    }

    byte[] getContentXMLBytes() {
        return this.getEntryBytes(this.contentIndex);
    }

    byte[] getStyleXMLBytes() {
        return this.getEntryBytes(this.styleIndex);
    }

    byte[] getMetaXMLBytes() {
        return this.getEntryBytes(this.metaIndex);
    }

    byte[] getSettingsXMLBytes() {
        return this.getEntryBytes(this.settingsIndex);
    }

    byte[] getManifestXMLBytes() {
        return this.getEntryBytes(this.manifestIndex);
    }

    byte[] getNamedBytes(String name) {
        int i = 0;
        while (i < this.entryList.size()) {
            Entry e = (Entry)this.entryList.get(i);
            if (e.zipEntry.getName().equals(name)) {
                return this.getEntryBytes(i);
            }
            ++i;
        }
        return null;
    }

    void setNamedBytes(String name, byte[] bytes) {
        int i = 0;
        while (i < this.entryList.size()) {
            Entry e = (Entry)this.entryList.get(i);
            if (e.zipEntry.getName().equals(name)) {
                this.setEntryBytes(i, bytes, name);
                return;
            }
            ++i;
        }
        this.setEntryBytes(-1, bytes, name);
    }

    private byte[] getEntryBytes(int index) {
        byte[] bytes = null;
        if (index > -1) {
            Entry entry = (Entry)this.entryList.get(index);
            bytes = entry.bytes;
        }
        return bytes;
    }

    void setContentXMLBytes(byte[] bytes) {
        this.contentIndex = this.setEntryBytes(this.contentIndex, bytes, CONTENTXML);
    }

    void setStyleXMLBytes(byte[] bytes) {
        this.styleIndex = this.setEntryBytes(this.styleIndex, bytes, STYLEXML);
    }

    void setMetaXMLBytes(byte[] bytes) {
        this.metaIndex = this.setEntryBytes(this.metaIndex, bytes, METAXML);
    }

    void setSettingsXMLBytes(byte[] bytes) {
        this.settingsIndex = this.setEntryBytes(this.settingsIndex, bytes, SETTINGSXML);
    }

    void setManifestXMLBytes(byte[] bytes) {
        this.manifestIndex = this.setEntryBytes(this.manifestIndex, bytes, MANIFESTXML);
    }

    private int setEntryBytes(int index, byte[] bytes, String name) {
        if (index > -1) {
            ZipEntry ze;
            Entry entry = (Entry)this.entryList.get(index);
            name = entry.zipEntry.getName();
            int method = entry.zipEntry.getMethod();
            entry.zipEntry = ze = this.createZipEntry(name, bytes, method);
            entry.bytes = bytes;
        } else {
            ZipEntry ze = this.createZipEntry(name, bytes, 8);
            Entry entry = new Entry(ze, bytes);
            this.entryList.add(entry);
            index = this.entryList.size() - 1;
        }
        return index;
    }

    void write(OutputStream os) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(os);
        ListIterator iterator = this.entryList.listIterator();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            ZipEntry ze = entry.zipEntry;
            String name = ze.getName();
            zos.putNextEntry(ze);
            zos.write(entry.bytes);
        }
        zos.close();
    }

    private ZipEntry createZipEntry(String name, byte[] bytes, int method) {
        ZipEntry ze = new ZipEntry(name);
        ze.setMethod(method);
        ze.setSize(bytes.length);
        CRC32 crc = new CRC32();
        crc.reset();
        crc.update(bytes);
        ze.setCrc(crc.getValue());
        ze.setTime(System.currentTimeMillis());
        return ze;
    }

    static {
        CONTENTXML = CONTENTXML;
        STYLEXML = STYLEXML;
        METAXML = METAXML;
        SETTINGSXML = SETTINGSXML;
        MANIFESTXML = MANIFESTXML;
        BUFFERSIZE = 1024;
    }

    private class Entry {
        ZipEntry zipEntry = null;
        byte[] bytes = null;

        Entry(ZipEntry zipEntry, byte[] bytes) {
            this.zipEntry = zipEntry;
            this.bytes = bytes;
        }
    }
}

