/* Combined Purdue/PurduePlus patches, level 2.0, 1/17/89 */
/***********************************************************

Copyright (c) 1987  X Consortium

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall not be
used in advertising or otherwise to promote the sale, use or other dealings
in this Software without prior written authorization from the X Consortium.


Copyright 1987 by Digital Equipment Corporation, Maynard, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of Digital not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/

#ifdef HAVE_DIX_CONFIG_H
#include <dix-config.h>
#endif

#include <stdlib.h>

#include <X11/X.h>
#include "scrnintstr.h"
#include "windowstr.h"
#include "privates.h"
#include "afb.h"
#include "mistruct.h"
#include "regionstr.h"
#include "maskbits.h"

Bool
afbCreateWindow(WindowPtr pWin)
{
	return (TRUE);
}

/* This always returns true, because Xfree can't fail.  It might be possible
 * on some devices for Destroy to fail */
Bool
afbDestroyWindow(WindowPtr pWin)
{
	return (TRUE);
}

/*ARGSUSED*/
Bool
afbMapWindow(pWindow)
	WindowPtr pWindow;
{
	return (TRUE);
}

/*ARGSUSED*/
Bool
afbPositionWindow(WindowPtr pWin, int x, int y)
{
	/* This is the "wrong" fix to the right problem, but it doesn't really
	 * cost very much.  When the window is moved, we need to invalidate any
	 * RotatedPixmap that exists in any GC currently validated against this
	 * window.
	 */
	pWin->drawable.serialNumber = NEXT_SERIAL_NUMBER;

	/* Again, we have no failure modes indicated by any of the routines
	 * we've called, so we have to assume it worked */
	return (TRUE);
}

/*ARGSUSED*/
Bool
afbUnmapWindow(pWindow)
	WindowPtr pWindow;
{
	return (TRUE);
}

/* UNCLEAN!
   this code calls the bitblt helper code directly.

   afbCopyWindow copies only the parts of the destination that are
visible in the source.
*/


void
afbCopyWindow(pWin, ptOldOrg, prgnSrc)
	WindowPtr pWin;
	DDXPointRec ptOldOrg;
	RegionPtr prgnSrc;
{
	DDXPointPtr pptSrc;
	register DDXPointPtr ppt;
	RegionPtr prgnDst;
	register BoxPtr pbox;
	register int dx, dy;
	register int i, nbox;
	WindowPtr pwinRoot;

	pwinRoot = WindowTable[pWin->drawable.pScreen->myNum];

	prgnDst = REGION_CREATE(pWin->drawable.pScreen, NULL, 1);

	dx = ptOldOrg.x - pWin->drawable.x;
	dy = ptOldOrg.y - pWin->drawable.y;
	REGION_TRANSLATE(pWin->drawable.pScreen, prgnSrc, -dx, -dy);
	REGION_INTERSECT(pWin->drawable.pScreen, prgnDst, &pWin->borderClip,
						  prgnSrc);

	pbox = REGION_RECTS(prgnDst);
	nbox = REGION_NUM_RECTS(prgnDst);
	if(!(pptSrc = (DDXPointPtr )xalloc(nbox * sizeof(DDXPointRec))))
		return;
	ppt = pptSrc;

	for (i=nbox; --i >= 0; ppt++, pbox++) {
		ppt->x = pbox->x1 + dx;
		ppt->y = pbox->y1 + dy;
	}

	afbDoBitblt((DrawablePtr)pwinRoot, (DrawablePtr)pwinRoot, GXcopy, prgnDst,
					 pptSrc, ~0);
	xfree(pptSrc);
	REGION_DESTROY(pWin->drawable.pScreen, prgnDst);
}

Bool
afbChangeWindowAttributes(WindowPtr pWin, unsigned long mask)
{
	return (TRUE);
}
