.TH XScreenSaver 1 "" "X Version 11"
.SH NAME
jigglypuff - save your screen by tormenting your eyes.
.SH SYNOPSIS
.B jigglypuff
[\-display \fIhost:display.screen\fP]
[\-visual \fIvisual\fP]
[\-window]
[\-root]
[-delay \fInumber\fP]
[-cycles \fInumber\fP]
[-wireframe]
[-fps]
[-color \fIcolorspec\fP]
[-spooky]
[-complexity \fIn\fP]
[-speed \fIn\fP]
[-spherism \fIn\fP]
[-hold \fIn\fP]
[-distance \fIn\fP]
[-damping \fIn\fP]
.SH DESCRIPTION
This draws all manners of obscene, spastic, puffy, vaguely ball-shaped
objects orbiting lazily about the screen, with a dizzying array of
mostly pointless options.
.SH OPTIONS
.TP 8
.B \-visual \fIvisual\fP
Specify which visual to use.  Legal values are the name of a visual class,
or the id number (decimal or hex) of a specific visual.
.TP 8
.B \-window
Draw on a newly-created window.  This is the default.
.TP 8
.B \-root
Draw on the root window.
.TP 8
.B \-delay \fInumber\fP
Per-frame delay, in microseconds.  Default: 20000 (0.02 seconds.).
.TP 8
.B \-wireframe
Render in wireframe instead of solid. Default: render solid.
.TP 8
.B \-fps | \-no-fps
Display frames per second. Default: off.
.TP 8
.B -tetra | -no-tetra
Whether to start the shape in the form of a tetrahedron. The default
is to start as a sphere.
.TP 8
.B -color \fIcolorspec\fP
Available options for colorspec are: cycle, flowerbox, clownpuke, chrome
and #xxxxxx (i.e an (old-style) X color specification.) Default: cycle
.TP 8
.B -spooky \fIn\fP
This option controls a kind of interesting effect obtained by
using unnormalized normal vectors (how's that for an oxymoron?) in OpenGL.
A value of zero disables the effect. Other values vary the lengths of
the normals proportionally.
Okay, so it's not very spooky. Sue me.
Default: 0
.TP 8
.B -complexity \fIn\fP
Valid options are 1, 2, and 3. Everything else is treated as though it
were 2, which is the default. This controls the number of polygons in
the 'thing'. A value of 1 yields 1024, and the values go up in powers
of 4. (i.e. 4096, 16384.)
 note: There is an inherent lack of stability
at lower complexity, which can cause the shape to devolve into a 'flying
snotrag'.
.TP 8
.B -speed \fIn\fP
Controls how fast the blob moves around the screen. Default: 500.
.TP 8
.B -spherism, -hold, -distance, -damping
These options control the 'jigglyness'. The best way to explain these is
to explain how jigglypuff works. Basically, the shape is a tetrahedron
whose faces are subdivided into a number of triangles, forming a mesh.
Each of the vertices of the mesh has two different forces applied to it:
one proportional to its distance from the surface of a sphere, and one
proportional to the difference of the distance to each of its neighbors
in the mesh to a given ideal distance. In short, one tries to move the
points into the configuration of a sphere, and the other tries to push
them back into a tetrahedron. The catch is that the points have inertia,
so they always overshoot their target, and hence they oscillate. The
magnitudes of the two forces is controlled by the options 'spherism' and
\'hold'; 'distance' specifies the distance the vertices seek to keep from
their neighbors, with 500 corresponding to the size of the start tetrahedron.
e.g. if you were to give the options '-tetra -spherism 0 -distance 500', you
would end up with a stable tetrahedron. The 'damping' option can help to
keep the blob from collapsing or flying apart. The option specifies the
speed at which damping starts, hence lower values mean more damping.
Defaults: spherism: 200; hold: 800; distance: 100; damping: 500.
.TP 8
.B -random
Probably the only parameter you'l ever need. Overrides almost all of the
parameters with random values. The values affected are: speed, spherism,
hold, distance, damping, spooky, color, wireframe and tetra.
Default: off
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the default host and display number.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.SH SEE ALSO
.BR X (1),
.BR xscreensaver (1)
.SH COPYRIGHT
Copyright \(co 2003 by Keith Macleod.  Permission to use, copy, modify, 
distribute, and sell this software and its documentation for any purpose is 
hereby granted without fee, provided that the above copyright notice appear 
in all copies and that both that copyright notice and this permission notice
appear in supporting documentation.  No representations are made about the 
suitability of this software for any purpose.  It is provided "as is" without
express or implied warranty.
.SH AUTHOR
By Keith Macleod
