/* recent-manager-provider.c generated by valac 0.11.5.3-984e-dirty, the Vala compiler
 * generated from recent-manager-provider.vala, do not modify */

/*
 * Zeitgeist
 *
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <zeitgeist.h>
#include <gio/gio.h>


#define TYPE_DATA_PROVIDER (data_provider_get_type ())
#define DATA_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_PROVIDER, DataProvider))
#define DATA_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_PROVIDER, DataProviderClass))
#define IS_DATA_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_PROVIDER))
#define IS_DATA_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_PROVIDER))
#define DATA_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_PROVIDER, DataProviderClass))

typedef struct _DataProvider DataProvider;
typedef struct _DataProviderClass DataProviderClass;
typedef struct _DataProviderPrivate DataProviderPrivate;

#define TYPE_DATA_HUB (data_hub_get_type ())
#define DATA_HUB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_HUB, DataHub))
#define DATA_HUB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_HUB, DataHubClass))
#define IS_DATA_HUB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_HUB))
#define IS_DATA_HUB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_HUB))
#define DATA_HUB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_HUB, DataHubClass))

typedef struct _DataHub DataHub;
typedef struct _DataHubClass DataHubClass;

#define TYPE_RECENT_MANAGER_GTK (recent_manager_gtk_get_type ())
#define RECENT_MANAGER_GTK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RECENT_MANAGER_GTK, RecentManagerGtk))
#define RECENT_MANAGER_GTK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RECENT_MANAGER_GTK, RecentManagerGtkClass))
#define IS_RECENT_MANAGER_GTK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RECENT_MANAGER_GTK))
#define IS_RECENT_MANAGER_GTK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RECENT_MANAGER_GTK))
#define RECENT_MANAGER_GTK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RECENT_MANAGER_GTK, RecentManagerGtkClass))

typedef struct _RecentManagerGtk RecentManagerGtk;
typedef struct _RecentManagerGtkClass RecentManagerGtkClass;
typedef struct _RecentManagerGtkPrivate RecentManagerGtkPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _gtk_recent_info_unref0(var) ((var == NULL) ? NULL : (var = (gtk_recent_info_unref (var), NULL)))
#define __g_list_free__gtk_recent_info_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__gtk_recent_info_unref0_ (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _DataProvider {
	GObject parent_instance;
	DataProviderPrivate * priv;
};

struct _DataProviderClass {
	GObjectClass parent_class;
	void (*start) (DataProvider* self);
	void (*stop) (DataProvider* self);
	const gchar* (*get_unique_id) (DataProvider* self);
	void (*set_unique_id) (DataProvider* self, const gchar* value);
	const gchar* (*get_name) (DataProvider* self);
	void (*set_name) (DataProvider* self, const gchar* value);
	const gchar* (*get_description) (DataProvider* self);
	void (*set_description) (DataProvider* self, const gchar* value);
	DataHub* (*get_datahub) (DataProvider* self);
	void (*set_datahub) (DataProvider* self, DataHub* value);
	gboolean (*get_enabled) (DataProvider* self);
	void (*set_enabled) (DataProvider* self, gboolean value);
	gboolean (*get_register) (DataProvider* self);
	void (*set_register) (DataProvider* self, gboolean value);
};

struct _RecentManagerGtk {
	DataProvider parent_instance;
	RecentManagerGtkPrivate * priv;
};

struct _RecentManagerGtkClass {
	DataProviderClass parent_class;
};

struct _RecentManagerGtkPrivate {
	gchar* _unique_id;
	gchar* _name;
	gchar* _description;
	DataHub* _datahub;
	gboolean _enabled;
	gboolean _register;
	GtkRecentManager* recent_manager;
	GHashTable* app_to_desktop_file;
	guint idle_id;
};


static gpointer recent_manager_gtk_parent_class = NULL;

GType data_provider_get_type (void) G_GNUC_CONST;
GType data_hub_get_type (void) G_GNUC_CONST;
GType recent_manager_gtk_get_type (void) G_GNUC_CONST;
#define RECENT_MANAGER_GTK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_RECENT_MANAGER_GTK, RecentManagerGtkPrivate))
enum  {
	RECENT_MANAGER_GTK_DUMMY_PROPERTY,
	RECENT_MANAGER_GTK_UNIQUE_ID,
	RECENT_MANAGER_GTK_NAME,
	RECENT_MANAGER_GTK_DESCRIPTION,
	RECENT_MANAGER_GTK_DATAHUB,
	RECENT_MANAGER_GTK_ENABLED,
	RECENT_MANAGER_GTK_REGISTER
};
RecentManagerGtk* recent_manager_gtk_new (DataHub* datahub);
RecentManagerGtk* recent_manager_gtk_construct (GType object_type, DataHub* datahub);
static void recent_manager_gtk_real_start (DataProvider* base);
static void recent_manager_gtk_items_changed (RecentManagerGtk* self);
static void _recent_manager_gtk_items_changed_gtk_recent_manager_changed (GtkRecentManager* _sender, gpointer self);
GPtrArray* recent_manager_gtk_get_items (RecentManagerGtk* self);
static void recent_manager_gtk_real_stop (DataProvider* base);
static gboolean _lambda0_ (RecentManagerGtk* self);
static gboolean __lambda0__gsource_func (gpointer self);
static void _g_object_unref0_ (gpointer var);
DataHub* data_provider_get_datahub (DataProvider* self);
gchar** data_hub_get_data_source_actors (DataHub* self, gboolean only_enabled, int* result_length1);
static gchar* recent_manager_gtk_get_ooo_desktop_file_for_mimetype (RecentManagerGtk* self, const gchar* mimetype);
static gchar* recent_manager_gtk_find_desktop_file_for_app (RecentManagerGtk* self, const gchar* app_name, const gchar* mimetype);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
gint64 data_provider_get_last_timestamp (DataProvider* self);
static void _gtk_recent_info_unref0_ (gpointer var);
static void _g_list_free__gtk_recent_info_unref0_ (GList* self);
void data_provider_set_last_timestamp (DataProvider* self, gint64 value);
static gchar** _vala_array_dup1 (gchar** self, int length);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static GObject * recent_manager_gtk_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _g_free0_ (gpointer var);
static void recent_manager_gtk_finalize (GObject* obj);
const gchar* data_provider_get_unique_id (DataProvider* self);
const gchar* data_provider_get_name (DataProvider* self);
const gchar* data_provider_get_description (DataProvider* self);
gboolean data_provider_get_enabled (DataProvider* self);
gboolean data_provider_get_register (DataProvider* self);
static void _vala_recent_manager_gtk_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void data_provider_set_unique_id (DataProvider* self, const gchar* value);
void data_provider_set_name (DataProvider* self, const gchar* value);
void data_provider_set_description (DataProvider* self, const gchar* value);
void data_provider_set_datahub (DataProvider* self, DataHub* value);
void data_provider_set_enabled (DataProvider* self, gboolean value);
void data_provider_set_register (DataProvider* self, gboolean value);
static void _vala_recent_manager_gtk_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


RecentManagerGtk* recent_manager_gtk_construct (GType object_type, DataHub* datahub) {
	RecentManagerGtk * self = NULL;
	g_return_val_if_fail (datahub != NULL, NULL);
	self = (RecentManagerGtk*) g_object_new (object_type, "unique-id", "com.zeitgeist-project,datahub,recent", "name", "Recently Used Documents", "description", "Logs events from GtkRecentlyUsed", "datahub", datahub, NULL);
	return self;
}


RecentManagerGtk* recent_manager_gtk_new (DataHub* datahub) {
	return recent_manager_gtk_construct (TYPE_RECENT_MANAGER_GTK, datahub);
}


static void _recent_manager_gtk_items_changed_gtk_recent_manager_changed (GtkRecentManager* _sender, gpointer self) {
	recent_manager_gtk_items_changed (self);
}


static void recent_manager_gtk_real_start (DataProvider* base) {
	RecentManagerGtk * self;
	GPtrArray* _tmp0_ = NULL;
	GPtrArray* _tmp1_;
	self = (RecentManagerGtk*) base;
	g_signal_connect_object (self->priv->recent_manager, "changed", (GCallback) _recent_manager_gtk_items_changed_gtk_recent_manager_changed, self, 0);
	_tmp0_ = recent_manager_gtk_get_items (self);
	_tmp1_ = _tmp0_;
	g_signal_emit_by_name ((DataProvider*) self, "items-available", _tmp1_);
	_g_ptr_array_unref0 (_tmp1_);
}


static void recent_manager_gtk_real_stop (DataProvider* base) {
	RecentManagerGtk * self;
	guint _tmp0_;
	self = (RecentManagerGtk*) base;
	g_signal_parse_name ("changed", GTK_TYPE_RECENT_MANAGER, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (self->priv->recent_manager, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _recent_manager_gtk_items_changed_gtk_recent_manager_changed, self);
}


static gboolean _lambda0_ (RecentManagerGtk* self) {
	gboolean result = FALSE;
	GPtrArray* _tmp0_ = NULL;
	GPtrArray* _tmp1_;
	_tmp0_ = recent_manager_gtk_get_items (self);
	_tmp1_ = _tmp0_;
	g_signal_emit_by_name ((DataProvider*) self, "items-available", _tmp1_);
	_g_ptr_array_unref0 (_tmp1_);
	self->priv->idle_id = (guint) 0;
	result = FALSE;
	return result;
}


static gboolean __lambda0__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda0_ (self);
	return result;
}


static void recent_manager_gtk_items_changed (RecentManagerGtk* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->idle_id == 0) {
		guint _tmp0_;
		_tmp0_ = g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda0__gsource_func, g_object_ref (self), g_object_unref);
		self->priv->idle_id = _tmp0_;
	}
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static gpointer _gtk_recent_info_ref0 (gpointer self) {
	return self ? gtk_recent_info_ref (self) : NULL;
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}


static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static void _gtk_recent_info_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (gtk_recent_info_unref (var), NULL));
}


static void _g_list_free__gtk_recent_info_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _gtk_recent_info_unref0_, NULL);
	g_list_free (self);
}


GPtrArray* recent_manager_gtk_get_items (RecentManagerGtk* self) {
	GPtrArray* result = NULL;
	GPtrArray* _tmp0_ = NULL;
	GPtrArray* events;
	gint64 _tmp1_;
	gint64 signal_time;
	DataHub* _tmp2_ = NULL;
	gint _tmp3_;
	gchar** _tmp4_ = NULL;
	gchar** ignored_actors;
	gint ignored_actors_length1;
	gint _ignored_actors_size_;
	GList* _tmp5_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_ptr_array_new_with_free_func (_g_object_unref0_);
	events = _tmp0_;
	_tmp1_ = zeitgeist_timestamp_for_now ();
	signal_time = _tmp1_;
	_tmp2_ = data_provider_get_datahub ((DataProvider*) self);
	_tmp4_ = data_hub_get_data_source_actors (_tmp2_, TRUE, &_tmp3_);
	ignored_actors = _tmp4_;
	ignored_actors_length1 = _tmp3_;
	_ignored_actors_size_ = _tmp3_;
	_tmp5_ = gtk_recent_manager_get_items (self->priv->recent_manager);
	{
		GList* ri_collection;
		GList* ri_it;
		ri_collection = _tmp5_;
		for (ri_it = ri_collection; ri_it != NULL; ri_it = ri_it->next) {
			GtkRecentInfo* _tmp6_;
			GtkRecentInfo* ri;
			_tmp6_ = _gtk_recent_info_ref0 ((GtkRecentInfo*) ri_it->data);
			ri = _tmp6_;
			{
				const gchar* _tmp7_ = NULL;
				const gchar* uri;
				gboolean _tmp8_ = FALSE;
				gboolean _tmp9_ = FALSE;
				gboolean _tmp10_;
				gchar* _tmp13_ = NULL;
				gchar* _tmp14_;
				gchar* _tmp15_ = NULL;
				gchar* _tmp16_;
				gchar* last_app;
				const gchar* exec_str = NULL;
				guint count = 0U;
				gulong time_ = 0UL;
				const gchar* _tmp17_ = NULL;
				guint _tmp18_;
				gulong _tmp19_;
				gboolean _tmp20_;
				gboolean registered;
				gchar** _tmp21_;
				gchar** _tmp22_ = NULL;
				gchar** exec;
				gint exec_length1;
				gint _exec_size_;
				gchar* desktop_file = NULL;
				gboolean _tmp23_ = FALSE;
				gchar* _tmp29_ = NULL;
				gchar* _tmp30_;
				gchar* _tmp31_ = NULL;
				gchar* _tmp32_;
				gchar* actor;
				const gchar* _tmp33_ = NULL;
				gchar* _tmp34_ = NULL;
				gchar* origin;
				const gchar* _tmp35_ = NULL;
				const gchar* _tmp36_ = NULL;
				const gchar* _tmp37_ = NULL;
				const gchar* _tmp38_ = NULL;
				const gchar* _tmp39_ = NULL;
				const gchar* _tmp40_ = NULL;
				const gchar* _tmp41_ = NULL;
				ZeitgeistSubject* _tmp42_ = NULL;
				ZeitgeistSubject* subject;
				ZeitgeistEvent* event = NULL;
				gint64 timestamp = 0LL;
				ZeitgeistEvent* _tmp43_ = NULL;
				ZeitgeistEvent* _tmp44_;
				gulong _tmp45_;
				gboolean _tmp46_ = FALSE;
				gint64 _tmp47_;
				ZeitgeistEvent* _tmp49_ = NULL;
				ZeitgeistEvent* _tmp50_;
				gulong _tmp51_;
				gboolean _tmp52_ = FALSE;
				gint64 _tmp53_;
				ZeitgeistEvent* _tmp55_ = NULL;
				ZeitgeistEvent* _tmp56_;
				gulong _tmp57_;
				gboolean _tmp58_ = FALSE;
				gint64 _tmp59_;
				_tmp7_ = gtk_recent_info_get_uri (ri);
				uri = _tmp7_;
				_tmp10_ = gtk_recent_info_exists (ri);
				if (!_tmp10_) {
					_tmp9_ = TRUE;
				} else {
					gboolean _tmp11_;
					_tmp11_ = gtk_recent_info_get_private_hint (ri);
					_tmp9_ = _tmp11_;
				}
				if (_tmp9_) {
					_tmp8_ = TRUE;
				} else {
					gboolean _tmp12_;
					_tmp12_ = g_str_has_prefix (uri, "file:///tmp/");
					_tmp8_ = _tmp12_;
				}
				if (_tmp8_) {
					_gtk_recent_info_unref0 (ri);
					continue;
				}
				_tmp13_ = gtk_recent_info_last_application (ri);
				_tmp14_ = _tmp13_;
				_tmp15_ = string_strip (_tmp14_);
				last_app = (_tmp16_ = _tmp15_, _g_free0 (_tmp14_), _tmp16_);
				_tmp20_ = gtk_recent_info_get_application_info (ri, last_app, &_tmp17_, &_tmp18_, &_tmp19_);
				exec_str = _tmp17_;
				count = _tmp18_;
				time_ = _tmp19_;
				registered = _tmp20_;
				if (!registered) {
					g_warning ("recent-manager-provider.vala:106: %s was not registered in RecentInfo " \
"item %p", last_app, ri);
					_g_free0 (last_app);
					_gtk_recent_info_unref0 (ri);
					continue;
				}
				_tmp22_ = _tmp21_ = g_strsplit_set (exec_str, " \t\n", 2);
				exec = _tmp22_;
				exec_length1 = _vala_array_length (_tmp21_);
				_exec_size_ = _vala_array_length (_tmp21_);
				if (g_strcmp0 (exec[0], "soffice") == 0) {
					_tmp23_ = TRUE;
				} else {
					_tmp23_ = g_strcmp0 (exec[0], "ooffice") == 0;
				}
				if (_tmp23_) {
					const gchar* _tmp24_ = NULL;
					gchar* _tmp25_ = NULL;
					gchar* _tmp26_;
					_tmp24_ = gtk_recent_info_get_mime_type (ri);
					_tmp25_ = recent_manager_gtk_get_ooo_desktop_file_for_mimetype (self, _tmp24_);
					_tmp26_ = _tmp25_;
					_g_free0 (desktop_file);
					desktop_file = _tmp26_;
				} else {
					gchar* _tmp27_ = NULL;
					gchar* _tmp28_;
					_tmp27_ = recent_manager_gtk_find_desktop_file_for_app (self, exec[0], NULL);
					_tmp28_ = _tmp27_;
					_g_free0 (desktop_file);
					desktop_file = _tmp28_;
				}
				if (desktop_file == NULL) {
					g_warning ("recent-manager-provider.vala:125: Desktop file for %s was not found", exec[0]);
					_g_free0 (desktop_file);
					exec = (_vala_array_free (exec, exec_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (last_app);
					_gtk_recent_info_unref0 (ri);
					continue;
				}
				_tmp29_ = g_path_get_basename (desktop_file);
				_tmp30_ = _tmp29_;
				_tmp31_ = g_strdup_printf ("application://%s", _tmp30_);
				actor = (_tmp32_ = _tmp31_, _g_free0 (_tmp30_), _tmp32_);
				if (_vala_string_array_contains (ignored_actors, ignored_actors_length1, actor)) {
					_g_free0 (actor);
					_g_free0 (desktop_file);
					exec = (_vala_array_free (exec, exec_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (last_app);
					_gtk_recent_info_unref0 (ri);
					continue;
				}
				_tmp33_ = gtk_recent_info_get_uri (ri);
				_tmp34_ = g_path_get_dirname (_tmp33_);
				origin = _tmp34_;
				_tmp35_ = gtk_recent_info_get_uri (ri);
				_tmp36_ = gtk_recent_info_get_mime_type (ri);
				_tmp37_ = zeitgeist_interpretation_for_mimetype (_tmp36_);
				_tmp38_ = gtk_recent_info_get_uri (ri);
				_tmp39_ = zeitgeist_manifestation_for_uri (_tmp38_);
				_tmp40_ = gtk_recent_info_get_mime_type (ri);
				_tmp41_ = gtk_recent_info_get_display_name (ri);
				_tmp42_ = zeitgeist_subject_new_full (_tmp35_, _tmp37_, _tmp39_, _tmp40_, origin, _tmp41_, "");
				subject = g_object_ref_sink (_tmp42_);
				_tmp43_ = zeitgeist_event_new_full (ZEITGEIST_ZG_CREATE_EVENT, ZEITGEIST_ZG_USER_ACTIVITY, actor, subject, NULL, NULL);
				_tmp44_ = g_object_ref_sink (_tmp43_);
				_g_object_unref0 (event);
				event = _tmp44_;
				_tmp45_ = gtk_recent_info_get_added (ri);
				timestamp = (gint64) _tmp45_;
				timestamp = timestamp * ((gint64) 1000);
				zeitgeist_event_set_timestamp (event, timestamp);
				_tmp47_ = data_provider_get_last_timestamp ((DataProvider*) self);
				if (timestamp > _tmp47_) {
					_tmp46_ = timestamp >= 0;
				} else {
					_tmp46_ = FALSE;
				}
				if (_tmp46_) {
					ZeitgeistEvent* _tmp48_;
					_tmp48_ = event;
					event = NULL;
					g_ptr_array_add (events, _tmp48_);
				}
				_tmp49_ = zeitgeist_event_new_full (ZEITGEIST_ZG_MODIFY_EVENT, ZEITGEIST_ZG_USER_ACTIVITY, actor, subject, NULL, NULL);
				_tmp50_ = g_object_ref_sink (_tmp49_);
				_g_object_unref0 (event);
				event = _tmp50_;
				_tmp51_ = gtk_recent_info_get_modified (ri);
				timestamp = (gint64) _tmp51_;
				timestamp = timestamp * ((gint64) 1000);
				zeitgeist_event_set_timestamp (event, timestamp);
				_tmp53_ = data_provider_get_last_timestamp ((DataProvider*) self);
				if (timestamp > _tmp53_) {
					_tmp52_ = timestamp >= 0;
				} else {
					_tmp52_ = FALSE;
				}
				if (_tmp52_) {
					ZeitgeistEvent* _tmp54_;
					_tmp54_ = event;
					event = NULL;
					g_ptr_array_add (events, _tmp54_);
				}
				_tmp55_ = zeitgeist_event_new_full (ZEITGEIST_ZG_ACCESS_EVENT, ZEITGEIST_ZG_USER_ACTIVITY, actor, subject, NULL, NULL);
				_tmp56_ = g_object_ref_sink (_tmp55_);
				_g_object_unref0 (event);
				event = _tmp56_;
				_tmp57_ = gtk_recent_info_get_visited (ri);
				timestamp = (gint64) _tmp57_;
				timestamp = timestamp * ((gint64) 1000);
				zeitgeist_event_set_timestamp (event, timestamp);
				_tmp59_ = data_provider_get_last_timestamp ((DataProvider*) self);
				if (timestamp > _tmp59_) {
					_tmp58_ = timestamp >= 0;
				} else {
					_tmp58_ = FALSE;
				}
				if (_tmp58_) {
					ZeitgeistEvent* _tmp60_;
					_tmp60_ = event;
					event = NULL;
					g_ptr_array_add (events, _tmp60_);
				}
				_g_object_unref0 (event);
				_g_object_unref0 (subject);
				_g_free0 (origin);
				_g_free0 (actor);
				_g_free0 (desktop_file);
				exec = (_vala_array_free (exec, exec_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (last_app);
				_gtk_recent_info_unref0 (ri);
			}
		}
		__g_list_free__gtk_recent_info_unref0_0 (ri_collection);
	}
	data_provider_set_last_timestamp ((DataProvider*) self, signal_time);
	result = events;
	ignored_actors = (_vala_array_free (ignored_actors, ignored_actors_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static gchar* recent_manager_gtk_get_ooo_desktop_file_for_mimetype (RecentManagerGtk* self, const gchar* mimetype) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (mimetype != NULL, NULL);
	_tmp0_ = recent_manager_gtk_find_desktop_file_for_app (self, "libreoffice", mimetype);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		_tmp2_ = recent_manager_gtk_find_desktop_file_for_app (self, "ooffice", mimetype);
		_tmp3_ = _tmp2_;
		_g_free0 (_tmp1_);
		_tmp1_ = _tmp3_;
	}
	result = _tmp1_;
	return result;
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}


static gchar* recent_manager_gtk_find_desktop_file_for_app (RecentManagerGtk* self, const gchar* app_name, const gchar* mimetype) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp5_;
	gchar* hash_name;
	gconstpointer _tmp6_ = NULL;
	const gchar* in_cache;
	gchar** _tmp8_;
	gchar** _tmp9_ = NULL;
	gchar** _tmp10_;
	gchar** _tmp11_;
	gchar** data_dirs;
	gint data_dirs_length1;
	gint _data_dirs_size_;
	const gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (app_name != NULL, NULL);
	if (mimetype != NULL) {
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		_tmp1_ = g_strdup_printf ("%s::%s", app_name, mimetype);
		_tmp2_ = _tmp1_;
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp2_;
	} else {
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = g_strdup (app_name);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp4_;
	}
	_tmp5_ = g_strdup (_tmp0_);
	hash_name = _tmp5_;
	_tmp6_ = g_hash_table_lookup (self->priv->app_to_desktop_file, hash_name);
	in_cache = (const gchar*) _tmp6_;
	if (in_cache != NULL) {
		gchar* _tmp7_;
		_tmp7_ = g_strdup (in_cache);
		result = _tmp7_;
		_g_free0 (hash_name);
		_g_free0 (_tmp0_);
		return result;
	}
	_tmp9_ = _tmp8_ = g_get_system_data_dirs ();
	_tmp10_ = (_tmp11_ = _tmp9_, (_tmp11_ == NULL) ? ((gpointer) _tmp11_) : _vala_array_dup1 (_tmp11_, _vala_array_length (_tmp8_)));
	data_dirs = _tmp10_;
	data_dirs_length1 = _vala_array_length (_tmp8_);
	_data_dirs_size_ = _vala_array_length (_tmp8_);
	_tmp12_ = g_get_user_data_dir ();
	_tmp13_ = g_strdup (_tmp12_);
	_vala_array_add1 (&data_dirs, &data_dirs_length1, &_data_dirs_size_, _tmp13_);
	{
		gchar** dir_collection;
		int dir_collection_length1;
		int dir_it;
		dir_collection = data_dirs;
		dir_collection_length1 = data_dirs_length1;
		for (dir_it = 0; dir_it < data_dirs_length1; dir_it = dir_it + 1) {
			const gchar* dir;
			dir = dir_collection[dir_it];
			{
				gchar* _tmp14_ = NULL;
				gchar* _tmp15_;
				gchar* _tmp16_ = NULL;
				gchar* _tmp17_;
				gchar* p;
				GFile* _tmp18_ = NULL;
				GFile* f;
				gboolean _tmp19_;
				_tmp14_ = g_strdup_printf ("%s.desktop", app_name);
				_tmp15_ = _tmp14_;
				_tmp16_ = g_build_filename (dir, "applications", _tmp15_, NULL, NULL);
				p = (_tmp17_ = _tmp16_, _g_free0 (_tmp15_), _tmp17_);
				_tmp18_ = g_file_new_for_path (p);
				f = _tmp18_;
				_tmp19_ = g_file_query_exists (f, NULL);
				if (_tmp19_) {
					gchar* _tmp20_;
					gchar* _tmp21_;
					_tmp20_ = g_strdup (hash_name);
					_tmp21_ = g_strdup (p);
					g_hash_table_insert (self->priv->app_to_desktop_file, _tmp20_, _tmp21_);
					result = p;
					_g_object_unref0 (f);
					data_dirs = (_vala_array_free (data_dirs, data_dirs_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (hash_name);
					_g_free0 (_tmp0_);
					return result;
				}
				_g_object_unref0 (f);
				_g_free0 (p);
			}
		}
	}
	{
		gchar** dir_collection;
		int dir_collection_length1;
		int dir_it;
		dir_collection = data_dirs;
		dir_collection_length1 = data_dirs_length1;
		for (dir_it = 0; dir_it < data_dirs_length1; dir_it = dir_it + 1) {
			const gchar* dir;
			dir = dir_collection[dir_it];
			{
				gchar* _tmp22_ = NULL;
				gchar* p;
				GFile* _tmp23_ = NULL;
				GFile* app_dir;
				gboolean _tmp24_;
				GFileEnumerator* _tmp25_ = NULL;
				GFileEnumerator* enumerator;
				GFileInfo* _tmp26_ = NULL;
				GFileInfo* fi;
				_tmp22_ = g_build_filename (dir, "applications", NULL, NULL);
				p = _tmp22_;
				_tmp23_ = g_file_new_for_path (p);
				app_dir = _tmp23_;
				_tmp24_ = g_file_query_exists (app_dir, NULL);
				if (!_tmp24_) {
					_g_object_unref0 (app_dir);
					_g_free0 (p);
					continue;
				}
				_tmp25_ = g_file_enumerate_children (app_dir, G_FILE_ATTRIBUTE_STANDARD_NAME, 0, NULL, &_inner_error_);
				enumerator = _tmp25_;
				if (_inner_error_ != NULL) {
					goto __catch1_g_error;
				}
				_tmp26_ = g_file_enumerator_next_file (enumerator, NULL, &_inner_error_);
				fi = _tmp26_;
				if (_inner_error_ != NULL) {
					_g_object_unref0 (enumerator);
					goto __catch1_g_error;
				}
				while (TRUE) {
					const gchar* _tmp27_ = NULL;
					gboolean _tmp28_;
					GFileInfo* _tmp43_ = NULL;
					GFileInfo* _tmp44_;
					GFileInfo* _tmp45_;
					if (!(fi != NULL)) {
						break;
					}
					_tmp27_ = g_file_info_get_name (fi);
					_tmp28_ = g_str_has_suffix (_tmp27_, ".desktop");
					if (_tmp28_) {
						gchar* contents = NULL;
						const gchar* _tmp29_ = NULL;
						gchar* _tmp30_ = NULL;
						gchar* desktop_file;
						GFile* _tmp31_ = NULL;
						GFile* f;
						gchar* _tmp32_ = NULL;
						gboolean _tmp33_;
						gboolean _tmp34_;
						_tmp29_ = g_file_info_get_name (fi);
						_tmp30_ = g_build_filename (p, _tmp29_, NULL, NULL);
						desktop_file = _tmp30_;
						_tmp31_ = g_file_new_for_path (desktop_file);
						f = _tmp31_;
						_tmp33_ = g_file_load_contents (f, NULL, &_tmp32_, NULL, NULL, &_inner_error_);
						_g_free0 (contents);
						contents = _tmp32_;
						_tmp34_ = _tmp33_;
						if (_inner_error_ != NULL) {
							goto __catch2_g_error;
						}
						if (_tmp34_) {
							gchar* _tmp35_ = NULL;
							gchar* _tmp36_;
							gboolean _tmp37_;
							gboolean _tmp38_;
							_tmp35_ = g_strdup_printf ("Exec=%s", app_name);
							_tmp36_ = _tmp35_;
							_tmp37_ = string_contains (contents, _tmp36_);
							if ((_tmp38_ = _tmp37_, _g_free0 (_tmp36_), _tmp38_)) {
								gboolean _tmp39_ = FALSE;
								if (mimetype == NULL) {
									_tmp39_ = TRUE;
								} else {
									gboolean _tmp40_;
									_tmp40_ = string_contains (contents, mimetype);
									_tmp39_ = _tmp40_;
								}
								if (_tmp39_) {
									gchar* _tmp41_;
									gchar* _tmp42_;
									_tmp41_ = g_strdup (hash_name);
									_tmp42_ = g_strdup (desktop_file);
									g_hash_table_insert (self->priv->app_to_desktop_file, _tmp41_, _tmp42_);
									result = desktop_file;
									_g_object_unref0 (f);
									_g_free0 (contents);
									_g_object_unref0 (fi);
									_g_object_unref0 (enumerator);
									_g_object_unref0 (app_dir);
									_g_free0 (p);
									data_dirs = (_vala_array_free (data_dirs, data_dirs_length1, (GDestroyNotify) g_free), NULL);
									_g_free0 (hash_name);
									_g_free0 (_tmp0_);
									return result;
								}
							}
						}
						goto __finally2;
						__catch2_g_error:
						{
							GError * err;
							err = _inner_error_;
							_inner_error_ = NULL;
							g_warning ("recent-manager-provider.vala:259: %s", err->message);
							_g_error_free0 (err);
						}
						__finally2:
						if (_inner_error_ != NULL) {
							_g_object_unref0 (f);
							_g_free0 (desktop_file);
							_g_free0 (contents);
							_g_object_unref0 (fi);
							_g_object_unref0 (enumerator);
							goto __catch1_g_error;
						}
						_g_object_unref0 (f);
						_g_free0 (desktop_file);
						_g_free0 (contents);
					}
					_tmp43_ = g_file_enumerator_next_file (enumerator, NULL, &_inner_error_);
					_tmp44_ = _tmp43_;
					if (_inner_error_ != NULL) {
						_g_object_unref0 (fi);
						_g_object_unref0 (enumerator);
						goto __catch1_g_error;
					}
					_tmp45_ = _tmp44_;
					_g_object_unref0 (fi);
					fi = _tmp45_;
				}
				g_file_enumerator_close (enumerator, NULL, &_inner_error_);
				if (_inner_error_ != NULL) {
					_g_object_unref0 (fi);
					_g_object_unref0 (enumerator);
					goto __catch1_g_error;
				}
				_g_object_unref0 (fi);
				_g_object_unref0 (enumerator);
				goto __finally1;
				__catch1_g_error:
				{
					GError * err;
					err = _inner_error_;
					_inner_error_ = NULL;
					g_warning ("recent-manager-provider.vala:269: %s", err->message);
					_g_error_free0 (err);
				}
				__finally1:
				if (_inner_error_ != NULL) {
					_g_object_unref0 (app_dir);
					_g_free0 (p);
					data_dirs = (_vala_array_free (data_dirs, data_dirs_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (hash_name);
					_g_free0 (_tmp0_);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				_g_object_unref0 (app_dir);
				_g_free0 (p);
			}
		}
	}
	result = NULL;
	data_dirs = (_vala_array_free (data_dirs, data_dirs_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (hash_name);
	_g_free0 (_tmp0_);
	return result;
}


static const gchar* recent_manager_gtk_real_get_unique_id (DataProvider* base) {
	const gchar* result;
	RecentManagerGtk* self;
	self = (RecentManagerGtk*) base;
	result = self->priv->_unique_id;
	return result;
}


static void recent_manager_gtk_real_set_unique_id (DataProvider* base, const gchar* value) {
	RecentManagerGtk* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	self = (RecentManagerGtk*) base;
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_unique_id);
	self->priv->_unique_id = _tmp1_;
	g_object_notify ((GObject *) self, "unique-id");
}


static const gchar* recent_manager_gtk_real_get_name (DataProvider* base) {
	const gchar* result;
	RecentManagerGtk* self;
	self = (RecentManagerGtk*) base;
	result = self->priv->_name;
	return result;
}


static void recent_manager_gtk_real_set_name (DataProvider* base, const gchar* value) {
	RecentManagerGtk* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	self = (RecentManagerGtk*) base;
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp1_;
	g_object_notify ((GObject *) self, "name");
}


static const gchar* recent_manager_gtk_real_get_description (DataProvider* base) {
	const gchar* result;
	RecentManagerGtk* self;
	self = (RecentManagerGtk*) base;
	result = self->priv->_description;
	return result;
}


static void recent_manager_gtk_real_set_description (DataProvider* base, const gchar* value) {
	RecentManagerGtk* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	self = (RecentManagerGtk*) base;
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_description);
	self->priv->_description = _tmp1_;
	g_object_notify ((GObject *) self, "description");
}


static DataHub* recent_manager_gtk_real_get_datahub (DataProvider* base) {
	DataHub* result;
	RecentManagerGtk* self;
	self = (RecentManagerGtk*) base;
	result = self->priv->_datahub;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void recent_manager_gtk_real_set_datahub (DataProvider* base, DataHub* value) {
	RecentManagerGtk* self;
	DataHub* _tmp0_;
	DataHub* _tmp1_;
	self = (RecentManagerGtk*) base;
	_tmp0_ = _g_object_ref0 (value);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->_datahub);
	self->priv->_datahub = _tmp1_;
	g_object_notify ((GObject *) self, "datahub");
}


static gboolean recent_manager_gtk_real_get_enabled (DataProvider* base) {
	gboolean result;
	RecentManagerGtk* self;
	self = (RecentManagerGtk*) base;
	result = self->priv->_enabled;
	return result;
}


static void recent_manager_gtk_real_set_enabled (DataProvider* base, gboolean value) {
	RecentManagerGtk* self;
	self = (RecentManagerGtk*) base;
	self->priv->_enabled = value;
	g_object_notify ((GObject *) self, "enabled");
}


static gboolean recent_manager_gtk_real_get_register (DataProvider* base) {
	gboolean result;
	RecentManagerGtk* self;
	self = (RecentManagerGtk*) base;
	result = self->priv->_register;
	return result;
}


static void recent_manager_gtk_real_set_register (DataProvider* base, gboolean value) {
	RecentManagerGtk* self;
	self = (RecentManagerGtk*) base;
	self->priv->_register = value;
	g_object_notify ((GObject *) self, "register");
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static GObject * recent_manager_gtk_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	RecentManagerGtk * self;
	GHashTable* _tmp0_ = NULL;
	GHashTable* _tmp1_;
	GtkRecentManager* _tmp2_ = NULL;
	parent_class = G_OBJECT_CLASS (recent_manager_gtk_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = RECENT_MANAGER_GTK (obj);
	_tmp0_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, _g_free0_);
	_tmp1_ = _tmp0_;
	_g_hash_table_unref0 (self->priv->app_to_desktop_file);
	self->priv->app_to_desktop_file = _tmp1_;
	_tmp2_ = gtk_recent_manager_get_default ();
	self->priv->recent_manager = _tmp2_;
	gtk_recent_manager_set_limit (self->priv->recent_manager, -1);
	return obj;
}


static void recent_manager_gtk_class_init (RecentManagerGtkClass * klass) {
	recent_manager_gtk_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RecentManagerGtkPrivate));
	DATA_PROVIDER_CLASS (klass)->start = recent_manager_gtk_real_start;
	DATA_PROVIDER_CLASS (klass)->stop = recent_manager_gtk_real_stop;
	DATA_PROVIDER_CLASS (klass)->get_unique_id = recent_manager_gtk_real_get_unique_id;
	DATA_PROVIDER_CLASS (klass)->set_unique_id = recent_manager_gtk_real_set_unique_id;
	DATA_PROVIDER_CLASS (klass)->get_name = recent_manager_gtk_real_get_name;
	DATA_PROVIDER_CLASS (klass)->set_name = recent_manager_gtk_real_set_name;
	DATA_PROVIDER_CLASS (klass)->get_description = recent_manager_gtk_real_get_description;
	DATA_PROVIDER_CLASS (klass)->set_description = recent_manager_gtk_real_set_description;
	DATA_PROVIDER_CLASS (klass)->get_datahub = recent_manager_gtk_real_get_datahub;
	DATA_PROVIDER_CLASS (klass)->set_datahub = recent_manager_gtk_real_set_datahub;
	DATA_PROVIDER_CLASS (klass)->get_enabled = recent_manager_gtk_real_get_enabled;
	DATA_PROVIDER_CLASS (klass)->set_enabled = recent_manager_gtk_real_set_enabled;
	DATA_PROVIDER_CLASS (klass)->get_register = recent_manager_gtk_real_get_register;
	DATA_PROVIDER_CLASS (klass)->set_register = recent_manager_gtk_real_set_register;
	G_OBJECT_CLASS (klass)->get_property = _vala_recent_manager_gtk_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_recent_manager_gtk_set_property;
	G_OBJECT_CLASS (klass)->constructor = recent_manager_gtk_constructor;
	G_OBJECT_CLASS (klass)->finalize = recent_manager_gtk_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), RECENT_MANAGER_GTK_UNIQUE_ID, "unique-id");
	g_object_class_override_property (G_OBJECT_CLASS (klass), RECENT_MANAGER_GTK_NAME, "name");
	g_object_class_override_property (G_OBJECT_CLASS (klass), RECENT_MANAGER_GTK_DESCRIPTION, "description");
	g_object_class_override_property (G_OBJECT_CLASS (klass), RECENT_MANAGER_GTK_DATAHUB, "datahub");
	g_object_class_override_property (G_OBJECT_CLASS (klass), RECENT_MANAGER_GTK_ENABLED, "enabled");
	g_object_class_override_property (G_OBJECT_CLASS (klass), RECENT_MANAGER_GTK_REGISTER, "register");
}


static void recent_manager_gtk_instance_init (RecentManagerGtk * self) {
	self->priv = RECENT_MANAGER_GTK_GET_PRIVATE (self);
	self->priv->_enabled = TRUE;
	self->priv->_register = TRUE;
	self->priv->idle_id = (guint) 0;
}


static void recent_manager_gtk_finalize (GObject* obj) {
	RecentManagerGtk * self;
	self = RECENT_MANAGER_GTK (obj);
	_g_free0 (self->priv->_unique_id);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_description);
	_g_object_unref0 (self->priv->_datahub);
	_g_hash_table_unref0 (self->priv->app_to_desktop_file);
	G_OBJECT_CLASS (recent_manager_gtk_parent_class)->finalize (obj);
}


GType recent_manager_gtk_get_type (void) {
	static volatile gsize recent_manager_gtk_type_id__volatile = 0;
	if (g_once_init_enter (&recent_manager_gtk_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RecentManagerGtkClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) recent_manager_gtk_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RecentManagerGtk), 0, (GInstanceInitFunc) recent_manager_gtk_instance_init, NULL };
		GType recent_manager_gtk_type_id;
		recent_manager_gtk_type_id = g_type_register_static (TYPE_DATA_PROVIDER, "RecentManagerGtk", &g_define_type_info, 0);
		g_once_init_leave (&recent_manager_gtk_type_id__volatile, recent_manager_gtk_type_id);
	}
	return recent_manager_gtk_type_id__volatile;
}


static void _vala_recent_manager_gtk_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RecentManagerGtk * self;
	self = RECENT_MANAGER_GTK (object);
	switch (property_id) {
		case RECENT_MANAGER_GTK_UNIQUE_ID:
		g_value_set_string (value, data_provider_get_unique_id ((DataProvider*) self));
		break;
		case RECENT_MANAGER_GTK_NAME:
		g_value_set_string (value, data_provider_get_name ((DataProvider*) self));
		break;
		case RECENT_MANAGER_GTK_DESCRIPTION:
		g_value_set_string (value, data_provider_get_description ((DataProvider*) self));
		break;
		case RECENT_MANAGER_GTK_DATAHUB:
		g_value_set_object (value, data_provider_get_datahub ((DataProvider*) self));
		break;
		case RECENT_MANAGER_GTK_ENABLED:
		g_value_set_boolean (value, data_provider_get_enabled ((DataProvider*) self));
		break;
		case RECENT_MANAGER_GTK_REGISTER:
		g_value_set_boolean (value, data_provider_get_register ((DataProvider*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_recent_manager_gtk_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RecentManagerGtk * self;
	self = RECENT_MANAGER_GTK (object);
	switch (property_id) {
		case RECENT_MANAGER_GTK_UNIQUE_ID:
		data_provider_set_unique_id ((DataProvider*) self, g_value_get_string (value));
		break;
		case RECENT_MANAGER_GTK_NAME:
		data_provider_set_name ((DataProvider*) self, g_value_get_string (value));
		break;
		case RECENT_MANAGER_GTK_DESCRIPTION:
		data_provider_set_description ((DataProvider*) self, g_value_get_string (value));
		break;
		case RECENT_MANAGER_GTK_DATAHUB:
		data_provider_set_datahub ((DataProvider*) self, g_value_get_object (value));
		break;
		case RECENT_MANAGER_GTK_ENABLED:
		data_provider_set_enabled ((DataProvider*) self, g_value_get_boolean (value));
		break;
		case RECENT_MANAGER_GTK_REGISTER:
		data_provider_set_register ((DataProvider*) self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



