import logging
import time
import pprint

from _zeitgeist.engine.extension import Extension
from _zeitgeist.engine.sql import UnicodeCursor
from _zeitgeist.engine.main import ZeitgeistEngine

# needs http://code.google.com/p/python-sqlparse/
import sqlparse

def execute(self, sql, parameters=None):
    dbg_sql = sql
    if not dbg_sql.endswith(";"):
        dbg_sql = "%s;" %dbg_sql
    dbg_sql = dbg_sql.replace("\t", " ")
    dbg_sql = dbg_sql.replace("\n", " ")
    if parameters is not None:
        dbg_sql = dbg_sql.replace("?", "'%s'")
        dbg_sql = dbg_sql %tuple(parameters)
    try:
        s = sqlparse.format(dbg_sql, reindent=True)
    except:
        s = "no pretty sql: %s : %s" %(sql, parameters)
    start = time.time()
    result = self.__class__.execute(self, sql, parameters)
    logging.debug("# BEGIN SQL QUERY #\n%s\ntook %fs\n# END SQL QUERY" %(s, time.time() - start))
    return result
    
def find_events(self, return_mode, time_range, event_templates,
        storage_state, max_events, order, sender=None):
        logging.debug("# start finding events\n")
        logging.debug("# parameters: %s\n" %pprint.pformat(locals()))
        size = dict(
            (i, self._cursor.__class__.execute(
                self._cursor, "SELECT COUNT(*) FROM %s" %i).fetchone()[0]) for i in ("event", "uri", "mimetype", "interpretation", "manifestation", "actor")
        )
        logging.debug("# database size: %s" %pprint.pformat(size))
        
        start = time.time()
        result = self.__class__._find_events(self, return_mode, 
            time_range, event_templates, storage_state, max_events, order, sender=None)
        logging.debug("GOT %i events in %fs" %(len(result), time.time() - start))
        return result

class DebugSQL(Extension):
    PUBLIC_METHODS = []
    
    def __init__(self, engine):
        engine._cursor.execute = execute.__get__(engine._cursor, UnicodeCursor)
        engine._find_events = find_events.__get__(engine, ZeitgeistEngine)
