/* sql-schema.c generated by valac 0.16.0, the Vala compiler
 * generated from sql-schema.vala, do not modify */

/* sql-schema.vala
 *
 * Copyright © 2011 Collabora Ltd.
 *             By Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 * Copyright © 2011-2012 Canonical Ltd.
 *             By Michal Hruby <michal.hruby@canonical.com>
 *             By Siegfried-A. Gevatter <siegfried.gevatter@collabora.co.uk>
 *
 * Based upon a Python implementation (2009-2011) by:
 *  Markus Korn <thekorn@gmx.net>
 *  Mikkel Kamstrup Erlandsen <mikkel.kamstrup@gmail.com>
 *  Seif Lotfy <seif@lotfy.com>
 *  Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <sqlite3.h>
#include <glib/gstdio.h>


#define ZEITGEIST_SQ_LITE_TYPE_DATABASE_SCHEMA (zeitgeist_sq_lite_database_schema_get_type ())
#define ZEITGEIST_SQ_LITE_DATABASE_SCHEMA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_SQ_LITE_TYPE_DATABASE_SCHEMA, ZeitgeistSQLiteDatabaseSchema))
#define ZEITGEIST_SQ_LITE_DATABASE_SCHEMA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_SQ_LITE_TYPE_DATABASE_SCHEMA, ZeitgeistSQLiteDatabaseSchemaClass))
#define ZEITGEIST_SQ_LITE_IS_DATABASE_SCHEMA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_SQ_LITE_TYPE_DATABASE_SCHEMA))
#define ZEITGEIST_SQ_LITE_IS_DATABASE_SCHEMA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_SQ_LITE_TYPE_DATABASE_SCHEMA))
#define ZEITGEIST_SQ_LITE_DATABASE_SCHEMA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_SQ_LITE_TYPE_DATABASE_SCHEMA, ZeitgeistSQLiteDatabaseSchemaClass))

typedef struct _ZeitgeistSQLiteDatabaseSchema ZeitgeistSQLiteDatabaseSchema;
typedef struct _ZeitgeistSQLiteDatabaseSchemaClass ZeitgeistSQLiteDatabaseSchemaClass;
typedef struct _ZeitgeistSQLiteDatabaseSchemaPrivate ZeitgeistSQLiteDatabaseSchemaPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block3Data Block3Data;

struct _ZeitgeistSQLiteDatabaseSchema {
	GObject parent_instance;
	ZeitgeistSQLiteDatabaseSchemaPrivate * priv;
};

struct _ZeitgeistSQLiteDatabaseSchemaClass {
	GObjectClass parent_class;
};

typedef enum  {
	ZEITGEIST_ENGINE_ERROR_BACKUP_FAILED,
	ZEITGEIST_ENGINE_ERROR_DATABASE_BUSY,
	ZEITGEIST_ENGINE_ERROR_DATABASE_CANTOPEN,
	ZEITGEIST_ENGINE_ERROR_DATABASE_CORRUPT,
	ZEITGEIST_ENGINE_ERROR_DATABASE_ERROR,
	ZEITGEIST_ENGINE_ERROR_DATABASE_RETIRE_FAILED,
	ZEITGEIST_ENGINE_ERROR_EXISTING_INSTANCE,
	ZEITGEIST_ENGINE_ERROR_INVALID_ARGUMENT,
	ZEITGEIST_ENGINE_ERROR_INVALID_KEY,
	ZEITGEIST_ENGINE_ERROR_INVALID_SIGNATURE,
	ZEITGEIST_ENGINE_ERROR_TOO_MANY_RESULTS
} ZeitgeistEngineError;
#define ZEITGEIST_ENGINE_ERROR zeitgeist_engine_error_quark ()
struct _Block3Data {
	int _ref_count_;
	gint64 schema_version;
};


static gpointer zeitgeist_sq_lite_database_schema_parent_class = NULL;

GType zeitgeist_sq_lite_database_schema_get_type (void) G_GNUC_CONST;
enum  {
	ZEITGEIST_SQ_LITE_DATABASE_SCHEMA_DUMMY_PROPERTY
};
#define ZEITGEIST_SQ_LITE_DATABASE_SCHEMA_CORE_SCHEMA "core"
#define ZEITGEIST_SQ_LITE_DATABASE_SCHEMA_CORE_SCHEMA_VERSION 7
#define ZEITGEIST_SQ_LITE_DATABASE_SCHEMA_DATABASE_CREATION "database_creation"
GQuark zeitgeist_engine_error_quark (void);
void zeitgeist_sq_lite_database_schema_ensure_schema (sqlite3* database, GError** error);
gboolean zeitgeist_utils_using_in_memory_database (void);
gint zeitgeist_sq_lite_database_schema_get_schema_version (sqlite3* database, GError** error);
void zeitgeist_sq_lite_database_schema_create_schema (sqlite3* database, GError** error);
void zeitgeist_sq_lite_database_schema_create_basic_indices (sqlite3* database, GError** error);
void zeitgeist_sq_lite_database_schema_create_event_indices (sqlite3* database, GError** error);
gint64 zeitgeist_timestamp_now (void);
static void zeitgeist_sq_lite_database_schema_exec_query (sqlite3* database, const gchar* sql, GError** error);
static void zeitgeist_sq_lite_database_schema_backup_database (GError** error);
void zeitgeist_sq_lite_database_schema_drop_event_indices (sqlite3* database, GError** error);
#define ZEITGEIST_NFO_WEB_DATA_OBJECT "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#WebDataObject"
void zeitgeist_utils_backup_database (GError** error);
static gint64 zeitgeist_sq_lite_database_schema_get_schema_metadata (sqlite3* database, const gchar* key);
gint64 zeitgeist_sq_lite_database_schema_get_creation_date (sqlite3* database);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static gint __lambda2_ (Block3Data* _data3_, gint n_cols, gchar** values, int values_length1, gchar** column_names, int column_names_length1);
static gint ___lambda2__sqlite3_callback (gpointer self, gint n_columns, gchar** values, gchar** column_names);
void zeitgeist_sq_lite_database_schema_set_corruption_flag (sqlite3* database, GError** error);
static void zeitgeist_sq_lite_database_schema_set_schema_version (sqlite3* database, gint schema_version, GError** error);
const gchar* zeitgeist_utils_get_database_file_path (void);
const gchar* zeitgeist_utils_get_data_path (void);
gchar* zeitgeist_utils_get_default_data_path (void);
ZeitgeistSQLiteDatabaseSchema* zeitgeist_sq_lite_database_schema_new (void);
ZeitgeistSQLiteDatabaseSchema* zeitgeist_sq_lite_database_schema_construct (GType object_type);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


void zeitgeist_sq_lite_database_schema_ensure_schema (sqlite3* database, GError** error) {
	gint _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
	gint _tmp4_;
	gint schema_version;
	gint _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (database != NULL);
	_tmp1_ = zeitgeist_utils_using_in_memory_database ();
	if (_tmp1_) {
		_tmp0_ = -1;
	} else {
		sqlite3* _tmp2_;
		gint _tmp3_ = 0;
		_tmp2_ = database;
		_tmp3_ = zeitgeist_sq_lite_database_schema_get_schema_version (_tmp2_, &_inner_error_);
		_tmp0_ = _tmp3_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	_tmp4_ = _tmp0_;
	schema_version = _tmp4_;
	_tmp5_ = schema_version;
	if (_tmp5_ == (-1)) {
		sqlite3* _tmp6_;
		sqlite3* _tmp7_;
		sqlite3* _tmp8_;
		gint64 _tmp9_ = 0LL;
		gchar* _tmp10_ = NULL;
		gchar* schema_sql;
		sqlite3* _tmp11_;
		const gchar* _tmp12_;
		_tmp6_ = database;
		zeitgeist_sq_lite_database_schema_create_schema (_tmp6_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp7_ = database;
		zeitgeist_sq_lite_database_schema_create_basic_indices (_tmp7_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp8_ = database;
		zeitgeist_sq_lite_database_schema_create_event_indices (_tmp8_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp9_ = zeitgeist_timestamp_now ();
		_tmp10_ = g_strdup_printf ("INSERT INTO schema_version VALUES ('%s', %" G_GINT64_FORMAT ")", ZEITGEIST_SQ_LITE_DATABASE_SCHEMA_DATABASE_CREATION, _tmp9_);
		schema_sql = _tmp10_;
		_tmp11_ = database;
		_tmp12_ = schema_sql;
		zeitgeist_sq_lite_database_schema_exec_query (_tmp11_, _tmp12_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (schema_sql);
				return;
			} else {
				_g_free0 (schema_sql);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_g_free0 (schema_sql);
	} else {
		gboolean _tmp13_ = FALSE;
		gint _tmp14_;
		gboolean _tmp16_;
		_tmp14_ = schema_version;
		if (_tmp14_ >= 3) {
			gint _tmp15_;
			_tmp15_ = schema_version;
			_tmp13_ = _tmp15_ <= 6;
		} else {
			_tmp13_ = FALSE;
		}
		_tmp16_ = _tmp13_;
		if (_tmp16_) {
			gint _tmp17_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			gchar** _tmp27_ = NULL;
			gchar** tables;
			gint tables_length1;
			gint _tables_size_;
			gchar** _tmp28_;
			gint _tmp28__length1;
			sqlite3* _tmp34_;
			sqlite3* _tmp35_;
			sqlite3* _tmp36_;
			sqlite3* _tmp37_;
			gchar** _tmp38_;
			gint _tmp38__length1;
			gint _tmp48_;
			sqlite3* _tmp51_;
			gchar* _tmp52_ = NULL;
			gchar* _tmp53_;
			sqlite3* _tmp54_;
			zeitgeist_sq_lite_database_schema_backup_database (&_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			_tmp17_ = schema_version;
			if (_tmp17_ == 3) {
				sqlite3* _tmp18_;
				sqlite3* _tmp19_;
				sqlite3* _tmp20_;
				sqlite3* _tmp21_;
				sqlite3* _tmp22_;
				_tmp18_ = database;
				zeitgeist_sq_lite_database_schema_exec_query (_tmp18_, "ALTER TABLE storage ADD COLUMN icon VARCHAR", &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				_tmp19_ = database;
				zeitgeist_sq_lite_database_schema_exec_query (_tmp19_, "ALTER TABLE storage ADD COLUMN display_name VARCHAR", &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				_tmp20_ = database;
				zeitgeist_sq_lite_database_schema_exec_query (_tmp20_, "\n" \
"                        INSERT OR IGNORE INTO storage (value, state)\n" \
"                            VALUES ('unknown', 1)\n" \
"                        ", &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				_tmp21_ = database;
				zeitgeist_sq_lite_database_schema_exec_query (_tmp21_, "\n" \
"                        UPDATE event SET subj_storage =\n" \
"                            (SELECT id FROM storage WHERE value='unkno" \
"wn')\n" \
"                        WHERE subj_storage IS NULL\n" \
"                        ", &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				_tmp22_ = database;
				zeitgeist_sq_lite_database_schema_exec_query (_tmp22_, "ALTER TABLE event RENAME TO event_old", &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
			}
			_tmp23_ = g_strdup ("interpretation");
			_tmp24_ = g_strdup ("manifestation");
			_tmp25_ = g_strdup ("mimetype");
			_tmp26_ = g_strdup ("actor");
			_tmp27_ = g_new0 (gchar*, 4 + 1);
			_tmp27_[0] = _tmp23_;
			_tmp27_[1] = _tmp24_;
			_tmp27_[2] = _tmp25_;
			_tmp27_[3] = _tmp26_;
			tables = _tmp27_;
			tables_length1 = 4;
			_tables_size_ = tables_length1;
			_tmp28_ = tables;
			_tmp28__length1 = tables_length1;
			{
				gchar** table_collection = NULL;
				gint table_collection_length1 = 0;
				gint _table_collection_size_ = 0;
				gint table_it = 0;
				table_collection = _tmp28_;
				table_collection_length1 = _tmp28__length1;
				for (table_it = 0; table_it < _tmp28__length1; table_it = table_it + 1) {
					const gchar* table = NULL;
					table = table_collection[table_it];
					{
						sqlite3* _tmp29_;
						const gchar* _tmp30_;
						const gchar* _tmp31_;
						gchar* _tmp32_ = NULL;
						gchar* _tmp33_;
						_tmp29_ = database;
						_tmp30_ = table;
						_tmp31_ = table;
						_tmp32_ = g_strdup_printf ("ALTER TABLE %s RENAME TO %s_old", _tmp30_, _tmp31_);
						_tmp33_ = _tmp32_;
						zeitgeist_sq_lite_database_schema_exec_query (_tmp29_, _tmp33_, &_inner_error_);
						_g_free0 (_tmp33_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
								g_propagate_error (error, _inner_error_);
								tables = (_vala_array_free (tables, tables_length1, (GDestroyNotify) g_free), NULL);
								return;
							} else {
								tables = (_vala_array_free (tables, tables_length1, (GDestroyNotify) g_free), NULL);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
						}
					}
				}
			}
			_tmp34_ = database;
			zeitgeist_sq_lite_database_schema_create_schema (_tmp34_, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
					g_propagate_error (error, _inner_error_);
					tables = (_vala_array_free (tables, tables_length1, (GDestroyNotify) g_free), NULL);
					return;
				} else {
					tables = (_vala_array_free (tables, tables_length1, (GDestroyNotify) g_free), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			_tmp35_ = database;
			zeitgeist_sq_lite_database_schema_drop_event_indices (_tmp35_, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
					g_propagate_error (error, _inner_error_);
					tables = (_vala_array_free (tables, tables_length1, (GDestroyNotify) g_free), NULL);
					return;
				} else {
					tables = (_vala_array_free (tables, tables_length1, (GDestroyNotify) g_free), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			_tmp36_ = database;
			zeitgeist_sq_lite_database_schema_create_basic_indices (_tmp36_, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
					g_propagate_error (error, _inner_error_);
					tables = (_vala_array_free (tables, tables_length1, (GDestroyNotify) g_free), NULL);
					return;
				} else {
					tables = (_vala_array_free (tables, tables_length1, (GDestroyNotify) g_free), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			_tmp37_ = database;
			zeitgeist_sq_lite_database_schema_create_event_indices (_tmp37_, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
					g_propagate_error (error, _inner_error_);
					tables = (_vala_array_free (tables, tables_length1, (GDestroyNotify) g_free), NULL);
					return;
				} else {
					tables = (_vala_array_free (tables, tables_length1, (GDestroyNotify) g_free), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			_tmp38_ = tables;
			_tmp38__length1 = tables_length1;
			{
				gchar** table_collection = NULL;
				gint table_collection_length1 = 0;
				gint _table_collection_size_ = 0;
				gint table_it = 0;
				table_collection = _tmp38_;
				table_collection_length1 = _tmp38__length1;
				for (table_it = 0; table_it < _tmp38__length1; table_it = table_it + 1) {
					const gchar* table = NULL;
					table = table_collection[table_it];
					{
						sqlite3* _tmp39_;
						const gchar* _tmp40_;
						const gchar* _tmp41_;
						gchar* _tmp42_ = NULL;
						gchar* _tmp43_;
						sqlite3* _tmp44_;
						const gchar* _tmp45_;
						gchar* _tmp46_ = NULL;
						gchar* _tmp47_;
						_tmp39_ = database;
						_tmp40_ = table;
						_tmp41_ = table;
						_tmp42_ = g_strdup_printf ("INSERT INTO %s SELECT id, value FROM %s_old", _tmp40_, _tmp41_);
						_tmp43_ = _tmp42_;
						zeitgeist_sq_lite_database_schema_exec_query (_tmp39_, _tmp43_, &_inner_error_);
						_g_free0 (_tmp43_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
								g_propagate_error (error, _inner_error_);
								tables = (_vala_array_free (tables, tables_length1, (GDestroyNotify) g_free), NULL);
								return;
							} else {
								tables = (_vala_array_free (tables, tables_length1, (GDestroyNotify) g_free), NULL);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
						}
						_tmp44_ = database;
						_tmp45_ = table;
						_tmp46_ = g_strdup_printf ("DROP TABLE %s_old", _tmp45_);
						_tmp47_ = _tmp46_;
						zeitgeist_sq_lite_database_schema_exec_query (_tmp44_, _tmp47_, &_inner_error_);
						_g_free0 (_tmp47_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
								g_propagate_error (error, _inner_error_);
								tables = (_vala_array_free (tables, tables_length1, (GDestroyNotify) g_free), NULL);
								return;
							} else {
								tables = (_vala_array_free (tables, tables_length1, (GDestroyNotify) g_free), NULL);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
						}
					}
				}
			}
			_tmp48_ = schema_version;
			if (_tmp48_ == 3) {
				sqlite3* _tmp49_;
				sqlite3* _tmp50_;
				_tmp49_ = database;
				zeitgeist_sq_lite_database_schema_exec_query (_tmp49_, "\n" \
"                        INSERT INTO event\n" \
"                        SELECT\n" \
"                            id, timestamp, interpretation, manifestati" \
"on,\n" \
"                            actor, payload, subj_id, subj_interpretati" \
"on,\n" \
"                            subj_manifestation, subj_origin, subj_mime" \
"type,\n" \
"                            subj_text, subj_storage, NULL as origin,\n" \
"                            subj_id AS subj_id_current\n" \
"                         FROM event_old\n" \
"                         ", &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
						g_propagate_error (error, _inner_error_);
						tables = (_vala_array_free (tables, tables_length1, (GDestroyNotify) g_free), NULL);
						return;
					} else {
						tables = (_vala_array_free (tables, tables_length1, (GDestroyNotify) g_free), NULL);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				_tmp50_ = database;
				zeitgeist_sq_lite_database_schema_exec_query (_tmp50_, "DROP TABLE event_old", &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
						g_propagate_error (error, _inner_error_);
						tables = (_vala_array_free (tables, tables_length1, (GDestroyNotify) g_free), NULL);
						return;
					} else {
						tables = (_vala_array_free (tables, tables_length1, (GDestroyNotify) g_free), NULL);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
			}
			_tmp51_ = database;
			_tmp52_ = g_strdup_printf ("INSERT OR IGNORE INTO manifestation (value) VALUES ('%s')", ZEITGEIST_NFO_WEB_DATA_OBJECT);
			_tmp53_ = _tmp52_;
			zeitgeist_sq_lite_database_schema_exec_query (_tmp51_, _tmp53_, &_inner_error_);
			_g_free0 (_tmp53_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
					g_propagate_error (error, _inner_error_);
					tables = (_vala_array_free (tables, tables_length1, (GDestroyNotify) g_free), NULL);
					return;
				} else {
					tables = (_vala_array_free (tables, tables_length1, (GDestroyNotify) g_free), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			_tmp54_ = database;
			zeitgeist_sq_lite_database_schema_exec_query (_tmp54_, "\n" \
"                    UPDATE event\n" \
"                    SET subj_manifestation=(\n" \
"                        SELECT id FROM manifestation WHERE value='" ZEITGEIST_NFO_WEB_DATA_OBJECT "')\n" \
"                    WHERE\n" \
"                        subj_manifestation=(\n" \
"                            SELECT id FROM manifestation WHERE value='" ZEITGEIST_NFO_WEB_DATA_OBJECT "')\n" \
"                        AND subj_id IN (\n" \
"                            SELECT id FROM uri\n" \
"                            WHERE\n" \
"                                value LIKE \"http://%\"\n" \
"                                OR value LIKE \"https://%\"\n" \
"                        )\n" \
"                    ", &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
					g_propagate_error (error, _inner_error_);
					tables = (_vala_array_free (tables, tables_length1, (GDestroyNotify) g_free), NULL);
					return;
				} else {
					tables = (_vala_array_free (tables, tables_length1, (GDestroyNotify) g_free), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			g_message ("sql-schema.vala:158: Upgraded database to schema version 6.");
			tables = (_vala_array_free (tables, tables_length1, (GDestroyNotify) g_free), NULL);
		} else {
			gint _tmp55_;
			_tmp55_ = schema_version;
			if (_tmp55_ < ZEITGEIST_SQ_LITE_DATABASE_SCHEMA_CORE_SCHEMA_VERSION) {
				gint _tmp56_;
				gchar* _tmp57_ = NULL;
				gchar* _tmp58_;
				GError* _tmp59_;
				GError* _tmp60_;
				_tmp56_ = schema_version;
				_tmp57_ = g_strdup_printf ("Unable to upgrade from schema version %d", _tmp56_);
				_tmp58_ = _tmp57_;
				_tmp59_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_ERROR, _tmp58_);
				_tmp60_ = _tmp59_;
				_g_free0 (_tmp58_);
				_inner_error_ = _tmp60_;
				if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
	}
}


static void zeitgeist_sq_lite_database_schema_backup_database (GError** error) {
	GError * _inner_error_ = NULL;
	{
		zeitgeist_utils_backup_database (&_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch21_g_error;
		}
	}
	goto __finally21;
	__catch21_g_error:
	{
		GError* backup_error = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* msg;
		const gchar* _tmp3_;
		GError* _tmp4_;
		backup_error = _inner_error_;
		_inner_error_ = NULL;
		_tmp0_ = backup_error;
		_tmp1_ = _tmp0_->message;
		_tmp2_ = g_strconcat ("Database backup failed: ", _tmp1_, NULL);
		msg = _tmp2_;
		_tmp3_ = msg;
		_tmp4_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_BACKUP_FAILED, _tmp3_);
		_inner_error_ = _tmp4_;
		_g_free0 (msg);
		_g_error_free0 (backup_error);
		goto __finally21;
	}
	__finally21:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


gint zeitgeist_sq_lite_database_schema_get_schema_version (sqlite3* database, GError** error) {
	gint result = 0;
	sqlite3* _tmp0_;
	gint64 _tmp1_ = 0LL;
	gint schema_version;
	gint _tmp2_;
	gint _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (database != NULL, 0);
	_tmp0_ = database;
	_tmp1_ = zeitgeist_sq_lite_database_schema_get_schema_metadata (_tmp0_, ZEITGEIST_SQ_LITE_DATABASE_SCHEMA_CORE_SCHEMA);
	schema_version = (gint) _tmp1_;
	_tmp2_ = schema_version;
	g_debug ("sql-schema.vala:185: schema_version is %d", _tmp2_);
	_tmp3_ = schema_version;
	if (_tmp3_ < (-1)) {
		GError* _tmp4_;
		_tmp4_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_CORRUPT, "Database corruption flag is set.");
		_inner_error_ = _tmp4_;
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	result = schema_version;
	return result;
}


gint64 zeitgeist_sq_lite_database_schema_get_creation_date (sqlite3* database) {
	gint64 result = 0LL;
	sqlite3* _tmp0_;
	gint64 _tmp1_ = 0LL;
	g_return_val_if_fail (database != NULL, 0LL);
	_tmp0_ = database;
	_tmp1_ = zeitgeist_sq_lite_database_schema_get_schema_metadata (_tmp0_, ZEITGEIST_SQ_LITE_DATABASE_SCHEMA_DATABASE_CREATION);
	result = _tmp1_;
	return result;
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		g_slice_free (Block3Data, _data3_);
	}
}


static gint _sqlite3_exec (sqlite3* self, const gchar* sql, sqlite3_callback callback, void* callback_target, gchar** errmsg) {
	gchar* _vala_errmsg = NULL;
	gint result = 0;
	const gchar* sqlite_errmsg = NULL;
	const gchar* _tmp0_;
	sqlite3_callback _tmp1_;
	void* _tmp1__target;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint ec;
	const gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_tmp0_ = sql;
	_tmp1_ = callback;
	_tmp1__target = callback_target;
	_tmp3_ = sqlite3_exec (self, _tmp0_, _tmp1_, _tmp1__target, (char**) (&_tmp2_));
	sqlite_errmsg = _tmp2_;
	ec = _tmp3_;
	if ((&_vala_errmsg) != NULL) {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = sqlite_errmsg;
		_tmp5_ = g_strdup (_tmp4_);
		_g_free0 (_vala_errmsg);
		_vala_errmsg = _tmp5_;
	}
	_tmp6_ = sqlite_errmsg;
	sqlite3_free ((void*) _tmp6_);
	result = ec;
	if (errmsg) {
		*errmsg = _vala_errmsg;
	} else {
		_g_free0 (_vala_errmsg);
	}
	return result;
}


static gint64 int64_parse (const gchar* str) {
	gint64 result = 0LL;
	const gchar* _tmp0_;
	gint64 _tmp1_ = 0LL;
	g_return_val_if_fail (str != NULL, 0LL);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtoll (_tmp0_, NULL, (guint) 0);
	result = _tmp1_;
	return result;
}


static gint __lambda2_ (Block3Data* _data3_, gint n_cols, gchar** values, int values_length1, gchar** column_names, int column_names_length1) {
	gint result = 0;
	gchar** _tmp0_;
	gint _tmp0__length1;
	const gchar* _tmp1_;
	_tmp0_ = values;
	_tmp0__length1 = values_length1;
	_tmp1_ = _tmp0_[0];
	if (_tmp1_ != NULL) {
		gchar** _tmp2_;
		gint _tmp2__length1;
		const gchar* _tmp3_;
		gint64 _tmp4_ = 0LL;
		_tmp2_ = values;
		_tmp2__length1 = values_length1;
		_tmp3_ = _tmp2_[0];
		_tmp4_ = int64_parse (_tmp3_);
		_data3_->schema_version = _tmp4_;
	}
	result = 0;
	return result;
}


static gint ___lambda2__sqlite3_callback (gpointer self, gint n_columns, gchar** values, gchar** column_names) {
	gint result;
	result = __lambda2_ (self, n_columns, values, -1, column_names, -1);
	return result;
}


static gint64 zeitgeist_sq_lite_database_schema_get_schema_metadata (sqlite3* database, const gchar* key) {
	gint64 result = 0LL;
	Block3Data* _data3_;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* sql;
	sqlite3* _tmp5_;
	g_return_val_if_fail (database != NULL, 0LL);
	g_return_val_if_fail (key != NULL, 0LL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_tmp0_ = key;
	_tmp1_ = g_strdup_printf ("WHERE schema='%s'", _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat ("SELECT version FROM schema_version ", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	sql = _tmp4_;
	_data3_->schema_version = (gint64) (-1);
	_tmp5_ = database;
	_sqlite3_exec (_tmp5_, sql, ___lambda2__sqlite3_callback, _data3_, NULL);
	result = _data3_->schema_version;
	_g_free0 (sql);
	block3_data_unref (_data3_);
	_data3_ = NULL;
	return result;
}


void zeitgeist_sq_lite_database_schema_set_corruption_flag (sqlite3* database, GError** error) {
	sqlite3* _tmp0_;
	gint _tmp1_ = 0;
	gint version;
	gint _tmp2_;
	sqlite3* _tmp4_;
	gint _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (database != NULL);
	_tmp0_ = database;
	_tmp1_ = zeitgeist_sq_lite_database_schema_get_schema_version (_tmp0_, &_inner_error_);
	version = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp2_ = version;
	if (_tmp2_ > 0) {
		gint _tmp3_;
		_tmp3_ = version;
		version = -_tmp3_;
	}
	_tmp4_ = database;
	_tmp5_ = version;
	zeitgeist_sq_lite_database_schema_set_schema_version (_tmp4_, _tmp5_, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void zeitgeist_sq_lite_database_schema_set_schema_version (sqlite3* database, gint schema_version, GError** error) {
	gint _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* schema_sql;
	sqlite3* _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (database != NULL);
	_tmp0_ = schema_version;
	_tmp1_ = g_strdup_printf ("INSERT INTO schema_version VALUES ('%s', %d)", ZEITGEIST_SQ_LITE_DATABASE_SCHEMA_CORE_SCHEMA, _tmp0_);
	schema_sql = _tmp1_;
	_tmp2_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp2_, schema_sql, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (schema_sql);
			return;
		} else {
			_g_free0 (schema_sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_free0 (schema_sql);
}


void zeitgeist_sq_lite_database_schema_create_schema (sqlite3* database, GError** error) {
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gboolean _tmp5_;
	sqlite3* _tmp7_;
	sqlite3* _tmp8_;
	sqlite3* _tmp9_;
	sqlite3* _tmp10_;
	sqlite3* _tmp11_;
	sqlite3* _tmp12_;
	sqlite3* _tmp13_;
	sqlite3* _tmp14_;
	sqlite3* _tmp15_;
	sqlite3* _tmp16_;
	sqlite3* _tmp17_;
	sqlite3* _tmp18_;
	sqlite3* _tmp19_;
	sqlite3* _tmp20_;
	sqlite3* _tmp21_;
	sqlite3* _tmp22_;
	sqlite3* _tmp23_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (database != NULL);
	_tmp0_ = zeitgeist_utils_using_in_memory_database ();
	if (!_tmp0_) {
		const gchar* _tmp1_ = NULL;
		_tmp1_ = zeitgeist_utils_get_database_file_path ();
		g_chmod (_tmp1_, 0600);
	}
	_tmp2_ = zeitgeist_utils_get_data_path ();
	_tmp3_ = zeitgeist_utils_get_default_data_path ();
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strcmp0 (_tmp2_, _tmp4_) == 0;
	_g_free0 (_tmp4_);
	if (_tmp5_) {
		const gchar* _tmp6_ = NULL;
		_tmp6_ = zeitgeist_utils_get_data_path ();
		g_chmod (_tmp6_, 0700);
	}
	_tmp7_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp7_, "PRAGMA journal_mode = WAL", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp8_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp8_, "PRAGMA synchronous = NORMAL", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp9_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp9_, "PRAGMA locking_mode = NORMAL", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp10_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp10_, "\n" \
"                CREATE TABLE IF NOT EXISTS uri (\n" \
"                    id INTEGER PRIMARY KEY,\n" \
"                    value VARCHAR UNIQUE\n" \
"                )\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp11_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp11_, "\n" \
"                CREATE TABLE IF NOT EXISTS interpretation (\n" \
"                    id INTEGER PRIMARY KEY AUTOINCREMENT,\n" \
"                    value VARCHAR UNIQUE\n" \
"                )\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp12_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp12_, "\n" \
"                CREATE TABLE IF NOT EXISTS manifestation (\n" \
"                    id INTEGER PRIMARY KEY AUTOINCREMENT,\n" \
"                    value VARCHAR UNIQUE\n" \
"                )\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp13_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp13_, "\n" \
"                CREATE TABLE IF NOT EXISTS mimetype (\n" \
"                    id INTEGER PRIMARY KEY AUTOINCREMENT,\n" \
"                    value VARCHAR UNIQUE\n" \
"                )\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp14_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp14_, "\n" \
"                CREATE TABLE IF NOT EXISTS actor (\n" \
"                    id INTEGER PRIMARY KEY AUTOINCREMENT,\n" \
"                    value VARCHAR UNIQUE\n" \
"                )\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp15_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp15_, "\n" \
"                CREATE TABLE IF NOT EXISTS text (\n" \
"                    id INTEGER PRIMARY KEY,\n" \
"                    value VARCHAR UNIQUE\n" \
"                )\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp16_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp16_, "\n" \
"                CREATE TABLE IF NOT EXISTS payload\n" \
"                    (id INTEGER PRIMARY KEY, value BLOB)\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp17_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp17_, "\n" \
"                CREATE TABLE IF NOT EXISTS storage (\n" \
"                    id INTEGER PRIMARY KEY,\n" \
"                    value VARCHAR UNIQUE,\n" \
"                    state INTEGER,\n" \
"                    icon VARCHAR,\n" \
"                    display_name VARCHAR\n" \
"                )\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp18_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp18_, "\n" \
"                CREATE TABLE IF NOT EXISTS event (\n" \
"                    id INTEGER,\n" \
"                    timestamp INTEGER,\n" \
"                    interpretation INTEGER,\n" \
"                    manifestation INTEGER,\n" \
"                    actor INTEGER,\n" \
"                    payload INTEGER,\n" \
"                    subj_id INTEGER,\n" \
"                    subj_interpretation INTEGER,\n" \
"                    subj_manifestation INTEGER,\n" \
"                    subj_origin INTEGER,\n" \
"                    subj_mimetype INTEGER,\n" \
"                    subj_text INTEGER,\n" \
"                    subj_storage INTEGER,\n" \
"                    origin INTEGER,\n" \
"                    subj_id_current INTEGER,\n" \
"                    CONSTRAINT interpretation_fk\n" \
"                        FOREIGN KEY(interpretation)\n" \
"                        REFERENCES interpretation(id)\n" \
"                        ON DELETE CASCADE,\n" \
"                    CONSTRAINT manifestation_fk\n" \
"                        FOREIGN KEY(manifestation)\n" \
"                        REFERENCES manifestation(id)\n" \
"                        ON DELETE CASCADE,\n" \
"                    CONSTRAINT actor_fk\n" \
"                        FOREIGN KEY(actor)\n" \
"                        REFERENCES actor(id)\n" \
"                        ON DELETE CASCADE,\n" \
"                    CONSTRAINT origin_fk\n" \
"                        FOREIGN KEY(origin)\n" \
"                        REFERENCES uri(id)\n" \
"                        ON DELETE CASCADE,\n" \
"                    CONSTRAINT payload_fk\n" \
"                        FOREIGN KEY(payload)\n" \
"                        REFERENCES payload(id)\n" \
"                        ON DELETE CASCADE,\n" \
"                    CONSTRAINT subj_id_fk\n" \
"                        FOREIGN KEY(subj_id)\n" \
"                        REFERENCES uri(id)\n" \
"                        ON DELETE CASCADE,\n" \
"                    CONSTRAINT subj_id_current_fk\n" \
"                        FOREIGN KEY(subj_id_current)\n" \
"                        REFERENCES uri(id)\n" \
"                        ON DELETE CASCADE,\n" \
"                    CONSTRAINT subj_interpretation_fk\n" \
"                        FOREIGN KEY(subj_interpretation)\n" \
"                        REFERENCES interpretation(id)\n" \
"                        ON DELETE CASCADE,\n" \
"                    CONSTRAINT subj_manifestation_fk\n" \
"                        FOREIGN KEY(subj_manifestation)\n" \
"                        REFERENCES manifestation(id)\n" \
"                        ON DELETE CASCADE,\n" \
"                    CONSTRAINT subj_origin_fk\n" \
"                        FOREIGN KEY(subj_origin)\n" \
"                        REFERENCES uri(id)\n" \
"                        ON DELETE CASCADE,\n" \
"                    CONSTRAINT subj_mimetype_fk\n" \
"                        FOREIGN KEY(subj_mimetype)\n" \
"                        REFERENCES mimetype(id)\n" \
"                        ON DELETE CASCADE,\n" \
"                    CONSTRAINT subj_text_fk\n" \
"                        FOREIGN KEY(subj_text)\n" \
"                        REFERENCES text(id)\n" \
"                        ON DELETE CASCADE,\n" \
"                    CONSTRAINT subj_storage_fk\n" \
"                        FOREIGN KEY(subj_storage)\n" \
"                        REFERENCES storage(id)\n" \
"                        ON DELETE CASCADE,\n" \
"                    CONSTRAINT unique_event UNIQUE (timestamp, interpr" \
"etation,\n" \
"                        manifestation, actor, subj_id)\n" \
"                )\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp19_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp19_, "\n" \
"                CREATE TABLE IF NOT EXISTS extensions_conf (\n" \
"                    extension VARCHAR,\n" \
"                    key VARCHAR,\n" \
"                    value BLOB,\n" \
"                    CONSTRAINT unique_extension UNIQUE (extension, key" \
")\n" \
"                )\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp20_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp20_, "DROP VIEW IF EXISTS event_view", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp21_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp21_, "\n" \
"                CREATE VIEW IF NOT EXISTS event_view AS\n" \
"                    SELECT event.id,\n" \
"                        event.timestamp,\n" \
"                        event.interpretation,\n" \
"                        event.manifestation,\n" \
"                        event.actor,\n" \
"                        (SELECT value FROM payload\n" \
"                            WHERE payload.id=event.payload)\n" \
"                            AS payload,\n" \
"                        (SELECT value FROM uri\n" \
"                            WHERE uri.id=event.subj_id)\n" \
"                            AS subj_uri,\n" \
"                        event.subj_id, --//this points to an id in the" \
" uri table\n" \
"                        event.subj_interpretation,\n" \
"                        event.subj_manifestation,\n" \
"                        event.subj_origin,\n" \
"                        (SELECT value FROM uri\n" \
"                            WHERE uri.id=event.subj_origin)\n" \
"                            AS subj_origin_uri,\n" \
"                        event.subj_mimetype,\n" \
"                        (SELECT value FROM text\n" \
"                            WHERE text.id = event.subj_text)\n" \
"                            AS subj_text,\n" \
"                        (SELECT value FROM storage\n" \
"                            WHERE storage.id=event.subj_storage)\n" \
"                            AS subj_storage,\n" \
"                        (SELECT state FROM storage\n" \
"                            WHERE storage.id=event.subj_storage)\n" \
"                            AS subj_storage_state,\n" \
"                        event.origin,\n" \
"                        (SELECT value FROM uri\n" \
"                            WHERE uri.id=event.origin)\n" \
"                            AS event_origin_uri,\n" \
"                        (SELECT value FROM uri\n" \
"                            WHERE uri.id=event.subj_id_current)\n" \
"                            AS subj_current_uri,\n" \
"                        event.subj_id_current,\n" \
"                        event.subj_text AS subj_text_id,\n" \
"                        event.subj_storage AS subj_storage_id,\n" \
"                        (SELECT value FROM actor\n" \
"                            WHERE actor.id=event.actor)\n" \
"                            AS actor_uri\n" \
"                    FROM event\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp22_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp22_, "\n" \
"                CREATE TABLE IF NOT EXISTS schema_version (\n" \
"                    schema VARCHAR PRIMARY KEY ON CONFLICT REPLACE,\n" \
"                    version INT\n" \
"                )\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp23_ = database;
	zeitgeist_sq_lite_database_schema_set_schema_version (_tmp23_, ZEITGEIST_SQ_LITE_DATABASE_SCHEMA_CORE_SCHEMA_VERSION, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


void zeitgeist_sq_lite_database_schema_create_basic_indices (sqlite3* database, GError** error) {
	sqlite3* _tmp0_;
	sqlite3* _tmp1_;
	sqlite3* _tmp2_;
	sqlite3* _tmp3_;
	sqlite3* _tmp4_;
	sqlite3* _tmp5_;
	sqlite3* _tmp6_;
	sqlite3* _tmp7_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (database != NULL);
	_tmp0_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp0_, "\n" \
"                CREATE UNIQUE INDEX IF NOT EXISTS uri_value ON uri(val" \
"ue)\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp1_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp1_, "\n" \
"                CREATE UNIQUE INDEX IF NOT EXISTS interpretation_value" \
"\n" \
"                    ON interpretation(value)\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp2_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp2_, "\n" \
"                CREATE UNIQUE INDEX IF NOT EXISTS manifestation_value\n" \
"                    ON manifestation(value)\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp3_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp3_, "\n" \
"                CREATE UNIQUE INDEX IF NOT EXISTS mimetype_value\n" \
"                    ON mimetype(value)\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp4_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp4_, "\n" \
"                CREATE UNIQUE INDEX IF NOT EXISTS actor_value\n" \
"                    ON actor(value)\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp5_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp5_, "\n" \
"                CREATE UNIQUE INDEX IF NOT EXISTS text_value\n" \
"                    ON text(value)\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp6_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp6_, "\n" \
"                CREATE UNIQUE INDEX IF NOT EXISTS storage_value\n" \
"                    ON storage(value)\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp7_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp7_, "\n" \
"                CREATE UNIQUE INDEX IF NOT EXISTS extensions_conf_key\n" \
"                    ON extensions_conf (extension, key)\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


void zeitgeist_sq_lite_database_schema_create_event_indices (sqlite3* database, GError** error) {
	sqlite3* _tmp0_;
	sqlite3* _tmp1_;
	sqlite3* _tmp2_;
	sqlite3* _tmp3_;
	sqlite3* _tmp4_;
	sqlite3* _tmp5_;
	sqlite3* _tmp6_;
	sqlite3* _tmp7_;
	sqlite3* _tmp8_;
	sqlite3* _tmp9_;
	sqlite3* _tmp10_;
	sqlite3* _tmp11_;
	sqlite3* _tmp12_;
	sqlite3* _tmp13_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (database != NULL);
	_tmp0_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp0_, "\n" \
"                CREATE INDEX IF NOT EXISTS event_id\n" \
"                    ON event(id, timestamp)\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp1_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp1_, "\n" \
"                CREATE INDEX IF NOT EXISTS event_timestamp\n" \
"                    ON event(timestamp, id)\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp2_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp2_, "\n" \
"                CREATE INDEX IF NOT EXISTS event_interpretation\n" \
"                    ON event(interpretation, timestamp)\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp3_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp3_, "\n" \
"                CREATE INDEX IF NOT EXISTS event_manifestation\n" \
"                    ON event(manifestation, timestamp)\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp4_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp4_, "\n" \
"                CREATE INDEX IF NOT EXISTS event_actor\n" \
"                    ON event(actor, timestamp)\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp5_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp5_, "\n" \
"                CREATE INDEX IF NOT EXISTS event_origin\n" \
"                    ON event(origin, timestamp)\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp6_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp6_, "\n" \
"                CREATE INDEX IF NOT EXISTS event_subj_id\n" \
"                    ON event(subj_id, timestamp, subj_interpretation)\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp7_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp7_, "\n" \
"                CREATE INDEX IF NOT EXISTS event_subj_id_current\n" \
"                    ON event(subj_id_current, timestamp, subj_interpre" \
"tation)\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp8_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp8_, "\n" \
"                CREATE INDEX IF NOT EXISTS event_subj_interpretation\n" \
"                    ON event(subj_interpretation, timestamp, subj_id)\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp9_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp9_, "\n" \
"                CREATE INDEX IF NOT EXISTS event_subj_manifestation\n" \
"                    ON event(subj_manifestation, timestamp, subj_id)\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp10_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp10_, "\n" \
"                CREATE INDEX IF NOT EXISTS event_subj_origin\n" \
"                    ON event(subj_origin, timestamp, subj_interpretati" \
"on, subj_id)\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp11_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp11_, "\n" \
"                CREATE INDEX IF NOT EXISTS event_subj_mimetype\n" \
"                    ON event(subj_mimetype, timestamp)\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp12_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp12_, "\n" \
"                CREATE INDEX IF NOT EXISTS event_subj_text\n" \
"                    ON event(subj_text, timestamp)\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp13_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp13_, "\n" \
"                CREATE INDEX IF NOT EXISTS event_subj_storage\n" \
"                    ON event(subj_storage, timestamp)\n" \
"                ", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


void zeitgeist_sq_lite_database_schema_drop_event_indices (sqlite3* database, GError** error) {
	sqlite3* _tmp0_;
	sqlite3* _tmp1_;
	sqlite3* _tmp2_;
	sqlite3* _tmp3_;
	sqlite3* _tmp4_;
	sqlite3* _tmp5_;
	sqlite3* _tmp6_;
	sqlite3* _tmp7_;
	sqlite3* _tmp8_;
	sqlite3* _tmp9_;
	sqlite3* _tmp10_;
	sqlite3* _tmp11_;
	sqlite3* _tmp12_;
	sqlite3* _tmp13_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (database != NULL);
	_tmp0_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp0_, "DROP INDEX IF EXISTS event_id", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp1_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp1_, "DROP INDEX IF EXISTS event_timestamp", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp2_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp2_, "DROP INDEX IF EXISTS event_interpretation", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp3_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp3_, "DROP INDEX IF EXISTS event_manifestation", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp4_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp4_, "DROP INDEX IF EXISTS event_actor", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp5_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp5_, "DROP INDEX IF EXISTS event_origin", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp6_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp6_, "DROP INDEX IF EXISTS event_subj_id", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp7_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp7_, "DROP INDEX IF EXISTS event_subj_id_current", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp8_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp8_, "DROP INDEX IF EXISTS event_subj_interpretation", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp9_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp9_, "DROP INDEX IF EXISTS event_subj_manifestation", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp10_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp10_, "DROP INDEX IF EXISTS event_subj_origin", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp11_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp11_, "DROP INDEX IF EXISTS event_subj_mimetype", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp12_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp12_, "DROP INDEX IF EXISTS event_subj_text", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp13_ = database;
	zeitgeist_sq_lite_database_schema_exec_query (_tmp13_, "DROP INDEX IF EXISTS event_subj_storage", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


/**
         * Execute the given SQL. If the query doesn't succeed, throw
         * an error.
         *
         * @param database the database on which to run the query
         * @param sql the SQL query to run
         */
static void zeitgeist_sq_lite_database_schema_exec_query (sqlite3* database, const gchar* sql, GError** error) {
	sqlite3* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_ = 0;
	gint rc;
	gint _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (database != NULL);
	g_return_if_fail (sql != NULL);
	_tmp0_ = database;
	_tmp1_ = sql;
	_tmp2_ = _sqlite3_exec (_tmp0_, _tmp1_, NULL, NULL, NULL);
	rc = _tmp2_;
	_tmp3_ = rc;
	if (_tmp3_ != SQLITE_OK) {
		gint _tmp4_;
		_tmp4_ = rc;
		if (_tmp4_ == SQLITE_CORRUPT) {
			sqlite3* _tmp5_;
			const gchar* _tmp6_ = NULL;
			GError* _tmp7_;
			_tmp5_ = database;
			_tmp6_ = sqlite3_errmsg (_tmp5_);
			_tmp7_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_CORRUPT, _tmp6_);
			_inner_error_ = _tmp7_;
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		} else {
			static const char fmt_str[] = "Can't create database: %d, %s\n\n" "Unable to execute SQL:\n%s";
			gint _tmp8_;
			sqlite3* _tmp9_;
			const gchar* _tmp10_ = NULL;
			const gchar* _tmp11_;
			gchar* _tmp12_ = NULL;
			gchar* err_msg;
			const gchar* _tmp13_;
			GError* _tmp14_;
			_tmp8_ = rc;
			_tmp9_ = database;
			_tmp10_ = sqlite3_errmsg (_tmp9_);
			_tmp11_ = sql;
			_tmp12_ = g_strdup_printf (fmt_str, _tmp8_, _tmp10_, _tmp11_);
			err_msg = _tmp12_;
			_tmp13_ = err_msg;
			_tmp14_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_ERROR, _tmp13_);
			_inner_error_ = _tmp14_;
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (err_msg);
				return;
			} else {
				_g_free0 (err_msg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_g_free0 (err_msg);
		}
	}
}


ZeitgeistSQLiteDatabaseSchema* zeitgeist_sq_lite_database_schema_construct (GType object_type) {
	ZeitgeistSQLiteDatabaseSchema * self = NULL;
	self = (ZeitgeistSQLiteDatabaseSchema*) g_object_new (object_type, NULL);
	return self;
}


ZeitgeistSQLiteDatabaseSchema* zeitgeist_sq_lite_database_schema_new (void) {
	return zeitgeist_sq_lite_database_schema_construct (ZEITGEIST_SQ_LITE_TYPE_DATABASE_SCHEMA);
}


static void zeitgeist_sq_lite_database_schema_class_init (ZeitgeistSQLiteDatabaseSchemaClass * klass) {
	zeitgeist_sq_lite_database_schema_parent_class = g_type_class_peek_parent (klass);
}


static void zeitgeist_sq_lite_database_schema_instance_init (ZeitgeistSQLiteDatabaseSchema * self) {
}


GType zeitgeist_sq_lite_database_schema_get_type (void) {
	static volatile gsize zeitgeist_sq_lite_database_schema_type_id__volatile = 0;
	if (g_once_init_enter (&zeitgeist_sq_lite_database_schema_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistSQLiteDatabaseSchemaClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_sq_lite_database_schema_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistSQLiteDatabaseSchema), 0, (GInstanceInitFunc) zeitgeist_sq_lite_database_schema_instance_init, NULL };
		GType zeitgeist_sq_lite_database_schema_type_id;
		zeitgeist_sq_lite_database_schema_type_id = g_type_register_static (G_TYPE_OBJECT, "ZeitgeistSQLiteDatabaseSchema", &g_define_type_info, 0);
		g_once_init_leave (&zeitgeist_sq_lite_database_schema_type_id__volatile, zeitgeist_sq_lite_database_schema_type_id);
	}
	return zeitgeist_sq_lite_database_schema_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



