#this should be automated in the CMFSetup product
#you should be able to define Product dependencies and error messages
#in the config file

import zLOG
import os
import sys

MINIMUM_PYTHON_VER = (2, 3, 4)
PREFERRED_PYTHON_VER = "2.3.5 or newer"

MINIMUM_ZOPE_VER = (2, 7, 5)
PREFERRED_ZOPE_VER = "2.7.6 or newer"

MINIMUM_CMF_VER = (1, 5, 2)

messages = []

def log(message, summary='', severity=zLOG.ERROR, optional=0):
    if optional:
        subsys = 'Plone Option'
    else:
        subsys = 'Plone Dependency'
    messages.append({'message' : message, 'summary' : summary,
                     'severity' : severity, 'optional' : optional
		    })
    zLOG.LOG(subsys, severity, summary, message + "\n")

# test python version
PYTHON_VER = sys.version_info[:3]
if PYTHON_VER < MINIMUM_PYTHON_VER:
    log(("Python version %s found but Plone needs at least "
         "Python %s. Please download and install Python %s "
	 "from http://python.org/" % (PYTHON_VER, 
	 MINIMUM_PYTHON_VER, PREFERRED_PYTHON_VER) ))

# test zope version
ZOPE_VER = "unknown"
try:
    from App.version_txt import getZopeVersion
except ImportError:
    pass
else:
    try:
        ZOPE_VER = getZopeVersion()[:3]
    except (ValueError, TypeError, KeyError):
        pass

if ZOPE_VER in ('unknown', (-1, -1, -1)): # -1, -1, 1 is developer release
    log(("Unable to detect Zope version. Please make sure you have Zope "
         "%s installed." % PREFERRED_ZOPE_VER))
elif ZOPE_VER < MINIMUM_ZOPE_VER:
    log(("Zope version %s found but Plone needs at least "
         "Zope %s Please download and install Zope %s "
	 "from http://zope.org/" % 
	 (ZOPE_VER, MINIMUM_ZOPE_VER, PREFERRED_ZOPE_VER) ))

# make sure CMF is installed
cmfcore = 0
try:
    import Products.CMFCore
    cmfcore = 1
except ImportError:
    log(("CMFCore not found.  Please download the CMF "
         "from http://cmf.zope.org/download"))

# check the CMF version
if cmfcore:
    from Products.CMFCore import cmfcore_globals
    from App.Common import package_home
    from os.path import join
    
    x = []
    CMF_VERSION = 'Unknown'
    try:
        file = join(package_home(cmfcore_globals), 'version.txt')
        CMF_VERSION = open(file, 'r').read().strip()
        version = CMF_VERSION.strip()
        if version.lower().startswith('cmf-'):
            version = version[4:]
        filtered = ''
        for v in version:
            if v in ['0','1','2','3','4','5','6','7','8','9','.']:
                filtered += v
            else:
                break
        cmf_ver = [int(x) for x in filtered.split('.')]
    except IOError:
        # couldnt find file, oh well
        pass
    except ValueError:
        # couldnt make sense of the version number
        pass
    if tuple(cmf_ver) < MINIMUM_CMF_VER:
        log(("Plone requires CMF %s or later. "
             "Your version is: %s" % (MINIMUM_CMF_VER, CMF_VERSION)))

try:
    import Products.CMFQuickInstallerTool
except ImportError:
    log(("CMFQuickInstallerTool not found. "
         "Please download it from http://sf.net/projects/collective"))

try:
    # TODO: we might want to check if the user has jpeg and zlib support, too
    import PIL.Image
except ImportError:
    log(("PIL not found. Plone needs PIL 1.1.5 or newer to scale images. "
         "Please download it from http://www.pythonware.com/products/pil/ or "
         "http://effbot.org/downloads/#Imaging"), 
         severity=zLOG.INFO, optional=1)

try:
    import Products.ExternalEditor
except ImportError:
    log(("ExternalEditor not found. If you want "
         "the external edit functionality, please "
         "download it from "
         "http://plope.com/software/ExternalEditor"),
        severity=zLOG.INFO, optional=1)

try:
    import Products.kupu
except ImportError:
    log(("Kupu not found. If you want WYSIWYG capabilities "
        "in Plone, you can download it from "
        "http://kupu.oscom.org/"),
        severity=zLOG.INFO, optional=1)

try:
    import Products.PlacelessTranslationService
except ImportError:
    log(("Placeless Translation Service not found. Plone "
         "runs without this, but if you want multilingual "
         "interface or access keys, you must download it from "
         "http://www.sourceforge.net/projects/collective"),
        severity=zLOG.INFO, optional=1)

try:
    import Products.Localizer
except ImportError:
    pass
else:
    log(("Localizer found. Plone 2 is using the PlacelessTranslationService "
         "for translation. Please deinstall the Localizer after you have saved "
         "your po catalogs."),
        severity=zLOG.WARNING, optional=1)

try:
    import Products.TranslationService
except ImportError:
    pass
else:
    log(("TranslationService found. Plone 2 is using the PlacelessTranslationService "
         "for translation. Please deinstall the TranslationService."),
        severity=zLOG.WARNING, optional=1)

try:
    import Products.CMFPlone
    plonePath = Products.CMFPlone.__path__[0]
except ImportError, AttributeError:
    i18nPath = None
else:
    i18nPath = os.path.join(plonePath, 'i18n')

if (i18nPath and os.path.isfile(os.path.join(i18nPath, 'plone-en.po')) ):
    log(("Plone i18n files found at CMFPlone/i18/. Plone's "
         "i18n files have been moved to the PloneTranslation product. "
	 "Please remove the CMFPlone/i18n/ folder to avoid conflicts."),
        severity=zLOG.INFO, optional=1)

try:
    import Products.PloneTranslations
except ImportError:
    log(("PloneTranslation product with i18n files not found. Plone "
         "runs without this, but if you want multilingual "
         "interface or access keys, you must download it from "
         "http://www.sourceforge.net/projects/plone-i18n"),
        severity=zLOG.INFO, optional=1)

try:
    import Products.CMFFormController
except ImportError:
    log(("CMFFormController not found. Please "
         "download if from http://sf.net/projects/collective"))

try:
    import Products.GroupUserFolder
except ImportError:
    log(("GroupUserFolder not found. Please "
         "download it from http://sf.net/projects/collective"))

try:
    import Products.CallProfiler
    try:
        import Products.CMFFormControllerPatch
    except ImportError:
        log(("CMFFormControllerPatch not found. This is "
             "only required for using Call Profiler with Plone, "
             "you can download it from "
             "http://sf.net/projects/collective"),
            severity=zLOG.INFO, optional=1)
except ImportError:
    pass

try:
    import Products.BTreeFolder2
except ImportError:
    log(("BTreeFolder2 not found. Please download it "
         "from http://hathawaymix.org/Software/BTreeFolder2"))

try:
    import Products.SecureMailHost
except ImportError:
    log(("SecureMailHost not found. Please "
         "download it from http://sf.net/projects/collective"))

try:
    import Products.MimetypesRegistry
except ImportError:
    log(("MimetypesRegistry not found. Please "
         "download it from http://sf.net/projects/archetypes"))

try:
    import Products.PortalTransforms
except ImportError:
    log(("PortalTransforms not found. Please "
         "download it from http://sf.net/projects/archetypes"))

try:
    import Products.Archetypes
except ImportError:
    # TODO we might want to check the AT version
    log(("Archetypes not found. Please "
         "download it from http://sf.net/projects/archetypes"))

try:
    import Products.ATContentTypes.content.document
except ImportError:
    log(("ATContentTypes not found or too old. Please "
         "download it from http://plone.org/products/atcontenttypes"))

try:
    import Products.ExtendedPathIndex
except ImportError:
    log(("ExtendedPathIndex not found. "
         "Please download it from http://plone.org/products/extendedpathindex"))

try:
    import Products.ResourceRegistries
except ImportError:
    log(("ResourceRegistries not found. "
         "Please download it from http://plone.org/products/resourceregistries"))

try:
    import Products.CMFDynamicViewFTI
except ImportError:
    log(("CMFDynamicViewFTI not found. "
         "Please download it from http://plone.org/products/cmfdynamicviewfti"))
