/*
 * Decompiled with CFR 0.152.
 */
package com.arbortext.catalog;

import com.arbortext.catalog.Catalog;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class CatalogEntityResolver
implements EntityResolver {
    public int debug;
    private boolean retryBadSystemIds;
    public Catalog catalog;

    public CatalogEntityResolver() {
        block2: {
            this.debug = 0;
            this.retryBadSystemIds = false;
            this.catalog = null;
            String property = System.getProperty("xml.catalog.debug");
            if (property == null) break block2;
            try {
                this.debug = Integer.parseInt(property);
            }
            catch (NumberFormatException numberFormatException) {
                this.debug = 0;
            }
        }
    }

    private void debug(int level, String message) {
        if (this.debug >= level) {
            System.out.println(message);
        }
    }

    private void debug(int level, String message, String spec) {
        if (this.debug >= level) {
            System.out.println(String.valueOf(message) + ": " + spec);
        }
    }

    private void debug(int level, String message, String spec1, String spec2) {
        if (this.debug >= level) {
            System.out.println(String.valueOf(message) + ": " + spec1);
            System.out.println("\t" + spec2);
        }
    }

    public synchronized void parseCatalog(String fileName) throws MalformedURLException, IOException {
        this.catalog.parseCatalog(fileName);
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        String resolved = null;
        if (systemId != null) {
            try {
                resolved = this.catalog.resolveSystem(systemId);
            }
            catch (MalformedURLException malformedURLException) {
                this.debug(1, "Malformed URL exception trying to resolve", publicId);
                resolved = null;
            }
            catch (IOException iOException) {
                this.debug(1, "I/O exception trying to resolve", publicId);
                resolved = null;
            }
        }
        if (resolved == null) {
            if (publicId != null) {
                try {
                    resolved = this.catalog.resolvePublic(publicId, systemId);
                }
                catch (MalformedURLException malformedURLException) {
                    this.debug(1, "Malformed URL exception trying to resolve", publicId);
                }
                catch (IOException iOException) {
                    this.debug(1, "I/O exception trying to resolve", publicId);
                }
            }
            if (resolved != null) {
                this.debug(2, "Resolved", publicId, resolved);
            }
        } else {
            this.debug(2, "Resolved", systemId, resolved);
        }
        if (resolved == null && this.retryBadSystemIds && publicId != null && systemId != null) {
            URL systemURL = null;
            try {
                systemURL = new URL(systemId);
            }
            catch (MalformedURLException malformedURLException) {
                try {
                    systemURL = new URL("file:///" + systemId);
                }
                catch (MalformedURLException malformedURLException2) {
                    systemURL = null;
                }
            }
            if (systemURL != null) {
                try {
                    InputStream iStream = systemURL.openStream();
                    InputSource iSource = new InputSource(systemId);
                    iSource.setPublicId(publicId);
                    iSource.setByteStream(iStream);
                    return iSource;
                }
                catch (Exception exception) {}
            }
            this.debug(2, "Failed to open", systemId);
            this.debug(2, "\tAttempting catalog lookup without system identifier.");
            return this.resolveEntity(publicId, null);
        }
        if (resolved != null) {
            try {
                InputSource iSource = new InputSource(resolved);
                iSource.setPublicId(publicId);
                URL url = new URL(resolved);
                InputStream iStream = url.openStream();
                iSource.setByteStream(iStream);
                return iSource;
            }
            catch (Exception exception) {
                this.debug(1, "Failed to create InputSource", resolved);
                return null;
            }
        }
        return null;
    }

    public void setCatalog(Catalog cat) {
        this.catalog = cat;
    }

    public void setRetry(boolean retry) {
        this.retryBadSystemIds = retry;
    }
}

