/*
 * Decompiled with CFR 0.152.
 */
package com.arbortext.catalog;

import com.arbortext.catalog.CatalogEntry;
import com.arbortext.catalog.CatalogReader;
import com.arbortext.catalog.InvalidCatalogEntryException;
import com.arbortext.catalog.InvalidCatalogEntryTypeException;
import com.arbortext.catalog.NoXMLParserException;
import com.arbortext.catalog.NotXMLCatalogException;
import com.arbortext.catalog.UnknownCatalogFormatException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public class XMLCatalogReader
implements DocumentHandler {
    private String catfilename;
    public int debug;
    private static final int NOTXMLCATALOG = -1;
    private static final int UNKNOWNCATALOG = 0;
    private static final int XCATALOG = 1;
    private int catalogType;
    private Vector catalogEntries;
    private Enumeration catalogEnum;
    private String parserClass;

    public XMLCatalogReader() {
        block2: {
            this.catfilename = null;
            this.debug = 0;
            this.catalogType = -1;
            this.catalogEntries = new Vector();
            this.catalogEnum = null;
            this.parserClass = null;
            String property = System.getProperty("xml.catalog.debug");
            if (property == null) break block2;
            try {
                this.debug = Integer.parseInt(property);
            }
            catch (NumberFormatException numberFormatException) {
                this.debug = 0;
            }
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    private void debug(int level, String message, String token) {
        if (this.debug >= level) {
            System.out.println(String.valueOf(message) + ": " + token);
        }
    }

    private void debug(int level, String message, String token, String spec) {
        if (this.debug >= level) {
            System.out.println(String.valueOf(message) + ": " + token + " " + spec);
        }
    }

    private void debug(int level, String message, String token, String spec1, String spec2) {
        if (this.debug >= level) {
            System.out.println(String.valueOf(message) + ": " + token + " " + spec1);
            System.out.println("\t" + spec2);
        }
    }

    public void endDocument() throws SAXException {
    }

    public void endElement(String name) throws SAXException {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public CatalogEntry nextEntry() throws IOException {
        if (this.catalogEnum == null) {
            this.catalogEnum = this.catalogEntries.elements();
        }
        if (this.catalogEnum.hasMoreElements()) {
            return (CatalogEntry)this.catalogEnum.nextElement();
        }
        return null;
    }

    public void parseCatalog(String fileUrl) throws SAXException, IOException, NotXMLCatalogException, NoXMLParserException, UnknownCatalogFormatException, ClassNotFoundException, InstantiationException, IllegalAccessException, ClassCastException {
        if (this.parserClass == null) {
            throw new NoXMLParserException();
        }
        Parser parser = (Parser)Class.forName(this.parserClass).newInstance();
        this.catfilename = fileUrl;
        parser.setDocumentHandler(this);
        parser.parse(fileUrl);
        if (this.catalogType == -1) {
            throw new NotXMLCatalogException();
        }
        if (this.catalogType == 0) {
            throw new UnknownCatalogFormatException();
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void setParserClass(String parser) {
        this.parserClass = parser;
    }

    public void startDocument() throws SAXException {
    }

    public void startElement(String name, AttributeList atts) throws SAXException {
        if ((this.catalogType == 0 || this.catalogType == -1) && name.equals("XMLCatalog")) {
            this.catalogType = 1;
            return;
        }
        if (this.catalogType == 1) {
            this.xCatalogEntry(name, atts);
        }
    }

    private void xCatalogEntry(String name, AttributeList atts) {
        CatalogEntry ce = null;
        try {
            if (name.equals("Base")) {
                ce = new CatalogEntry(1, atts.getValue("HRef"));
                this.debug(3, "Base", atts.getValue("HRef"));
            }
            if (name.equals("Delegate")) {
                ce = new CatalogEntry(6, CatalogReader.normalize(atts.getValue("PublicId")), atts.getValue("HRef"));
                this.debug(3, "Delegate", CatalogReader.normalize(atts.getValue("PublicId")), atts.getValue("HRef"));
            }
            if (name.equals("Extend")) {
                ce = new CatalogEntry(2, atts.getValue("HRef"));
                this.debug(3, "Extend", atts.getValue("HRef"));
            }
            if (name.equals("Map")) {
                ce = new CatalogEntry(12, CatalogReader.normalize(atts.getValue("PublicId")), atts.getValue("HRef"));
                this.debug(3, "Map", CatalogReader.normalize(atts.getValue("PublicId")), atts.getValue("HRef"));
            }
            if (name.equals("Remap")) {
                ce = new CatalogEntry(13, atts.getValue("SystemId"), atts.getValue("HRef"));
                this.debug(3, "Remap", CatalogReader.normalize(atts.getValue("SystemId")), atts.getValue("HRef"));
            }
            if (ce == null) {
                this.debug(1, "Invalid catalog entry type", name);
            }
        }
        catch (InvalidCatalogEntryTypeException invalidCatalogEntryTypeException) {
            this.debug(1, "Invalid catalog entry type", name);
        }
        catch (InvalidCatalogEntryException invalidCatalogEntryException) {
            this.debug(1, "Invalid catalog entry", name);
        }
        if (ce != null) {
            this.catalogEntries.addElement(ce);
        }
    }
}

