// $Id: LayoutHelper.java,v 1.4 2003/06/30 18:00:31 linus Exp $
// Copyright (c) 1996-2003 The Regents of the University of California. All
// Rights Reserved. Permission to use, copy, modify, and distribute this
// software and its documentation without fee, and without a written
// agreement is hereby granted, provided that the above copyright notice
// and this paragraph appear in all copies.  This software program and
// documentation are copyrighted by The Regents of the University of
// California. The software program and documentation are supplied "AS
// IS", without any accompanying services from The Regents. The Regents
// does not warrant that the operation of the program will be
// uninterrupted or error-free. The end-user understands that the program
// was developed for research purposes and is advised not to rely
// exclusively on the program for any reason.  IN NO EVENT SHALL THE
// UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,
// SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING LOST PROFITS,
// ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
// THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE. THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY
// WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
// PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
// CALIFORNIA HAS NO OBLIGATIONS TO PROVIDE MAINTENANCE, SUPPORT,
// UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

package org.argouml.uml.diagram.layout;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Polygon;

/** LayoutHelper is a utility class which mainly returns various types
 *  of routing polygons for different kind of connection lines between
 *  two nodes. Specific layouters might use these methods to reuse certain
 *  kinds of diagram lines.
 *  @stereotype utility
*/
public class LayoutHelper {

    public static final int NORTH = 0;
    public static final int NORTHEAST = 1;
    public static final int EAST = 2;
    public static final int SOUTHEAST = 4;
    public static final int SOUTH = 8;
    public static final int SOUTHWEST = 16;
    public static final int WEST = 32;
    public static final int NORTHWEST = 64;

    public static Point getPointOnPerimeter(Rectangle rect, int direction) 
    {
        return getPointOnPerimeter(rect, direction, 0, 0);
    }

    public static Point getPointOnPerimeter(Rectangle rect, int direction, 
					    double xOff, double yOff)
    {
        double x = 0;
        double y = 0;;
        if (direction == NORTH || direction == NORTHEAST || 
            direction == NORTHWEST) { y = rect.getY(); }
        if (direction == SOUTH || direction == SOUTHWEST ||
            direction == SOUTHEAST) { y = rect.getY() + rect.getHeight(); }
        if (direction == EAST || direction == WEST) {
            y = rect.getY() + rect.getHeight() / 2.0;
	}

        if (direction == NORTHWEST || direction == WEST || 
            direction == SOUTHWEST) { x = rect.getX(); }
        if (direction == NORTHEAST || direction == EAST ||
            direction == SOUTHEAST) { x = rect.getX() + rect.getWidth(); }
        if (direction == NORTH || direction == SOUTH) {
            x = rect.getX() + rect.getWidth() / 2.0; 
	}

        x += xOff;
        y += yOff;
        return new Point((int) x, (int) y);        
    }

    /** get a routing polygon for a straightline between two points
     */
    public static Polygon getRoutingPolygonStraightLine(Point start, Point end)
    {
        return getRoutingPolygonStraightLineWithOffset(start, end, 0);
    }

    /** get a routing polygon with a horizontal offset from the two points */
    public static Polygon getRoutingPolygonStraightLineWithOffset(Point start, 
                                                Point end, int offset) 
    {
        Polygon newPoly = new Polygon();

        newPoly.addPoint((int) start.getX(), (int) start.getY());
        if (offset != 0) {
            double newY = 0.0;
            if (offset < 0) {
                newY = 
                    Math.min(start.getY() + offset, end.getY() + offset);
            }
            if (offset > 0) {
                newY = 
                    Math.max(start.getY() + offset, end.getY() + offset);
            }
            newPoly.addPoint((int) start.getX(), (int) newY);
            newPoly.addPoint((int) end.getX(), (int) newY);
            
        }
        newPoly.addPoint((int) end.getX(), (int) end.getY());
        return newPoly;
    }

}

