// $Id: UMLTaggedTextProperty.java,v 1.5 2003/06/30 19:23:20 linus Exp $
// Copyright (c) 1996-99 The Regents of the University of California. All
// Rights Reserved. Permission to use, copy, modify, and distribute this
// software and its documentation without fee, and without a written
// agreement is hereby granted, provided that the above copyright notice
// and this paragraph appear in all copies.  This software program and
// documentation are copyrighted by The Regents of the University of
// California. The software program and documentation are supplied "AS
// IS", without any accompanying services from The Regents. The Regents
// does not warrant that the operation of the program will be
// uninterrupted or error-free. The end-user understands that the program
// was developed for research purposes and is advised not to rely
// exclusively on the program for any reason.  IN NO EVENT SHALL THE
// UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,
// SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING LOST PROFITS,
// ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
// THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE. THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY
// WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
// PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
// CALIFORNIA HAS NO OBLIGATIONS TO PROVIDE MAINTENANCE, SUPPORT,
// UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

package org.argouml.uml.ui;
import java.lang.reflect.*;
import ru.novosoft.uml.*;
import ru.novosoft.uml.foundation.core.*;

/**
 * @deprecated as of ArgoUml 0.13.5 (10-may-2003),
 *             replaced by ?,
 *             this class is part of the 'old'(pre 0.13.*) implementation of proppanels
 *             that used reflection a lot.
 */
public class UMLTaggedTextProperty extends UMLTextProperty  {
    
    public UMLTaggedTextProperty(String propertyName) {
        super(propertyName);
        _propertyName = propertyName;
    }
    
	/**
     * Hack to circumvent problems with the validating property. This method never
     * validates.
	 * @see org.argouml.uml.ui.UMLTextProperty#setProperty(UMLUserInterfaceContainer, String, boolean)
     * @author jaap.branderhorst@xs4all.nl
	 */
    public void setProperty(UMLUserInterfaceContainer container, String newValue, boolean validating) {
        setProperty(container, newValue);
    }
        
    public void setProperty(UMLUserInterfaceContainer container, String newValue) {
        Object element = container.getTarget();
        if (element instanceof MModelElement) {
            ((MModelElement) element).setTaggedValue(_propertyName, newValue);
        }
    }
    
    public String getProperty(UMLUserInterfaceContainer container) {
        String value = null;
        Object element = container.getTarget();
        if (element instanceof MModelElement) {
            value = ((MModelElement) element).getTaggedValue(_propertyName);
        }
        else {
            value = "";
        }
        return value;
    }
    
    boolean isAffected(MElementEvent event) {
        String sourceName = event.getName();
        if (_propertyName == null || sourceName == null || sourceName.equals(_propertyName))
            return true;
        return false;
    }
    
    void targetChanged() {
    }
}


