/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.ast;

import org.aspectj.org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.CharLiteral;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ExtendedStringLiteral;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Literal;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.StringLiteralConcatenation;
import org.aspectj.org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.Constant;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class StringLiteral
extends Literal {
    char[] source;

    public StringLiteral(char[] token, int s, int e) {
        this(s, e);
        this.source = token;
    }

    public StringLiteral(int s, int e) {
        super(s, e);
    }

    public void computeConstant() {
        this.constant = Constant.fromValue(String.valueOf(this.source));
    }

    public ExtendedStringLiteral extendWith(CharLiteral lit) {
        return new ExtendedStringLiteral(this, lit);
    }

    public ExtendedStringLiteral extendWith(StringLiteral lit) {
        return new ExtendedStringLiteral(this, lit);
    }

    public StringLiteralConcatenation extendsWith(StringLiteral lit) {
        return new StringLiteralConcatenation(this, lit);
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
        int pc = codeStream.position;
        if (valueRequired) {
            codeStream.ldc(this.constant.stringValue());
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public TypeBinding literalType(BlockScope scope) {
        return scope.getJavaLangString();
    }

    public StringBuffer printExpression(int indent, StringBuffer output) {
        output.append('\"');
        int i = 0;
        while (i < this.source.length) {
            switch (this.source[i]) {
                case '\b': {
                    output.append("\\b");
                    break;
                }
                case '\t': {
                    output.append("\\t");
                    break;
                }
                case '\n': {
                    output.append("\\n");
                    break;
                }
                case '\f': {
                    output.append("\\f");
                    break;
                }
                case '\r': {
                    output.append("\\r");
                    break;
                }
                case '\"': {
                    output.append("\\\"");
                    break;
                }
                case '\'': {
                    output.append("\\'");
                    break;
                }
                case '\\': {
                    output.append("\\\\");
                    break;
                }
                default: {
                    output.append(this.source[i]);
                }
            }
            ++i;
        }
        output.append('\"');
        return output;
    }

    public char[] source() {
        return this.source;
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        visitor.visit(this, scope);
        visitor.endVisit(this, scope);
    }
}

