/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.util.LinkedList;
import java.util.StringTokenizer;
import org.eclipse.core.internal.resources.WorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Preferences;

public class WorkspacePreferences
extends WorkspaceDescription {
    private Preferences preferences = ResourcesPlugin.getPlugin().getPluginPreferences();
    public static final String PROJECT_SEPARATOR = ":";

    public WorkspacePreferences() {
        super("Workspace");
        super.setAutoBuilding(this.preferences.getBoolean("description.autobuilding"));
        super.setSnapshotInterval(this.preferences.getInt("description.snapshotinterval"));
        super.setMaxBuildIterations(this.preferences.getInt("description.maxbuilditerations"));
        super.setMaxFileStates(this.preferences.getInt("description.maxfilestates"));
        super.setMaxFileStateSize(this.preferences.getLong("description.maxfilestatesize"));
        super.setFileStateLongevity(this.preferences.getLong("description.filestatelongevity"));
        super.setOperationsPerSnapshot(this.preferences.getInt("snapshots.operations"));
        super.setDeltaExpiration(this.preferences.getLong("delta.expiration"));
        this.preferences.addPropertyChangeListener(new Preferences.IPropertyChangeListener(){

            public void propertyChange(Preferences.PropertyChangeEvent event) {
                WorkspacePreferences.this.synchronizeWithPreferences(event.getProperty());
            }
        });
    }

    public String[] getBuildOrder() {
        boolean defaultBuildOrder = this.preferences.getBoolean("description.defaultbuildorder");
        if (defaultBuildOrder) {
            return null;
        }
        return WorkspacePreferences.convertStringToStringArray(this.preferences.getString("description.buildorder"));
    }

    public String[] getBuildOrder(boolean makeCopy) {
        String[] result = this.getBuildOrder();
        if (result == null) {
            return null;
        }
        return makeCopy ? (String[])result.clone() : result;
    }

    public void setAutoBuilding(boolean value) {
        this.preferences.setValue("description.autobuilding", value);
    }

    public void setBuildOrder(String[] value) {
        this.preferences.setValue("description.defaultbuildorder", value == null);
        this.preferences.setValue("description.buildorder", WorkspacePreferences.convertStringArraytoString(value));
    }

    public void setFileStateLongevity(long time) {
        this.preferences.setValue("description.filestatelongevity", time);
    }

    public void setOperationsPerSnapshot(int value) {
        this.preferences.setValue("snapshots.operations", value);
    }

    public void setDeltaExpiration(long value) {
        this.preferences.setValue("delta.expiration", value);
    }

    public void setMaxBuildIterations(int number) {
        this.preferences.setValue("description.maxbuilditerations", number);
    }

    public void setMaxFileStates(int number) {
        this.preferences.setValue("description.maxfilestates", number);
    }

    public void setMaxFileStateSize(long size) {
        this.preferences.setValue("description.maxfilestatesize", size);
    }

    public void setSnapshotInterval(long delay) {
        this.preferences.setValue("description.snapshotinterval", delay);
    }

    public static String convertStringArraytoString(String[] array) {
        if (array == null || array.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < array.length) {
            sb.append(array[i]);
            sb.append(PROJECT_SEPARATOR);
            ++i;
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public static String[] convertStringToStringArray(String string) {
        LinkedList<String> list = new LinkedList<String>();
        StringTokenizer tokenizer = new StringTokenizer(string, PROJECT_SEPARATOR);
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken());
        }
        return list.toArray(new String[list.size()]);
    }

    private static void copyFromTo(WorkspaceDescription source, WorkspaceDescription target) {
        target.setAutoBuilding(source.isAutoBuilding());
        target.setBuildOrder(source.getBuildOrder());
        target.setFileStateLongevity(source.getFileStateLongevity());
        target.setMaxBuildIterations(source.getMaxBuildIterations());
        target.setMaxFileStates(source.getMaxFileStates());
        target.setMaxFileStateSize(source.getMaxFileStateSize());
        target.setSnapshotInterval(source.getSnapshotInterval());
        target.setOperationsPerSnapshot(source.getOperationsPerSnapshot());
        target.setDeltaExpiration(source.getDeltaExpiration());
    }

    public void copyFrom(WorkspaceDescription source) {
        WorkspacePreferences.copyFromTo(source, this);
    }

    public void copyTo(WorkspaceDescription target) {
        WorkspacePreferences.copyFromTo(this, target);
    }

    public Object clone() {
        throw new UnsupportedOperationException("clone() is not supported in " + this.getClass().getName());
    }

    protected void synchronizeWithPreferences(String property) {
        if (property.equals("description.autobuilding")) {
            super.setAutoBuilding(this.preferences.getBoolean("description.autobuilding"));
        } else if (property.equals("description.snapshotinterval")) {
            super.setSnapshotInterval(this.preferences.getLong("description.snapshotinterval"));
        } else if (property.equals("description.maxbuilditerations")) {
            super.setMaxBuildIterations(this.preferences.getInt("description.maxbuilditerations"));
        } else if (property.equals("description.maxfilestates")) {
            super.setMaxFileStates(this.preferences.getInt("description.maxfilestates"));
        } else if (property.equals("description.maxfilestatesize")) {
            super.setMaxFileStateSize(this.preferences.getLong("description.maxfilestatesize"));
        } else if (property.equals("description.filestatelongevity")) {
            super.setFileStateLongevity(this.preferences.getLong("description.filestatelongevity"));
        } else if (property.equals("snapshots.operations")) {
            super.setOperationsPerSnapshot(this.preferences.getInt("snapshots.operations"));
        } else if (property.equals("delta.expiration")) {
            super.setDeltaExpiration(this.preferences.getLong("delta.expiration"));
        }
    }
}

