/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.ast;

import org.aspectj.org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.aspectj.org.eclipse.jdt.internal.compiler.ClassFile;
import org.aspectj.org.eclipse.jdt.internal.compiler.CompilationResult;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Initializer;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.aspectj.org.eclipse.jdt.internal.compiler.codegen.ConstantPool;
import org.aspectj.org.eclipse.jdt.internal.compiler.codegen.Label;
import org.aspectj.org.eclipse.jdt.internal.compiler.flow.ExceptionHandlingFlowContext;
import org.aspectj.org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.aspectj.org.eclipse.jdt.internal.compiler.flow.InitializationFlowContext;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.aspectj.org.eclipse.jdt.internal.compiler.parser.Parser;
import org.aspectj.org.eclipse.jdt.internal.compiler.problem.AbortMethod;

public class Clinit
extends AbstractMethodDeclaration {
    private FieldBinding assertionSyntheticFieldBinding = null;
    private FieldBinding classLiteralSyntheticField = null;

    public Clinit(CompilationResult compilationResult) {
        super(compilationResult);
        this.modifiers = 0;
        this.selector = TypeConstants.CLINIT;
    }

    public void analyseCode(ClassScope classScope, InitializationFlowContext staticInitializerFlowContext, FlowInfo flowInfo) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            ExceptionHandlingFlowContext clinitContext = new ExceptionHandlingFlowContext(staticInitializerFlowContext.parent, this, TypeConstants.NoExceptions, this.scope, FlowInfo.DEAD_END);
            this.needFreeReturn = flowInfo.isReachable();
            flowInfo = flowInfo.mergedWith(staticInitializerFlowContext.initsOnReturn);
            FieldBinding[] fields = this.scope.enclosingSourceType().fields();
            int i = 0;
            int count = fields.length;
            while (i < count) {
                FieldBinding field = fields[i];
                if (field.isStatic() && field.isFinal() && !flowInfo.isDefinitelyAssigned(fields[i])) {
                    this.scope.problemReporter().uninitializedBlankFinalField(field, this.scope.referenceType().declarationOf(field.original()));
                }
                ++i;
            }
            staticInitializerFlowContext.checkInitializerExceptions(this.scope, clinitContext, flowInfo);
        }
        catch (AbortMethod e) {
            this.ignoreFurtherInvestigation = true;
        }
    }

    public void generateCode(ClassScope classScope, ClassFile classFile) {
        int clinitOffset = 0;
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            clinitOffset = classFile.contentsOffset;
            this.generateCode(classScope, classFile, clinitOffset);
        }
        catch (AbortMethod e) {
            if (e.compilationResult == CodeStream.RESTART_IN_WIDE_MODE) {
                try {
                    classFile.contentsOffset = clinitOffset;
                    --classFile.methodCount;
                    classFile.codeStream.wideMode = true;
                    this.generateCode(classScope, classFile, clinitOffset);
                }
                catch (AbortMethod e2) {
                    classFile.contentsOffset = clinitOffset;
                    --classFile.methodCount;
                }
            }
            classFile.contentsOffset = clinitOffset;
            --classFile.methodCount;
        }
    }

    private void generateCode(ClassScope classScope, ClassFile classFile, int clinitOffset) {
        ConstantPool constantPool = classFile.constantPool;
        int constantPoolOffset = constantPool.currentOffset;
        int constantPoolIndex = constantPool.currentIndex;
        classFile.generateMethodInfoHeaderForClinit();
        int codeAttributeOffset = classFile.contentsOffset;
        classFile.generateCodeAttributeHeader();
        CodeStream codeStream = classFile.codeStream;
        this.resolve(classScope);
        codeStream.reset(this, classFile);
        TypeDeclaration declaringType = classScope.referenceContext;
        MethodScope staticInitializerScope = declaringType.staticInitializerScope;
        staticInitializerScope.computeLocalVariablePositions(0, codeStream);
        this.generateSyntheticCode(classScope, codeStream);
        FieldDeclaration[] fieldDeclarations = declaringType.fields;
        BlockScope lastInitializerScope = null;
        if (declaringType.kind() == 3) {
            FieldDeclaration fieldDecl;
            int max;
            int i;
            int enumCount = 0;
            int remainingFieldCount = 0;
            if (fieldDeclarations != null) {
                i = 0;
                max = fieldDeclarations.length;
                while (i < max) {
                    fieldDecl = fieldDeclarations[i];
                    if (fieldDecl.isStatic()) {
                        if (fieldDecl.getKind() == 3) {
                            fieldDecl.generateCode(staticInitializerScope, codeStream);
                            ++enumCount;
                        } else {
                            ++remainingFieldCount;
                        }
                    }
                    ++i;
                }
            }
            if (enumCount > 0 && fieldDeclarations != null) {
                codeStream.generateInlinedValue(enumCount);
                codeStream.anewarray(declaringType.binding);
                i = 0;
                max = fieldDeclarations.length;
                while (i < max) {
                    fieldDecl = fieldDeclarations[i];
                    if (fieldDecl.getKind() == 3) {
                        codeStream.dup();
                        codeStream.generateInlinedValue(fieldDecl.binding.id);
                        codeStream.getstatic(fieldDecl.binding);
                        codeStream.aastore();
                    }
                    ++i;
                }
                codeStream.putstatic(declaringType.enumValuesSyntheticfield);
            }
            if (remainingFieldCount != 0) {
                i = 0;
                max = fieldDeclarations.length;
                while (i < max) {
                    fieldDecl = fieldDeclarations[i];
                    switch (fieldDecl.getKind()) {
                        case 3: {
                            break;
                        }
                        case 2: {
                            if (!fieldDecl.isStatic()) break;
                            lastInitializerScope = ((Initializer)fieldDecl).block.scope;
                            fieldDecl.generateCode(staticInitializerScope, codeStream);
                            break;
                        }
                        case 1: {
                            if (!fieldDecl.binding.isStatic()) break;
                            lastInitializerScope = null;
                            fieldDecl.generateCode(staticInitializerScope, codeStream);
                        }
                    }
                    ++i;
                }
            }
        } else if (fieldDeclarations != null) {
            int i = 0;
            int max = fieldDeclarations.length;
            while (i < max) {
                FieldDeclaration fieldDecl = fieldDeclarations[i];
                switch (fieldDecl.getKind()) {
                    case 2: {
                        if (!fieldDecl.isStatic()) break;
                        lastInitializerScope = ((Initializer)fieldDecl).block.scope;
                        fieldDecl.generateCode(staticInitializerScope, codeStream);
                        break;
                    }
                    case 1: {
                        if (!fieldDecl.binding.isStatic()) break;
                        lastInitializerScope = null;
                        fieldDecl.generateCode(staticInitializerScope, codeStream);
                    }
                }
                ++i;
            }
        }
        this.generatePostSyntheticCode(classScope, codeStream);
        if (codeStream.position == 0) {
            classFile.contentsOffset = clinitOffset;
            --classFile.methodCount;
            constantPool.resetForClinit(constantPoolIndex, constantPoolOffset);
        } else {
            if (this.needFreeReturn) {
                int before = codeStream.position;
                codeStream.return_();
                if (lastInitializerScope != null) {
                    codeStream.updateLastRecordedEndPC(lastInitializerScope, before);
                }
            }
            codeStream.recordPositionsFrom(0, declaringType.sourceStart);
            classFile.completeCodeAttributeForClinit(codeAttributeOffset);
        }
    }

    protected void generateSyntheticCode(ClassScope classScope, CodeStream codeStream) {
        if (this.assertionSyntheticFieldBinding != null) {
            codeStream.generateClassLiteralAccessForType(classScope.enclosingSourceType(), this.classLiteralSyntheticField);
            codeStream.invokeJavaLangClassDesiredAssertionStatus();
            Label falseLabel = new Label(codeStream);
            codeStream.ifne(falseLabel);
            codeStream.iconst_1();
            Label jumpLabel = new Label(codeStream);
            codeStream.goto_(jumpLabel);
            falseLabel.place();
            codeStream.iconst_0();
            jumpLabel.place();
            codeStream.putstatic(this.assertionSyntheticFieldBinding);
        }
    }

    protected void generatePostSyntheticCode(ClassScope classScope, CodeStream codeStream) {
    }

    public boolean isClinit() {
        return true;
    }

    public boolean isInitializationMethod() {
        return true;
    }

    public boolean isStatic() {
        return true;
    }

    public void parseStatements(Parser parser, CompilationUnitDeclaration unit) {
    }

    public StringBuffer print(int tab, StringBuffer output) {
        ASTNode.printIndent(tab, output).append("<clinit>()");
        this.printBody(tab + 1, output);
        return output;
    }

    public void resolve(ClassScope classScope) {
        this.scope = new MethodScope(classScope, classScope.referenceContext, true);
    }

    public void traverse(ASTVisitor visitor, ClassScope classScope) {
        visitor.visit(this, classScope);
        visitor.endVisit(this, classScope);
    }

    public void setAssertionSupport(FieldBinding assertionSyntheticFieldBinding, boolean needClassLiteralField) {
        this.assertionSyntheticFieldBinding = assertionSyntheticFieldBinding;
        SourceTypeBinding sourceType = this.scope.outerMostMethodScope().enclosingSourceType();
        if (needClassLiteralField) {
            this.classLiteralSyntheticField = sourceType.addSyntheticFieldForClassLiteral(sourceType, this.scope);
        }
    }
}

