/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.compiler.problem;

import java.lang.reflect.Modifier;
import java.util.Iterator;
import org.aspectj.ajdt.internal.compiler.ast.PointcutDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.Proceed;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseFactory;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.CompilationResult;
import org.aspectj.org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.aspectj.org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ExplicitConstructorCall;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.aspectj.util.FuzzyBoolean;
import org.aspectj.weaver.AjcMemberMaker;
import org.aspectj.weaver.ConcreteTypeMunger;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.patterns.DeclareAnnotation;
import org.aspectj.weaver.patterns.DeclareSoft;

public class AjProblemReporter
extends ProblemReporter {
    private static final boolean DUMP_STACK = false;
    public EclipseFactory factory;

    public AjProblemReporter(IErrorHandlingPolicy policy, CompilerOptions options, IProblemFactory problemFactory) {
        super(policy, options, problemFactory);
    }

    public void unhandledException(TypeBinding exceptionType, ASTNode location) {
        if (!this.factory.getWorld().getDeclareSoft().isEmpty()) {
            Shadow callSite = this.factory.makeShadow(location, this.referenceContext);
            Shadow enclosingExec = this.factory.makeShadow(this.referenceContext);
            if (callSite == null && enclosingExec.getKind() == Shadow.ConstructorExecution && location instanceof ExplicitConstructorCall) {
                super.unhandledException(exceptionType, location);
                return;
            }
            Iterator i = this.factory.getWorld().getDeclareSoft().iterator();
            while (i.hasNext()) {
                FuzzyBoolean match;
                DeclareSoft d = (DeclareSoft)i.next();
                ResolvedTypeX throwException = this.factory.fromEclipse((ReferenceBinding)exceptionType);
                FuzzyBoolean isExceptionTypeOrSubtype = d.getException().matchesInstanceof(throwException);
                if (!isExceptionTypeOrSubtype.alwaysTrue()) continue;
                if (callSite != null) {
                    match = d.getPointcut().match(callSite);
                    if (match.alwaysTrue()) {
                        return;
                    }
                    if (!match.alwaysFalse()) {
                        // empty if block
                    }
                }
                if (enclosingExec == null) continue;
                match = d.getPointcut().match(enclosingExec);
                if (match.alwaysTrue()) {
                    return;
                }
                if (match.alwaysFalse()) continue;
            }
        }
        if (location instanceof Proceed) {
            return;
        }
        super.unhandledException(exceptionType, location);
    }

    private boolean isPointcutDeclaration(MethodBinding binding) {
        return CharOperation.prefixEquals(PointcutDeclaration.mangledPrefix, binding.selector);
    }

    public void abstractMethodCannotBeOverridden(SourceTypeBinding type, MethodBinding concreteMethod) {
        if (this.isPointcutDeclaration(concreteMethod)) {
            return;
        }
        super.abstractMethodCannotBeOverridden(type, concreteMethod);
    }

    public void inheritedMethodReducesVisibility(SourceTypeBinding type, MethodBinding concreteMethod, MethodBinding[] abstractMethods) {
        ResolvedTypeX onTypeX = null;
        onTypeX = !type.isAnonymousType() ? this.factory.fromEclipse(type) : this.factory.fromEclipse(type.superclass());
        Iterator i = onTypeX.getInterTypeMungersIncludingSupers().iterator();
        while (i.hasNext()) {
            ConcreteTypeMunger m = (ConcreteTypeMunger)i.next();
            ResolvedMember sig = m.getSignature();
            if (Modifier.isAbstract(sig.getModifiers()) || !ResolvedTypeX.matches(AjcMemberMaker.interMethod(sig, m.getAspectType(), sig.getDeclaringType().isInterface(this.factory.getWorld())), EclipseFactory.makeResolvedMember(concreteMethod))) continue;
            return;
        }
        super.inheritedMethodReducesVisibility(type, concreteMethod, abstractMethods);
    }

    public void abstractMethodMustBeImplemented(SourceTypeBinding type, MethodBinding abstractMethod) {
        if (this.isPointcutDeclaration(abstractMethod)) {
            return;
        }
        if (CharOperation.prefixEquals("ajc$interField".toCharArray(), abstractMethod.selector)) {
            return;
        }
        ResolvedTypeX onTypeX = null;
        onTypeX = !type.isAnonymousType() ? this.factory.fromEclipse(type) : this.factory.fromEclipse(type.superclass());
        Iterator i = onTypeX.getInterTypeMungersIncludingSupers().iterator();
        while (i.hasNext()) {
            ConcreteTypeMunger m = (ConcreteTypeMunger)i.next();
            ResolvedMember sig = m.getSignature();
            if (Modifier.isAbstract(sig.getModifiers()) || !ResolvedTypeX.matches(AjcMemberMaker.interMethod(sig, m.getAspectType(), sig.getDeclaringType().isInterface(this.factory.getWorld())), EclipseFactory.makeResolvedMember(abstractMethod))) continue;
            return;
        }
        super.abstractMethodMustBeImplemented(type, abstractMethod);
    }

    public void disallowedTargetForAnnotation(Annotation annotation) {
        if (annotation.recipient instanceof MethodBinding) {
            MethodBinding binding = (MethodBinding)annotation.recipient;
            String name = new String(binding.selector);
            if (name.startsWith("ajc$")) {
                long metaTagBits = annotation.resolvedType.getAnnotationTagBits();
                if (name.indexOf("interField") != -1 ? (metaTagBits & 0x1000000000L) != 0L : (name.indexOf("InterConstructor") != -1 ? (metaTagBits & 0x8000000000L) != 0L : (name.indexOf("interMethod") != -1 ? (metaTagBits & 0x2000000000L) != 0L : (name.indexOf("declare_" + DeclareAnnotation.AT_TYPE + "_") != -1 ? (metaTagBits & 0x20000000000L) != 0L || (metaTagBits & 0x800000000L) != 0L : (name.indexOf("declare_" + DeclareAnnotation.AT_FIELD + "_") != -1 ? (metaTagBits & 0x1000000000L) != 0L : name.indexOf("declare_" + DeclareAnnotation.AT_CONSTRUCTOR + "_") != -1 && (metaTagBits & 0x8000000000L) != 0L))))) {
                    return;
                }
            }
        }
        super.disallowedTargetForAnnotation(annotation);
    }

    public void handle(int problemId, String[] problemArguments, String[] messageArguments, int severity, int problemStartPosition, int problemEndPosition, ReferenceContext referenceContext, CompilationResult unitResult) {
        if (severity != -1) {
            // empty if block
        }
        super.handle(problemId, problemArguments, messageArguments, severity, problemStartPosition, problemEndPosition, referenceContext, unitResult);
    }

    public void javadocMissingParamTag(char[] name, int sourceStart, int sourceEnd, int modifiers) {
        boolean reportIt = true;
        String sName = new String(name);
        if (sName.startsWith("ajc$")) {
            reportIt = false;
        }
        if (sName.equals("thisJoinPoint")) {
            reportIt = false;
        }
        if (sName.equals("thisJoinPointStaticPart")) {
            reportIt = false;
        }
        if (sName.equals("thisEnclosingJoinPointStaticPart")) {
            reportIt = false;
        }
        if (sName.equals("ajc_aroundClosure")) {
            reportIt = false;
        }
        if (reportIt) {
            super.javadocMissingParamTag(name, sourceStart, sourceEnd, modifiers);
        }
    }

    public void abstractMethodInAbstractClass(SourceTypeBinding type, AbstractMethodDeclaration methodDecl) {
        String abstractMethodName = new String(methodDecl.selector);
        if (abstractMethodName.startsWith("ajc$pointcut")) {
            return;
        }
        String[] arguments = new String[]{new String(type.sourceName()), abstractMethodName};
        super.handle(67109227, arguments, arguments, methodDecl.sourceStart, methodDecl.sourceEnd, this.referenceContext, this.referenceContext == null ? null : this.referenceContext.compilationResult());
    }
}

