/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.adaptor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.adaptor.EclipseAdaptor;
import org.eclipse.core.runtime.adaptor.EclipseAdaptorMsg;
import org.eclipse.core.runtime.adaptor.LocationManager;
import org.eclipse.core.runtime.internal.adaptor.CachedManifest;
import org.eclipse.core.runtime.internal.adaptor.EclipseEnvironmentInfo;
import org.eclipse.core.runtime.internal.adaptor.PluginConverterImpl;
import org.eclipse.osgi.framework.adaptor.core.AbstractBundleData;
import org.eclipse.osgi.framework.adaptor.core.AbstractFrameworkAdaptor;
import org.eclipse.osgi.framework.adaptor.core.BundleEntry;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.framework.util.Headers;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.pluginconversion.PluginConversionException;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

public class EclipseBundleData
extends AbstractBundleData {
    public static final byte MANIFEST_TYPE_UNKNOWN = 0;
    public static final byte MANIFEST_TYPE_BUNDLE = 1;
    public static final byte MANIFEST_TYPE_PLUGIN = 2;
    public static final byte MANIFEST_TYPE_FRAGMENT = 4;
    public static final byte MANIFEST_TYPE_JAR = 8;
    private static String[] libraryVariants = null;
    private long manifestTimeStamp = 0L;
    private byte manifestType = 0;
    public static final String PROTOCOL = "platform";
    public static final String FILE = "file";
    private static final String PROP_CHECK_CONFIG = "osgi.checkConfiguration";
    protected String pluginClass = null;
    private boolean autoStart;
    private String[] autoStartExceptions;
    protected String buddyList;
    protected String registeredBuddyList;
    protected boolean hasPackageInfo;

    private static String[] buildLibraryVariants() {
        ArrayList<String> result = new ArrayList<String>();
        EclipseEnvironmentInfo info = EclipseEnvironmentInfo.getDefault();
        result.add("ws/" + info.getWS() + "/");
        result.add("os/" + info.getOS() + "/" + info.getOSArch() + "/");
        result.add("os/" + info.getOS() + "/");
        String nl = info.getNL();
        nl = nl.replace('_', '/');
        while (nl.length() > 0) {
            result.add("nl/" + nl + "/");
            int i = nl.lastIndexOf(47);
            String string = nl = i < 0 ? "" : nl.substring(0, i);
        }
        result.add("");
        return result.toArray(new String[result.size()]);
    }

    public EclipseBundleData(AbstractFrameworkAdaptor adaptor, long id) {
        super(adaptor, id);
    }

    public void initializeExistingBundle() throws IOException {
        this.createBaseBundleFile();
        if (!this.checkManifestTimeStamp()) {
            if (this.getBundleStoreDir().exists()) {
                FileOutputStream out = new FileOutputStream(new File(this.getBundleStoreDir(), ".delete"));
                out.close();
            }
            throw new IOException();
        }
    }

    private boolean checkManifestTimeStamp() {
        if (!"true".equalsIgnoreCase(System.getProperty(PROP_CHECK_CONFIG))) {
            return true;
        }
        if (PluginConverterImpl.getTimeStamp(this.getBaseFile(), this.getManifestType()) == this.getManifestTimeStamp()) {
            if ((this.getManifestType() & 9) != 0) {
                return true;
            }
            String cacheLocation = System.getProperty("osgi.manifest.cache");
            Location parentConfiguration = LocationManager.getConfigurationLocation().getParentLocation();
            if (parentConfiguration != null) {
                try {
                    return this.checkManifestAndParent(cacheLocation, this.getSymbolicName(), this.getVersion().toString(), this.getManifestType()) != null;
                }
                catch (BundleException bundleException) {
                    return false;
                }
            }
            File cacheFile = new File(cacheLocation, String.valueOf(this.getSymbolicName()) + '_' + this.getVersion() + ".MF");
            if (cacheFile.isFile()) {
                return true;
            }
        }
        return false;
    }

    public String findLibrary(String libName) {
        String result = super.findLibrary(libName);
        if (result != null) {
            return result;
        }
        if (libraryVariants == null) {
            libraryVariants = EclipseBundleData.buildLibraryVariants();
        }
        if (libName.length() == 0) {
            return null;
        }
        if (libName.charAt(0) == '/' || libName.charAt(0) == '\\') {
            libName = libName.substring(1);
        }
        libName = System.mapLibraryName(libName);
        return this.searchVariants(libraryVariants, libName);
    }

    private String searchVariants(String[] variants, String path) {
        int i = 0;
        while (i < variants.length) {
            BundleEntry libEntry = this.baseBundleFile.getEntry(String.valueOf(variants[i]) + path);
            if (libEntry != null) {
                File libFile = this.baseBundleFile.getFile(String.valueOf(variants[i]) + path);
                if (libFile == null) {
                    return null;
                }
                if ("hpux".equals(EclipseEnvironmentInfo.getDefault().getOS())) {
                    try {
                        Runtime.getRuntime().exec(new String[]{"chmod", "755", libFile.getAbsolutePath()}).waitFor();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return libFile.getAbsolutePath();
            }
            ++i;
        }
        return null;
    }

    private URL[] getSearchURLs(URL target) {
        return new URL[]{target};
    }

    public synchronized Dictionary getManifest() throws BundleException {
        return this.getManifest(false);
    }

    public synchronized Dictionary getManifest(boolean first) throws BundleException {
        if (this.manifest == null) {
            this.manifest = first ? this.loadManifest() : new CachedManifest(this);
        }
        return this.manifest;
    }

    private boolean isComplete(Dictionary manifest) {
        if (manifest.get("Bundle-SymbolicName") != null) {
            return true;
        }
        return this.getEntry("plugin.xml") == null && this.getEntry("fragment.xml") == null;
    }

    public synchronized Dictionary loadManifest() throws BundleException {
        URL url = this.getEntry("META-INF/MANIFEST.MF");
        if (url != null) {
            Dictionary generatedManifest;
            Dictionary builtIn = this.loadManifestFrom(url);
            if (!this.isComplete(builtIn) && (generatedManifest = this.generateManifest(builtIn)) != null) {
                return generatedManifest;
            }
            this.manifestType = 1;
            if (this.getBaseFile().isFile()) {
                this.manifestTimeStamp = this.getBaseFile().lastModified();
                this.manifestType = (byte)(this.manifestType | 8);
            } else {
                this.manifestTimeStamp = this.getBaseBundleFile().getEntry("META-INF/MANIFEST.MF").getTime();
            }
            return builtIn;
        }
        Dictionary result = this.generateManifest(null);
        if (result == null) {
            throw new BundleException(NLS.bind((String)EclipseAdaptorMsg.ECLIPSE_DATA_MANIFEST_NOT_FOUND, (Object)this.getLocation()));
        }
        return result;
    }

    private Headers basicCheckManifest(String cacheLocation, String symbolicName, String version, byte inputType) throws BundleException {
        File currentFile = new File(cacheLocation, String.valueOf(symbolicName) + '_' + version + ".MF");
        if (PluginConverterImpl.upToDate(currentFile, this.getBaseFile(), inputType)) {
            try {
                return Headers.parseManifest((InputStream)new FileInputStream(currentFile));
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        return null;
    }

    private Headers checkManifestAndParent(String cacheLocation, String symbolicName, String version, byte inputType) throws BundleException {
        Headers result = this.basicCheckManifest(cacheLocation, symbolicName, version, inputType);
        if (result != null) {
            return result;
        }
        Location parentConfiguration = null;
        parentConfiguration = LocationManager.getConfigurationLocation().getParentLocation();
        if (parentConfiguration != null) {
            result = this.basicCheckManifest(new File(parentConfiguration.getURL().getFile(), "org.eclipse.osgi/manifests").toString(), symbolicName, version, inputType);
        }
        return result;
    }

    private Dictionary generateManifest(Dictionary originalManifest) throws BundleException {
        Dictionary generatedManifest;
        Headers existingHeaders;
        String cacheLocation = System.getProperty("osgi.manifest.cache");
        if (this.getSymbolicName() != null && (existingHeaders = this.checkManifestAndParent(cacheLocation, this.getSymbolicName(), this.getVersion().toString(), this.manifestType)) != null) {
            return existingHeaders;
        }
        PluginConverterImpl converter = PluginConverterImpl.getDefault();
        try {
            generatedManifest = converter.convertManifest(this.getBaseFile(), true, null, true, null);
        }
        catch (PluginConversionException pce) {
            String message = NLS.bind((String)EclipseAdaptorMsg.ECLIPSE_CONVERTER_ERROR_CONVERTING, (Object)this.getBaseFile());
            throw new BundleException(message, pce);
        }
        Version version = Version.parseVersion((String)generatedManifest.get("Bundle-Version"));
        String symbolicName = ManifestElement.parseHeader((String)"Bundle-SymbolicName", (String)((String)generatedManifest.get("Bundle-SymbolicName")))[0].getValue();
        ManifestElement generatedFrom = ManifestElement.parseHeader((String)"Generated-from", (String)((String)generatedManifest.get("Generated-from")))[0];
        Headers existingHeaders2 = this.checkManifestAndParent(cacheLocation, symbolicName, version.toString(), Byte.parseByte(generatedFrom.getAttribute("type")));
        this.setManifestTimeStamp(Long.parseLong(generatedFrom.getValue()));
        this.setManifestType(Byte.parseByte(generatedFrom.getAttribute("type")));
        if (!this.adaptor.canWrite() || existingHeaders2 != null) {
            return existingHeaders2;
        }
        if (originalManifest != null) {
            Enumeration keysEnum = originalManifest.keys();
            while (keysEnum.hasMoreElements()) {
                Object key = keysEnum.nextElement();
                generatedManifest.put(key, originalManifest.get(key));
            }
        }
        File bundleManifestLocation = new File(cacheLocation, String.valueOf(symbolicName) + '_' + version.toString() + ".MF");
        try {
            converter.writeManifest(bundleManifestLocation, generatedManifest, true);
        }
        catch (Exception exception) {}
        return generatedManifest;
    }

    private Dictionary loadManifestFrom(URL manifestURL) throws BundleException {
        try {
            return Headers.parseManifest((InputStream)manifestURL.openStream());
        }
        catch (IOException e) {
            throw new BundleException(NLS.bind((String)EclipseAdaptorMsg.ECLIPSE_DATA_ERROR_READING_MANIFEST, (Object)this.getLocation()), e);
        }
    }

    protected void loadFromManifest() throws BundleException {
        this.getManifest(true);
        super.loadFromManifest();
        if (this.manifest instanceof CachedManifest) {
            throw new IllegalStateException();
        }
        this.pluginClass = (String)this.manifest.get("Plugin-Class");
        this.parseAutoStart((String)this.manifest.get("Eclipse-AutoStart"));
        this.buddyList = (String)this.manifest.get("Eclipse-BuddyPolicy");
        this.registeredBuddyList = (String)this.manifest.get("Eclipse-RegisterBuddy");
        this.hasPackageInfo = this.hasPackageInfo(this.getEntry("META-INF/MANIFEST.MF"));
    }

    /*
     * Exception decompiling
     */
    private boolean hasPackageInfo(URL url) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 5[TRYBLOCK] [3 : 135->138)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getPluginClass() {
        return this.pluginClass;
    }

    public String getBuddyList() {
        return this.buddyList;
    }

    public String getRegisteredBuddyList() {
        return this.registeredBuddyList;
    }

    public void setPluginClass(String value) {
        this.pluginClass = value;
    }

    public long getManifestTimeStamp() {
        return this.manifestTimeStamp;
    }

    public void setManifestTimeStamp(long stamp) {
        this.manifestTimeStamp = stamp;
    }

    public byte getManifestType() {
        return this.manifestType;
    }

    public void setManifestType(byte manifestType) {
        this.manifestType = manifestType;
    }

    public void setAutoStart(boolean value) {
        this.autoStart = value;
    }

    public boolean isAutoStart() {
        return this.autoStart;
    }

    public int getPersistentStatus() {
        return this.isAutoStartable() ? 0xFFFFFFFE & this.getStatus() : this.getStatus();
    }

    public void setAutoStartExceptions(String[] autoStartExceptions) {
        this.autoStartExceptions = autoStartExceptions;
    }

    public String[] getAutoStartExceptions() {
        return this.autoStartExceptions;
    }

    private void parseAutoStart(String headerValue) {
        this.autoStart = false;
        this.autoStartExceptions = null;
        ManifestElement[] allElements = null;
        try {
            allElements = ManifestElement.parseHeader((String)"Eclipse-AutoStart", (String)headerValue);
        }
        catch (BundleException e) {
            String message = NLS.bind((String)EclipseAdaptorMsg.ECLIPSE_CLASSLOADER_CANNOT_GET_HEADERS, (Object)this.getLocation());
            EclipseAdaptor.getDefault().getFrameworkLog().log(new FrameworkLogEntry("org.eclipse.osgi", message, 0, (Throwable)e, null));
        }
        if (allElements == null) {
            return;
        }
        this.autoStart = "true".equalsIgnoreCase(allElements[0].getValue());
        String exceptionsValue = allElements[0].getAttribute("exceptions");
        if (exceptionsValue == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(exceptionsValue, ",");
        int numberOfTokens = tokenizer.countTokens();
        this.autoStartExceptions = new String[numberOfTokens];
        int i = 0;
        while (i < numberOfTokens) {
            this.autoStartExceptions[i] = tokenizer.nextToken().trim();
            ++i;
        }
    }

    public boolean isAutoStartable() {
        return this.autoStart || this.autoStartExceptions != null && this.autoStartExceptions.length > 0;
    }

    public synchronized void save() throws IOException {
        if (this.adaptor.canWrite()) {
            ((EclipseAdaptor)this.adaptor).saveMetaDataFor(this);
        }
    }

    public String toString() {
        return "BundleData for " + this.getSymbolicName() + " (" + this.id + ")";
    }

    public File getParentGenerationDir() {
        Location parentConfiguration = null;
        Location currentConfiguration = LocationManager.getConfigurationLocation();
        if (currentConfiguration != null && (parentConfiguration = currentConfiguration.getParentLocation()) != null) {
            return new File(parentConfiguration.getURL().getFile(), "org.eclipse.osgi/bundles/" + this.getBundleID() + '/' + this.getGeneration());
        }
        return null;
    }
}

