/***************************************************************************
                          GUI_decodersettings.cpp  -  description
                             -------------------

	Used to set decoder settings :
 		- Currently : u & v swap flag for mjpeg
   		- Post processing for Divx

    begin                : Wed Jul 10 2002
    copyright            : (C) 2002 by mean
    email                : fixounet@free.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
        /*
 * DO NOT EDIT THIS FILE - it is generated by Glade.
 */


#  include <config.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "math.h"

#include "ADM_gui/GUI_decodersettings.h"
#include "ADM_library/default.h"
//-----------------------------------
static GtkWidget *create_dialog1 (void);
static GtkWidget *create_dialog2 (int old);
static int lock;
static GtkWidget *wdg=NULL;
static GtkWidget *checkbutton_invertuv=NULL;
static  GtkWidget *hscale1=NULL;
static GtkObject *pp_adj=NULL;
static  GtkWidget *checkbutton_hz;
static  GtkWidget *checkbutton_vt;
static  GtkWidget *checkbutton_dering;

static void on_ent_callback_destroy(GtkButton * button, gpointer user_data);
static void on_ent_callback(GtkButton * button, gpointer user_data);
//--------------------------------------
// adjust

int getMjpegParams( int *invert)
{

 	
    int ret=0;

    wdg = create_dialog1();
    lock = 0;
     gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON(checkbutton_invertuv),*invert);
    gtk_widget_show(wdg);

    while (!lock)
      {
	  gtk_main_iteration();
      }
    if (lock == 1)
      {	
			*invert=     gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON(checkbutton_invertuv));

			 ret=1;
      }
      if(wdg)     gtk_widget_destroy(wdg);
      wdg=NULL;
    return ret;

}


 int getDivxParams( int *pplevel, int *hz, int *vt, int *dering)
 {

    int ret=0;

    wdg = create_dialog2(*pplevel);
    lock = 0;
    
     gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON(checkbutton_hz),*hz);
     gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON(checkbutton_vt),*vt);
     gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON(checkbutton_dering),*dering);

         gtk_widget_show(wdg);

  
    while (!lock)
      {
	  gtk_main_iteration();
      }
    if (lock == 1)
      {	

           *pplevel=   (int)floor(GTK_ADJUSTMENT(pp_adj)->value);
             		
     			*hz=		gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON(checkbutton_hz));
     			*vt=		gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON(checkbutton_vt));
    			*dering=gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON(checkbutton_dering));

			 ret=1;
      }
      if(lock!=-2)     gtk_widget_destroy(wdg);
    return ret;

}
// Callbacks
void on_ent_callback_destroy(GtkButton * button, gpointer user_data)
{
    UNUSED_ARG(button);
    UNUSED_ARG(user_data); 
    on_ent_callback(NULL, (gpointer) -1);
}

void on_ent_callback(GtkButton * button, gpointer user_data)
{
    UNUSED_ARG(button);
    int res;

    res = (int) user_data;
    if (lock)
			return;			// second call back->ignore.
    switch (res)
      {
      case 1:
				  lock = 1;
				  break;
      case 0:
	  			lock = -1;
	     		break;
      case -1:
	  			lock = -2;
				  break;
      }
    return;

};


//-----------------mjpeg---------------

GtkWidget *create_dialog1 (void)
{
  GtkWidget *dialog1;
  GtkWidget *dialog_vbox1;
  GtkWidget *hbox2;
//  GtkWidget *checkbutton_invertuv;
  GtkWidget *dialog_action_area1;
  GtkWidget *hbox1;
  GtkWidget *button_ok;
  GtkWidget *button_ko;

  dialog1 = gtk_dialog_new ();
//  gtk_object_set_data (GTK_OBJECT (dialog1), "dialog1", dialog1);
  //  gtk_object_set_data (GTK_OBJECT (dialog2), "dialog2", dialog2);

    gtk_object_set_data_full(GTK_OBJECT(dialog1),
			     "dialog1",
			     dialog1,
			     (GtkDestroyNotify) on_ent_callback_destroy);


  gtk_window_set_title (GTK_WINDOW (dialog1), "Mjpeg decoder settings");
  gtk_window_set_policy (GTK_WINDOW (dialog1), TRUE, TRUE, FALSE);

  dialog_vbox1 = GTK_DIALOG (dialog1)->vbox;
  gtk_object_set_data (GTK_OBJECT (dialog1), "dialog_vbox1", dialog_vbox1);
  gtk_widget_show (dialog_vbox1);

  hbox2 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox2);
  gtk_object_set_data_full (GTK_OBJECT (dialog1), "hbox2", hbox2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox2);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), hbox2, TRUE, TRUE, 0);

  checkbutton_invertuv = gtk_check_button_new_with_label (" invert U & V");
  gtk_widget_ref (checkbutton_invertuv);
  gtk_object_set_data_full (GTK_OBJECT (dialog1), "checkbutton_invertuv", checkbutton_invertuv,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (checkbutton_invertuv);
  gtk_box_pack_start (GTK_BOX (hbox2), checkbutton_invertuv, FALSE, FALSE, 0);

  dialog_action_area1 = GTK_DIALOG (dialog1)->action_area;
  gtk_object_set_data (GTK_OBJECT (dialog1), "dialog_action_area1", dialog_action_area1);
  gtk_widget_show (dialog_action_area1);
  gtk_container_set_border_width (GTK_CONTAINER (dialog_action_area1), 10);

  hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox1);
  gtk_object_set_data_full (GTK_OBJECT (dialog1), "hbox1", hbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox1);
  gtk_box_pack_start (GTK_BOX (dialog_action_area1), hbox1, TRUE, TRUE, 0);

  button_ok = gtk_button_new_with_label ("Ok");
  gtk_widget_ref (button_ok);
  gtk_object_set_data_full (GTK_OBJECT (dialog1), "button_ok", button_ok,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button_ok);
  gtk_box_pack_start (GTK_BOX (hbox1), button_ok, FALSE, FALSE, 0);

  button_ko = gtk_button_new_with_label ("Cancel");
  gtk_widget_ref (button_ko);
  gtk_object_set_data_full (GTK_OBJECT (dialog1), "button_ko", button_ko,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button_ko);
  gtk_box_pack_start (GTK_BOX (hbox1), button_ko, FALSE, FALSE, 0);

        gtk_signal_connect(GTK_OBJECT(button_ok), "clicked",
		       GTK_SIGNAL_FUNC(on_ent_callback), (void *) 1);
    gtk_signal_connect(GTK_OBJECT(button_ko), "clicked",
		       GTK_SIGNAL_FUNC(on_ent_callback), (void *) 0);


  return dialog1;
}

GtkWidget*
create_dialog2 (int old)
{
  GtkWidget *dialog2;
  GtkWidget *dialog_vbox2;
  GtkWidget *vbox1;
  GtkWidget *label1;
//  GtkWidget *hscale1;
//  GtkWidget *checkbutton_hz;
//  GtkWidget *checkbutton_vt;
  guint checkbutton_dering_key;
//  GtkWidget *checkbutton_dering;
  GtkWidget *dialog_action_area2;
  GtkWidget *hbox3;
  GtkWidget *button3_ok;
  GtkWidget *button4_ko;
  GtkAccelGroup *accel_group;

  accel_group = gtk_accel_group_new ();

  dialog2 = gtk_dialog_new ();
//  gtk_object_set_data (GTK_OBJECT (dialog2), "dialog2", dialog2);
 // gtk_window_set_title (GTK_WINDOW (dialog2), "MPEG4 settings");
//  gtk_window_set_policy (GTK_WINDOW (dialog2), TRUE, TRUE, FALSE);

      gtk_object_set_data_full(GTK_OBJECT(dialog2),
			     "dialog2",
			     dialog2,
			     (GtkDestroyNotify) on_ent_callback_destroy);
  gtk_window_set_title (GTK_WINDOW (dialog2), "MPEG4 settings");
  gtk_window_set_policy (GTK_WINDOW (dialog2), TRUE, TRUE, FALSE);


  dialog_vbox2 = GTK_DIALOG (dialog2)->vbox;
  gtk_object_set_data (GTK_OBJECT (dialog2), "dialog_vbox2", dialog_vbox2);
  gtk_widget_show (dialog_vbox2);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox1);
  gtk_object_set_data_full (GTK_OBJECT (dialog2), "vbox1", vbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox1);
  gtk_box_pack_start (GTK_BOX (dialog_vbox2), vbox1, TRUE, TRUE, 0);

  label1 = gtk_label_new ("Post Processing");
  gtk_widget_ref (label1);
  gtk_object_set_data_full (GTK_OBJECT (dialog2), "label1", label1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label1);
  gtk_box_pack_start (GTK_BOX (vbox1), label1, FALSE, FALSE, 0);

  
    pp_adj=gtk_adjustment_new (old, 1, 100, 1, 1, 0); //gtk_adjustment_new (2, 2, 10, 1, 1, 1);

// hscale1 = gtk_hscale_new (GTK_ADJUSTMENT (gtk_adjustment_new (1, 1, 10, 1, 1, 0)));
 hscale1 = gtk_hscale_new (GTK_ADJUSTMENT (pp_adj));
  
  gtk_object_set_data_full (GTK_OBJECT (dialog2), "hscale1", hscale1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hscale1);
  gtk_box_pack_start (GTK_BOX (vbox1), hscale1, TRUE, TRUE, 0);
  gtk_scale_set_digits (GTK_SCALE (hscale1), 0);

  checkbutton_hz = gtk_check_button_new_with_label ("Horiz deblocking");
  gtk_widget_ref (checkbutton_hz);
  gtk_object_set_data_full (GTK_OBJECT (dialog2), "checkbutton_hz", checkbutton_hz,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (checkbutton_hz);
  gtk_box_pack_start (GTK_BOX (vbox1), checkbutton_hz, FALSE, FALSE, 0);

  checkbutton_vt = gtk_check_button_new_with_label ("Vert deblocking");
  gtk_widget_ref (checkbutton_vt);
  gtk_object_set_data_full (GTK_OBJECT (dialog2), "checkbutton_vt", checkbutton_vt,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (checkbutton_vt);
  gtk_box_pack_start (GTK_BOX (vbox1), checkbutton_vt, FALSE, FALSE, 0);

  checkbutton_dering = gtk_check_button_new_with_label ("");
  checkbutton_dering_key = gtk_label_parse_uline (GTK_LABEL (GTK_BIN (checkbutton_dering)->child),
                                   "checkbutton_dering");
  gtk_widget_add_accelerator (checkbutton_dering, "clicked", accel_group,
                              checkbutton_dering_key, GDK_MOD1_MASK, (GtkAccelFlags) 0);
  gtk_widget_ref (checkbutton_dering);
  gtk_object_set_data_full (GTK_OBJECT (dialog2), "checkbutton_dering", checkbutton_dering,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (checkbutton_dering);
  gtk_box_pack_start (GTK_BOX (vbox1), checkbutton_dering, FALSE, FALSE, 0);

  dialog_action_area2 = GTK_DIALOG (dialog2)->action_area;
  gtk_object_set_data (GTK_OBJECT (dialog2), "dialog_action_area2", dialog_action_area2);
  gtk_widget_show (dialog_action_area2);
  gtk_container_set_border_width (GTK_CONTAINER (dialog_action_area2), 10);

  hbox3 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox3);
  gtk_object_set_data_full (GTK_OBJECT (dialog2), "hbox3", hbox3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox3);
  gtk_box_pack_start (GTK_BOX (dialog_action_area2), hbox3, FALSE, FALSE, 0);

  button3_ok = gtk_button_new_with_label ("Ok");
  gtk_widget_ref (button3_ok);
  gtk_object_set_data_full (GTK_OBJECT (dialog2), "button3_ok", button3_ok,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button3_ok);
  gtk_box_pack_start (GTK_BOX (hbox3), button3_ok, FALSE, FALSE, 0);

  button4_ko = gtk_button_new_with_label ("Cancel");
  gtk_widget_ref (button4_ko);
  gtk_object_set_data_full (GTK_OBJECT (dialog2), "button4_ko", button4_ko,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button4_ko);
  gtk_box_pack_start (GTK_BOX (hbox3), button4_ko, FALSE, FALSE, 0);

  gtk_window_add_accel_group (GTK_WINDOW (dialog2), accel_group);
        gtk_signal_connect(GTK_OBJECT(button3_ok), "clicked",
		       GTK_SIGNAL_FUNC(on_ent_callback), (void *) 1);
    gtk_signal_connect(GTK_OBJECT(button4_ko), "clicked",
		       GTK_SIGNAL_FUNC(on_ent_callback), (void *) 0);

  return dialog2;
}

