/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import gov.llnl.babel.parsers.sidl.Parser;
import gov.llnl.babel.parsers.sidl.SIDLException;
import gov.llnl.babel.repository.Repository;
import gov.llnl.babel.repository.RepositoryException;
import gov.llnl.babel.repository.RepositoryFactory;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.SymbolTable;
import gov.llnl.babel.url.URLUtilities;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.Set;

public class ParserTest {
    private static final LongOpt[] s_lopts = new LongOpt[]{new LongOpt("help", 0, null, 104), new LongOpt("input", 1, null, 105), new LongOpt("output", 1, null, 111), new LongOpt("repository", 1, null, 114)};
    private static final String s_opts = "hi:o:r:";
    private static final String s_name = "gov.llnl.babel.ParserTest";

    public static void main(String[] args) {
        Repository repository = null;
        URLUtilities.enableHTTPS();
        Getopt g = new Getopt(s_name, args, s_opts, s_lopts);
        g.setOpterr(true);
        try {
            int c;
            block10: while ((c = g.getopt()) != -1) {
                switch (c) {
                    case 104: {
                        ParserTest.printUsage();
                        continue block10;
                    }
                    case 105: {
                        SymbolTable.getInstance().addSymbolResolver(RepositoryFactory.getInstance().createRepository(g.getOptarg()));
                        continue block10;
                    }
                    case 111: {
                        repository = RepositoryFactory.getInstance().createRepository(g.getOptarg());
                        continue block10;
                    }
                    case 114: {
                        repository = RepositoryFactory.getInstance().createRepository(g.getOptarg());
                        SymbolTable.getInstance().addSymbolResolver(repository);
                        continue block10;
                    }
                }
                ParserTest.printUsage();
            }
        }
        catch (RepositoryException ex) {
            System.err.println("Babel: Error: Repository Exception");
            System.err.println(ex.getMessage());
            System.exit(1);
        }
        for (int i = g.getOptind(); i < args.length; ++i) {
            ParserTest.parseURL(URLUtilities.expandURL(args[i]));
        }
        Set symbols = SymbolTable.getInstance().getModifiedSymbolNames();
        Iterator i = symbols.iterator();
        while (i.hasNext()) {
            System.out.println("New or modified symbol \"" + ((SymbolID)i.next()).getSymbolName() + "\"");
        }
        if (repository != null) {
            try {
                repository.writeSymbols(symbols);
            }
            catch (RepositoryException ex) {
                System.err.println("Babel: Error: Repository Exception");
                System.err.println(ex.getMessage());
                System.exit(1);
            }
        }
    }

    private static void printUsage() {
        System.out.println("Command line options:");
        System.out.println("   -h     | --help           Print command line help");
        System.out.println("   -i URI | --input=URI      Add repository to search path");
        System.out.println("   -o URI | --output=URI     Set symbol output repository");
        System.out.println("   -r URI | --repository=URI Set repository as input and output");
        System.exit(1);
    }

    private static void parseURL(String url) {
        System.out.println("Babel: Parsing URL \"" + url + "\"...");
        try {
            URL u = new URL(url);
            InputStream s = u.openStream();
            Parser parser = new Parser(s);
            parser.setSourceURL(url);
            String[] warnings = parser.beginParse();
            s.close();
            if (warnings != null) {
                for (int w = 0; w < warnings.length; ++w) {
                    System.err.println("Babel: Warning: " + warnings[w]);
                }
            }
        }
        catch (SIDLException ex) {
            System.err.println("Babel: Error: SIDLException");
            System.err.println(ex.getMessage());
            System.exit(1);
        }
        catch (IOException ex) {
            System.err.println("Babel: Error: IOException");
            System.err.println(ex.getMessage());
            System.exit(1);
        }
    }
}

