/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend;

import gov.llnl.babel.backend.writers.LanguageWriter;
import gov.llnl.babel.backend.writers.LineRedirector;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CodeSplicer {
    private static final String s_target = "DO-NOT-DELETE splicer";
    private static final String s_begin = "DO-NOT-DELETE splicer.begin(";
    private static final String s_end = "DO-NOT-DELETE splicer.end(";
    private Map d_symbol_edits = new HashMap();
    private Set d_used_symbols = new HashSet();
    private String d_vpath;
    private String d_path;
    private Map d_splice_bounding_lines;
    private LineRedirector d_lr;

    public static String getBeginString(String symbol) {
        return s_begin + symbol + ")";
    }

    public static String getEndString(String symbol) {
        return s_end + symbol + ")";
    }

    public CodeSplicer(BufferedReader reader, String vpath, String path) throws IOException {
        this.d_vpath = vpath == null || vpath.equals("") || vpath.equals(".") ? "." : vpath;
        this.d_path = path;
        if (this.d_path.equals(this.d_vpath)) {
            this.d_vpath = ".";
        }
        this.d_splice_bounding_lines = new HashMap();
        this.d_lr = null;
        this.populateDatabase(reader);
    }

    public CodeSplicer() {
        this.d_vpath = ".";
        this.d_splice_bounding_lines = new HashMap();
        this.d_lr = null;
    }

    public void setLineRedirector(LineRedirector lr) {
        this.d_lr = lr;
    }

    public String getVPath() {
        return this.d_vpath;
    }

    public void setVPath(String vpath) {
        this.d_vpath = vpath == null || vpath.equals("") || vpath.equals(".") ? "." : vpath;
    }

    public boolean hasSymbol(String symbol) {
        return this.d_symbol_edits.containsKey(symbol);
    }

    public void outputSymbolEdits(String symbol, PrintWriter writer) {
        String edits = (String)this.d_symbol_edits.get(symbol);
        if (edits != null) {
            if (!this.d_vpath.equals(".") && this.d_lr != null) {
                int[] bounds = (int[])this.d_splice_bounding_lines.get(symbol);
                this.d_lr.redirectBegin(this.d_vpath, bounds[0]);
                int start = this.d_lr.getLineCount();
                writer.print(edits);
                writer.flush();
                int end = this.d_lr.getLineCount();
                this.d_lr.redirectEnd(this.d_path, end);
            } else {
                writer.print(edits);
            }
            this.d_used_symbols.add(symbol);
        }
    }

    public String getEditString(String symbol) {
        return (String)this.d_symbol_edits.get(symbol);
    }

    public boolean hasUnusedSymbolEdits() {
        return this.d_used_symbols.size() < this.d_symbol_edits.size();
    }

    public void outputUnusedSymbolEdits(PrintWriter writer) {
        Iterator i = this.d_symbol_edits.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String symbol = (String)entry.getKey();
            String edits = (String)entry.getValue();
            if (this.d_used_symbols.contains(symbol)) continue;
            writer.print(edits);
        }
    }

    public Set getSymbols() {
        return this.d_symbol_edits.keySet();
    }

    private void populateDatabase(BufferedReader reader) throws IOException {
        boolean eof = false;
        int line = 0;
        while (!eof) {
            String s = reader.readLine();
            ++line;
            if (s == null) {
                eof = true;
                continue;
            }
            if (s.indexOf(s_end) >= 0) {
                throw new IOException("found 'splicer.end()' outside of a splicer block\n" + line + ": " + s);
            }
            String symbol = this.extractSymbol(s);
            if (symbol == null) continue;
            int[] bounds = new int[2];
            bounds[0] = line;
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.print(s + '\n');
            String end = CodeSplicer.getEndString(symbol);
            boolean eob = false;
            while (!eob) {
                String b = reader.readLine();
                ++line;
                if (b == null) {
                    eob = true;
                    eof = true;
                } else {
                    if (b.indexOf(s_begin) >= 0) {
                        throw new IOException("encountered 'splicer.begin()' inside of a splicer block \"" + symbol + "\"\n" + line + ": " + b);
                    }
                    if (b.indexOf(end) >= 0) {
                        eob = true;
                    } else if (b.indexOf(s_end) >= 0) {
                        throw new IOException("encountered 'splicer.end()' inside of a splicer block \"" + symbol + "\"\n" + line + ": " + b);
                    }
                }
                pw.print(b + '\n');
            }
            pw.flush();
            this.d_symbol_edits.put(symbol, sw.toString());
            bounds[1] = line;
            this.d_splice_bounding_lines.put(symbol, bounds);
        }
    }

    private String extractSymbol(String s) {
        int back;
        int front;
        String symbol = null;
        if (s != null && (front = s.indexOf(s_begin)) >= 0 && (back = s.indexOf(")", front += s_begin.length())) >= front) {
            symbol = s.substring(front, back).trim();
        }
        return symbol;
    }

    public void splice(String symbol, LanguageWriter writer, String alt_msg) {
        if (this.hasSymbol(symbol)) {
            this.outputSymbolEdits(symbol, writer.getPrintWriter());
        } else {
            writer.disableLineBreak();
            writer.writeCommentLine(CodeSplicer.getBeginString(symbol));
            if (alt_msg != null) {
                writer.writeCommentLine("Insert-Code-Here {" + symbol + "} (" + alt_msg + ")");
            }
            writer.writeCommentLine(CodeSplicer.getEndString(symbol));
            writer.enableLineBreak();
        }
    }

    public void splice(String symbol, LanguageWriter writer, String alt_msg, String alt_code) {
        if (this.hasSymbol(symbol)) {
            this.outputSymbolEdits(symbol, writer.getPrintWriter());
        } else {
            writer.disableLineBreak();
            writer.writeCommentLine(CodeSplicer.getBeginString(symbol));
            if (alt_msg != null) {
                writer.writeCommentLine("Insert-Code-Here {" + symbol + "} (" + alt_msg + ")");
            }
            if (alt_code != null && alt_code.length() > 0) {
                writer.println(alt_code);
            }
            writer.writeCommentLine(CodeSplicer.getEndString(symbol));
            writer.enableLineBreak();
        }
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("usage: gov.llnl.babel.backend.CodeSplicer input-file");
            System.exit(1);
        }
        try {
            BufferedReader reader = new BufferedReader(new FileReader(args[0]));
            CodeSplicer cs = new CodeSplicer(reader, ".", args[0]);
            reader.close();
            PrintWriter pw = new PrintWriter(System.out);
            cs.outputUnusedSymbolEdits(pw);
            pw.flush();
        }
        catch (IOException ex) {
            System.out.println(ex.getMessage());
            System.exit(1);
        }
    }
}

