/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend;

import gov.llnl.babel.BabelConfiguration;
import gov.llnl.babel.symbols.Extendable;
import gov.llnl.babel.symbols.Interface;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.SymbolTable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;

public class LevelComparator
implements Comparator {
    private SymbolTable d_table;
    private Interface d_baseExceptionInterface;

    public LevelComparator(SymbolTable table) {
        this.d_table = table;
        this.d_baseExceptionInterface = (Interface)this.d_table.lookupSymbol(BabelConfiguration.getBaseExceptionInterface());
    }

    private final int getMaxLevel(Extendable ext, Extendable par) {
        int max = Integer.MIN_VALUE;
        if (ext != null && par != null) {
            if (ext == par) {
                max = 0;
            } else {
                Extendable parent;
                Collection parents = ext.getParents(false);
                Iterator i = parents.iterator();
                while (i.hasNext()) {
                    parent = (Extendable)i.next();
                    if (par != parent) continue;
                    max = 1;
                }
                i = parents.iterator();
                while (i.hasNext()) {
                    parent = (Extendable)i.next();
                    int level = this.getMaxLevel(parent, par) + 1;
                    if (level <= max) continue;
                    max = level;
                }
            }
        }
        return max;
    }

    private final int getMaxExceptionLevel(Extendable ext) {
        return this.getMaxLevel(ext, this.d_baseExceptionInterface);
    }

    public final int compare(Object o1, Object o2) {
        if (o1 instanceof SymbolID && o2 instanceof SymbolID) {
            Symbol sym1 = this.d_table.lookupSymbol((SymbolID)o1);
            Symbol sym2 = this.d_table.lookupSymbol((SymbolID)o2);
            if (sym1 instanceof Extendable && sym2 instanceof Extendable) {
                int l2;
                int l1 = this.getMaxExceptionLevel((Extendable)sym1);
                return l1 < (l2 = this.getMaxExceptionLevel((Extendable)sym2)) ? 1 : (l1 > l2 ? -1 : 0);
            }
        }
        return 0;
    }

    public final boolean equals(Object obj) {
        return false;
    }
}

