/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.fortran;

import gov.llnl.babel.BabelConfiguration;
import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.CodeSplicer;
import gov.llnl.babel.backend.IOR;
import gov.llnl.babel.backend.fortran.Fortran;
import gov.llnl.babel.backend.fortran.ModuleSource;
import gov.llnl.babel.backend.fortran.StubSource;
import gov.llnl.babel.backend.mangler.FortranMangler;
import gov.llnl.babel.backend.mangler.NameMangler;
import gov.llnl.babel.backend.mangler.NonMangler;
import gov.llnl.babel.backend.writers.LanguageWriterForFortran;
import gov.llnl.babel.symbols.Argument;
import gov.llnl.babel.symbols.Class;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.SymbolTable;
import gov.llnl.babel.symbols.Type;
import gov.llnl.babel.symbols.Version;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ImplSource {
    private static final String s_use = ".use";
    private CodeSplicer d_splicer;
    private LanguageWriterForFortran d_lw;
    private NameMangler d_mang;
    private final boolean d_isF90 = Fortran.isFortran90();

    public ImplSource(LanguageWriterForFortran writer, CodeSplicer splicer) throws NoSuchAlgorithmException {
        this.d_lw = writer;
        this.d_splicer = splicer;
        this.d_mang = Fortran.needsAbbrev() ? new FortranMangler(31, 21) : new NonMangler();
    }

    public static void useStatementsForSupers(Method m, SymbolID id, LanguageWriterForFortran writer, CodeSplicer splicer) throws CodeGenerationException {
        try {
            writer.tab();
            ImplSource source = new ImplSource(writer, splicer);
            source.useStatementsForSupers(m, id);
            writer.backTab();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new CodeGenerationException("NoSuchAlgorithmException caught in Impl Source");
        }
    }

    public void useStatementsForSupers(Method m, SymbolID id) throws CodeGenerationException {
        this.addUseForReferences(m, id);
    }

    public String getArgumentDeclaration(Argument a) throws CodeGenerationException {
        Type argType = a.getType();
        StringBuffer result = new StringBuffer(Fortran.getReturnString(argType));
        if (this.d_isF90) {
            if (argType.isRarray()) {
                result.append(", dimension");
                result.append(Fortran.arrayIndices(argType.getArrayIndices()));
            }
            result.append(" :: ");
            result.append(a.getFormalName());
        } else {
            result.append(' ');
            result.append(a.getFormalName());
            if (argType.isRarray()) {
                result.append(Fortran.arrayIndices(argType.getArrayIndices()));
            }
        }
        return result.toString();
    }

    private Set extendedReferences(Method m, SymbolID id) {
        Set refs = m.getSymbolReferences();
        HashSet<SymbolID> set = new HashSet<SymbolID>(refs.size() + 2);
        set.addAll(refs);
        if (!m.getThrows().isEmpty()) {
            Symbol baseInterface = SymbolTable.getInstance().lookupSymbol(BabelConfiguration.getBaseInterface());
            set.add(baseInterface.getSymbolID());
        }
        set.add(id);
        return set;
    }

    private static void checkType(Type t, Set result) throws CodeGenerationException {
        if (16 == t.getDetailedType()) {
            Type arrayType = t.getArrayType();
            if (null != arrayType) {
                switch (arrayType.getDetailedType()) {
                    case 11: 
                    case 12: 
                    case 13: 
                    case 15: {
                        result.add(arrayType.getSymbolID());
                        break;
                    }
                    case 14: 
                    case 16: {
                        throw new CodeGenerationException("Bad argument type in method");
                    }
                    case 0: {
                        break;
                    }
                    default: {
                        result.add(new SymbolID("sidl." + arrayType.getTypeString(), new Version()));
                        break;
                    }
                }
            } else {
                result.add(new SymbolID("sidl.array", new Version()));
            }
        }
    }

    private static Set arrayReferences(Method m) throws CodeGenerationException {
        ArrayList args = m.getArgumentList();
        HashSet result = new HashSet(args.size());
        Iterator i = args.iterator();
        while (i.hasNext()) {
            Type t = ((Argument)i.next()).getType();
            ImplSource.checkType(t, result);
        }
        ImplSource.checkType(m.getReturnType(), result);
        return result;
    }

    private void addUseForReferences(Method m, SymbolID id) throws CodeGenerationException {
        SymbolID refid;
        Set refs = this.extendedReferences(m, id);
        HashSet<SymbolID> appeared = new HashSet<SymbolID>(refs.size());
        Iterator i = refs.iterator();
        while (i.hasNext()) {
            refid = (SymbolID)i.next();
            if (appeared.contains(refid)) continue;
            this.d_lw.println("use " + Fortran.getModule(refid));
            appeared.add(refid);
        }
        refs = ImplSource.arrayReferences(m);
        appeared.clear();
        i = refs.iterator();
        while (i.hasNext()) {
            refid = (SymbolID)i.next();
            if (appeared.contains(refid)) continue;
            this.d_lw.println("use " + Fortran.getArrayModule(refid));
            appeared.add(refid);
        }
    }

    private void extendAndGenerate(Method m, SymbolID id) throws CodeGenerationException {
        List extendedArgs = StubSource.extendArgs(id, m, true);
        String splicerTag = id.getFullName() + '.' + m.getLongMethodName();
        String splicerTagUse = splicerTag + s_use;
        String methodImplName = Fortran.getMethodImplName(id, m, this.d_mang);
        this.d_lw.writeComment(m, false);
        if (this.d_isF90) {
            this.d_lw.print("recursive ");
        }
        this.d_lw.print("subroutine " + methodImplName + "(");
        Iterator i = extendedArgs.iterator();
        while (i.hasNext()) {
            this.d_lw.print(((Argument)i.next()).getFormalName());
            if (!i.hasNext()) continue;
            this.d_lw.print(", ");
        }
        this.d_lw.println(")");
        if (this.d_isF90) {
            this.d_lw.tab();
            this.addUseForReferences(m, id);
            this.d_lw.println("use " + id.getFullName().replace('.', '_') + "_impl");
            this.d_splicer.splice(splicerTagUse, this.d_lw, "use statements");
        }
        this.d_lw.println("implicit none");
        i = Fortran.reorderArguments(extendedArgs).iterator();
        while (i.hasNext()) {
            Argument a = (Argument)i.next();
            String decl = this.getArgumentDeclaration(a);
            if (this.d_isF90) {
                this.d_lw.println(decl + " ! " + a.getModeString());
                continue;
            }
            this.d_lw.writeCommentLine(a.getArgumentString());
            this.d_lw.println(decl);
        }
        this.d_lw.println();
        if (this.d_isF90) {
            this.d_lw.backTab();
        }
        this.d_splicer.splice(splicerTag, this.d_lw, m.getShortMethodName() + " method");
        if (this.d_isF90) {
            this.d_lw.println("end subroutine " + methodImplName);
        } else {
            this.d_lw.println("end");
        }
    }

    private Collection extendMethods(Class ext) throws CodeGenerationException {
        Collection localMethods = ext.getMethods(false);
        SymbolID id = ext.getSymbolID();
        ArrayList<Method> extendedMethods = new ArrayList<Method>(localMethods.size() + 2);
        extendedMethods.add(IOR.getBuiltinMethod(3, id));
        extendedMethods.add(IOR.getBuiltinMethod(4, id));
        extendedMethods.add(IOR.getBuiltinMethod(5, id));
        extendedMethods.addAll(localMethods);
        return extendedMethods;
    }

    private void addMiscCodeSection(String sectionName) {
        this.d_splicer.splice(sectionName, this.d_lw, "extra code");
    }

    private void writeIncludes(Class cls) throws CodeGenerationException {
        SymbolID id;
        Iterator i = ModuleSource.extendedReferences(cls).iterator();
        this.d_lw.disableLineBreak();
        while (i.hasNext()) {
            id = (SymbolID)i.next();
            this.d_lw.printlnUnformatted("#include \"" + Fortran.getStubNameFile(id) + "\"");
        }
        i = cls.getBasicArrayRefs().iterator();
        while (i.hasNext()) {
            id = (SymbolID)i.next();
            this.d_lw.printlnUnformatted("#include \"" + Fortran.getStubNameFile(id) + "\"");
        }
        this.d_lw.enableLineBreak();
    }

    public void generateCode(Class cls) throws CodeGenerationException {
        Collection methods = this.extendMethods(cls);
        SymbolID id = cls.getSymbolID();
        this.d_lw.writeBanner(cls, Fortran.getImplFile(id), true, "Server-side implementation for " + id.getFullName());
        this.d_lw.println();
        this.d_lw.writeComment(cls, false);
        this.d_lw.println();
        if (Fortran.needsAbbrev()) {
            this.writeIncludes(cls);
        }
        this.addMiscCodeSection("_miscellaneous_code_start");
        this.d_lw.println();
        this.d_lw.println();
        Iterator i = methods.iterator();
        while (i.hasNext()) {
            Method m = (Method)i.next();
            if (m.isAbstract()) continue;
            this.d_lw.println();
            this.d_lw.println();
            this.extendAndGenerate(m, id);
        }
        this.d_lw.println();
        this.d_lw.println();
        this.addMiscCodeSection("_miscellaneous_code_end");
        if (this.d_splicer.hasUnusedSymbolEdits()) {
            this.d_lw.println();
            this.d_lw.beginBlockComment(true);
            this.d_lw.println("================= BEGIN UNREFERENCED METHOD(S) ================");
            this.d_lw.println("The following code segment(s) belong to unreferenced method(s).");
            this.d_lw.println("This can result from a method rename/removal in the sidl file.");
            this.d_lw.println("Move or remove the code in order to compile cleanly.");
            this.d_lw.endBlockComment(true);
            this.d_splicer.outputUnusedSymbolEdits(this.d_lw.getPrintWriter());
            this.d_lw.writeCommentLine("================== END UNREFERENCED METHOD(S) =================");
        }
    }

    public static void generateCode(Class cls, LanguageWriterForFortran writer, CodeSplicer splicer) throws CodeGenerationException, NoSuchAlgorithmException {
        ImplSource source = new ImplSource(writer, splicer);
        source.generateCode(cls);
    }
}

