/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.jdk;

import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.IOR;
import gov.llnl.babel.backend.writers.LanguageWriter;
import gov.llnl.babel.backend.writers.LanguageWriterForC;
import gov.llnl.babel.backend.writers.LanguageWriterForJava;
import gov.llnl.babel.symbols.Argument;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.Type;
import java.util.HashMap;
import java.util.Iterator;

public class Java {
    private static final HashMap s_java_val = new HashMap();
    private static final HashMap s_java_ref = new HashMap();
    private static final HashMap s_ior_name = new HashMap();
    private static final HashMap s_java_arr = new HashMap();
    private static final HashMap s_java_sig = new HashMap();
    private static final HashMap s_jni_arg = new HashMap();
    private static final HashMap s_init_ior = new HashMap();
    private static final HashMap s_init_jni = new HashMap();
    private static final HashMap s_init_java = new HashMap();
    private static final HashMap s_in = new HashMap();
    private static final HashMap s_inout = new HashMap();
    private static final HashMap s_post = new HashMap();
    private static final HashMap s_return = new HashMap();
    private static final HashMap s_server_in = new HashMap();
    private static final HashMap s_server_out = new HashMap();
    private static final HashMap s_server_inout = new HashMap();
    private static final HashMap s_server_post = new HashMap();
    private static final HashMap s_server_return = new HashMap();
    private static final Integer s_void = new Integer(0);
    private static final Integer s_boolean = new Integer(1);
    private static final Integer s_char = new Integer(2);
    private static final Integer s_dcomplex = new Integer(3);
    private static final Integer s_double = new Integer(4);
    private static final Integer s_fcomplex = new Integer(5);
    private static final Integer s_float = new Integer(6);
    private static final Integer s_int = new Integer(7);
    private static final Integer s_long = new Integer(8);
    private static final Integer s_opaque = new Integer(9);
    private static final Integer s_string = new Integer(10);
    private static final Integer s_enum = new Integer(11);
    private static final Integer s_class = new Integer(12);
    private static final Integer s_interface = new Integer(13);
    private static final Integer s_array = new Integer(16);

    public static String getClientJavaFile(SymbolID id) {
        return id.getShortName() + ".java";
    }

    public static String getClientJNIFile(SymbolID id) {
        return id.getFullName().replace('.', '_') + "_jniStub.c";
    }

    public static String getJavaImplSourceFile(SymbolID id) {
        return id.getShortName() + "_Impl.java";
    }

    public static String getServerJNIFile(SymbolID id) {
        return id.getFullName().replace('.', '_') + "_jniSkel.c";
    }

    public static String getJavaSymbolName(SymbolID id) {
        return id.getShortName();
    }

    public static String getFullJavaSymbolName(SymbolID id) {
        return id.getFullName();
    }

    public static String getJavaServerClassName(SymbolID id) {
        return id.getShortName() + "_Impl";
    }

    public static String getJavaServerMethodName(Method meth) {
        return meth.getLongMethodName() + "_Impl";
    }

    public static String getRegisterFunction(SymbolID id) {
        return id.getFullName().replace('.', '_') + "__register";
    }

    public static String getJavaBaseClass() {
        return "gov.llnl.sidl.BaseClass";
    }

    public static String getJavaBaseInterface() {
        return "gov.llnl.sidl.BaseInterface";
    }

    public static String getJavaBaseArray() {
        return "gov.llnl.sidl.BaseArray";
    }

    public static String getInterfaceWrapper() {
        return "Wrapper";
    }

    public static String getHolderName() {
        return "Holder";
    }

    public static String getEnsureArray(Type arrayType) {
        return "sidl_" + arrayType.getTypeString() + "__array_ensure";
    }

    private static String getJavaArrayType(int dim, Type type) {
        if (null != type) {
            String val = (String)s_java_arr.get(new Integer(type.getDetailedType()));
            if (val == null) {
                val = Java.getFullJavaSymbolName(type.getSymbolID()) + "$Array#";
            }
            return val.replace('#', Character.forDigit(dim, 10));
        }
        return "gov.llnl.sidl.BaseArray";
    }

    private static String getJavaInternalReturnType(Type type) {
        int t = type.getDetailedType();
        String val = (String)s_java_val.get(new Integer(t));
        if (val == null) {
            if (t == 12 || t == 13) {
                val = Java.getFullJavaSymbolName(type.getSymbolID());
            } else if (t == 16) {
                val = Java.getJavaArrayType(type.getArrayDimension(), type.getArrayType());
            }
        }
        return val;
    }

    public static String getJavaReturnType(Type type) {
        return Java.getJavaInternalReturnType(type).replace('$', '.');
    }

    private static String getDescriptor(String type) {
        String jni = (String)s_java_sig.get(type);
        if (jni == null) {
            jni = "L" + type.replace('.', '/') + ";";
        }
        return jni;
    }

    private static String getJavaServerInternalArgument(Argument arg) {
        String val = null;
        Type type = arg.getType();
        int t = type.getDetailedType();
        int m = arg.getMode();
        Integer T = new Integer(t);
        Type arrayType = type.getArrayType();
        Object arrayTypeInteger = null;
        Object arrayTypeString = null;
        if (type.isArray()) {
            if (type.isGenericArray()) {
                if (m == 0) {
                    return Java.getJavaBaseArray();
                }
                return Java.getJavaBaseArray() + "$Holder";
            }
            if (m == 0) {
                return Java.getJavaArrayType(type.getArrayDimension(), type.getArrayType());
            }
            return Java.getJavaArrayType(type.getArrayDimension(), type.getArrayType()) + "$Holder";
        }
        val = t == 12 || t == 13 ? (m == 0 ? Java.getFullJavaSymbolName(arg.getType().getSymbolID()) : Java.getFullJavaSymbolName(arg.getType().getSymbolID()) + "$Holder") : (m == 0 ? (String)s_java_val.get(T) : (String)s_java_ref.get(T));
        return val;
    }

    private static String getJavaInternalArgument(Argument arg) {
        String val = null;
        Type type = arg.getType();
        int t = type.getDetailedType();
        int m = arg.getMode();
        Integer T = new Integer(t);
        val = (String)(m == 0 ? s_java_val.get(T) : s_java_ref.get(T));
        if (val == null) {
            if (t == 12 || t == 13) {
                val = Java.getFullJavaSymbolName(arg.getType().getSymbolID());
                if (m != 0) {
                    val = val + "$" + Java.getHolderName();
                }
            } else if (t == 16) {
                val = Java.getJavaArrayType(type.getArrayDimension(), type.getArrayType());
                if (m != 0) {
                    val = val + "$" + Java.getHolderName();
                }
            }
        }
        return val;
    }

    public static String getJavaArgument(Argument arg) {
        return Java.getJavaInternalArgument(arg).replace('$', '.');
    }

    public static String getJavaServerArgument(Argument arg) {
        return Java.getJavaServerInternalArgument(arg).replace('$', '.');
    }

    public static String getJavaFormalArgument(Argument arg) {
        return Java.getJavaArgument(arg) + " " + arg.getFormalName();
    }

    public static String getJavaSignature(Method method) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("(");
        Iterator a = method.getArgumentList().iterator();
        while (a.hasNext()) {
            Argument arg = (Argument)a.next();
            buffer.append(Java.getDescriptor(Java.getJavaInternalArgument(arg)));
        }
        buffer.append(")");
        Type type = method.getReturnType();
        buffer.append(Java.getDescriptor(Java.getJavaInternalReturnType(type)));
        return buffer.toString();
    }

    public static String getJavaServerSignature(Method method) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("(");
        Iterator a = method.getArgumentList().iterator();
        while (a.hasNext()) {
            Argument arg = (Argument)a.next();
            buffer.append(Java.getDescriptor(Java.getJavaServerInternalArgument(arg)));
        }
        buffer.append(")");
        Type type = method.getReturnType();
        buffer.append(Java.getDescriptor(Java.getJavaInternalReturnType(type)));
        return buffer.toString();
    }

    public static String getDefaultReturnValue(Method method) {
        if (method.getReturnType().getType() >= 9 || method.getReturnType().getType() == 5 || method.getReturnType().getType() == 3) {
            return "null";
        }
        if (method.getReturnType().getType() > 2 && method.getReturnType().getType() < 9) {
            return "0";
        }
        if (method.getReturnType().getType() == 2) {
            return "'\\0'";
        }
        if (method.getReturnType().getType() == 1) {
            return "false";
        }
        return "";
    }

    public static String getDefaultJNIReturnValue(Method method) {
        if (method.getReturnType().getDetailedType() == 11) {
            return "0";
        }
        if (method.getReturnType().getDetailedType() >= 9) {
            return "NULL";
        }
        if (method.getReturnType().getDetailedType() == 5 || method.getReturnType().getDetailedType() == 3) {
            return "_retval";
        }
        if (method.getReturnType().getDetailedType() > 2 && method.getReturnType().getDetailedType() < 9) {
            return "0";
        }
        if (method.getReturnType().getDetailedType() == 2) {
            return "'\\0'";
        }
        if (method.getReturnType().getDetailedType() == 1) {
            return "0";
        }
        return "";
    }

    public static String getJNIFunction(Method method) {
        return "jni_" + method.getLongMethodName();
    }

    public static String getSuperJNIFunction(Method method) {
        return "jni_super_" + method.getLongMethodName();
    }

    public static String getJNINativeType(String type) {
        String jni = (String)s_jni_arg.get(type);
        if (jni == null) {
            jni = "jobject";
        }
        return jni;
    }

    public static String getJNIReturnType(Type type) {
        return Java.getJNINativeType(Java.getJavaReturnType(type));
    }

    public static void declareIORVariable(LanguageWriterForC writer, Type type, String variable) throws CodeGenerationException {
        Java.printSub(writer, (String)s_init_ior.get(new Integer(type.getDetailedType())), Java.getReturnString(type), variable);
    }

    public static void declareIORVariable(LanguageWriterForC writer, Argument arg, String prefix) throws CodeGenerationException {
        Type type = arg.getType();
        Java.printSub(writer, (String)s_init_ior.get(new Integer(type.getDetailedType())), Java.getReturnString(type), prefix + arg.getFormalName());
    }

    public static void declareJavaVariable(LanguageWriterForC writer, Type type, String variable) {
        String rtype = Java.getJNIReturnType(type);
        Java.printSub(writer, (String)s_init_jni.get(rtype), rtype, variable);
    }

    public static void declareJavaVariable(LanguageWriterForJava writer, Type type, String variable) {
        String rtype = type.getTypeString();
        Java.printSub(writer, (String)s_init_java.get(rtype), rtype, variable);
    }

    public static void declareServerInOutVariable(LanguageWriterForC writer, Type type, String variable) {
        String rtype = Java.getJNIReturnType(type);
        Java.printSub(writer, "#1 #2 = (#1) NULL;", "jobject", variable);
    }

    public static String getJNIFormalArgument(Argument arg) {
        return Java.getJNINativeType(Java.getJavaArgument(arg)) + " _arg_" + arg.getFormalName();
    }

    public static String getJNIEnsureName(Argument arg) {
        return "_ensure_" + arg.getFormalName();
    }

    public static String getJNIEnsureName(String name) {
        return "_ensure_" + name;
    }

    public static void preprocessJNIArgument(LanguageWriterForC writer, Argument arg, String prefix) throws CodeGenerationException {
        String convert = null;
        Type type = arg.getType();
        Type arrayType = type.getArrayType();
        Integer arrayTypeInteger = null;
        String arrayTypeString = null;
        Integer detail = new Integer(type.getDetailedType());
        if (type.isArray()) {
            if (null != arrayType) {
                arrayTypeInteger = new Integer(arrayType.getDetailedType());
                arrayTypeString = arrayType.isSymbol() ? arrayType.getSymbolID().getFullName() : ((String)s_java_arr.get(arrayTypeInteger)).replace('#', Character.forDigit(type.getArrayDimension(), 10));
            } else {
                arrayTypeString = "gov.llnl.sidl.BaseArray";
            }
        }
        if (arg.getMode() == 0) {
            convert = (String)s_in.get(detail);
        } else if (arg.getMode() == 1) {
            convert = (String)s_inout.get(detail);
        }
        if (convert != null) {
            Java.printSub(writer, convert, prefix + arg.getFormalName(), "_arg_" + arg.getFormalName(), Java.getReturnString(type), type.isSymbol() ? type.getSymbolID().getFullName() : arrayTypeString);
        }
    }

    public static void postprocessJNIArgument(LanguageWriterForC writer, Argument arg, String prefix) throws CodeGenerationException {
        if (arg.getMode() != 0) {
            Type type = arg.getType();
            if (type.isArray()) {
                String convert = (String)s_post.get(new Integer(type.getDetailedType()));
                Type arrayType = type.getArrayType();
                Integer arrayTypeInteger = null;
                String arrayTypeString = null;
                if (null != arrayType) {
                    arrayTypeInteger = new Integer(arrayType.getDetailedType());
                    arrayTypeString = arrayType.isSymbol() ? arrayType.getSymbolID().getFullName() : ((String)s_java_arr.get(arrayTypeInteger)).replace('#', Character.forDigit(type.getArrayDimension(), 10));
                } else {
                    arrayTypeString = "gov.llnl.sidl.BaseArray";
                }
                convert = "sidl_Java_I2J_array_holder(env, #1, #2, \"#4\");";
                if (convert != null) {
                    String fromName = "_arg_" + arg.getFormalName();
                    Java.printSub(writer, convert, fromName, prefix + arg.getFormalName(), Java.getReturnString(type), type.isSymbol() ? type.getSymbolID().getFullName() : arrayTypeString);
                }
            } else {
                String convert = (String)s_post.get(new Integer(type.getDetailedType()));
                if (convert != null) {
                    Java.printSub(writer, convert, prefix + arg.getFormalName(), "_arg_" + arg.getFormalName(), Java.getReturnString(type), type.isSymbol() ? type.getSymbolID().getFullName() : null);
                }
            }
        }
        if (arg.getType().getType() == 10) {
            writer.println("sidl_String_free(" + prefix + arg.getFormalName() + ");");
        }
    }

    public static void postprocessJNIReturn(LanguageWriterForC writer, Type type, String ior_result, String java_result) {
        int t = type.getDetailedType();
        Java.printSub(writer, (String)s_return.get(new Integer(t)), java_result, ior_result, Java.getJNIReturnType(type), Java.getJavaInternalReturnType(type));
        if (t == 10) {
            writer.println("sidl_String_free(" + ior_result + ");");
        }
    }

    public static void preprocessServerJNIArgument(LanguageWriterForC writer, Argument arg, String prefix) throws CodeGenerationException {
        String convert = null;
        Type type = arg.getType();
        Integer detail = new Integer(type.getDetailedType());
        Type arrayType = type.getArrayType();
        Integer arrayTypeInteger = null;
        String arrayTypeString = null;
        String argFormalName = arg.getFormalName();
        String typeName = type.isSymbol() ? type.getSymbolID().getFullName() : " ";
        String returnString = Java.getReturnString(type);
        if (type.isArray()) {
            if (null != arrayType) {
                arrayTypeInteger = new Integer(arrayType.getDetailedType());
                arrayTypeString = arrayType.isSymbol() ? arrayType.getSymbolID().getFullName() + "$Array" + type.getArrayDimension() : ((String)s_java_arr.get(arrayTypeInteger)).replace('#', Character.forDigit(type.getArrayDimension(), 10));
            } else {
                arrayTypeString = "gov.llnl.sidl.BaseArray";
            }
        }
        if (arg.getMode() == 0) {
            convert = (String)s_server_in.get(detail);
        } else if (arg.getMode() == 1) {
            convert = (String)s_server_out.get(detail);
            if (convert != null) {
                Java.printSub(writer, convert, prefix + argFormalName, argFormalName, returnString, type.isSymbol() ? typeName : arrayTypeString);
            }
            convert = (String)s_server_inout.get(detail);
        } else if (arg.getMode() == 2) {
            convert = (String)s_server_out.get(detail);
        }
        if (convert != null) {
            String fromName = null;
            fromName = arg.hasArrayOrderSpec() ? Java.getJNIEnsureName(arg) : (arg.getMode() == 0 || arrayType == null && !type.isArray() ? argFormalName : "*" + argFormalName);
            Java.printSub(writer, convert, prefix + argFormalName, fromName, returnString, type.isSymbol() ? typeName : arrayTypeString);
        }
        if (arg.getType().getType() == 10 && arg.getMode() == 1) {
            writer.println("sidl_String_free(*" + argFormalName + ");");
        }
    }

    public static void postprocessServerJNIArgument(LanguageWriterForC writer, Argument arg, String prefix) throws CodeGenerationException {
        if (arg.getMode() != 0) {
            String convert;
            Type type = arg.getType();
            Type arrayType = type.getArrayType();
            Integer arrayTypeInteger = null;
            String arrayTypeString = null;
            String argFormalName = arg.getFormalName();
            String typeName = type.isSymbol() ? type.getSymbolID().getFullName() : " ";
            String returnString = Java.getReturnString(type);
            if (type.isArray()) {
                if (null != arrayType) {
                    arrayTypeInteger = new Integer(arrayType.getDetailedType());
                    arrayTypeString = arrayType.isSymbol() ? arrayType.getSymbolID().getFullName() : ((String)s_java_arr.get(arrayTypeInteger)).replace('#', Character.forDigit(type.getArrayDimension(), 10));
                } else {
                    arrayTypeString = "gov.llnl.sidl.BaseArray";
                }
            }
            if ((convert = (String)s_server_post.get(new Integer(type.getDetailedType()))) != null) {
                String toName = null;
                toName = arg.hasArrayOrderSpec() ? Java.getJNIEnsureName(arg) : (!type.isArray() ? arg.getFormalName() : "*" + arg.getFormalName());
                Java.printSub(writer, convert, toName, prefix + arg.getFormalName(), Java.getReturnString(type), type.isSymbol() ? type.getSymbolID().getFullName() : arrayTypeString);
            }
        }
    }

    public static void postprocessServerJNIReturn(LanguageWriterForC writer, Type type, String java_result, String ior_result) {
        int t = type.getDetailedType();
        Java.printSub(writer, (String)s_server_return.get(new Integer(t)), ior_result, java_result, Java.getJNIReturnType(type), Java.getJavaInternalReturnType(type));
    }

    private static String substitute(String s, String s0) {
        return Java.substitute(s, new String[]{s0});
    }

    private static String substitute(String s, String s0, String s1) {
        return Java.substitute(s, new String[]{s0, s1});
    }

    private static String substitute(String s, String s0, String s1, String s2, String s3) {
        return Java.substitute(s, new String[]{s0, s1, s2, s3});
    }

    private static String substitute(String s, String[] args) {
        if (s == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(s);
        for (int i = 0; i < sb.length() - 1; ++i) {
            if (sb.charAt(i) != '#') continue;
            try {
                int n = Integer.parseInt(String.valueOf(sb.charAt(i + 1))) - 1;
                if (n < 0 || n >= args.length) continue;
                sb.replace(i, i + 2, args[n]);
                continue;
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        return sb.toString();
    }

    private static void printSub(LanguageWriter lw, String s, String s0) {
        lw.println(Java.substitute(s, s0));
    }

    private static void printSub(LanguageWriter lw, String s, String s0, String s1) {
        lw.println(Java.substitute(s, s0, s1));
    }

    private static void printSub(LanguageWriter lw, String s, String s0, String s1, String s2, String s3) {
        lw.println(Java.substitute(s, s0, s1, s2, s3));
    }

    private static void printSub(LanguageWriter lw, String s, String[] args) {
        lw.println(Java.substitute(s, args));
    }

    private static String getReturnString(Type type) throws CodeGenerationException {
        return IOR.getReturnString(type, true, false);
    }

    static {
        s_java_val.put(s_void, "void");
        s_java_val.put(s_boolean, "boolean");
        s_java_val.put(s_char, "char");
        s_java_val.put(s_dcomplex, "sidl.DoubleComplex");
        s_java_val.put(s_double, "double");
        s_java_val.put(s_fcomplex, "sidl.FloatComplex");
        s_java_val.put(s_float, "float");
        s_java_val.put(s_int, "int");
        s_java_val.put(s_long, "long");
        s_java_val.put(s_opaque, "long");
        s_java_val.put(s_string, "java.lang.String");
        s_java_val.put(s_enum, "int");
        s_java_ref.put(s_boolean, "sidl.Boolean$Holder");
        s_java_ref.put(s_char, "sidl.Character$Holder");
        s_java_ref.put(s_dcomplex, "sidl.DoubleComplex$Holder");
        s_java_ref.put(s_double, "sidl.Double$Holder");
        s_java_ref.put(s_fcomplex, "sidl.FloatComplex$Holder");
        s_java_ref.put(s_float, "sidl.Float$Holder");
        s_java_ref.put(s_int, "sidl.Integer$Holder");
        s_java_ref.put(s_long, "sidl.Long$Holder");
        s_java_ref.put(s_opaque, "sidl.Opaque$Holder");
        s_java_ref.put(s_string, "sidl.String$Holder");
        s_java_ref.put(s_enum, "sidl.Enum$Holder");
        s_ior_name.put(s_boolean, "bool");
        s_ior_name.put(s_char, "char");
        s_ior_name.put(s_dcomplex, "dcomplex");
        s_ior_name.put(s_double, "double");
        s_ior_name.put(s_fcomplex, "fcomplex");
        s_ior_name.put(s_float, "float");
        s_ior_name.put(s_int, "int");
        s_ior_name.put(s_long, "long");
        s_ior_name.put(s_opaque, "opaque");
        s_ior_name.put(s_string, "string");
        s_ior_name.put(s_enum, "int");
        s_ior_name.put(s_class, "BaseInterface");
        s_ior_name.put(s_interface, "BaseInterface");
        s_java_arr.put(s_boolean, "sidl.Boolean$Array#");
        s_java_arr.put(s_char, "sidl.Character$Array#");
        s_java_arr.put(s_dcomplex, "sidl.DoubleComplex$Array#");
        s_java_arr.put(s_double, "sidl.Double$Array#");
        s_java_arr.put(s_fcomplex, "sidl.FloatComplex$Array#");
        s_java_arr.put(s_float, "sidl.Float$Array#");
        s_java_arr.put(s_int, "sidl.Integer$Array#");
        s_java_arr.put(s_long, "sidl.Long$Array#");
        s_java_arr.put(s_opaque, "sidl.Opaque$Array#");
        s_java_arr.put(s_string, "sidl.String$Array#");
        s_java_sig.put("boolean", "Z");
        s_java_sig.put("char", "C");
        s_java_sig.put("int", "I");
        s_java_sig.put("long", "J");
        s_java_sig.put("float", "F");
        s_java_sig.put("double", "D");
        s_java_sig.put("void", "V");
        s_jni_arg.put("void", "void");
        s_jni_arg.put("boolean", "jboolean");
        s_jni_arg.put("char", "jchar");
        s_jni_arg.put("double", "jdouble");
        s_jni_arg.put("float", "jfloat");
        s_jni_arg.put("int", "jint");
        s_jni_arg.put("long", "jlong");
        s_jni_arg.put("java.lang.String", "jstring");
        s_init_ior.put(s_boolean, "#1 #2 = FALSE;");
        s_init_ior.put(s_char, "#1 #2 = (#1) 0;");
        s_init_ior.put(s_dcomplex, "#1 #2 = { 0.0, 0.0 };");
        s_init_ior.put(s_double, "#1 #2 = 0.0;");
        s_init_ior.put(s_fcomplex, "#1 #2 = { 0.0, 0.0 };");
        s_init_ior.put(s_float, "#1 #2 = 0.0;");
        s_init_ior.put(s_int, "#1 #2 = 0;");
        s_init_ior.put(s_long, "#1 #2 = 0;");
        s_init_ior.put(s_opaque, "#1 #2 = (#1) NULL;");
        s_init_ior.put(s_string, "#1 #2 = (#1) NULL;");
        s_init_ior.put(s_enum, "#1 #2 = (#1) 0;");
        s_init_ior.put(s_class, "#1 #2 = (#1) NULL;");
        s_init_ior.put(s_interface, "#1 #2 = (#1) NULL;");
        s_init_ior.put(s_array, "#1 #2 = (#1) NULL;");
        s_init_jni.put("jboolean", "#1 #2 = JNI_FALSE;");
        s_init_jni.put("jchar", "#1 #2 = 0;");
        s_init_jni.put("jdouble", "#1 #2 = 0.0;");
        s_init_jni.put("jfloat", "#1 #2 = 0.0;");
        s_init_jni.put("jint", "#1 #2 = 0;");
        s_init_jni.put("jlong", "#1 #2 = 0;");
        s_init_jni.put("jobject", "#1 #2 = (#1) NULL;");
        s_init_jni.put("jstring", "#1 #2 = (#1) NULL;");
        s_init_java.put("boolean", "#1 #2 = false");
        s_init_java.put("char", "#1 #2 = 0");
        s_init_java.put("double", "#1 #2 = 0.0;");
        s_init_java.put("float", "#1 #2 = 0.0;");
        s_init_java.put("int", "#1 #2 = 0;");
        s_init_java.put("long", "#1 #2 = 0;");
        s_init_java.put("object", "#1 #2 = (#1) NULL;");
        s_init_java.put("string", "#1 #2 = (#1) NULL;");
        s_in.put(s_boolean, "#1 = (#3) #2;");
        s_in.put(s_char, "#1 = (#3) #2;");
        s_in.put(s_dcomplex, "#1 = sidl_Java_J2I_dcomplex(env, #2);");
        s_in.put(s_double, "#1 = (#3) #2;");
        s_in.put(s_fcomplex, "#1 = sidl_Java_J2I_fcomplex(env, #2);");
        s_in.put(s_float, "#1 = (#3) #2;");
        s_in.put(s_int, "#1 = (#3) #2;");
        s_in.put(s_long, "#1 = (#3) #2;");
        s_in.put(s_opaque, "#1 = (#3) JLONG_TO_POINTER(#2);");
        s_in.put(s_string, "#1 = sidl_Java_J2I_string(env, #2);");
        s_in.put(s_enum, "#1 = (#3) #2;");
        s_in.put(s_class, "#1 = (#3) sidl_Java_J2I_cls(env, #2);");
        s_in.put(s_interface, "#1 = (#3) sidl_Java_J2I_ifc(env, #2, \"#4\");");
        s_in.put(s_array, "#1 = (#3) sidl_Java_J2I_borrow_array(env, #2);");
        s_inout.put(s_boolean, "#1 = sidl_Java_J2I_boolean_holder(env, #2);");
        s_inout.put(s_char, "#1 = sidl_Java_J2I_character_holder(env, #2);");
        s_inout.put(s_dcomplex, "#1 = sidl_Java_J2I_dcomplex_holder(env, #2);");
        s_inout.put(s_double, "#1 = sidl_Java_J2I_double_holder(env, #2);");
        s_inout.put(s_fcomplex, "#1 = sidl_Java_J2I_fcomplex_holder(env, #2);");
        s_inout.put(s_float, "#1 = sidl_Java_J2I_float_holder(env, #2);");
        s_inout.put(s_int, "#1 = sidl_Java_J2I_int_holder(env, #2);");
        s_inout.put(s_long, "#1 = sidl_Java_J2I_long_holder(env, #2);");
        s_inout.put(s_opaque, "#1 = sidl_Java_J2I_opaque_holder(env, #2);");
        s_inout.put(s_string, "#1 = sidl_Java_J2I_string_holder(env, #2);");
        s_inout.put(s_enum, "#1 = (#3) sidl_Java_J2I_int_holder(env, #2);");
        s_inout.put(s_class, "#1 = (#3) sidl_Java_J2I_cls_holder(env, #2, \"#4\");");
        s_inout.put(s_interface, "#1 = (#3) sidl_Java_J2I_ifc_holder(env, #2, \"#4\");");
        s_inout.put(s_array, "#1 = (#3) sidl_Java_J2I_array_holder(env, #2, \"#4\");");
        s_post.put(s_boolean, "sidl_Java_I2J_boolean_holder(env, #2, #1);");
        s_post.put(s_char, "sidl_Java_I2J_character_holder(env, #2, #1);");
        s_post.put(s_dcomplex, "sidl_Java_I2J_dcomplex_holder(env, #2, &#1);");
        s_post.put(s_double, "sidl_Java_I2J_double_holder(env, #2, #1);");
        s_post.put(s_fcomplex, "sidl_Java_I2J_fcomplex_holder(env, #2, &#1);");
        s_post.put(s_float, "sidl_Java_I2J_float_holder(env, #2, #1);");
        s_post.put(s_int, "sidl_Java_I2J_int_holder(env, #2, #1);");
        s_post.put(s_long, "sidl_Java_I2J_long_holder(env, #2, #1);");
        s_post.put(s_opaque, "sidl_Java_I2J_opaque_holder(env, #2, #1);");
        s_post.put(s_string, "sidl_Java_I2J_string_holder(env, #2, #1);");
        s_post.put(s_enum, "sidl_Java_I2J_int_holder(env, #2, (int) #1);");
        s_post.put(s_class, "sidl_Java_I2J_cls_holder(env, #2, #1, \"#4\");");
        s_post.put(s_interface, "sidl_Java_I2J_ifc_holder(env, #2, #1, \"#4\");");
        s_post.put(s_array, "#1 = sidl_Java_I2J_new_array(env, #2, \"#4\");");
        s_return.put(s_boolean, "#1 = (#3) #2;");
        s_return.put(s_char, "#1 = (#3) #2;");
        s_return.put(s_dcomplex, "#1 = sidl_Java_I2J_dcomplex(env, &#2);");
        s_return.put(s_double, "#1 = (#3) #2;");
        s_return.put(s_fcomplex, "#1 = sidl_Java_I2J_fcomplex(env, &#2);");
        s_return.put(s_float, "#1 = (#3) #2;");
        s_return.put(s_int, "#1 = (#3) #2;");
        s_return.put(s_long, "#1 = (#3) #2;");
        s_return.put(s_opaque, "#1 = (#3) POINTER_TO_JLONG(#2);");
        s_return.put(s_string, "#1 = sidl_Java_I2J_string(env, #2);");
        s_return.put(s_enum, "#1 = (#3) #2;");
        s_return.put(s_class, "#1 = sidl_Java_I2J_cls(env, #2, \"#4\");");
        s_return.put(s_interface, "#1 = sidl_Java_I2J_ifc(env, #2, \"#4\");");
        s_return.put(s_array, "#1 = sidl_Java_I2J_new_array(env, #2, \"#4\");");
        s_server_in.put(s_boolean, "#1 = (#3) #2;");
        s_server_in.put(s_char, "#1 = (#3) #2;");
        s_server_in.put(s_dcomplex, "#1 = sidl_Java_I2J_dcomplex(data.env, &#2);");
        s_server_in.put(s_double, "#1 = (#3) #2;");
        s_server_in.put(s_fcomplex, "#1 = sidl_Java_I2J_fcomplex(data.env, &#2);");
        s_server_in.put(s_float, "#1 = (#3) #2;");
        s_server_in.put(s_int, "#1 = (#3) #2;");
        s_server_in.put(s_long, "#1 = (#3) #2;");
        s_server_in.put(s_opaque, "#1 = (#3) POINTER_TO_JLONG(#2);");
        s_server_in.put(s_string, "#1 = sidl_Java_I2J_string(data.env, #2);");
        s_server_in.put(s_enum, "#1 = (#3) #2;");
        s_server_in.put(s_class, "#1 = sidl_Java_I2J_cls(data.env, #2, \"#4\");");
        s_server_in.put(s_interface, "#1 = sidl_Java_I2J_ifc(data.env, #2, \"#4\");");
        s_server_in.put(s_array, "#1 = sidl_Java_I2J_new_array_server(data.env, #2, \"#4\");");
        s_server_out.put(s_boolean, "#1 = sidl_Java_create_empty_class(data.env, \"sidl.Boolean$Holder\");");
        s_server_out.put(s_char, "#1 = sidl_Java_create_empty_class(data.env, \"sidl.Character$Holder\");");
        s_server_out.put(s_dcomplex, "#1 = sidl_Java_create_empty_class(data.env, \"sidl.DoubleComplex$Holder\");");
        s_server_out.put(s_double, "#1 = sidl_Java_create_empty_class(data.env, \"sidl.Double$Holder\");");
        s_server_out.put(s_fcomplex, "#1 = sidl_Java_create_empty_class(data.env, \"sidl.FloatComplex$Holder\");");
        s_server_out.put(s_float, "#1 = sidl_Java_create_empty_class(data.env, \"sidl.Float$Holder\");");
        s_server_out.put(s_int, "#1 = sidl_Java_create_empty_class(data.env, \"sidl.Integer$Holder\");");
        s_server_out.put(s_long, "#1 = sidl_Java_create_empty_class(data.env, \"sidl.Long$Holder\");");
        s_server_out.put(s_opaque, "#1 = sidl_Java_create_empty_class(data.env, \"sidl.Opaque$Holder\");");
        s_server_out.put(s_string, "#1 = sidl_Java_create_empty_class(data.env, \"sidl.String$Holder\");");
        s_server_out.put(s_enum, "#1 = sidl_Java_create_empty_class(data.env, \"sidl.Enum$Holder\");");
        s_server_out.put(s_class, "#1 = sidl_Java_create_empty_class(data.env, \"#4$Holder\");");
        s_server_out.put(s_interface, "#1 = sidl_Java_create_empty_class(data.env, \"#4$Holder\");");
        s_server_out.put(s_array, "#1 = sidl_Java_create_empty_class(data.env, \"#4$Holder\");");
        s_server_inout.put(s_boolean, "sidl_Java_I2J_boolean_holder(data.env, #1, *#2);");
        s_server_inout.put(s_char, "sidl_Java_I2J_character_holder(data.env, #1, *#2);");
        s_server_inout.put(s_dcomplex, "sidl_Java_I2J_dcomplex_holder(data.env, #1, #2);");
        s_server_inout.put(s_double, "sidl_Java_I2J_double_holder(data.env, #1, *#2);");
        s_server_inout.put(s_fcomplex, "sidl_Java_I2J_fcomplex_holder(data.env, #1, #2);");
        s_server_inout.put(s_float, "sidl_Java_I2J_float_holder(data.env, #1, *#2);");
        s_server_inout.put(s_int, "sidl_Java_I2J_int_holder(data.env, #1, *#2);");
        s_server_inout.put(s_long, "sidl_Java_I2J_long_holder(data.env, #1, *#2);");
        s_server_inout.put(s_opaque, "sidl_Java_I2J_opaque_holder(data.env, #1, *#2);");
        s_server_inout.put(s_string, "sidl_Java_I2J_string_holder(data.env, #1, *#2);");
        s_server_inout.put(s_enum, "sidl_Java_I2J_int_holder(data.env, #1,(int) *#2);");
        s_server_inout.put(s_class, "sidl_Java_I2J_cls_holder(data.env, #1, *#2, \"#4\");");
        s_server_inout.put(s_interface, "sidl_Java_I2J_ifc_holder(data.env, #1, *#2, \"#4\");");
        s_server_inout.put(s_array, "sidl_Java_I2J_array_holder(data.env, #1, #2, \"#4\");");
        s_server_post.put(s_boolean, "*#1 = sidl_Java_J2I_boolean_holder(data.env, #2);");
        s_server_post.put(s_char, "*#1 = sidl_Java_J2I_character_holder(data.env, #2);");
        s_server_post.put(s_dcomplex, "*#1 = sidl_Java_J2I_dcomplex_holder(data.env, #2);");
        s_server_post.put(s_double, "*#1 = sidl_Java_J2I_double_holder(data.env, #2);");
        s_server_post.put(s_fcomplex, "*#1 = sidl_Java_J2I_fcomplex_holder(data.env, #2);");
        s_server_post.put(s_float, "*#1 = sidl_Java_J2I_float_holder(data.env, #2);");
        s_server_post.put(s_int, "*#1 = sidl_Java_J2I_int_holder(data.env, #2);");
        s_server_post.put(s_long, "*#1 = sidl_Java_J2I_long_holder(data.env, #2);");
        s_server_post.put(s_opaque, "*#1 = sidl_Java_J2I_opaque_holder(data.env, #2);");
        s_server_post.put(s_string, "*#1 = sidl_Java_J2I_string_holder(data.env, #2);");
        s_server_post.put(s_enum, "*#1 = (#3) sidl_Java_J2I_int_holder(data.env, #2);");
        s_server_post.put(s_class, "*#1 = (#3) sidl_Java_J2I_cls_holder(data.env, #2, \"#4\");");
        s_server_post.put(s_interface, "*#1 = (#3) sidl_Java_J2I_ifc_holder(data.env, #2, \"#4\");");
        s_server_post.put(s_array, "#1 = (#3) sidl_Java_J2I_array_holder(data.env, #2, \"#4\");");
        s_server_return.put(s_boolean, "#1 = (#3) #2;");
        s_server_return.put(s_char, "#1 = (#3) #2;");
        s_server_return.put(s_dcomplex, "#1 = sidl_Java_J2I_dcomplex(data.env, #2);");
        s_server_return.put(s_double, "#1 = (#3) #2;");
        s_server_return.put(s_fcomplex, "#1 = sidl_Java_J2I_fcomplex(data.env, #2);");
        s_server_return.put(s_float, "#1 = (#3) #2;");
        s_server_return.put(s_int, "#1 = (#3) #2;");
        s_server_return.put(s_long, "#1 = (#3) #2;");
        s_server_return.put(s_opaque, "#1 = (#3) JLONG_TO_POINTER(#2);");
        s_server_return.put(s_string, "#1 = sidl_Java_J2I_string(data.env, #2);");
        s_server_return.put(s_enum, "#1 = (#3) #2;");
        s_server_return.put(s_class, "#1 = (#3) sidl_Java_J2I_cls(data.env, #2);");
        s_server_return.put(s_interface, "#1 = (#3) sidl_Java_J2I_ifc(data.env, #2, \"#4\");");
        s_server_return.put(s_array, "#1 = (#3) sidl_Java_J2I_take_array(data.env, #2);");
    }
}

