/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.jdk;

import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.CodeSplicer;
import gov.llnl.babel.backend.FileManager;
import gov.llnl.babel.backend.jdk.Java;
import gov.llnl.babel.backend.writers.LanguageWriterForJava;
import gov.llnl.babel.symbols.Argument;
import gov.llnl.babel.symbols.Extendable;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.SymbolTable;
import gov.llnl.babel.symbols.SymbolUtilities;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class JavaImplSource {
    private Extendable d_ext = null;
    private LanguageWriterForJava d_writer = null;
    private CodeSplicer d_splicer = null;
    private String d_classname = null;

    public JavaImplSource(Extendable ext) throws CodeGenerationException {
        if (ext == null) {
            throw new CodeGenerationException("Unexpected null extendable object");
        }
        this.d_ext = ext;
        SymbolID id = this.d_ext.getSymbolID();
        this.d_classname = Java.getJavaServerClassName(id);
        int type = this.d_ext.getSymbolType();
        String filename = Java.getJavaImplSourceFile(id);
        try {
            FileManager.getInstance().setJavaStylePackageGeneration(true);
            this.d_splicer = FileManager.getInstance().getCodeSplicer(id, type, filename);
            this.d_writer = new LanguageWriterForJava(FileManager.getInstance().createFile(id, type, "JAVAIMPL", filename));
            FileManager.getInstance().setJavaStylePackageGeneration(false);
            this.d_writer.writeBanner(this.d_ext, filename, true, "Server-side implementation for " + id.getFullName());
        }
        catch (IOException e) {
            if (this.d_writer != null) {
                this.d_writer.close();
                this.d_writer = null;
            }
            throw new CodeGenerationException("IOException : " + e.getMessage());
        }
    }

    public static void generateCode(Extendable ext) throws CodeGenerationException {
        JavaImplSource source = new JavaImplSource(ext);
        source.generateCode();
    }

    public synchronized void generateCode() throws CodeGenerationException {
        this.writePackageImports();
        this.writeClassBeginning();
        this.writeCtorDtor();
        this.writeSIDLDefinedMethods();
        this.d_splicer.splice(this.d_ext.getSymbolID().getFullName() + "._misc", this.d_writer, "miscellaneous");
        this.d_writer.println();
        this.writeClassEnd();
        this.checkSplicer();
        this.d_writer.close();
    }

    private void writePackageImports() {
        this.writePackage();
        this.writeImports();
        this.spliceImports();
    }

    private void writePackage() {
        String pkg = SymbolUtilities.getParentPackage(this.d_ext.getSymbolID().getFullName());
        this.d_writer.println("package " + pkg + ";");
        this.d_writer.println();
    }

    private void writeImports() {
        Iterator i = this.d_ext.getSymbolReferences().iterator();
        while (i.hasNext()) {
            SymbolID id = (SymbolID)i.next();
            if (id.getFullName().equals(this.d_ext.getSymbolID().getFullName())) continue;
            this.d_writer.println("import " + id.getFullName() + ";");
        }
        this.d_writer.println();
    }

    private void spliceImports() {
        this.d_splicer.splice(this.d_ext.getSymbolID().getFullName() + "._imports", this.d_writer, "additional imports");
        this.d_writer.println();
    }

    private void writeClassBeginning() {
        String name = this.d_ext.getSymbolID().getShortName();
        SymbolID id = this.d_ext.getSymbolID();
        String splicer_symbol_data = this.d_ext.getSymbolID().getFullName() + "._data";
        String splicer_symbol_load = this.d_ext.getSymbolID().getFullName() + "._load";
        this.d_writer.writeComment(this.d_ext, true);
        this.d_writer.println("public class " + this.d_classname + " extends " + this.d_ext.getSymbolID().getShortName());
        this.d_writer.println("{");
        this.d_writer.println();
        this.d_writer.tab();
        this.d_splicer.splice(splicer_symbol_data, this.d_writer, "private data");
        this.d_writer.println();
        this.d_writer.println("static { ");
        this.d_splicer.splice(splicer_symbol_load, this.d_writer, "class initialization");
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void writeCtorDtor() {
        String name = this.d_ext.getSymbolID().getShortName();
        this.d_writer.writeComment("User defined constructor", true);
        this.d_writer.println("public " + this.d_classname + "(long IORpointer){");
        this.d_writer.tab();
        this.d_writer.println("super(IORpointer);");
        this.d_splicer.splice(this.d_ext.getSymbolID().getFullName() + "." + name, this.d_writer, "constructor");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
        this.d_writer.writeComment("User defined destructing method", true);
        this.d_writer.println("public void finalize() throws Throwable{");
        this.d_writer.tab();
        this.d_writer.println("super.finalize();");
        this.d_splicer.splice(this.d_ext.getSymbolID().getFullName() + "._dtor", this.d_writer, "destructor");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void writeSIDLDefinedMethods() {
        List static_methods = (List)this.d_ext.getStaticMethods(false);
        if (static_methods.size() > 0) {
            this.d_writer.writeCommentLine("user defined static methods:");
            Iterator m = static_methods.iterator();
            while (m.hasNext()) {
                Method method = (Method)m.next();
                this.generateMethod(method);
            }
        } else {
            this.d_writer.writeCommentLine("user defined static methods: (none)");
        }
        this.d_writer.println();
        List nonstatic_methods = (List)this.d_ext.getNonstaticMethods(false);
        if (nonstatic_methods.size() > 0) {
            this.d_writer.writeCommentLine("user defined non-static methods:");
            Iterator m = nonstatic_methods.iterator();
            while (m.hasNext()) {
                Method method = (Method)m.next();
                if (method.isAbstract()) continue;
                this.generateMethod(method);
            }
        } else {
            this.d_writer.writeCommentLine("user defined non-static methods: (none)");
        }
        this.d_writer.println();
    }

    private void generateMethod(Method method) {
        if (method == null) {
            return;
        }
        this.generateMethodBeginning(method);
        if (method.getArgumentList().size() > 0) {
            this.generateArgumentList(method);
        } else {
            this.d_writer.println(" () ");
        }
        if (method.getThrows().size() > 0) {
            this.generateThrowsList(method);
        }
        this.generateMethodBody(method);
    }

    private void generateMethodBeginning(Method method) {
        this.d_writer.writeComment(method, true);
        this.d_writer.print("public ");
        if (method.isStatic()) {
            this.d_writer.print("static ");
        }
        this.d_writer.print(Java.getJavaReturnType(method.getReturnType()) + " ");
        this.d_writer.print(Java.getJavaServerMethodName(method));
    }

    private void generateArgumentList(Method method) {
        if (method == null) {
            return;
        }
        ArrayList args = method.getArgumentList();
        this.d_writer.println(" (");
        this.d_writer.tab();
        Iterator a = args.iterator();
        while (a.hasNext()) {
            Argument arg = (Argument)a.next();
            this.d_writer.print("/*" + arg.getModeString() + "*/ " + Java.getJavaServerArgument(arg) + " " + arg.getFormalName());
            if (!a.hasNext()) continue;
            this.d_writer.println(",");
        }
        this.d_writer.println(" ) ");
        this.d_writer.backTab();
    }

    private void generateThrowsList(Method method) {
        if (method == null) {
            return;
        }
        Set exceptions = method.getThrows();
        this.d_writer.print("throws ");
        this.d_writer.tab();
        Iterator e = exceptions.iterator();
        while (e.hasNext()) {
            SymbolID id = (SymbolID)e.next();
            this.d_writer.print(Java.getFullJavaSymbolName(id));
            if (!SymbolUtilities.isBaseException(id) && SymbolTable.getInstance().lookupSymbol(id).isInterface()) {
                this.d_writer.print(".Wrapper");
            }
            if (!e.hasNext()) continue;
            this.d_writer.println(", ");
        }
        this.d_writer.println();
        this.d_writer.backTab();
    }

    private void generateMethodBody(Method method) {
        this.d_writer.println("{");
        this.d_writer.tab();
        this.d_splicer.splice(this.d_ext.getSymbolID().getFullName() + "." + method.getLongMethodName(), this.d_writer, method.getShortMethodName(), "return " + Java.getDefaultReturnValue(method) + ";");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void writeClassEnd() {
        String name = this.d_ext.getSymbolID().getShortName();
        this.d_writer.backTab();
        this.d_writer.print("} ");
        this.d_writer.writeCommentLine("end class " + name);
        this.d_writer.println();
    }

    private void checkSplicer() {
        if (this.d_splicer.hasUnusedSymbolEdits()) {
            this.d_writer.beginBlockComment(true);
            this.d_writer.println("================= BEGIN UNREFERENCED METHOD(S) ================");
            this.d_writer.println("The following code segment(s) belong to unreferenced method(s).");
            this.d_writer.println("This can result from a method rename/removal in the sidl file.");
            this.d_writer.println("Move or remove the code in order to compile cleanly.");
            this.d_writer.endBlockComment(true);
            this.d_splicer.outputUnusedSymbolEdits(this.d_writer.getPrintWriter());
            this.d_writer.writeCommentLine("================== END UNREFERENCED METHOD(S) =================");
        }
    }
}

