/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.sidl;

import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.CodeGenerator;
import gov.llnl.babel.backend.FileManager;
import gov.llnl.babel.backend.sidl.Sidl;
import gov.llnl.babel.backend.sidl.SidlSource;
import gov.llnl.babel.backend.writers.LanguageWriterForSidl;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.SymbolTable;
import gov.llnl.babel.symbols.SymbolUtilities;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class GenerateSidl
implements CodeGenerator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateSource(Symbol symbol) throws CodeGenerationException {
        PrintWriter sw = null;
        int type = symbol.getSymbolType();
        switch (type) {
            case 14: {
                SymbolID sid = symbol.getSymbolID();
                String pname = SymbolUtilities.getParentPackage(sid.getFullName());
                if (pname != null) break;
                try {
                    String sf = Sidl.getFileName(sid);
                    sw = FileManager.getInstance().createFile(sid, 14, "SIDLSRCS", sf);
                    LanguageWriterForSidl sidlWriter = new LanguageWriterForSidl(sw);
                    SidlSource.generateCode(symbol, sidlWriter);
                    if (sw == null) break;
                    sw.close();
                    break;
                }
                catch (Throwable throwable) {
                    if (sw != null) {
                        sw.close();
                    }
                    throw throwable;
                }
            }
        }
    }

    public void generateCode(Set symbols) throws CodeGenerationException {
        Iterator i = symbols.iterator();
        SymbolTable table = SymbolTable.getInstance();
        while (i.hasNext()) {
            SymbolID id = (SymbolID)i.next();
            Symbol symbol = table.lookupSymbol(id);
            if (symbol == null) continue;
            this.generateSource(symbol);
        }
    }

    public String getType() {
        return "text";
    }

    public boolean getUserSymbolsOnly() {
        return false;
    }

    public Set getLanguages() {
        TreeSet<String> result = new TreeSet<String>();
        result.add("sidl");
        return result;
    }
}

