/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.url.cookie;

import gov.llnl.babel.url.cookie.CookieCrumbleException;
import gov.llnl.babel.url.cookie.Lexer;
import java.io.Serializable;
import java.util.Date;
import java.util.StringTokenizer;

public class Cookie
implements Serializable {
    private String d_name;
    private String d_value;
    private String d_comment = null;
    private String d_urlComment = null;
    private String d_domain = null;
    private int d_maxAge = -1;
    private Date d_expiration = null;
    private String d_path = null;
    private String d_ports = null;
    private boolean d_secure = false;
    private boolean d_discard = true;
    private boolean d_discardExplicit = false;
    private String d_version = "0";

    public static String encodeValue(String value) {
        int len = value.length();
        StringBuffer buf = new StringBuffer(len + 1);
        int i = 0;
        while (i < len) {
            char c = value.charAt(i);
            if (c == '\r' && i < len - 2 && value.charAt(i + 1) == '\n' && (value.charAt(i + 2) == '\t' || value.charAt(i + 2) == ' ')) {
                buf.append(value.substring(i, i + 3));
                i += 3;
                continue;
            }
            if (c == '\"' || c == '\\' || Character.isISOControl(c) && c != '\t') {
                buf.append('\\').append(c);
                ++i;
                continue;
            }
            buf.append(c);
            ++i;
        }
        return buf.toString();
    }

    public static String decodeValue(String value) {
        int firstBackslash = value.indexOf(92);
        if (firstBackslash >= 0) {
            int len = value.length();
            StringBuffer buf = new StringBuffer(len - 1);
            buf.append(value.substring(0, firstBackslash));
            for (int i = firstBackslash; i < len; ++i) {
                char c = value.charAt(i);
                if (c != '\\' || ++i >= len) continue;
                buf.append(value.charAt(i));
            }
            return buf.toString();
        }
        return value;
    }

    public static boolean validToken(String tok) {
        int len = tok.length();
        for (int i = 0; i < len; ++i) {
            if (Lexer.validTokenChar(tok.charAt(i))) continue;
            return false;
        }
        return len > 0;
    }

    public static boolean validValue(String value) {
        int len = value.length();
        int state = 0;
        block6: for (int i = 0; i < len; ++i) {
            char ch = value.charAt(i);
            if (ch > '\u00ff') {
                return false;
            }
            switch (state) {
                case 0: {
                    if (ch == '\r') {
                        state = 1;
                        continue block6;
                    }
                    if (Character.isISOControl(ch) && ch != '\t') {
                        return false;
                    }
                    if (ch != '\\') continue block6;
                    state = 3;
                    continue block6;
                }
                case 1: {
                    if (ch == '\n') {
                        state = 2;
                        continue block6;
                    }
                    return false;
                }
                case 2: {
                    if (ch == '\t' || ch == ' ') {
                        state = 0;
                        continue block6;
                    }
                    return false;
                }
                case 3: {
                    if (ch > '\u007f') {
                        return false;
                    }
                    state = 0;
                    continue block6;
                }
                default: {
                    return false;
                }
            }
        }
        return state == 0;
    }

    public static boolean validPortList(String ports) {
        StringTokenizer tok = new StringTokenizer(ports, ",");
        while (tok.hasMoreTokens()) {
            String port = tok.nextToken().trim();
            try {
                Integer.parseInt(port);
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
        return true;
    }

    public static String effectiveHostname(String hostname) {
        if (hostname.indexOf(46) < 0) {
            return hostname + ".local";
        }
        return hostname;
    }

    public Cookie(String name, String value) throws CookieCrumbleException {
        if (!Cookie.validToken(name)) {
            throw new CookieCrumbleException("Proposed cookie has invalid name \"" + name + "\"");
        }
        if (!Cookie.validValue(value)) {
            throw new CookieCrumbleException("Proposed cookie has invalid value \"" + value + "\"");
        }
        this.d_name = name;
        this.d_value = value;
    }

    public String getName() {
        return this.d_name;
    }

    public synchronized String getValue() {
        return this.d_value;
    }

    public synchronized String getComment() {
        return this.d_comment;
    }

    public synchronized String getUrlComment() {
        return this.d_comment;
    }

    public synchronized String getDomain() {
        return this.d_domain;
    }

    public synchronized int getMaxAge() {
        return this.d_maxAge;
    }

    public synchronized Date getExpiration() {
        return this.d_expiration;
    }

    public synchronized String getPath() {
        return this.d_path;
    }

    public synchronized String getPorts() {
        return this.d_ports;
    }

    public synchronized boolean isSecure() {
        return this.d_secure;
    }

    public synchronized boolean isDiscardable() {
        return this.d_discard;
    }

    public synchronized String getVersion() {
        return this.d_version;
    }

    public synchronized boolean hasValidDomain(String hostname) {
        String effective = Cookie.effectiveHostname(hostname);
        return this.d_domain.equalsIgnoreCase(effective) || this.d_domain.length() > 1 && effective.length() > this.d_domain.length() && this.d_domain.charAt(0) == '.' && effective.indexOf(46) == effective.length() - this.d_domain.length() && effective.regionMatches(true, effective.length() - this.d_domain.length(), this.d_domain, 0, this.d_domain.length());
    }

    public synchronized void setValue(String value) throws CookieCrumbleException {
        if (!Cookie.validValue(value)) {
            throw new CookieCrumbleException("Cookie value is not valid \"" + value + "\"");
        }
        this.d_value = value;
    }

    public synchronized void setComment(String comment) throws CookieCrumbleException {
        if (!Cookie.validValue(comment)) {
            throw new CookieCrumbleException("Cookie comment is not valid \"" + comment + "\"");
        }
        this.d_comment = comment;
    }

    public synchronized void setUrlComment(String comment) throws CookieCrumbleException {
        if (!(comment == null || Cookie.validValue(comment) && comment.startsWith("http:"))) {
            throw new CookieCrumbleException("Cookie comment URL is not valid \"" + comment + "\"");
        }
        this.d_urlComment = comment;
    }

    public synchronized void setDomain(String domain) throws CookieCrumbleException {
        if (!Cookie.validValue(domain)) {
            throw new CookieCrumbleException("Cookie domain value is not valid \"" + domain + "\"");
        }
        this.d_domain = domain;
    }

    public synchronized void setMaxAge(int maxAge, Date created) throws CookieCrumbleException {
        if (maxAge >= 0 && created != null) {
            this.d_maxAge = maxAge;
            if (maxAge > 0) {
                this.d_expiration = new Date(created.getTime() + 1000L * (long)maxAge);
                if (!this.d_discardExplicit) {
                    this.d_discard = false;
                }
            } else {
                this.d_expiration = new Date(1L);
            }
        } else {
            throw new CookieCrumbleException("Cookie maximum age and/or creation date is illegal maxAge = " + maxAge);
        }
    }

    public synchronized void setPath(String path) throws CookieCrumbleException {
        if (!Cookie.validValue(path)) {
            throw new CookieCrumbleException("Cookie path is invalid \"" + path + "\"");
        }
        this.d_path = path;
    }

    public synchronized void setPorts(String ports) throws CookieCrumbleException {
        if (!Cookie.validValue(ports) || !Cookie.validPortList(ports)) {
            throw new CookieCrumbleException("Cookie port list is not valid \"" + ports + "\"");
        }
        this.d_ports = ports;
    }

    public synchronized void setSecure(boolean secure) {
        this.d_secure = secure;
    }

    public synchronized void setDiscardable(boolean discard) {
        this.d_discard = discard;
        this.d_discardExplicit = true;
    }

    public synchronized void setVersion(String version) {
        this.d_version = version;
    }

    public synchronized boolean hasExpired(long currentTime) {
        return this.d_expiration != null && this.d_expiration.getTime() <= currentTime;
    }

    public synchronized boolean isPortAllowed(int port) {
        if (this.d_ports == null) {
            return true;
        }
        StringTokenizer tok = new StringTokenizer(this.d_ports, ",");
        while (tok.hasMoreTokens()) {
            try {
                if (port != Integer.parseInt(tok.nextToken().trim())) continue;
                return true;
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        return false;
    }

    private boolean domainMatch(String hostname) {
        String effective = Cookie.effectiveHostname(hostname);
        if (this.d_domain.equalsIgnoreCase(effective)) {
            return true;
        }
        return effective.length() > this.d_domain.length() && this.d_domain.length() > 1 && this.d_domain.charAt(0) == '.' && effective.regionMatches(true, effective.length() - this.d_domain.length(), this.d_domain, 0, this.d_domain.length());
    }

    public synchronized boolean equals(Cookie c) {
        return this.d_name.equals(c.getName()) && this.d_domain.equalsIgnoreCase(c.getDomain()) && this.d_path.equals(c.getPath());
    }

    public synchronized boolean isRelevant(String hostname, String path, int port) {
        if (this.d_domain == null || this.d_path == null) {
            return false;
        }
        return this.domainMatch(hostname) && this.isPortAllowed(port) && path.startsWith(this.d_path);
    }

    public synchronized String toString() {
        StringBuffer result = new StringBuffer();
        result.append('\t').append(this.d_name).append("=\"").append(Cookie.encodeValue(this.d_value)).append("\"; $Path=\"").append(Cookie.encodeValue(this.d_path)).append('\"');
        return result.toString();
    }
}

