c
c     File:       exceptionclient.f
c     Copyright:  (c) 2001 The Regents of the University of California
c     Revision:   @(#) $Revision: 4434 $
c     Date:       $Date: 2005-03-17 09:05:29 -0800 (Thu, 17 Mar 2005) $
c     Description:Simple F77 exception test client
c
c

      subroutine starttest(number)
      implicit none
      integer*4 number
      integer*8 tracker
      call synch_RegOut_getInstance_f(tracker)
      call synch_RegOut_startPart_f(tracker, number)
      call synch_RegOut_deleteRef_f(tracker)
      end

      subroutine reporttest(test, number)
      implicit none
      integer*4 number
      integer*8 tracker
      logical test
      call synch_RegOut_getInstance_f(tracker)
      if (test) then
         call synch_RegOut_endPart_f(tracker, number, 0)
      else
         call synch_RegOut_endPart_f(tracker, number, 1)
      endif
      call synch_RegOut_deleteRef_f(tracker)
      number = number + 1
      end

      subroutine reportexc(exc)
      implicit none
      integer*8 exc
      character*(100) msg
      character*(1024) trace

      call sidl_SIDLException_getNote_f(exc, msg)
      write (6, 100) msg
      call sidl_SIDLException_getTrace_f(exc, trace)
      write (6, 110) trace
 100  format (1x, a100)
 110  format (1x, a1024)
      end

      subroutine testnone(fib, test)
      implicit none
      integer*8 fib
      integer*4 test
      integer*8 retval
      integer*8 exc

      call starttest(test)
      call ExceptionTest_Fib_getFib_f (fib, 10, 25, 200, 0, retval, 
     $                                 exc)
      if (exc .eq. 0) then
        call reporttest(.true., test)
        write (6, 100) retval
      else
        call reporttest(.false., test)
        call reportexc(exc)
        call sidl_SIDLException_deleteRef_f (exc)
      endif
 100  format ('fib= ', I4)
      end

      subroutine testneg(fib, test)
      implicit none
      integer*8 fib
      integer*4 test
      integer*8 retval
      integer*8 exc
      logical   isone

      call starttest(test)
      call ExceptionTest_Fib_getFib_f (fib, -1, 10, 10, 0, retval, 
     $                                 exc)
      if (exc .eq. 0) then
        call reporttest(.false., test)
        write (6, 100) retval
      else
        call sidl_SIDLException_isType_f (exc, 
     $          'ExceptionTest.NegativeValueException', isone)
        if (isone .eqv. .true.) then
          call reporttest(.true., test)
        else
          call reporttest(.false., test)
        endif
        call reportexc(exc)
        call sidl_SIDLException_deleteRef_f (exc)
      endif
 100  format ('fib= ', I4)
      end

      subroutine testdeep(fib, test)
      implicit none
      integer*8 fib
      integer*4 test
      integer*8 retval
      integer*8 exc
      logical   isone

      call starttest(test)
      call ExceptionTest_Fib_getFib_f (fib, 10, 1, 100, 0, retval, 
     $                                 exc)
      if (exc .eq. 0) then
        call reporttest(.false., test)
        write (6, 100) retval
      else
        call sidl_SIDLException_isType_f (exc, 
     $          'ExceptionTest.TooDeepException', isone)
        if (isone .eqv. .true.) then
          call reporttest(.true., test)
        else
          call reporttest(.false., test)
        endif
        call reportexc(exc)
        call sidl_SIDLException_deleteRef_f (exc)
      endif
 100  format ('fib= ', I4)
      end

      subroutine testbig(fib, test)
      implicit none
      integer*8 fib
      integer*4 test
      integer*8 retval
      integer*8 exc
      logical   isone

      call starttest(test)
      call ExceptionTest_Fib_getFib_f (fib, 10, 100, 1, 0, retval, 
     $                                 exc)
      if (exc .eq. 0) then
        call reporttest(.false., test)
        write (6, 100) retval
      else
        call sidl_SIDLException_isType_f (exc, 
     $          'ExceptionTest.TooBigException', isone)
        if (isone .eqv. .true.) then
          call reporttest(.true., test)
        else
          call reporttest(.false., test)
        endif
        call reportexc(exc)
        call sidl_SIDLException_deleteRef_f (exc)
      endif
 100  format ('fib= ', I4)
      end


      program exceptionclient
      implicit none
      integer*4 test
      integer*8 fib
      integer*8 retval, tracker

      call synch_RegOut_getInstance_f(tracker)
      call synch_RegOut_setExpectations_f(tracker, 4)
      call ExceptionTest_Fib__create_f (fib)

      test = 1

      call synch_RegOut_writeComment_f(tracker,
     $      'No Exception test')
      call testnone(fib, test)

      call synch_RegOut_writeComment_f(tracker,
     $     'Negative Value Exception test')
      call testneg(fib, test)
      call synch_RegOut_writeComment_f(tracker,
     $     'Too Deep Exception test')
      call testdeep(fib, test)
      call synch_RegOut_writeComment_f(tracker,
     $     'Too Big Exception test')
      call testbig(fib, test)

      call ExceptionTest_Fib_deleteRef_f (fib)
      call synch_RegOut_close_f(tracker)
      call synch_RegOut_deleteRef_f(tracker)
      end
