/*
 * File:          ExceptionTest_Fib_jniStub.c
 * Symbol:        ExceptionTest.Fib-v1.0
 * Symbol Type:   class
 * Babel Version: 0.10.2
 * Description:   Client-side JNI glue code for ExceptionTest.Fib
 * 
 * WARNING: Automatically generated; changes will be lost
 * 
 * babel-version = 0.10.2
 */

#include "sidl_Java.h"
#include "sidl_Loader.h"
#include "sidl_String.h"
#include "ExceptionTest_Fib_IOR.h"
#include "babel_config.h"

/*
 * Convert between jlong and void* pointers.
 */

#if (SIZEOF_VOID_P == 8)
#define JLONG_TO_POINTER(x) ((void*)(x))
#define POINTER_TO_JLONG(x) ((jlong)(x))
#else
#define JLONG_TO_POINTER(x) ((void*)(int32_t)(x))
#define POINTER_TO_JLONG(x) ((jlong)(int32_t)(x))
#endif

#ifndef NULL
#define NULL 0
#endif

/*
 * Function to extract IOR reference from the Java object.
 */

static struct ExceptionTest_Fib__object* _get_ior(
  JNIEnv* env,
  jobject obj)
{
  void* ptr = NULL;
  static jmethodID mid = (jmethodID) NULL;

  if (mid == (jmethodID) NULL) {
    jclass cls = (*env)->GetObjectClass(env, obj);
    mid = (*env)->GetMethodID(env, cls, "_get_ior", "()J");
    (*env)->DeleteLocalRef(env, cls);
  }

  ptr = JLONG_TO_POINTER((*env)->CallLongMethod(env, obj, mid));
  return (struct ExceptionTest_Fib__object*) ptr;
}

/*
 * External reference to IOR methods.
 */

static const struct ExceptionTest_Fib__external* s_external = NULL;

/*
 * Create object instance and return reference.
 */

static jlong jni__create_ior(
  JNIEnv* env,
  jclass  cls)
{
  (void) env;
  (void) cls;
  return POINTER_TO_JLONG((*s_external->createObject)());
}

/*
 * <p>
 * Generate the requested Fibonacci number or generate exceptions if
 * the input Fibonacci number is invalid or if any of the maximum depth
 * or maximum value parameters are exceeded.  The last argument of the
 * method should be zero.
 * </p>
 * <p>
 * The algorithm should be similar to the <code>Java</code> code below.
 * </p>
 * <pre>
 * public int getFib(int n, int max_depth, int max_value, int depth)
 *     throws NegativeValueException, FibException {
 * 
 *   if (n < 0) {
 *     throw new NegativeValueException("n negative");
 * 
 *   } else if (depth > max_depth) {
 *     throw new TooDeepException("too deep");
 * 
 *   } else if (n == 0) {
 *     return 1;
 * 
 *   } else if (n == 1) {
 *     return 1;
 * 
 *   } else {
 *     int a = getFib(n-1, max_depth, max_value, depth+1);
 *     int b = getFib(n-2, max_depth, max_value, depth+1);
 *     if (a + b > max_value) {
 *       throw new TooBigException("too big");
 *     }
 *     return a + b;
 *   }
 * } 
 * </pre>
 */

static jint
jni_getFib(
  JNIEnv* env,
  jobject obj,
  jint _arg_n,
  jint _arg_max_depth,
  jint _arg_max_value,
  jint _arg_depth)
{
  /*
   * Declare return and temporary variables.
   */

  struct ExceptionTest_Fib__object* _ior = NULL;
  int32_t _tmp_n = 0;
  int32_t _tmp_max_depth = 0;
  int32_t _tmp_max_value = 0;
  int32_t _tmp_depth = 0;
  int32_t _ior_res = 0;
  jint _res = 0;
  struct sidl_BaseInterface__object* _ex = NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  _tmp_n = (int32_t) _arg_n;
  _tmp_max_depth = (int32_t) _arg_max_depth;
  _tmp_max_value = (int32_t) _arg_max_value;
  _tmp_depth = (int32_t) _arg_depth;

  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(_ior->d_epv->f_getFib))(
    _ior,
    _tmp_n,
    _tmp_max_depth,
    _tmp_max_value,
    _tmp_depth,
    &_ex);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  _res = (jint) _ior_res;
  sidl_Java_CheckException(
    env,
    _ex,
    "ExceptionTest.NegativeValueException",
    "ExceptionTest.FibException",
    NULL);

  return _res;
}

/*
 * Register JNI methods with the Java JVM.
 */

void ExceptionTest_Fib__register(JNIEnv* env)
{
  JNINativeMethod methods[2];
  jclass cls;

#ifdef SIDL_STATIC_LIBRARY
  s_external = ExceptionTest_Fib__externals();
#else
  sidl_DLL dll = sidl_DLL__create();
  const struct ExceptionTest_Fib__external*(*dll_f)(void);
  /* check global namespace for symbol first */
  if (dll && sidl_DLL_loadLibrary(dll, "main:", TRUE, FALSE)) {
    dll_f =
      (const struct ExceptionTest_Fib__external*(*)(void)) 
        sidl_DLL_lookupSymbol(
        dll, "ExceptionTest_Fib__externals");
    s_external = (dll_f ? (*dll_f)() : NULL);
  }
  if (dll) sidl_DLL_deleteRef(dll);
  if (!s_external) {
    dll = sidl_Loader_findLibrary("ExceptionTest.Fib",
      "ior/impl", sidl_Scope_SCLSCOPE,
      sidl_Resolve_SCLRESOLVE);
    if (dll) {
      dll_f =
        (const struct ExceptionTest_Fib__external*(*)(void)) 
          sidl_DLL_lookupSymbol(
          dll, "ExceptionTest_Fib__externals");
      s_external = (dll_f ? (*dll_f)() : NULL);
      sidl_DLL_deleteRef(dll);
    }
  }
  if (!s_external) {
    jclass e = (*env)->FindClass(env, "java/lang/UnsatisfiedLinkError");
    if (e != NULL) {
      (*env)->ThrowNew(env, e, "Could not find implementation for sidl class ExceptionTest.Fib");
      (*env)->DeleteLocalRef(env, e);
    }
  }
#endif

  methods[0].name      = "_create_ior";
  methods[0].signature = "()J";
  methods[0].fnPtr     = (void *)jni__create_ior;
  methods[1].name      = "getFib";
  methods[1].signature = "(IIII)I";
  methods[1].fnPtr     = (void *)jni_getFib;


  cls = (*env)->FindClass(env, "ExceptionTest/Fib");
  if (cls) {
    (*env)->RegisterNatives(env, cls, methods, 2);
    (*env)->DeleteLocalRef(env, cls);
  }
}
