##
## File:        make.runF77
## Package:     Babel regression checks
## Revision:    $Revision: 4434 $
## Modified:    $Date: 2005-03-17 09:05:29 -0800 (Thu, 17 Mar 2005) $
## Description: automake makefile for run regression tests
##
## Copyright (c) 2000-2002, The Regents of the University of Calfornia.
## Produced at the Lawrence Livermore National Laboratory.
## Written by the Components Team <components@llnl.gov>
## UCRL-CODE-2002-054
## All rights reserved.
##
## This file is part of Babel. For more information, see
## http:##www.llnl.gov/CASC/components/. Please read the COPYRIGHT file
## for Our Notice and the LICENSE file for the GNU Lesser General Public
## License.
##
## This program is free software; you can redistribute it and/or modify it
## under the terms of the GNU Lesser General Public License (as published by
## the Free Software Foundation) version 2.1 dated February 1999.
##
## This program is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the IMPLIED WARRANTY OF
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the terms and
## conditions of the GNU Lesser General Public License for more details.
##
## You should have recieved a copy of the GNU Lesser General Public License
## along with this program; if not, write to the Free Software Foundation,
## Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

OUTPUTSIDL=$(srcdir)/../../output/output.sidl

if SUPPORT_FORTRAN77



check_PROGRAMS    = $(STATIC_PROGS) $(SHARED_PROGS)
check_SCRIPTS     = runAll.sh
check_LTLIBRARIES = libClient.la

BABELDIR    = $(top_builddir)/bin
INCLUDEDIR  = $(top_builddir)/runtime/sidl
INCLUDEDIR2 = .
LIBSIDL     = $(top_builddir)/runtime/sidl/libsidl.la
LIBSYNC     = ../../output/libC/libOutput.la
PUREBABELGEN = $(STUBSRCS) $(STUBFORTRANINC) $(IORHDRS) \
	$(synch_STUBSRCS) $(synch_STUBFORTRANINC) $(synch_IORHDRS)
DOCFILES = $(STUBDOCS) $(synch_STUBDOCS)
CLEANFILES = $(PUREBABELGEN) $(DOCFILES) babel-stamp babel-temp \
	stamp-installcheck core runAll

if SUPPORT_STATIC
if SUPPORT_FORTRAN90
  BABEL_STATIC_F90  = runF772F90
else
  BABEL_STATIC_F90  = 
endif
STATIC_PROGS       = runF772C runF772Cxx runF772F77 runF772UCxx $(BABEL_STATIC_F90)

runF772C_SOURCES        = $(TESTFILE)
runF772C_LDFLAGS        = -static
runF772C_LDADD          = libClient.la ../libC/libImpl.la \
			  $(LIBSYNC) $(LIBSIDL) $(FLIBS)
runF772C_LINK		= $(LINK) $(FMAIN)
# use C linker instead of F77 to avoid problem when compiling with Intel's
# icc with optimization (undefined _intel_fast_memcpy symbol)

runF772Cxx_SOURCES      = $(TESTFILE)
runF772Cxx_LDFLAGS      = -static
runF772Cxx_LDADD        = libClient.la ../libCxx/libImpl.la \
			  $(LIBSYNC) $(LIBSIDL) $(FLIBS)
runF772Cxx_LINK	 	= $(CXXLINK) $(FMAIN)

runF772UCxx_SOURCES      = $(TESTFILE)
runF772UCxx_LDFLAGS      = -static
runF772UCxx_DEPENDENCIES = libClient.la ../libUCxx/libImpl.la
runF772UCxx_LDADD        = libClient.la ../libUCxx/libImpl.la \
			  $(LIBSYNC) $(LIBSIDL) $(FLIBS)
runF772UCxx_LINK	 = $(CXXLINK) $(FMAIN)

runF772F77_SOURCES      = $(TESTFILE)
runF772F77_LDFLAGS      = -static
runF772F77_LDADD        = libClient.la ../libF77/libImpl.la \
			  $(LIBSYNC) $(LIBSIDL) $(FLIBS)
runF772F77_LINK		= $(LINK) $(FMAIN)
# use C linker instead of F77 to avoid problem when compiling with Intel's
# icc with optimization (undefined _intel_fast_memcpy symbol)

if SUPPORT_FORTRAN90
runF772F90_SOURCES      = $(TESTFILE)
runF772F90_LDFLAGS      = -static
runF772F90_LDADD        = libClient.la ../libF90/libImpl.la \
			  $(LIBSYNC) $(LIBSIDL) $(FLIBS) $(FCLIBS)
runF772F90_LINK		= $(LINK) $(FMAIN)
# use C linker instead of F77 to avoid problem when compiling with Intel's
# icc with optimization (undefined _intel_fast_memcpy symbol)
endif
endif

if SUPPORT_SHARED
SHARED_PROGS            = runAll
runAll_SOURCES          = $(TESTFILE)
runAll_LDFLAGS		= -dynamic
runAll_LDADD            = libClient.la $(LIBSYNC) $(LIBSIDL) $(FLIBS)
runAll_LINK		= $(LINK) $(FMAIN)
endif

nodist_libClient_la_SOURCES = $(PUREBABELGEN)
libClient_la_LIBADD       = $(LIBSYNC) $(LIBSIDL)
libClient_la_LDFLAGS      = -no-undefined -rpath `pwd`/.libs \
			    -release @VERSION@

EXTRA_DIST = babel.make synch_babel.make
AM_CPPFLAGS   = -I. -I$(INCLUDEDIR) -I$(INCLUDEDIR2)

$(PUREBABELGEN) $(DOCFILES) : babel-stamp
	@if test -f $@; then \
	  touch $@; \
	else \
	  rm -f babel-stamp; \
	  $(MAKE) $(AM_MAKEFLAGS) babel-stamp ; \
	fi

EXTRA_PROGRAMS  = force_cxx_linker
force_cxx_linker_SOURCES = force_cxx_linker.cc
endif

babel-stamp: $(SIDLFILE) $(OUTPUTSIDL)
	@rm -f babel-temp
	@touch babel-temp
	$(SHELL) $(BABELDIR)/babel --client=f77 \
		--suppress-timestamp $(SIDLFILE)
	$(SHELL) $(BABELDIR)/babel --client=f77 --make-prefix=synch_ \
	    --suppress-timestamp --exclude-external $(OUTPUTSIDL)
	@mv -f babel-temp $@

clean-local:
	test "X$(srcdir)" = "X." || rm -f babel.make synch_babel.make

update-babel-make: babel-stamp
	if test "X$(srcdir)" != "X."; then \
	   cp babel.make synch_babel.make $(srcdir); \
	fi

check-local:
	@if test -f stamp-installcheck; then		\
	  echo $(MAKE) $(AM_MAKEFLAGS) clean;		\
	  $(MAKE) $(AM_MAKEFLAGS) clean;		\
	fi
	$(MAKE) $(AM_MAKEFLAGS)  $(check_LTLIBRARIES) $(check_PROGRAMS) $(check_SCRIPTS)

installcheck-local:
	@if test ! -f stamp-installcheck; then		\
	  echo $(MAKE) $(AM_MAKEFLAGS) clean;		\
	  $(MAKE) $(AM_MAKEFLAGS) clean;		\
	fi
	$(MAKE) $(AM_MAKEFLAGS)				\
	  BABELDIR=$(bindir)				\
	  INCLUDEDIR=$(includedir)			\
	  INCLUDEDIR2=$(exec_prefix)/include		\
	  LIBSIDL=$(libdir)/libsidl.la  $(check_LTLIBRARIES) $(check_PROGRAMS) $(check_SCRIPTS)
	touch stamp-installcheck

# Make sure Makefile.in is newer than babel.make
dist-hook:
	touch -c $(distdir)/Makefile.in
