! 
! File:          Ordering_IntOrderTest_Impl.F90
! Symbol:        Ordering.IntOrderTest-v0.1
! Symbol Type:   class
! Babel Version: 0.10.2
! Description:   Server-side implementation for Ordering.IntOrderTest
! 
! WARNING: Automatically generated; only changes within splicers preserved
! 
! babel-version = 0.10.2
! 


! 
! Symbol "Ordering.IntOrderTest" (version 0.1)
! 
! This class provides methods to verify that the array ordering
! capabilities work for arrays of int.
! 


#include "Ordering_IntOrderTest_fAbbrev.h"
#include "sidl_ClassInfo_fAbbrev.h"
#include "sidl_BaseInterface_fAbbrev.h"
#include "sidl_BaseClass_fAbbrev.h"
#include "sidl_int_fAbbrev.h"
! DO-NOT-DELETE splicer.begin(_miscellaneous_code_start)

integer(selected_int_kind(9)) function iFunc(ind, dim)
  implicit none
  integer(selected_int_kind(9)) :: dim
  integer(selected_int_kind(9)), dimension(dim), intent(in) :: ind
  integer(selected_int_kind(9)) :: res, i
  res = 0
  do i=1, dim
     res = res + i * ind(i)
  enddo
  ifunc = res
end function iFunc

logical function isIMatrix_1(A)
  use sidl_int_array
  type(sidl_int_1d), intent(in) :: A
  integer(selected_int_kind(9)), dimension(1) :: ind, low, up
  integer(selected_int_kind(9)) :: i, iFunc
  isIMatrix_1 = .true.
  do i = 1, 1
     low(i) = lower(A, i-1)
     up(i) = upper(A, i-1)
  enddo
  do i = low(1), up(1)
     ind(1) = i
     if (iFunc(ind, 1) .ne. A%d_data(i)) then
        isIMatrix_1 = .false.
     endif
  enddo
end function isIMatrix_1

logical function isIMatrix_2(A)
  use sidl_int_array
  type(sidl_int_2d), intent(in) :: A
  integer(selected_int_kind(9)), dimension(2) :: ind, low, up
  integer(selected_int_kind(9)) :: i, j, iFunc
  isIMatrix_2 = .true.
  do i = 1, 2
     low(i) = lower(A, i-1)
     up(i) = upper(A, i-1)
  enddo
  do i = low(1), up(1)
     ind(1) = i
     do j = low(2), up(2)
        ind(2) = j
        if (iFunc(ind, 2) .ne. A%d_data(i,j)) then
           isIMatrix_2 = .false.
        endif
     enddo
  enddo
end function isIMatrix_2

logical function isIMatrix_4(A)
  use sidl_int_array
  type(sidl_int_4d), intent(in) :: A
  integer(selected_int_kind(9)), dimension(4) :: ind, low, up
  integer(selected_int_kind(9)) :: i, j, k, l, iFunc
  isIMatrix_4 = .true.
  do i = 1, 4
     low(i) = lower(A, i-1)
     up(i) = upper(A, i-1)
  enddo
  do i = low(1), up(1)
     ind(1) = i
     do j = low(2), up(2)
        ind(2) = j
        do  k = low(3), up(3)
           ind(3) = k
           do l = low(4), up(4)
              ind(4) = l
              if (iFunc(ind, 4) .ne. A%d_data(i,j,k,l)) then
                 isIMatrix_4 = .false.
              endif
           enddo
        enddo
     enddo
  enddo
end function isIMatrix_4

subroutine fillIMatrix_2(A)
  use sidl_int_array
  type(sidl_int_2d), intent(inout) :: A
  integer(selected_int_kind(9)), dimension(2) :: ind, low, up
  integer(selected_int_kind(9)) :: i, j, iFunc
  do i = 1, 2
     low(i) = lower(A, i-1)
     up(i) = upper(A, i-1)
  enddo
  do i = low(1), up(1)
     ind(1) = i
     do j = low(2), up(2)
        ind(2) = j
        if (mod(i+j,2) .eq. 1) then
           A%d_data(i,j) = iFunc(ind, 2)
        else
           call set(A, i, j, iFunc(ind, 2))
        endif
     enddo
  enddo
end subroutine fillIMatrix_2

subroutine fillIMatrix_4(A)
  use sidl_int_array
  type(sidl_int_4d), intent(inout) :: A
  integer(selected_int_kind(9)), dimension(4) :: ind, low, up
  integer(selected_int_kind(9)) :: i, j, k, l, iFunc
  do i = 1, 4
     low(i) = lower(A, i-1)
     up(i) = upper(A, i-1)
  enddo
  do i = low(1), up(1)
     ind(1) = i
     do j = low(2), up(2)
        ind(2) = j
        do  k = low(3), up(3)
           ind(3) = k
           do l = low(4), up(4)
              ind(4) = l
              if (mod(i+j+k+l, 2) .eq. 1) then
                 A%d_data(i,j,k,l) = iFunc(ind, 4)
              else
                 call set(A, ind, iFunc(ind, 4))
              endif
           enddo
        enddo
     enddo
  enddo
end subroutine fillIMatrix_4

! DO-NOT-DELETE splicer.end(_miscellaneous_code_start)




! 
! Class constructor called when the class is created.
! 

recursive subroutine Ordering_IntOrderTest__ctor_mi(self)
  use Ordering_IntOrderTest
  use Ordering_IntOrderTest_impl
  ! DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest._ctor.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(Ordering.IntOrderTest._ctor.use)
  implicit none
  type(Ordering_IntOrderTest_t) :: self ! in

! DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest._ctor)
! Insert the implementation here...
! DO-NOT-DELETE splicer.end(Ordering.IntOrderTest._ctor)
end subroutine Ordering_IntOrderTest__ctor_mi


! 
! Class destructor called when the class is deleted.
! 

recursive subroutine Ordering_IntOrderTest__dtor_mi(self)
  use Ordering_IntOrderTest
  use Ordering_IntOrderTest_impl
  ! DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest._dtor.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(Ordering.IntOrderTest._dtor.use)
  implicit none
  type(Ordering_IntOrderTest_t) :: self ! in

! DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest._dtor)
! Insert the implementation here...
! DO-NOT-DELETE splicer.end(Ordering.IntOrderTest._dtor)
end subroutine Ordering_IntOrderTest__dtor_mi


! 
! Static class initializer called exactly once before any user-defined method is dispatched
! 

recursive subroutine Ordering_IntOrderTest__load_mi()
  use Ordering_IntOrderTest
  use Ordering_IntOrderTest_impl
  ! DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest._load.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(Ordering.IntOrderTest._load.use)
  implicit none

! DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest._load)
! Insert the implementation here...
! DO-NOT-DELETE splicer.end(Ordering.IntOrderTest._load)
end subroutine Ordering_IntOrderTest__load_mi


! 
! Create a column-major matrix satisfying condition I.
! 

recursive subroutine makeColumnIMatrixz5ybfavnz3i_mi(size, useCreateCol,       &
  retval)
  use Ordering_IntOrderTest
  use sidl_int_array
  use Ordering_IntOrderTest_impl
  ! DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.makeColumnIMatrix.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.makeColumnIMatrix.use)
  implicit none
  integer (selected_int_kind(9)) :: size ! in
  logical :: useCreateCol ! in
  type(sidl_int_2d) :: retval ! out

! DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.makeColumnIMatrix)
  if (useCreateCol) then
     call create2dCol(size, size, retval)
  else
     call create2dRow(size, size, retval)
  endif
  call fillIMatrix_2(retval)
! DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.makeColumnIMatrix)
end subroutine makeColumnIMatrixz5ybfavnz3i_mi


! 
! Create a row-major matrix satisfying condition I.
! 

recursive subroutine Int_makeRowIMatrix8h06e37u6x_mi(size, useCreateRow,       &
  retval)
  use Ordering_IntOrderTest
  use sidl_int_array
  use Ordering_IntOrderTest_impl
  ! DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.makeRowIMatrix.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.makeRowIMatrix.use)
  implicit none
  integer (selected_int_kind(9)) :: size ! in
  logical :: useCreateRow ! in
  type(sidl_int_2d) :: retval ! out

! DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.makeRowIMatrix)
  if (useCreateRow) then
     call create2dRow(size, size, retval)
  else
     call create2dCol(size, size, retval)
  endif
  call fillIMatrix_2(retval)
! DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.makeRowIMatrix)
end subroutine Int_makeRowIMatrix8h06e37u6x_mi


! 
! Create a 4-D matrix satisfying condition I.  Each dimension has
! size elements numbers 0 through size-1.
! 

recursive subroutine IntOrd_makeIMatrixs68ixk4nld_mi(size, useCreateColumn,    &
  retval)
  use Ordering_IntOrderTest
  use sidl_int_array
  use Ordering_IntOrderTest_impl
  ! DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.makeIMatrix.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.makeIMatrix.use)
  implicit none
  integer (selected_int_kind(9)) :: size ! in
  logical :: useCreateColumn ! in
  type(sidl_int_4d) :: retval ! out

! DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.makeIMatrix)
  integer(selected_int_kind(9)) low(4), up(4), i
  do i = 1, 4
     low(i) = 0
     up(i) = size - 1
  enddo
  if (useCreateColumn) then
     call createCol(low, up, retval)
  else
     call createRow(low, up, retval)
  endif
  call fillIMatrix_4(retval)
! DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.makeIMatrix)
end subroutine IntOrd_makeIMatrixs68ixk4nld_mi


! 
! Create a column-major matrix satisfying condition I.
! 

recursive subroutine createColumnIMatrij98n1gtwcu_mi(size, useCreateCol, res)
  use Ordering_IntOrderTest
  use sidl_int_array
  use Ordering_IntOrderTest_impl
  ! DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.createColumnIMatrix.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.createColumnIMatrix.use)
  implicit none
  integer (selected_int_kind(9)) :: size ! in
  logical :: useCreateCol ! in
  type(sidl_int_2d) :: res ! out

! DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.createColumnIMatrix)
  if (useCreateCol) then
     call makeColumnIMatrix(size, .true., res)
  else
     call makeRowIMatrix(size, .true., res)
  endif
! DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.createColumnIMatrix)
end subroutine createColumnIMatrij98n1gtwcu_mi


! 
! Create a row-major matrix satisfying condition I.
! 

recursive subroutine I_createRowIMatrixq_lpgbci6l_mi(size, useCreateRow, res)
  use Ordering_IntOrderTest
  use sidl_int_array
  use Ordering_IntOrderTest_impl
  ! DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.createRowIMatrix.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.createRowIMatrix.use)
  implicit none
  integer (selected_int_kind(9)) :: size ! in
  logical :: useCreateRow ! in
  type(sidl_int_2d) :: res ! out

! DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.createRowIMatrix)
  if (useCreateRow) then
     call makeRowIMatrix(size, .true., res)
  else
     call makeColumnIMatrix(size, .true., res)
  endif
! DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.createRowIMatrix)
end subroutine I_createRowIMatrixq_lpgbci6l_mi


! 
! Make sure an array is column-major.  No changes to the dimension or
! values in a are made.
! 

recursive subroutine IntOr_ensureColumno2tek0_o3o_mi(a)
  use Ordering_IntOrderTest
  use sidl_int_array
  use Ordering_IntOrderTest_impl
  ! DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.ensureColumn.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.ensureColumn.use)
  implicit none
  type(sidl_int_2d) :: a ! inout

! DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.ensureColumn)
!     no action required
! DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.ensureColumn)
end subroutine IntOr_ensureColumno2tek0_o3o_mi


! 
! Make sure an array is row-major.  No changes to the dimension or
! values in a are made.
! 

recursive subroutine IntOrder_ensureRow2xbnpv1nvt_mi(a)
  use Ordering_IntOrderTest
  use sidl_int_array
  use Ordering_IntOrderTest_impl
  ! DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.ensureRow.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.ensureRow.use)
  implicit none
  type(sidl_int_2d) :: a ! inout

! DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.ensureRow)
!     no action required
! DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.ensureRow)
end subroutine IntOrder_ensureRow2xbnpv1nvt_mi


! 
!  Return <code>true</code> iff the implementation sees
!  an incoming array satisfying condition I.
! 

recursive subroutine IntOr_isIMatrixOne3gwlgypfcv_mi(A, retval)
  use Ordering_IntOrderTest
  use sidl_int_array
  use Ordering_IntOrderTest_impl
  ! DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.isIMatrixOne.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.isIMatrixOne.use)
  implicit none
  type(sidl_int_1d) :: A ! in
  logical :: retval ! out

! DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.isIMatrixOne)
  logical isIMatrix_1
  retval = isIMatrix_1(A)
! DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.isIMatrixOne)
end subroutine IntOr_isIMatrixOne3gwlgypfcv_mi


! 
! Return <code>true</code> iff the implementation sees
! an incoming column-major array satisfying condition I.
! 

recursive subroutine isColumnIMatrixOned9rdelopb9_mi(A, retval)
  use Ordering_IntOrderTest
  use sidl_int_array
  use Ordering_IntOrderTest_impl
  ! DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.isColumnIMatrixOne.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.isColumnIMatrixOne.use)
  implicit none
  type(sidl_int_1d) :: A ! in
  logical :: retval ! out

! DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.isColumnIMatrixOne)
  logical acol, isIMatrix_1
  acol = isColumnOrder(A)
  retval = acol .and. isIMatrix_1(A)
! DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.isColumnIMatrixOne)
end subroutine isColumnIMatrixOned9rdelopb9_mi


! 
! Return <code>true</code> iff the implementation sees
! an incoming row-major array satisfying condition I.
! 

recursive subroutine In_isRowIMatrixOne607iplqtr5_mi(A, retval)
  use Ordering_IntOrderTest
  use sidl_int_array
  use Ordering_IntOrderTest_impl
  ! DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.isRowIMatrixOne.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.isRowIMatrixOne.use)
  implicit none
  type(sidl_int_1d) :: A ! in
  logical :: retval ! out

! DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.isRowIMatrixOne)
  logical arow, isIMatrix_1
  arow = isRowOrder(A)
  retval = arow .and. isIMatrix_1(A)
! DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.isRowIMatrixOne)
end subroutine In_isRowIMatrixOne607iplqtr5_mi


! 
!  Return <code>true</code> iff the implementation sees
!  an incoming array satisfying condition I.
! 

recursive subroutine IntOr_isIMatrixTwogo7_eewh9w_mi(A, retval)
  use Ordering_IntOrderTest
  use sidl_int_array
  use Ordering_IntOrderTest_impl
  ! DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.isIMatrixTwo.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.isIMatrixTwo.use)
  implicit none
  type(sidl_int_2d) :: A ! in
  logical :: retval ! out

! DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.isIMatrixTwo)
  logical isIMatrix_2
  retval = isIMatrix_2(A)
! DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.isIMatrixTwo)
end subroutine IntOr_isIMatrixTwogo7_eewh9w_mi


! 
! Return <code>true</code> iff the implementation sees
! an incoming column-major array satisfying condition I.
! 

recursive subroutine isColumnIMatrixTwo9neer9_rft_mi(A, retval)
  use Ordering_IntOrderTest
  use sidl_int_array
  use Ordering_IntOrderTest_impl
  ! DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.isColumnIMatrixTwo.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.isColumnIMatrixTwo.use)
  implicit none
  type(sidl_int_2d) :: A ! in
  logical :: retval ! out

! DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.isColumnIMatrixTwo)
  logical acol, isIMatrix_2
  acol = isColumnOrder(A)
  retval = acol .and. isIMatrix_2(A)
! DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.isColumnIMatrixTwo)
end subroutine isColumnIMatrixTwo9neer9_rft_mi


! 
! Return <code>true</code> iff the implementation sees
! an incoming row-major array satisfying condition I.
! 

recursive subroutine In_isRowIMatrixTwoqo0guawv83_mi(A, retval)
  use Ordering_IntOrderTest
  use sidl_int_array
  use Ordering_IntOrderTest_impl
  ! DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.isRowIMatrixTwo.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.isRowIMatrixTwo.use)
  implicit none
  type(sidl_int_2d) :: A ! in
  logical :: retval ! out

! DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.isRowIMatrixTwo)
  logical arow, isIMatrix_2
  arow = isRowOrder(A)
  retval = arow .and. isIMatrix_2(A)
! DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.isRowIMatrixTwo)
end subroutine In_isRowIMatrixTwoqo0guawv83_mi


! 
!  Return <code>true</code> iff the implementation sees
!  an incoming array satisfying condition I.
! 

recursive subroutine IntO_isIMatrixFourgf7n_6hyd2_mi(A, retval)
  use Ordering_IntOrderTest
  use sidl_int_array
  use Ordering_IntOrderTest_impl
  ! DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.isIMatrixFour.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.isIMatrixFour.use)
  implicit none
  type(sidl_int_4d) :: A ! in
  logical :: retval ! out

! DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.isIMatrixFour)
  logical isIMatrix_4
  retval = isIMatrix_4(A)
! DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.isIMatrixFour)
end subroutine IntO_isIMatrixFourgf7n_6hyd2_mi


! 
! Return <code>true</code> iff the implementation sees
! an incoming column-major array satisfying condition I.
! 

recursive subroutine isColumnIMatrixFouunjqbwfb23_mi(A, retval)
  use Ordering_IntOrderTest
  use sidl_int_array
  use Ordering_IntOrderTest_impl
  ! DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.isColumnIMatrixFour.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.isColumnIMatrixFour.use)
  implicit none
  type(sidl_int_4d) :: A ! in
  logical :: retval ! out

! DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.isColumnIMatrixFour)
  logical acol, isIMatrix_4
  acol = isColumnOrder(A)
  retval = acol .and. isIMatrix_4(A)
! DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.isColumnIMatrixFour)
end subroutine isColumnIMatrixFouunjqbwfb23_mi


! 
! Return <code>true</code> iff the implementation sees
! an incoming row-major array satisfying condition I.
! 

recursive subroutine I_isRowIMatrixFourfai8pehvh9_mi(A, retval)
  use Ordering_IntOrderTest
  use sidl_int_array
  use Ordering_IntOrderTest_impl
  ! DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.isRowIMatrixFour.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.isRowIMatrixFour.use)
  implicit none
  type(sidl_int_4d) :: A ! in
  logical :: retval ! out

! DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.isRowIMatrixFour)
  logical arow, isIMatrix_4
  arow = isRowOrder(A)
  retval = arow .and. isIMatrix_4(A)
! DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.isRowIMatrixFour)
end subroutine I_isRowIMatrixFourfai8pehvh9_mi


! 
! Return <code>true</code> iff the implementation of slice
! and smart copy is correct.
! 

recursive subroutine Int_isSliceWorkingf42w8d0h4b_mi(useCreateCol, retval)
  use Ordering_IntOrderTest
  use Ordering_IntOrderTest_impl
  ! DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.isSliceWorking.use)
  use sidl_int_array
  ! DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.isSliceWorking.use)
  implicit none
  logical :: useCreateCol ! in
  logical :: retval ! out

! DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.isSliceWorking)
  integer(selected_int_kind(9)) :: maxDim, halfDim, ind(2), &
       astride(2), numElem(2)
  integer(selected_int_kind(9)) :: newIndex(2), dim, Aelem, &
       Belem, iFunc
  type(sidl_int_2d) :: A, B
  retval = .true.
  maxDim = 16
  halfDim = maxDim / 2
  astride(1) = 2
  astride(2) = 2
  numElem(1) = halfDim
  numElem(2) = halfDim
  ind(1) = 0
  ind(2) = 0
  newIndex(1) = 0
  newIndex(2) = 0
  call set_null(A)
  call set_null(B)
  if (useCreateCol) then
     call makeColumnIMatrix(maxDim, .false., A)
  else
     call makeRowIMatrix(maxDim, .false., A)
  endif
  call slice(A, numElem, ind, astride, newIndex, B)
  if (is_null(B)) then 
     retval = .false.
     goto 100
  endif
  dim = dimen(B)
  if (dim .ne. 2) then
     retval = .false.
     goto 100
  endif

  do while (newIndex(2) .lt. halfDim)
     do while (newIndex(1) .lt. halfDim)
        call get(A, ind, Aelem)
        call get(B, newIndex, Belem)
        if ((Aelem .ne. Belem) .or.  Belem .ne. iFunc(ind, 2)) then
           retval = .false.
           goto 100
        endif
        newIndex(1) = newIndex(1) + 1
        ind(1) = ind(1) + 2
     enddo
     newIndex(2) = newIndex(2) + 1
     ind(2) = ind(2) + 2
  enddo

  ! CLEANUP AND RETURN
100 if (not_null(A)) then
     call deleteRef(A)
  endif
  if (not_null(B)) then
     call deleteRef(B)
  endif
! DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.isSliceWorking)
end subroutine Int_isSliceWorkingf42w8d0h4b_mi


! DO-NOT-DELETE splicer.begin(_miscellaneous_code_end)
! Insert extra code here...
! DO-NOT-DELETE splicer.end(_miscellaneous_code_end)
