/*
 * File:        orderingtests.c
 * Copyright:   (c) 2002 The Regents of the University of California
 * Revision:    @(#) $Revision: 4434 $
 * Date:        $Date: 2005-03-17 09:05:29 -0800 (Thu, 17 Mar 2005) $
 * Description: Regression test for array ordering code
 *
 */

#include "Ordering_IntOrderTest.h"
#include <stdio.h>
#include <stdlib.h>
#include "synch.h"


static void declare_part(synch_RegOut tracker, int * part_no ) {
  synch_RegOut_startPart(tracker, ++(*part_no));
}

static void end_part( synch_RegOut tracker, int part_no, 
                      enum synch_ResultType__enum result) 
{
  synch_RegOut_endPart(tracker, part_no, result);
}

/**
 * Fill the stack with random junk.
 */
int clearstack(int magicNumber) {
  int chunk[2048], i;
  for(i = 0; i < 2048; i++){
    chunk[i] = rand() + magicNumber;
  }
  for(i = 0; i < 16; i++){
    magicNumber += chunk[rand() & 2047];
  }
  return magicNumber;
}

#define MYASSERT( AAA ) \
  declare_part(tracker,  &part_no ); \
  magicNumber = clearstack(magicNumber); \
  synch_RegOut_writeComment(tracker, #AAA); \
  if ( AAA ) result = synch_ResultType_PASS; \
  else result = synch_ResultType_FAIL;  \
  end_part( tracker, part_no, result);


static const int arraySize = 7;

static struct sidl_int__array*
make1DIMatrix(const int32_t size)
{
  struct sidl_int__array *result=NULL;
  int32_t i;
  result = sidl_int__array_create1d(size);
  for(i = 0; i < size; ++i ){
    sidlArrayElem1(result, i) = i;
  }
  return result;
}

int main(int argc, char **argv)
{
  int magicNumber = 1;
  enum synch_ResultType__enum result = synch_ResultType_PASS;
  synch_RegOut tracker = synch_RegOut__create();
  int part_no = 0;
  
  struct sidl_int__array *A = NULL;
  synch_RegOut_setExpectations(tracker, 32);
  A = Ordering_IntOrderTest_makeColumnIMatrix(arraySize, TRUE);
  MYASSERT(A && sidl_int__array_isColumnOrder(A));
  MYASSERT(Ordering_IntOrderTest_isIMatrixTwo(A));
  MYASSERT(Ordering_IntOrderTest_isColumnIMatrixTwo(A));
  MYASSERT(Ordering_IntOrderTest_isRowIMatrixTwo(A));
  Ordering_IntOrderTest_ensureRow(&A);
  MYASSERT(A && sidl_int__array_isRowOrder(A) &&
           Ordering_IntOrderTest_isIMatrixTwo(A));
  Ordering_IntOrderTest_ensureColumn(&A);
  MYASSERT(A && sidl_int__array_isColumnOrder(A) &&
           Ordering_IntOrderTest_isIMatrixTwo(A));
  Ordering_IntOrderTest_ensureRow(&A);
  MYASSERT(A && sidl_int__array_isRowOrder(A) &&
           Ordering_IntOrderTest_isIMatrixTwo(A));
  Ordering_IntOrderTest_ensureColumn(&A);
  MYASSERT(A && sidl_int__array_isColumnOrder(A) &&
           Ordering_IntOrderTest_isIMatrixTwo(A));
  sidl_int__array_deleteRef(A); A = NULL;

  A = Ordering_IntOrderTest_makeColumnIMatrix(arraySize, FALSE);
  MYASSERT(A && sidl_int__array_isColumnOrder(A));
  MYASSERT(Ordering_IntOrderTest_isIMatrixTwo(A));
  sidl_int__array_deleteRef(A); A = NULL;

  A = Ordering_IntOrderTest_makeRowIMatrix(arraySize, TRUE);
  MYASSERT(A && sidl_int__array_isRowOrder(A));
  MYASSERT(Ordering_IntOrderTest_isIMatrixTwo(A));
  MYASSERT(Ordering_IntOrderTest_isColumnIMatrixTwo(A));
  MYASSERT(Ordering_IntOrderTest_isRowIMatrixTwo(A));
  sidl_int__array_deleteRef(A); A = NULL;

  A = Ordering_IntOrderTest_makeRowIMatrix(arraySize, FALSE);
  MYASSERT(A && sidl_int__array_isRowOrder(A));
  MYASSERT(Ordering_IntOrderTest_isIMatrixTwo(A));
  sidl_int__array_deleteRef(A); A = NULL;

  Ordering_IntOrderTest_createColumnIMatrix(arraySize, TRUE, &A);
  MYASSERT(A && sidl_int__array_isColumnOrder(A));
  MYASSERT(Ordering_IntOrderTest_isIMatrixTwo(A));
  sidl_int__array_deleteRef(A); A = NULL;

  Ordering_IntOrderTest_createColumnIMatrix(arraySize, FALSE, &A);
  MYASSERT(A && sidl_int__array_isColumnOrder(A));
  MYASSERT(Ordering_IntOrderTest_isIMatrixTwo(A));
  sidl_int__array_deleteRef(A); A = NULL;

  Ordering_IntOrderTest_createRowIMatrix(arraySize, TRUE, &A);
  MYASSERT(A && sidl_int__array_isRowOrder(A));
  MYASSERT(Ordering_IntOrderTest_isIMatrixTwo(A));
  sidl_int__array_deleteRef(A); A = NULL;

  Ordering_IntOrderTest_createRowIMatrix(arraySize, FALSE, &A);
  MYASSERT(A && sidl_int__array_isRowOrder(A));
  MYASSERT(Ordering_IntOrderTest_isIMatrixTwo(A));
  sidl_int__array_deleteRef(A); A = NULL;

  A = Ordering_IntOrderTest_makeIMatrix(arraySize, TRUE);
  MYASSERT(A && Ordering_IntOrderTest_isIMatrixFour(A));
  MYASSERT(Ordering_IntOrderTest_isColumnIMatrixFour(A));
  MYASSERT(Ordering_IntOrderTest_isRowIMatrixFour(A));
  sidl_int__array_deleteRef(A); A = NULL;

  A = make1DIMatrix(arraySize);
  MYASSERT(A && Ordering_IntOrderTest_isIMatrixOne(A));
  MYASSERT(Ordering_IntOrderTest_isColumnIMatrixOne(A));
  MYASSERT(Ordering_IntOrderTest_isRowIMatrixOne(A));
  sidl_int__array_deleteRef(A); A = NULL;

  MYASSERT(Ordering_IntOrderTest_isSliceWorking(TRUE));
  MYASSERT(Ordering_IntOrderTest_isSliceWorking(FALSE));

  synch_RegOut_close(tracker);
  synch_RegOut_deleteRef(tracker);
  return 0;
}
