/*
 * File:          sidl_BaseInterface_jniStub.c
 * Symbol:        sidl.BaseInterface-v0.9.1
 * Symbol Type:   interface
 * Babel Version: 0.10.2
 * Release:       $Name:  $
 * Revision:      @(#) $Id: $
 * Description:   Client-side JNI glue code for sidl.BaseInterface
 * 
 * Copyright (c) 2000-2002, The Regents of the University of California.
 * Produced at the Lawrence Livermore National Laboratory.
 * Written by the Components Team <components@llnl.gov>
 * All rights reserved.
 * 
 * This file is part of Babel. For more information, see
 * http://www.llnl.gov/CASC/components/. Please read the COPYRIGHT file
 * for Our Notice and the LICENSE file for the GNU Lesser General Public
 * License.
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License (as published by
 * the Free Software Foundation) version 2.1 dated February 1999.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the IMPLIED WARRANTY OF
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the terms and
 * conditions of the GNU Lesser General Public License for more details.
 * 
 * You should have recieved a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 * WARNING: Automatically generated; changes will be lost
 * 
 * babel-version = 0.10.2
 */

#include "sidl_Java.h"
#include "sidl_Loader.h"
#include "sidl_String.h"
#include "sidl_BaseInterface_IOR.h"
#include "babel_config.h"

/*
 * Convert between jlong and void* pointers.
 */

#if (SIZEOF_VOID_P == 8)
#define JLONG_TO_POINTER(x) ((void*)(x))
#define POINTER_TO_JLONG(x) ((jlong)(x))
#else
#define JLONG_TO_POINTER(x) ((void*)(int32_t)(x))
#define POINTER_TO_JLONG(x) ((jlong)(int32_t)(x))
#endif

#ifndef NULL
#define NULL 0
#endif

/*
 * Function to extract IOR reference from the Java object.
 */

static struct sidl_BaseInterface__object* _get_ior(
  JNIEnv* env,
  jobject obj)
{
  void* ptr = NULL;
  static jmethodID mid = (jmethodID) NULL;

  if (mid == (jmethodID) NULL) {
    jclass cls = (*env)->GetObjectClass(env, obj);
    mid = (*env)->GetMethodID(env, cls, "_get_ior", "()J");
    (*env)->DeleteLocalRef(env, cls);
  }

  ptr = JLONG_TO_POINTER((*env)->CallLongMethod(env, obj, mid));
  return (struct sidl_BaseInterface__object*) ptr;
}

/*
 * <p>
 * Add one to the intrinsic reference count in the underlying object.
 * Object in <code>sidl</code> have an intrinsic reference count.
 * Objects continue to exist as long as the reference count is
 * positive. Clients should call this method whenever they
 * create another ongoing reference to an object or interface.
 * </p>
 * <p>
 * This does not have a return value because there is no language
 * independent type that can refer to an interface or a
 * class.
 * </p>
 */

static void
jni_addRef(
  JNIEnv* env,
  jobject obj)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_BaseInterface__object* _ior = NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);

  /*
   * Call the IOR method through the EPV.
   */

  (*(_ior->d_epv->f_addRef))(
    _ior->d_object);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

}

/*
 * Decrease by one the intrinsic reference count in the underlying
 * object, and delete the object if the reference is non-positive.
 * Objects in <code>sidl</code> have an intrinsic reference count.
 * Clients should call this method whenever they remove a
 * reference to an object or interface.
 */

static void
jni_deleteRef(
  JNIEnv* env,
  jobject obj)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_BaseInterface__object* _ior = NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);

  /*
   * Call the IOR method through the EPV.
   */

  (*(_ior->d_epv->f_deleteRef))(
    _ior->d_object);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

}

/*
 * Return true if and only if <code>obj</code> refers to the same
 * object as this object.
 */

static jboolean
jni_isSame(
  JNIEnv* env,
  jobject obj,
  jobject _arg_iobj)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_BaseInterface__object* _ior = NULL;
  struct sidl_BaseInterface__object* _tmp_iobj = (struct 
    sidl_BaseInterface__object*) NULL;
  sidl_bool _ior_res = FALSE;
  jboolean _res = JNI_FALSE;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  _tmp_iobj = (struct sidl_BaseInterface__object*) sidl_Java_J2I_ifc(env,
    _arg_iobj, "sidl.BaseInterface");

  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(_ior->d_epv->f_isSame))(
    _ior->d_object,
    _tmp_iobj);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  _res = (jboolean) _ior_res;

  return _res;
}

/*
 * Check whether the object can support the specified interface or
 * class.  If the <code>sidl</code> type name in <code>name</code>
 * is supported, then a reference to that object is returned with the
 * reference count incremented.  The callee will be responsible for
 * calling <code>deleteRef</code> on the returned object.  If
 * the specified type is not supported, then a null reference is
 * returned.
 */

static jobject
jni_queryInt(
  JNIEnv* env,
  jobject obj,
  jstring _arg_name)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_BaseInterface__object* _ior = NULL;
  char* _tmp_name = (char*) NULL;
  struct sidl_BaseInterface__object* _ior_res = (struct 
    sidl_BaseInterface__object*) NULL;
  jobject _res = (jobject) NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  _tmp_name = sidl_Java_J2I_string(env, _arg_name);

  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(_ior->d_epv->f_queryInt))(
    _ior->d_object,
    _tmp_name);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  sidl_String_free(_tmp_name);
  _res = sidl_Java_I2J_ifc(env, _ior_res, "sidl.BaseInterface");

  return _res;
}

/*
 * Return whether this object is an instance of the specified type.
 * The string name must be the <code>sidl</code> type name.  This
 * routine will return <code>true</code> if and only if a cast to
 * the string type name would succeed.
 */

static jboolean
jni_isType(
  JNIEnv* env,
  jobject obj,
  jstring _arg_name)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_BaseInterface__object* _ior = NULL;
  char* _tmp_name = (char*) NULL;
  sidl_bool _ior_res = FALSE;
  jboolean _res = JNI_FALSE;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  _tmp_name = sidl_Java_J2I_string(env, _arg_name);

  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(_ior->d_epv->f_isType))(
    _ior->d_object,
    _tmp_name);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  sidl_String_free(_tmp_name);
  _res = (jboolean) _ior_res;

  return _res;
}

/*
 * Return the meta-data about the class implementing this interface.
 */

static jobject
jni_getClassInfo(
  JNIEnv* env,
  jobject obj)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_BaseInterface__object* _ior = NULL;
  struct sidl_ClassInfo__object* _ior_res = (struct sidl_ClassInfo__object*) 
    NULL;
  jobject _res = (jobject) NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);

  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(_ior->d_epv->f_getClassInfo))(
    _ior->d_object);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  _res = sidl_Java_I2J_ifc(env, _ior_res, "sidl.ClassInfo");

  return _res;
}

/**
 * Local utility function to extract the array pointer from the Java object.
 * Extract the d_array long data member and convert it to a pointer.
 */
static struct sidl_BaseInterface__array* sidl_BaseInterface__getptr(
JNIEnv* env,
jobject obj)
{
  void* ptr = NULL;
  static jfieldID s_array_field = NULL;

  if (s_array_field == NULL) {
    jclass cls = (*env)->GetObjectClass(env, obj);
    s_array_field = (*env)->GetFieldID(env, cls, "d_array", "J");
    (*env)->DeleteLocalRef(env, cls);
  }

  ptr = JLONG_TO_POINTER((*env)->GetLongField(env, obj, s_array_field));
  return (struct sidl_BaseInterface__array*) ptr;
}

/**
 * Local utility function to set the array pointer on the Java object.
 * Convert the pointer to a long value and set the d_array data member.
 */
static void sidl_BaseInterface__setptr(
JNIEnv* env,
jobject obj,
struct sidl_BaseInterface__array* array)
{
  static jfieldID s_array_field = NULL;

  if (s_array_field == NULL) {
    jclass cls = (*env)->GetObjectClass(env, obj);
    s_array_field = (*env)->GetFieldID(env, cls, "d_array", "J");
    (*env)->DeleteLocalRef(env, cls);
  }

  (*env)->SetLongField(env, obj, s_array_field, POINTER_TO_JLONG(array));
}

/**
 * Native routine to fetch the specified value from the array.  The
 * specified array index/indices must be lie between the array lower
 * upper bounds (inclusive).  Invalid indices will have unpredictable
 * (but almost certainly bad) results.
 */
static jobject sidl_BaseInterface__get(
JNIEnv* env,
jobject obj,
jint i,
jint j,
jint k,
jint l,
jint m,
jint n,
jint o)
{
  struct sidl_BaseInterface__array* array = sidl_BaseInterface__getptr(env,
    obj);
  struct sidl_BaseInterface__object* value = NULL;
  struct sidl_BaseClass__object* bclass = NULL;
  jobject ret = NULL;
  int32_t a[7];
  a[0] = i;
  a[1] = j;
  a[2] = k;
  a[3] = l;
  a[4] = m;
  a[5] = n;
  a[6] = o;

  value = sidl_BaseInterface__array_get(array, a);
  bclass = sidl_BaseClass__cast(value);
  ret = sidl_Java_I2J_ifc(env, bclass, "sidl.BaseInterface");
  return ret;
}

/**
 * Native routine to set the specified value in the array.  The
 * specified array index/indices must be lie between the array lower
 * upper bounds (inclusive).  Invalid indices will have unpredictable
 * (but almost certainly bad) results.
 */
static void sidl_BaseInterface__set(
JNIEnv* env,
jobject obj,
jint i,
jint j,
jint k,
jint l,
jint m, 
jint n, 
jint o,
jobject value)
{
  struct sidl_BaseInterface__array* array = sidl_BaseInterface__getptr(env,
    obj);

  sidl_BaseInterface vpointer = sidl_Java_J2I_cls(env, value);
  int32_t a[7];
  a[0] = i;
  a[1] = j;
  a[2] = k;
  a[3] = l;
  a[4] = m;
  a[5] = n;
  a[6] = o;
  sidl_BaseInterface__array_set(array, a, vpointer);
}
/**
 * Native routine to reallocate data in the array.  The specified array
 * dimension and indices must match and be within valid ranges (e.g., the
 * upper bounds must be greater than or equal to lowe rbounds.  Invalid
 * indices will have unpredictable (but almost certainly bad) results.
 * This routine will deallocate the existing array data if it is not null.
 */
static void sidl_BaseInterface__reallocate(
JNIEnv* env,
jobject obj,
jint dim,
jarray lower,
jarray upper,
jboolean isRow)
{
  jint l[7];
  jint u[7];
  struct sidl_BaseInterface__array* array = NULL;
  struct sidl_BaseInterface__array* orig = sidl_BaseInterface__getptr(env,obj);
  int32_t i, lenl, lenu = 0;

  for(i=0; i < 7; ++i) {
    l[i] = 0;
    u[i] = 0;
  }
  lenl = (*env)->GetArrayLength(env, lower);
  lenu = (*env)->GetArrayLength(env, upper);


  sidl_BaseInterface__array_deleteRef(orig);
  (*env)->GetIntArrayRegion(env, lower, 0, lenl, (int32_t*)l);
  (*env)->GetIntArrayRegion(env, upper, 0, lenu, (int32_t*)u);


  if(isRow) 
    array = sidl_BaseInterface__array_createRow((int32_t) dim, (int32_t*) l,
      (int32_t*) u);
  else
    array = sidl_BaseInterface__array_createCol((int32_t) dim, (int32_t*) l,
      (int32_t*) u);


  sidl_BaseInterface__setptr(env, obj, array);
}

/**
 * 
 * Native function copies every element of an array to an array of the
 * same dimensionality, size, and type 
 * 
 */
static void sidl_BaseInterface__copy(
JNIEnv* env,
jobject obj,
jobject dest)
{
  struct sidl_BaseInterface__array* csrc = sidl_BaseInterface__getptr(env, obj);
  struct sidl_BaseInterface__array* cdest = sidl_BaseInterface__getptr(env,
    dest);

  if(csrc && cdest) {
    sidl_BaseInterface__array_copy(csrc,cdest);
    } 

  }

/**
 * 
 * Native function slices arrays in various ways
 * 
 */
static jobject sidl_BaseInterface__slice(
JNIEnv* env,
jobject obj, 
jint dimen, 
jintArray numElem, 
jintArray srcStart, 
jintArray srcStride,
jintArray newStart)
{
  struct sidl_BaseInterface__array* array = sidl_BaseInterface__getptr(env,
    obj);
  struct sidl_BaseInterface__array* ret_ptr = NULL;
  jobject ret_array = NULL;
  int cnumElem[7];
  int csrcStart[7];
  int csrcStride[7];
  int cnewStart[7]; 
  int i = 0; 
  for(i = 0; i < 7; ++i) {  /*Make sure the array are clean*/ 
    cnumElem[i] = 0;
    csrcStart[i] = 0;
    csrcStride[i] = 0;
    cnewStart[i] = 0;
    }

  if(numElem == NULL)
  return NULL;  /*If numElem is NULL, we need to return Null, that's bad.*/

  (*env)->GetIntArrayRegion(env, numElem, 0,
  (*env)->GetArrayLength(env, numElem), cnumElem);  

  if(srcStart != NULL)
  (*env)->GetIntArrayRegion(env, srcStart, 0, 
  (*env)->GetArrayLength(env, srcStart), csrcStart);  

  if(srcStride != NULL)
  (*env)->GetIntArrayRegion(env, srcStride, 0, 
  (*env)->GetArrayLength(env, srcStride), csrcStride);  

  if(newStart != NULL)
  (*env)->GetIntArrayRegion(env, newStart, 0, 
  (*env)->GetArrayLength(env, newStart), cnewStart);    


  if (array != NULL) {
    ret_ptr = sidl_BaseInterface__array_slice(array, dimen, cnumElem, csrcStart,
      csrcStride, cnewStart);
    }

  if(ret_ptr != NULL) {  
    ret_array = sidl_Java_I2J_new_array(env,ret_ptr,
      "sidl.BaseInterface$Array");
    }

  return ret_array;
  }


/**
 * 
 * Native routine to decrement the current array reference count.
 * 
 */

/**
 * 
 * Native routine converts Java array of object to sidl array
 * I'm sorry it's so complex, but the nature of working with the
 * JNI is such that I couldn't think of anyway but a big case statement
 * to make this work efficently
 * 
 */
static void sidl_BaseInterface__fromArray(
JNIEnv* env,
jobject obj,
jobjectArray orray,
jint dim,
jintArray _upper,
jboolean isRow)
{
  int i,j,k,l,m,n,o;
  jint upper[7];
  jint lower[7] = {0,0,0,0,0,0,0};
  jclass exceptionClass = NULL;
  jintArray _lower = (*env)->NewIntArray(env, 7);
  (*env)->GetIntArrayRegion(env, _upper, 0, 7, upper);
  (*env)->SetIntArrayRegion(env, _lower, 0, 7, lower);
  sidl_BaseInterface__reallocate(env, obj, dim, _lower, _upper, isRow);
  (*env)->DeleteLocalRef(env, _lower);

  switch(dim) {
    case 1:
    for(i = 0; i <= upper[0]; ++i) {
      jobject tmp = (*env)->GetObjectArrayElement(env,orray, i);
      sidl_BaseInterface__set(env,obj,i,0,0,0,0,0,0,tmp);
      (*env)->DeleteLocalRef(env, tmp);
      }
    break;
    case 2:
    for(j = 0; j <= upper[0]; ++j) {
      jobjectArray orray1 = (*env)->GetObjectArrayElement(env,orray, j);
      for(i = 0; i <= upper[1]; ++i) {
        jobject tmp = (*env)->GetObjectArrayElement(env,orray1, i);
        sidl_BaseInterface__set(env,obj,j,i,0,0,0,0,0,tmp);
        (*env)->DeleteLocalRef(env, tmp);
        }
      (*env)->DeleteLocalRef(env, orray1);
      }
    break;
    case 3:
    for(k = 0; k <= upper[0]; ++k) {
      jobjectArray orray1 = (*env)->GetObjectArrayElement(env,orray, k);
      for(j = 0; j <= upper[1]; ++j) {
        jobjectArray orray2 = (*env)->GetObjectArrayElement(env,orray1, j);
        for(i = 0; i <= upper[2]; ++i) {
          jobject tmp = (*env)->GetObjectArrayElement(env,orray2, i);
          sidl_BaseInterface__set(env,obj,k,j,i,0,0,0,0,tmp);
          (*env)->DeleteLocalRef(env, tmp);
          }
        (*env)->DeleteLocalRef(env, orray2);
        }
      (*env)->DeleteLocalRef(env, orray1);
      }

    break;
    case 4:
    for(l = 0; l <= upper[0]; ++l) {
      jobjectArray orray1 = (*env)->GetObjectArrayElement(env,orray, l);
      for(k = 0; k <= upper[1]; ++k) {
        jobjectArray orray2 = (*env)->GetObjectArrayElement(env,orray1, k);
        for(j = 0; j <= upper[2]; ++j) {
          jobjectArray orray3 = (*env)->GetObjectArrayElement(env,orray2, j);
          for(i = 0; i <= upper[3]; ++i) {
            jobject tmp = (*env)->GetObjectArrayElement(env,orray3, i);
            sidl_BaseInterface__set(env,obj,l,k,j,i,0,0,0,tmp);
            (*env)->DeleteLocalRef(env, tmp);
            }
          (*env)->DeleteLocalRef(env, orray3);
          }
        (*env)->DeleteLocalRef(env, orray2);
        }   
      (*env)->DeleteLocalRef(env, orray1);
      }
    (*env)->DeleteLocalRef(env, orray);

    break;
    case 5:
    for(m = 0; m <= upper[0]; ++m) {
      jobjectArray orray1 = (*env)->GetObjectArrayElement(env,orray, m);   
      for(l = 0; l <= upper[1]; ++l) {
        jobjectArray orray2 = (*env)->GetObjectArrayElement(env,orray1, l);
        for(k = 0; k <= upper[2]; ++k) {
          jobjectArray orray3 = (*env)->GetObjectArrayElement(env,orray2, k);
          for(j = 0; j <= upper[3]; ++j) {
            jobjectArray orray4 = (*env)->GetObjectArrayElement(env,orray3, j);
            for(i = 0; i <= upper[4]; ++i) {
              jobject tmp = (*env)->GetObjectArrayElement(env,orray4, i);
              sidl_BaseInterface__set(env,obj,m,l,k,j,i,0,0,tmp);
              (*env)->DeleteLocalRef(env, tmp);
              }
            (*env)->DeleteLocalRef(env, orray4);
            }
          (*env)->DeleteLocalRef(env, orray3);
          }   
        (*env)->DeleteLocalRef(env, orray2);
        }
      (*env)->DeleteLocalRef(env, orray1);
      }
    (*env)->DeleteLocalRef(env, orray);

    break;
    case 6:
    for(n = 0; n <= upper[0]; ++n) {
      jobjectArray orray1 = (*env)->GetObjectArrayElement(env,orray, n);   
      for(m = 0; m <= upper[1]; ++m) {
        jobjectArray orray2 = (*env)->GetObjectArrayElement(env,orray1, m);   
        for(l = 0; l <= upper[2]; ++l) {
          jobjectArray orray3 = (*env)->GetObjectArrayElement(env,orray2, l);
          for(k = 0; k <= upper[3]; ++k) {
            jobjectArray orray4 = (*env)->GetObjectArrayElement(env,orray3, k);
            for(j = 0; j <= upper[4]; ++j) {
              jobjectArray orray5 = (*env)->GetObjectArrayElement(env,orray4,
                j);
              for(i = 0; i <= upper[5]; ++i) {
                jobject tmp = (*env)->GetObjectArrayElement(env,orray5, i);
                sidl_BaseInterface__set(env,obj,n,m,l,k,j,i,0,tmp);
                (*env)->DeleteLocalRef(env, tmp);
                }
              (*env)->DeleteLocalRef(env, orray5);
              }
            (*env)->DeleteLocalRef(env, orray4);
            }   
          (*env)->DeleteLocalRef(env, orray3);
          }
        (*env)->DeleteLocalRef(env, orray2);
        }
      (*env)->DeleteLocalRef(env, orray1);
      }
    (*env)->DeleteLocalRef(env, orray);

    break;
    case 7:
    for(o = 0; o <= upper[0]; ++o) {
      jobjectArray orray1 = (*env)->GetObjectArrayElement(env,orray, o);   
      for(n = 0; n <= upper[1]; ++n) {
        jobjectArray orray2 = (*env)->GetObjectArrayElement(env,orray1, n);   
        for(m = 0; m <= upper[2]; ++m) {
          jobjectArray orray3 = (*env)->GetObjectArrayElement(env,orray2, m);   
          for(l = 0; l <= upper[3]; ++l) {
            jobjectArray orray4 = (*env)->GetObjectArrayElement(env,orray3, l);
            for(k = 0; k <= upper[4]; ++k) {
              jobjectArray orray5 = (*env)->GetObjectArrayElement(env,orray4,
                k);
              for(j = 0; j <= upper[5]; ++j) {
                jobjectArray orray6 = (*env)->GetObjectArrayElement(env,orray5,
                  j);
                for(i = 0; i <= upper[6]; ++i) {
                  jobject tmp = (*env)->GetObjectArrayElement(env,orray6, i);
                  sidl_BaseInterface__set(env,obj,o,n,m,l,k,j,i,tmp);
                  (*env)->DeleteLocalRef(env, tmp);
                  }
                (*env)->DeleteLocalRef(env, orray6);
                }
              (*env)->DeleteLocalRef(env, orray5);
              }   
            (*env)->DeleteLocalRef(env, orray4);
            }
          (*env)->DeleteLocalRef(env, orray3);
          }
        (*env)->DeleteLocalRef(env, orray2);
        }
      (*env)->DeleteLocalRef(env, orray1);
      }
    (*env)->DeleteLocalRef(env, orray);
    break;
    default:
    exceptionClass = (*env)->FindClass(env,
      "java/lang/IllegalArgumentException");
    (*env)->ThrowNew(env, exceptionClass,
      "JNI:_fromArray: Array dimensions must be between 1-7!");
    }
  }
/*
 * Register JNI methods with the Java JVM.
 */

void sidl_BaseInterface__register(JNIEnv* env)
{
  JNINativeMethod methods[6];
  jclass cls;

  methods[0].name      = "addRef";
  methods[0].signature = "()V";
  methods[0].fnPtr     = (void *)jni_addRef;
  methods[1].name      = "deleteRef";
  methods[1].signature = "()V";
  methods[1].fnPtr     = (void *)jni_deleteRef;
  methods[2].name      = "isSame";
  methods[2].signature = "(Lsidl/BaseInterface;)Z";
  methods[2].fnPtr     = (void *)jni_isSame;
  methods[3].name      = "queryInt";
  methods[3].signature = "(Ljava/lang/String;)Lsidl/BaseInterface;";
  methods[3].fnPtr     = (void *)jni_queryInt;
  methods[4].name      = "isType";
  methods[4].signature = "(Ljava/lang/String;)Z";
  methods[4].fnPtr     = (void *)jni_isType;
  methods[5].name      = "getClassInfo";
  methods[5].signature = "()Lsidl/ClassInfo;";
  methods[5].fnPtr     = (void *)jni_getClassInfo;


  cls = (*env)->FindClass(env, "sidl/BaseInterface$Wrapper");
  if (cls) {
    (*env)->RegisterNatives(env, cls, methods, 6);
    (*env)->DeleteLocalRef(env, cls);
  }
  JNINativeMethod methods1[6];
  jclass cls1;

  methods1[0].name      = "_get";
  methods1[0].signature = "(IIIIIII)Lsidl/BaseInterface$Wrapper;";
  methods1[0].fnPtr     = sidl_BaseInterface__get;
  methods1[1].name      = "_set";
  methods1[1].signature = "(IIIIIIILsidl/BaseInterface;)V";
  methods1[1].fnPtr     = sidl_BaseInterface__set;
  methods1[2].name      = "_reallocate";
  methods1[2].signature = "(I[I[IZ)V";
  methods1[2].fnPtr     = sidl_BaseInterface__reallocate;
  methods1[3].name      = "_copy";
  methods1[3].signature = "(Lsidl/BaseInterface$Array;)V";
  methods1[3].fnPtr     = sidl_BaseInterface__copy;  
  methods1[4].name      = "_slice";
  methods1[4].signature = "(I[I[I[I[I)Lsidl/BaseInterface$Array;";
  methods1[4].fnPtr     = sidl_BaseInterface__slice;    
  methods1[5].name      = "_fromArray";
  methods1[5].signature = "([Ljava/lang/Object;I[IZ)V";
  methods1[5].fnPtr     = sidl_BaseInterface__fromArray;


  cls1 = (*env)->FindClass(env, "sidl/BaseInterface$Array");
  if (cls1) {
    (*env)->RegisterNatives(env, cls1, methods1, 6);
    (*env)->DeleteLocalRef(env, cls1);
  }
}
