/*
 * File:          sidlx_io_TxtIStream_Impl.c
 * Symbol:        sidlx.io.TxtIStream-v0.1
 * Symbol Type:   class
 * Babel Version: 0.10.2
 * Description:   Server-side implementation for sidlx.io.TxtIStream
 * 
 * WARNING: Automatically generated; only changes within splicers preserved
 * 
 * babel-version = 0.10.2
 */

/*
 * DEVELOPERS ARE EXPECTED TO PROVIDE IMPLEMENTATIONS
 * FOR THE FOLLOWING METHODS BETWEEN SPLICER PAIRS.
 */

/*
 * Symbol "sidlx.io.TxtIStream" (version 0.1)
 * 
 * Simple text-based input stream 
 * some datatypes (e.g. strings, arrays, etc require special formatting)
 * undefined behavior with non-whitespace separated fields.
 */

#include "sidlx_io_TxtIStream_Impl.h"

#line 28 "../../../babel/runtime/sidlx/sidlx_io_TxtIStream_Impl.c"
/* DO-NOT-DELETE splicer.begin(sidlx.io.TxtIStream._includes) */
#include "sidlx_common.h"
/* DO-NOT-DELETE splicer.end(sidlx.io.TxtIStream._includes) */
#line 32 "sidlx_io_TxtIStream_Impl.c"

/*
 * Static class initializer called exactly once before any user-defined method is dispatched
 */

#undef __FUNC__
#define __FUNC__ "impl_sidlx_io_TxtIStream__load"

void
impl_sidlx_io_TxtIStream__load(
  void)
{
#line 43 "../../../babel/runtime/sidlx/sidlx_io_TxtIStream_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sidlx.io.TxtIStream._load) */
  /* Insert the implementation of the static class initializer method here... */
  /* DO-NOT-DELETE splicer.end(sidlx.io.TxtIStream._load) */
#line 49 "sidlx_io_TxtIStream_Impl.c"
}
/*
 * Class constructor called when the class is created.
 */

#undef __FUNC__
#define __FUNC__ "impl_sidlx_io_TxtIStream__ctor"

void
impl_sidlx_io_TxtIStream__ctor(
  /* in */ sidlx_io_TxtIStream self)
{
#line 58 "../../../babel/runtime/sidlx/sidlx_io_TxtIStream_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sidlx.io.TxtIStream._ctor) */
  struct sidlx_io_TxtIStream__data *data = (struct sidlx_io_TxtIStream__data *)
    malloc( sizeof (  struct sidlx_io_TxtIStream__data) );
  data->filedes = -1;
  sidlx_io_TxtIStream__set_data(self,data);
  /* DO-NOT-DELETE splicer.end(sidlx.io.TxtIStream._ctor) */
#line 69 "sidlx_io_TxtIStream_Impl.c"
}

/*
 * Class destructor called when the class is deleted.
 */

#undef __FUNC__
#define __FUNC__ "impl_sidlx_io_TxtIStream__dtor"

void
impl_sidlx_io_TxtIStream__dtor(
  /* in */ sidlx_io_TxtIStream self)
{
#line 77 "../../../babel/runtime/sidlx/sidlx_io_TxtIStream_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sidlx.io.TxtIStream._dtor) */
  struct sidlx_io_TxtIStream__data *data = sidlx_io_TxtIStream__get_data(self);
  if (data) { 
    free((void*)data);
  }
  sidlx_io_TxtIStream__set_data(self,NULL);
  /* DO-NOT-DELETE splicer.end(sidlx.io.TxtIStream._dtor) */
#line 91 "sidlx_io_TxtIStream_Impl.c"
}

/*
 * Method:  setFD[]
 */

#undef __FUNC__
#define __FUNC__ "impl_sidlx_io_TxtIStream_setFD"

void
impl_sidlx_io_TxtIStream_setFD(
  /* in */ sidlx_io_TxtIStream self,
  /* in */ int32_t fd)
{
#line 98 "../../../babel/runtime/sidlx/sidlx_io_TxtIStream_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sidlx.io.TxtIStream.setFD) */
  sidlx_io_TxtIStream__get_data(self)->filedes=fd;
  /* DO-NOT-DELETE splicer.end(sidlx.io.TxtIStream.setFD) */
#line 110 "sidlx_io_TxtIStream_Impl.c"
}

/*
 * returns true iff the stream is at its end, or closed 
 */

#undef __FUNC__
#define __FUNC__ "impl_sidlx_io_TxtIStream_atEnd"

sidl_bool
impl_sidlx_io_TxtIStream_atEnd(
  /* in */ sidlx_io_TxtIStream self)
{
#line 114 "../../../babel/runtime/sidlx/sidlx_io_TxtIStream_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sidlx.io.TxtIStream.atEnd) */
  /* Insert the implementation of the atEnd method here... */
  /* DO-NOT-DELETE splicer.end(sidlx.io.TxtIStream.atEnd) */
#line 128 "sidlx_io_TxtIStream_Impl.c"
}

/*
 * low level read an array of bytes 
 */

#undef __FUNC__
#define __FUNC__ "impl_sidlx_io_TxtIStream_read"

int32_t
impl_sidlx_io_TxtIStream_read(
  /* in */ sidlx_io_TxtIStream self,
  /* in */ int32_t nbytes,
  /* out */ struct sidl_char__array** data,
  /* out */ sidl_BaseInterface *_ex)
{
#line 133 "../../../babel/runtime/sidlx/sidlx_io_TxtIStream_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sidlx.io.TxtIStream.read) */
  int fd = sidlx_io_TxtIStream__get_data(self)->filedes;;
  int n = s_readn( fd, nbytes, data, _ex ); SIDL_CHECK(*_ex);
 EXIT:
  return n;

  /* DO-NOT-DELETE splicer.end(sidlx.io.TxtIStream.read) */
#line 153 "sidlx_io_TxtIStream_Impl.c"
}

/*
 * low level read 
 */

#undef __FUNC__
#define __FUNC__ "impl_sidlx_io_TxtIStream_readline"

int32_t
impl_sidlx_io_TxtIStream_readline(
  /* in */ sidlx_io_TxtIStream self,
  /* out */ struct sidl_char__array** data,
  /* out */ sidl_BaseInterface *_ex)
{
#line 155 "../../../babel/runtime/sidlx/sidlx_io_TxtIStream_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sidlx.io.TxtIStream.readline) */
  int fd;
  int maxlen=4*1024;
  int n;
  fd = sidlx_io_TxtIStream__get_data(self)->filedes;
  
  n = s_readline( fd, maxlen, data, _ex ); SIDL_CHECK(*_ex);
 EXIT:
  return n;
  /* DO-NOT-DELETE splicer.end(sidlx.io.TxtIStream.readline) */
#line 180 "sidlx_io_TxtIStream_Impl.c"
}

/*
 * Method:  get[Bool]
 */

#undef __FUNC__
#define __FUNC__ "impl_sidlx_io_TxtIStream_getBool"

void
impl_sidlx_io_TxtIStream_getBool(
  /* in */ sidlx_io_TxtIStream self,
  /* out */ sidl_bool* item,
  /* out */ sidl_BaseInterface *_ex)
{
#line 180 "../../../babel/runtime/sidlx/sidlx_io_TxtIStream_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sidlx.io.TxtIStream.getBool) */
  const int fd = sidlx_io_TxtIStream__get_data(self)->filedes;
  char buffer[2];
  int32_t k = s_readn2( fd, 1, &buffer, _ex); SIDL_CHECK(*_ex);
  if ( k>=1 ) { 
    if (buffer[0]=='T') { 
      *item = TRUE;
    } else if ( buffer[0]=='F') { 
      *item = FALSE;
    } else { 
      /* format error */
      SIDL_THROW( *_ex, sidlx_io_IOException,"format error: expected 'T' or 'F'");
    }
  } else { 
    SIDL_THROW( *_ex, sidlx_io_IOException,"I/O error: insufficient data read");
  }
 
 EXIT:
  return;
  /* DO-NOT-DELETE splicer.end(sidlx.io.TxtIStream.getBool) */
#line 217 "sidlx_io_TxtIStream_Impl.c"
}

/*
 * Method:  get[Char]
 */

#undef __FUNC__
#define __FUNC__ "impl_sidlx_io_TxtIStream_getChar"

void
impl_sidlx_io_TxtIStream_getChar(
  /* in */ sidlx_io_TxtIStream self,
  /* out */ char* item,
  /* out */ sidl_BaseInterface *_ex)
{
#line 215 "../../../babel/runtime/sidlx/sidlx_io_TxtIStream_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sidlx.io.TxtIStream.getChar) */
  const int fd = sidlx_io_TxtIStream__get_data(self)->filedes;
  char buffer[2];
  ssize_t k = s_readn2( fd, 1, &buffer, _ex); SIDL_CHECK(*_ex);
  if ( k>=1 ) { 
    *item = buffer[0];
  } else { 
    SIDL_THROW( *_ex, sidlx_io_IOException,"I/O error: insufficient data read");
  }
  
 EXIT:
  return;
  /* DO-NOT-DELETE splicer.end(sidlx.io.TxtIStream.getChar) */
#line 247 "sidlx_io_TxtIStream_Impl.c"
}

/*
 * Method:  get[Int]
 */

#undef __FUNC__
#define __FUNC__ "impl_sidlx_io_TxtIStream_getInt"

void
impl_sidlx_io_TxtIStream_getInt(
  /* in */ sidlx_io_TxtIStream self,
  /* out */ int32_t* item,
  /* out */ sidl_BaseInterface *_ex)
{
#line 243 "../../../babel/runtime/sidlx/sidlx_io_TxtIStream_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sidlx.io.TxtIStream.getInt) */
  const int fd = sidlx_io_TxtIStream__get_data(self)->filedes;
  char buffer[5]; /*int32_t is 4 bytes */
		    
  ssize_t k = s_readn2( fd, 4, &buffer, _ex); SIDL_CHECK(*_ex);
  /* should massage the buffer to be portable */

  if ( k>=1 ) { 
    *item = (int32_t) *buffer;
  } else { 
    SIDL_THROW( *_ex, sidlx_io_IOException,"I/O error: insufficient data read");
  }
    
 EXIT:
  return;
  /* DO-NOT-DELETE splicer.end(sidlx.io.TxtIStream.getInt) */
#line 280 "sidlx_io_TxtIStream_Impl.c"
}

/*
 * Method:  get[Long]
 */

#undef __FUNC__
#define __FUNC__ "impl_sidlx_io_TxtIStream_getLong"

void
impl_sidlx_io_TxtIStream_getLong(
  /* in */ sidlx_io_TxtIStream self,
  /* out */ int64_t* item,
  /* out */ sidl_BaseInterface *_ex)
{
#line 274 "../../../babel/runtime/sidlx/sidlx_io_TxtIStream_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sidlx.io.TxtIStream.getLong) */
  /* Insert the implementation of the getLong method here... */
  /* DO-NOT-DELETE splicer.end(sidlx.io.TxtIStream.getLong) */
#line 300 "sidlx_io_TxtIStream_Impl.c"
}

/*
 * Method:  get[Float]
 */

#undef __FUNC__
#define __FUNC__ "impl_sidlx_io_TxtIStream_getFloat"

void
impl_sidlx_io_TxtIStream_getFloat(
  /* in */ sidlx_io_TxtIStream self,
  /* out */ float* item,
  /* out */ sidl_BaseInterface *_ex)
{
#line 292 "../../../babel/runtime/sidlx/sidlx_io_TxtIStream_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sidlx.io.TxtIStream.getFloat) */
  /* Insert the implementation of the getFloat method here... */
  /* DO-NOT-DELETE splicer.end(sidlx.io.TxtIStream.getFloat) */
#line 320 "sidlx_io_TxtIStream_Impl.c"
}

/*
 * Method:  get[Double]
 */

#undef __FUNC__
#define __FUNC__ "impl_sidlx_io_TxtIStream_getDouble"

void
impl_sidlx_io_TxtIStream_getDouble(
  /* in */ sidlx_io_TxtIStream self,
  /* out */ double* item,
  /* out */ sidl_BaseInterface *_ex)
{
#line 310 "../../../babel/runtime/sidlx/sidlx_io_TxtIStream_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sidlx.io.TxtIStream.getDouble) */
  /* Insert the implementation of the getDouble method here... */
  /* DO-NOT-DELETE splicer.end(sidlx.io.TxtIStream.getDouble) */
#line 340 "sidlx_io_TxtIStream_Impl.c"
}

/*
 * Method:  get[Fcomplex]
 */

#undef __FUNC__
#define __FUNC__ "impl_sidlx_io_TxtIStream_getFcomplex"

void
impl_sidlx_io_TxtIStream_getFcomplex(
  /* in */ sidlx_io_TxtIStream self,
  /* out */ struct sidl_fcomplex* item,
  /* out */ sidl_BaseInterface *_ex)
{
#line 328 "../../../babel/runtime/sidlx/sidlx_io_TxtIStream_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sidlx.io.TxtIStream.getFcomplex) */
  /* Insert the implementation of the getFcomplex method here... */
  /* DO-NOT-DELETE splicer.end(sidlx.io.TxtIStream.getFcomplex) */
#line 360 "sidlx_io_TxtIStream_Impl.c"
}

/*
 * Method:  get[Dcomplex]
 */

#undef __FUNC__
#define __FUNC__ "impl_sidlx_io_TxtIStream_getDcomplex"

void
impl_sidlx_io_TxtIStream_getDcomplex(
  /* in */ sidlx_io_TxtIStream self,
  /* out */ struct sidl_dcomplex* item,
  /* out */ sidl_BaseInterface *_ex)
{
#line 346 "../../../babel/runtime/sidlx/sidlx_io_TxtIStream_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sidlx.io.TxtIStream.getDcomplex) */
  /* Insert the implementation of the getDcomplex method here... */
  /* DO-NOT-DELETE splicer.end(sidlx.io.TxtIStream.getDcomplex) */
#line 380 "sidlx_io_TxtIStream_Impl.c"
}

/*
 * Method:  get[String]
 */

#undef __FUNC__
#define __FUNC__ "impl_sidlx_io_TxtIStream_getString"

void
impl_sidlx_io_TxtIStream_getString(
  /* in */ sidlx_io_TxtIStream self,
  /* out */ char** item,
  /* out */ sidl_BaseInterface *_ex)
{
#line 364 "../../../babel/runtime/sidlx/sidlx_io_TxtIStream_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sidlx.io.TxtIStream.getString) */
  /* Insert the implementation of the getString method here... */
  /* DO-NOT-DELETE splicer.end(sidlx.io.TxtIStream.getString) */
#line 400 "sidlx_io_TxtIStream_Impl.c"
}
