/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend;

import gov.llnl.babel.backend.BuildGenerator;
import gov.llnl.babel.backend.CodeGenerator;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;

public class CodeGenerationFactory {
    private static String[] s_classList = new String[]{"gov.llnl.babel.backend.ior.GenerateIOR", "gov.llnl.babel.backend.c.GenerateClientC", "gov.llnl.babel.backend.c.GenerateServerC", "gov.llnl.babel.backend.python.GenPythonClient", "gov.llnl.babel.backend.python.GenPythonServer", "gov.llnl.babel.backend.cxx.GenerateCxxClient", "gov.llnl.babel.backend.cxx.GenerateCxxServer", "gov.llnl.babel.backend.fortran.GenerateClient", "gov.llnl.babel.backend.fortran.GenerateServer", "gov.llnl.babel.backend.jdk.GenerateClientJava", "gov.llnl.babel.backend.jdk.GenerateServerJava", "gov.llnl.babel.backend.MakefileGenerator", "gov.llnl.babel.backend.python.DualGenerator", "gov.llnl.babel.backend.sidl.GenerateSidl"};
    private static CodeGenerationFactory s_instance = null;
    private HashMap m_hashmap = new HashMap();
    private HashMap m_buildmap = new HashMap();

    private CodeGenerationFactory() {
    }

    public static CodeGenerationFactory getInstance() {
        if (s_instance == null) {
            s_instance = new CodeGenerationFactory();
            int i = 0;
            while (i < s_classList.length) {
                try {
                    Class<?> cls = Class.forName(s_classList[i]);
                    Object obj = cls.newInstance();
                    boolean matches = false;
                    if (obj instanceof CodeGenerator) {
                        matches = true;
                        s_instance.registerCodeGenerator((CodeGenerator)obj);
                    }
                    if (obj instanceof BuildGenerator) {
                        matches = true;
                        s_instance.registerBuildGenerator((BuildGenerator)obj);
                    }
                    if (!matches) {
                        System.err.println("Babel: Warning: backend extension '" + s_classList[i] + "' is neither a code or build generator. Ignoring it.");
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    System.err.println("Babel: Error: Unable to find backend '" + s_classList[i] + "'. Check your Java classpath.");
                    cnfe.printStackTrace(System.err);
                }
                catch (Exception e) {
                    System.err.println("Babel: Error: Unable to instantiate backend '" + s_classList[i] + "'.");
                    e.printStackTrace(System.err);
                }
                catch (LinkageError e) {
                    System.err.println("Babel: Error: Unable to load backend '" + s_classList[i] + "'. Linkage problem.");
                    e.printStackTrace(System.err);
                }
                ++i;
            }
        }
        return s_instance;
    }

    private void registerCodeGenerator(CodeGenerator gen) {
        Iterator i = gen.getLanguages().iterator();
        String mode = gen.getType();
        while (i.hasNext()) {
            String lang = (String)i.next();
            String key = this.hashLanguageAndType(lang, mode);
            this.m_hashmap.put(key, gen);
        }
    }

    private void registerBuildGenerator(BuildGenerator gen) {
        Iterator i = gen.getLanguages().iterator();
        while (i.hasNext()) {
            this.m_buildmap.put((String)i.next(), gen);
        }
    }

    public BuildGenerator getBuildGenerator(String language) {
        return (BuildGenerator)this.m_buildmap.get(language);
    }

    public CodeGenerator getCodeGenerator(String language, String mode) {
        String key = this.hashLanguageAndType(language, mode);
        return (CodeGenerator)this.m_hashmap.get(key);
    }

    private String hashLanguageAndType(String language, String mode) {
        String hash = language + "-" + mode;
        return hash.toLowerCase();
    }

    public void printRegisteredGenerators(PrintStream out) {
        out.println("Registered CodeGenerators = " + this.m_hashmap.size());
        Iterator it = this.m_hashmap.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            CodeGenerator gen = (CodeGenerator)this.m_hashmap.get(key);
            out.println("   key = \"" + key);
        }
    }
}

