/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend;

import gov.llnl.babel.BabelConfiguration;
import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.CodeSplicer;
import gov.llnl.babel.backend.FileListener;
import gov.llnl.babel.backend.writers.ChangeWriter;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.SymbolUtilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public class FileManager {
    private static FileManager s_instance = null;
    private boolean d_package_dirs = true;
    private boolean d_glue_dirs = false;
    private boolean d_language_dir;
    private File d_root_dir;
    private File d_vpath_dir;
    private Collection d_listeners = new LinkedList();

    protected FileManager() {
    }

    public static FileManager getInstance() {
        if (s_instance == null) {
            s_instance = new FileManager();
        }
        return s_instance;
    }

    public void addListener(FileListener listener) {
        this.d_listeners.add(listener);
    }

    public void removeListener(FileListener listener) {
        this.d_listeners.remove(listener);
    }

    private void notifyListeners(SymbolID id, int type, String role, String dir, String name) {
        Iterator i = this.d_listeners.iterator();
        while (i.hasNext()) {
            FileListener l = (FileListener)i.next();
            l.newFile(id, type, role, dir, name);
        }
    }

    public static void setInstance(FileManager instance) {
        s_instance = instance;
    }

    public boolean getJavaStylePackageGeneration() {
        return this.d_package_dirs;
    }

    public void setJavaStylePackageGeneration(boolean java_style) {
        this.d_package_dirs = java_style;
    }

    public void setGlueSubdirGeneration(boolean glue_dir) {
        this.d_glue_dirs = glue_dir;
    }

    public boolean getGlueSubdirGeneration() {
        return this.d_glue_dirs;
    }

    public void setVPathDirectory(String directory) throws CodeGenerationException {
        if (directory == null || directory.equals("") || directory.equals(".")) {
            this.d_vpath_dir = null;
            return;
        }
        File d = new File(directory);
        if (d.isFile()) {
            throw new CodeGenerationException("'" + directory + "' is a file, not a directory.");
        }
        if (!d.isDirectory()) {
            throw new CodeGenerationException("'" + directory + "' not found.");
        }
        this.d_vpath_dir = d;
    }

    public void setFileGenerationRootDirectory(String directory) throws CodeGenerationException {
        if (directory == null || directory.equals("") || directory.equals(".")) {
            this.d_root_dir = null;
            return;
        }
        File d = new File(directory);
        if (d.isFile()) {
            throw new CodeGenerationException("'" + directory + "' is a file, not a directory.");
        }
        if (!d.isDirectory() && !d.mkdirs()) {
            throw new CodeGenerationException("'" + directory + "' can neither be found nor created as a directory.");
        }
        this.d_root_dir = d;
    }

    public PrintWriter createFile(SymbolID id, int type, String groupname, String filename) throws CodeGenerationException {
        return new PrintWriter(this.createWriter(id, type, groupname, filename));
    }

    public Writer createWriter(SymbolID id, int type, String groupname, String filename) throws CodeGenerationException {
        if (id == null || groupname == null || filename == null || filename.equals("")) {
            throw new CodeGenerationException("Non-null, non-empty input parameters required.");
        }
        File dir = this.expandDirectory(id, type);
        BabelConfiguration babel_config = BabelConfiguration.getInstance();
        if (babel_config.makeLanguageSubdir()) {
            dir = this.expandLanguageSubdir(id, dir, babel_config.getTargetLanguage());
        }
        if (this.d_glue_dirs && !groupname.startsWith("IMPL")) {
            dir = this.expandGlueSubdir(id, dir);
        }
        String dirname = "";
        if (dir != null && !dir.toString().equals("")) {
            dir.mkdirs();
            dirname = dir.toString() + File.separator;
        }
        this.notifyListeners(id, type, groupname, dirname, filename);
        Writer writer = null;
        try {
            writer = ChangeWriter.createWriter(filename, dirname);
        }
        catch (IOException ex) {
            throw new CodeGenerationException(ex.getMessage());
        }
        return writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CodeSplicer getCodeSplicer(SymbolID id, int type, String file) throws IOException {
        File vpath_dir = this.expandVPathDirectory(id, type);
        File target_dir = this.expandDirectory(id, type);
        String path = "";
        String vpath = ".";
        CodeSplicer splicer = null;
        FileReader reader = null;
        if (target_dir != null && !target_dir.toString().equals("")) {
            path = path + target_dir.toString() + File.separator;
        }
        path = path + file;
        if (vpath_dir == null || vpath_dir.toString().equals("") || vpath_dir.toString().equals(".")) {
            vpath = path;
        } else {
            vpath = vpath_dir.toString() + File.separator + file;
            File f = new File(vpath);
            if (!(f.exists() && f.isFile() && f.canRead())) {
                vpath = path;
            }
        }
        try {
            try {
                reader = new FileReader(vpath);
                splicer = new CodeSplicer(new BufferedReader(reader), vpath, path);
            }
            catch (FileNotFoundException ex) {
                splicer = new CodeSplicer();
                Object var12_13 = null;
                if (reader == null) return splicer;
                reader.close();
                return splicer;
            }
            Object var12_12 = null;
            if (reader == null) return splicer;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            if (reader == null) throw throwable;
            reader.close();
            throw throwable;
        }
        reader.close();
        return splicer;
    }

    public File expandDirectory(SymbolID id, int type) {
        String path = "";
        if (this.d_root_dir != null) {
            path = path + this.d_root_dir.getPath() + File.separator;
        }
        if (id != null && this.d_package_dirs) {
            String pkg = null;
            pkg = type == 14 ? id.getFullName() : SymbolUtilities.getParentPackage(id.getFullName());
            path = path + pkg.replace('.', File.separatorChar) + File.separator;
        }
        if (path.equals("")) {
            return null;
        }
        return new File(path);
    }

    public File expandLanguageSubdir(SymbolID id, File file, String language) {
        String path = file.getPath();
        if (id != null && this.d_glue_dirs) {
            path = path + File.separator + language;
        }
        if (path.equals("")) {
            return null;
        }
        return new File(path);
    }

    public File expandGlueSubdir(SymbolID id, File file) {
        String path = file.getPath();
        if (id != null && this.d_glue_dirs) {
            path = path + File.separator + "glue";
        }
        if (path.equals("")) {
            return null;
        }
        return new File(path);
    }

    public File expandVPathDirectory(SymbolID id, int type) {
        File f;
        if (this.d_vpath_dir == null || this.d_vpath_dir.equals(this.d_root_dir)) {
            return null;
        }
        String path = this.d_vpath_dir.getPath() + File.separator;
        if (id != null && this.d_package_dirs) {
            String pkg = null;
            pkg = type == 14 ? id.getFullName() : SymbolUtilities.getParentPackage(id.getFullName());
            path = path + pkg.replace('.', File.separatorChar) + File.separator;
        }
        if ((f = new File(path)).isDirectory()) {
            return f;
        }
        return null;
    }
}

