/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.c;

import gov.llnl.babel.BabelConfiguration;
import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.IOR;
import gov.llnl.babel.backend.Utilities;
import gov.llnl.babel.backend.c.ArrayMethods;
import gov.llnl.babel.symbols.Argument;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.Type;
import gov.llnl.babel.symbols.Version;

public class C {
    private static final String[] s_types = new String[]{"void", "SIDL_bool", "char", "struct SIDL_dcomplex", "double", "struct SIDL_fcomplex", "float", "int32_t", "int64_t", "void*", "char*"};
    private static final String[] s_array_types = new String[]{null, "struct SIDL_bool__array*", "struct SIDL_char__array*", "struct SIDL_dcomplex__array*", "struct SIDL_double__array*", "struct SIDL_fcomplex__array*", "struct SIDL_float__array*", "struct SIDL_int__array*", "struct SIDL_long__array*", "struct SIDL_opaque__array*", "struct SIDL_string__array*"};
    private static String s_exceptionType = null;

    public static String getHeaderFile(SymbolID id) {
        return id.getFullName().replace('.', '_') + ".h";
    }

    public static String getStubFile(SymbolID id) {
        return id.getFullName().replace('.', '_') + "_Stub.c";
    }

    public static String getSkelFile(SymbolID id) {
        return id.getFullName().replace('.', '_') + "_Skel.c";
    }

    public static String getImplHeaderFile(SymbolID id) {
        return id.getFullName().replace('.', '_') + "_Impl.h";
    }

    public static String getImplSourceFile(SymbolID id) {
        return id.getFullName().replace('.', '_') + "_Impl.c";
    }

    public static String getDataName(SymbolID id) {
        return "struct " + id.getFullName().replace('.', '_') + "__data";
    }

    public static String getDataGetName(SymbolID id) {
        return id.getFullName().replace('.', '_') + "__get_data";
    }

    public static String getDataSetName(SymbolID id) {
        return id.getFullName().replace('.', '_') + "__set_data";
    }

    public static String getPrivateDestructor(SymbolID id) {
        return id.getFullName().replace('.', '_') + "__delete";
    }

    public static String getSymbolName(SymbolID id) {
        return id.getFullName().replace('.', '_');
    }

    public static String getEnumName(SymbolID id) {
        return "enum " + C.getSymbolName(id) + "__enum";
    }

    public static String getObjectName(SymbolID id) {
        return id.getFullName().replace('.', '_');
    }

    public static String getSetEPVName(SymbolID id) {
        return C.getSymbolName(id) + "__set_epv";
    }

    public static String getSetSEPVName(SymbolID id) {
        return C.getSymbolName(id) + "__set_sepv";
    }

    public static String getReturnString(Type type) throws CodeGenerationException {
        int t = type.getType();
        if (t < s_types.length) {
            return s_types[t];
        }
        if (t == 15) {
            Symbol symbol = Utilities.lookupSymbol(type.getSymbolID());
            if (symbol.getSymbolType() == 11) {
                return C.getEnumName(symbol.getSymbolID());
            }
            return C.getObjectName(symbol.getSymbolID());
        }
        if (t == 16) {
            Type atype = type.getArrayType();
            int a = atype.getType();
            if (a < s_array_types.length) {
                return s_array_types[a];
            }
            return IOR.getArrayName(atype.getSymbolID()) + "*";
        }
        return null;
    }

    public static String getArgumentString(Argument arg) throws CodeGenerationException {
        String s = C.getReturnString(arg.getType());
        int type = arg.getType().getType();
        if (arg.getMode() == 0) {
            if (type == 10) {
                s = "const " + s;
            }
        } else {
            s = s + "*";
        }
        return s;
    }

    public static String getArgumentWithFormal(Argument arg) throws CodeGenerationException {
        return C.getArgumentString(arg) + " " + arg.getFormalName();
    }

    public static String getMethodImplName(SymbolID id, String methodName) {
        return "impl_" + id.getFullName().replace('.', '_') + '_' + methodName;
    }

    public static String getMethodSkelName(SymbolID id, Method method) {
        return method.hasArrayOrderSpec() ? "skel_" + id.getFullName().replace('.', '_') + '_' + method.getLongMethodName() : C.getMethodImplName(id, method.getLongMethodName());
    }

    public static String getFullMethodName(SymbolID id, Method method) {
        return C.getSymbolName(id) + "_" + method.getLongMethodName();
    }

    public static String getFullMethodName(SymbolID id, String methodName) {
        return C.getSymbolName(id) + "_" + methodName;
    }

    public static String getEnsureArray(Type arrayType) {
        switch (arrayType.getDetailedType()) {
            case 12: 
            case 13: {
                return ArrayMethods.generateEnsureName(arrayType.getSymbolID());
            }
            case 11: {
                return "SIDL_int__array_ensure";
            }
        }
        return "SIDL_" + arrayType.getTypeString() + "__array_ensure";
    }

    public static String getDelRefArray(Type arrayType) {
        switch (arrayType.getDetailedType()) {
            case 12: 
            case 13: {
                return ArrayMethods.generateDelRefName(arrayType.getSymbolID());
            }
            case 11: {
                return "SIDL_int__array_deleteRef";
            }
        }
        return "SIDL_" + arrayType.getTypeString() + "__array_deleteRef";
    }

    public static String getExceptionType() {
        return s_exceptionType;
    }

    static {
        SymbolID id = new SymbolID(BabelConfiguration.getBaseException(), new Version());
        s_exceptionType = C.getObjectName(id);
    }
}

