/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.cxx;

import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.CodeSplicer;
import gov.llnl.babel.backend.FileManager;
import gov.llnl.babel.backend.Utilities;
import gov.llnl.babel.backend.cxx.Cxx;
import gov.llnl.babel.backend.writers.LanguageWriterForCxx;
import gov.llnl.babel.symbols.Extendable;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.SymbolID;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class CxxImplSource {
    private Extendable d_ext = null;
    private LanguageWriterForCxx d_writer = null;
    private CodeSplicer d_splicer = null;

    public CxxImplSource(Extendable ext) {
        this.d_ext = ext;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void generateCode() throws CodeGenerationException {
        SymbolID id = this.d_ext.getSymbolID();
        int type = this.d_ext.getSymbolType();
        String filename = Cxx.generateFilename(id, 1, 2);
        try {
            block4: {
                try {
                    this.d_splicer = FileManager.getInstance().getCodeSplicer(id, type, filename);
                    this.d_writer = Cxx.createSource(this.d_ext, 1, "IMPLSRCS");
                    this.d_splicer.setLineRedirector(this.d_writer);
                    this.writeIncludes();
                    this.writeCtorDtor();
                    this.writeSIDLDefinedMethods();
                    this.d_splicer.splice(this.d_ext.getSymbolID().getFullName() + "._misc", this.d_writer, "Put miscellaneous code here");
                    this.d_writer.println();
                    if (!this.d_splicer.hasUnusedSymbolEdits()) break block4;
                    this.d_writer.beginBlockComment(true);
                    this.d_writer.println("================= BEGIN UNREFERENCED METHOD(S) ================");
                    this.d_writer.println("The following code segment(s) belong to unreferenced method(s).");
                    this.d_writer.println("This can result from a method rename/removal in the SIDL file.");
                    this.d_writer.println("Move or remove the code in order to compile cleanly.");
                    this.d_writer.endBlockComment(true);
                    this.d_splicer.outputUnusedSymbolEdits(this.d_writer.getPrintWriter());
                    this.d_writer.writeCommentLine("================== END UNREFERENCED METHOD(S) =================");
                }
                catch (IOException ex) {
                    throw new CodeGenerationException("IOException : " + ex.getMessage());
                }
            }
            Object var6_4 = null;
            if (this.d_writer == null) return;
            this.d_writer.close();
            this.d_writer = null;
            return;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (this.d_writer == null) throw throwable;
            this.d_writer.close();
            this.d_writer = null;
            throw throwable;
        }
    }

    private void writeIncludes() {
        this.d_writer.generateInclude(Cxx.generateFilename(this.d_ext.getSymbolID(), 1, 1), false);
        this.d_writer.println();
        this.d_splicer.splice(this.d_ext.getSymbolID().getFullName() + "._includes", this.d_writer, "Put additional includes or other arbitrary code here...");
        this.d_writer.println();
    }

    private void writeCtorDtor() {
        this.d_writer.writeCommentLine("user defined constructor");
        this.d_writer.print("void " + Utilities.replace(this.d_ext.getSymbolID().getFullName(), ".", "::"));
        this.d_writer.println("_impl::_ctor() {");
        this.d_writer.increaseTabLevel();
        this.d_splicer.splice(this.d_ext.getSymbolID().getFullName() + "._ctor", this.d_writer, "add construction details here");
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("}");
        this.d_writer.println();
        this.d_writer.writeCommentLine("user defined destructor");
        this.d_writer.print("void " + Utilities.replace(this.d_ext.getSymbolID().getFullName(), ".", "::"));
        this.d_writer.println("_impl::_dtor() {");
        this.d_writer.increaseTabLevel();
        this.d_splicer.splice(this.d_ext.getSymbolID().getFullName() + "._dtor", this.d_writer, "add destruction details here");
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void writeSIDLDefinedMethods() throws CodeGenerationException {
        List static_methods = (List)this.d_ext.getStaticMethods(false);
        if (static_methods.size() > 0) {
            this.d_writer.writeCommentLine("user defined static methods:");
            Iterator m = static_methods.iterator();
            while (m.hasNext()) {
                Method method = (Method)m.next();
                this.generateMethod(method);
            }
        } else {
            this.d_writer.writeCommentLine("user defined static methods: (none)");
        }
        this.d_writer.println();
        List nonstatic_methods = (List)this.d_ext.getNonstaticMethods(false);
        if (nonstatic_methods.size() > 0) {
            this.d_writer.writeCommentLine("user defined non-static methods:");
            Iterator m = nonstatic_methods.iterator();
            while (m.hasNext()) {
                Method method = (Method)m.next();
                if (method.isAbstract()) continue;
                this.generateMethod(method);
            }
        } else {
            this.d_writer.writeCommentLine("user defined non-static methods: (none)");
        }
        this.d_writer.println();
    }

    private void generateMethod(Method method) throws CodeGenerationException {
        if (method == null) {
            return;
        }
        this.d_writer.writeComment(method, true);
        this.d_writer.println(Cxx.getReturnString(method.getReturnType()));
        this.d_writer.print(Utilities.replace(this.d_ext.getSymbolID().getFullName(), ".", "::"));
        this.d_writer.print("_impl::");
        this.d_writer.print(method.getShortMethodName());
        if (method.getArgumentList().size() > 0) {
            this.d_writer.println(" (");
            this.d_writer.increaseTabLevel();
            Cxx.generateArgumentList(this.d_writer, method);
            this.d_writer.println(" ) ");
            this.d_writer.decreaseTabLevel();
            Cxx.generateThrowsList(this.d_writer, method, false);
            this.d_writer.println("{");
        } else {
            this.d_writer.println(" () ");
            Cxx.generateThrowsList(this.d_writer, method, false);
            this.d_writer.println();
            this.d_writer.println("{");
        }
        this.d_writer.increaseTabLevel();
        this.d_splicer.splice(this.d_ext.getSymbolID().getFullName() + "." + method.getLongMethodName(), this.d_writer, "insert implementation here");
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("}");
        this.d_writer.println();
    }
}

