/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.fortran;

import gov.llnl.babel.BabelConfiguration;
import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.fortran.Fortran;
import gov.llnl.babel.backend.fortran.TypeModule;
import gov.llnl.babel.backend.mangler.FortranMangler;
import gov.llnl.babel.backend.mangler.NameMangler;
import gov.llnl.babel.backend.writers.LanguageWriter;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.Type;
import gov.llnl.babel.symbols.Version;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;

public class ArrayModule {
    private static final int s_maxArray = BabelConfiguration.getMaximumArray();
    private NameMangler d_mang;
    private LanguageWriter d_lw;
    private SymbolID d_id;
    private String d_privateSuffix = "_p";
    private String d_intType;
    private boolean d_access;
    private boolean d_borrow;
    private boolean d_is_base_type;
    private static final String[] s_constant_methods = new String[]{"addRef", "copy", "createCol", "createRow", "deleteRef", "dimen", "ensure", "isColumnOrder", "isRowOrder", "is_null", "lower", "not_null", "set_null", "smartCopy", "stride", "upper"};
    private String d_implDataType;
    private SymbolID d_implID;

    private String getImplArrayType(int dim) {
        return "type(" + Fortran.getArrayName(this.d_id, dim) + ")";
    }

    private String getPrivateName(String name, int dim) {
        return name + dim + this.d_privateSuffix;
    }

    private void initImplID(int type) throws CodeGenerationException {
        this.d_access = true;
        this.d_borrow = true;
        switch (type) {
            case 0: {
                throw new CodeGenerationException("Cannot create an array for a void");
            }
            case 12: 
            case 13: 
            case 15: {
                this.d_access = false;
                this.d_borrow = false;
                this.d_is_base_type = false;
                this.d_implID = this.d_id;
                break;
            }
            case 11: {
                this.d_is_base_type = false;
                this.d_access = false;
                this.d_borrow = false;
                this.d_implID = new SymbolID("SIDL.int", new Version());
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 10: {
                this.d_access = false;
                this.d_borrow = false;
            }
            default: {
                this.d_is_base_type = true;
                this.d_implID = new SymbolID("SIDL." + new Type(type).getTypeString(), new Version());
            }
        }
    }

    public ArrayModule(SymbolID id, int type, LanguageWriter lw) throws CodeGenerationException {
        try {
            boolean isEnum = 11 == type;
            this.d_id = id;
            this.d_lw = lw;
            this.d_mang = new FortranMangler(31, 21);
            this.d_implDataType = type <= 10 ? Fortran.getReturnString(new Type(type)) : Fortran.getReturnString(new Type(id));
            this.d_intType = Fortran.getReturnString(new Type(7));
            this.initImplID(type);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new CodeGenerationException(nsae.getMessage());
        }
    }

    private void generateIsNull(int dim) {
        this.d_lw.println("logical function " + this.getPrivateName("is_null", dim) + "(array)");
        this.d_lw.increaseTabLevel();
        this.d_lw.println(this.getImplArrayType(dim) + ", intent(in) :: array");
        this.d_lw.println(this.getPrivateName("is_null", dim) + " = (array%d_array .eq. 0)");
        this.d_lw.decreaseTabLevel();
        this.d_lw.println("end function " + this.getPrivateName("is_null", dim));
        this.d_lw.println();
    }

    private void generateNotNull(int dim) {
        this.d_lw.println("logical function " + this.getPrivateName("not_null", dim) + "(array)");
        this.d_lw.increaseTabLevel();
        this.d_lw.println(this.getImplArrayType(dim) + ", intent(in) :: array");
        this.d_lw.println(this.getPrivateName("not_null", dim) + " = (array%d_array .ne. 0)");
        this.d_lw.decreaseTabLevel();
        this.d_lw.println("end function " + this.getPrivateName("not_null", dim));
        this.d_lw.println();
    }

    private void generateSetNull(int dim) {
        this.d_lw.println("subroutine " + this.getPrivateName("set_null", dim) + "(array)");
        this.d_lw.increaseTabLevel();
        this.d_lw.println(this.getImplArrayType(dim) + ", intent(out) :: array");
        this.d_lw.println("array%d_array = 0");
        if (this.d_access) {
            this.d_lw.println("nullify(array%d_data)");
        }
        this.d_lw.decreaseTabLevel();
        this.d_lw.println("end subroutine " + this.getPrivateName("set_null", dim));
        this.d_lw.println();
    }

    private void generateNullRelated(int dim) {
        this.generateIsNull(dim);
        this.generateNotNull(dim);
        this.generateSetNull(dim);
    }

    private void generateCreate(String type, int dim) throws UnsupportedEncodingException {
        String createFunc = "create" + type;
        String function = this.d_mang.shortArrayName(this.d_implID.getFullName(), createFunc, "_m");
        this.d_lw.beginBlockComment(false);
        this.d_lw.println("The size of lower determines the dimension of the");
        this.d_lw.println("array.");
        this.d_lw.endBlockComment(false);
        this.d_lw.println("subroutine " + this.getPrivateName(createFunc, dim) + "(lower, upper, array)");
        this.d_lw.increaseTabLevel();
        this.d_lw.println(this.d_intType + ", dimension(" + dim + "), intent(in) :: lower");
        this.d_lw.println(this.d_intType + ", dimension(" + dim + "), intent(in) :: upper");
        this.d_lw.println(this.getImplArrayType(dim) + ", intent(out) :: array");
        this.d_lw.println("external " + function);
        this.d_lw.println("call " + function + "(" + dim + ", lower, upper, array)");
        this.d_lw.decreaseTabLevel();
        this.d_lw.println("end subroutine " + this.getPrivateName(createFunc, dim));
        this.d_lw.println();
    }

    private void generateCreate1d() throws UnsupportedEncodingException {
        String createFunc = "create1d";
        String function = this.d_mang.shortArrayName(this.d_implID.getFullName(), "create1d", "_m");
        this.d_lw.println("subroutine " + this.getPrivateName("create1d", 1) + "(len, array)");
        this.d_lw.increaseTabLevel();
        this.d_lw.println(this.d_intType + ", intent(in) :: len");
        this.d_lw.println(this.getImplArrayType(1) + ", intent(out) :: array");
        this.d_lw.println("external " + function);
        this.d_lw.println("call " + function + "(len, array)");
        this.d_lw.decreaseTabLevel();
        this.d_lw.println("end subroutine " + this.getPrivateName("create1d", 1));
        this.d_lw.println();
    }

    private void generateCreate2d(String type) throws UnsupportedEncodingException {
        String createFunc = "create2d" + type;
        String function = this.d_mang.shortArrayName(this.d_implID.getFullName(), createFunc, "_m");
        this.d_lw.println("subroutine " + this.getPrivateName(createFunc, 2) + "(m, n, array)");
        this.d_lw.increaseTabLevel();
        this.d_lw.println(this.d_intType + ", intent(in) :: m, n");
        this.d_lw.println(this.getImplArrayType(2) + ", intent(out) :: array");
        this.d_lw.println("external " + function);
        this.d_lw.println("call " + function + "(m, n, array)");
        this.d_lw.decreaseTabLevel();
        this.d_lw.println("end subroutine " + this.getPrivateName(createFunc, 2));
        this.d_lw.println();
    }

    private void generateCreates(int dim) throws UnsupportedEncodingException {
        this.generateCreate("Col", dim);
        this.generateCreate("Row", dim);
        if (dim == 1) {
            this.generateCreate1d();
        }
        if (dim == 2) {
            this.generateCreate2d("Col");
            this.generateCreate2d("Row");
        }
    }

    private void generateCopy(String func, int dim) throws UnsupportedEncodingException {
        String function = this.d_mang.shortArrayName(this.d_implID.getFullName(), func, "_m");
        this.d_lw.println("subroutine " + this.getPrivateName(func, dim) + "(src, dest)");
        this.d_lw.increaseTabLevel();
        this.d_lw.println(this.getImplArrayType(dim) + ", intent(in) :: src");
        this.d_lw.println(this.getImplArrayType(dim) + ", intent(in) :: dest");
        this.d_lw.println("external " + function);
        this.d_lw.println("call " + function + "(src, dest)");
        this.d_lw.decreaseTabLevel();
        this.d_lw.println("end subroutine " + this.getPrivateName(func, dim));
        this.d_lw.println();
    }

    private void generateSmartCopy(String func, int dim) throws UnsupportedEncodingException {
        String function = this.d_mang.shortArrayName(this.d_implID.getFullName(), func, "_m");
        this.d_lw.println("subroutine " + this.getPrivateName(func, dim) + "(src, dest)");
        this.d_lw.increaseTabLevel();
        this.d_lw.println(this.getImplArrayType(dim) + ", intent(in) :: src");
        this.d_lw.println(this.getImplArrayType(dim) + ", intent(out) :: dest");
        this.d_lw.println("integer(selected_int_kind(9)) :: dim");
        this.d_lw.println("external " + function);
        this.d_lw.println("dim = " + dim);
        this.d_lw.println("call " + function + "(src, " + dim + ", dest)");
        this.d_lw.decreaseTabLevel();
        this.d_lw.println("end subroutine " + this.getPrivateName(func, dim));
        this.d_lw.println();
    }

    private void generateCopies(int dim) throws UnsupportedEncodingException {
        this.generateCopy("copy", dim);
        this.generateSmartCopy("smartCopy", dim);
    }

    private void generateEnsure(int dim) throws UnsupportedEncodingException {
        String function = this.d_mang.shortArrayName(this.d_implID.getFullName(), "ensure", "_m");
        this.d_lw.println("subroutine " + this.getPrivateName("ensure", dim) + "(src, dim, ordering, result)");
        this.d_lw.increaseTabLevel();
        this.d_lw.println(this.getImplArrayType(dim) + ", intent(in)  :: src");
        this.d_lw.println(this.getImplArrayType(dim) + ", intent(out) :: result");
        this.d_lw.println(this.d_intType + ", intent(in) :: dim, ordering");
        this.d_lw.println("external " + function);
        this.d_lw.println("call " + function + "(src, " + dim + ", ordering, result)");
        this.d_lw.decreaseTabLevel();
        this.d_lw.println("end subroutine " + this.getPrivateName("ensure", dim));
        this.d_lw.println();
    }

    private void generateSlice(int dim) throws UnsupportedEncodingException {
        int j = 1;
        while (j <= dim) {
            String function = this.d_mang.shortArrayName(this.d_implID.getFullName(), "slice", "_m");
            this.d_lw.println("subroutine " + this.getPrivateName("slice" + j, dim) + "(src, numElem, srcStart, srcStride, newLower, result)");
            this.d_lw.increaseTabLevel();
            this.d_lw.println(this.getImplArrayType(dim) + ", intent(in)  :: src");
            this.d_lw.println(this.d_intType + ", dimension(" + dim + "), intent(in) :: numElem");
            this.d_lw.println(this.d_intType + ", dimension(" + dim + "), intent(in) :: srcStart, srcStride");
            this.d_lw.println(this.getImplArrayType(j) + ", intent(out) :: result");
            this.d_lw.println(this.d_intType + ", dimension(:), intent(in) :: newLower");
            this.d_lw.println("external " + function);
            this.d_lw.println("call " + function + "(src, " + j + ", numElem, srcStart, srcStride, newLower, result)");
            this.d_lw.decreaseTabLevel();
            this.d_lw.println("end subroutine " + this.getPrivateName("slice" + j, dim));
            this.d_lw.println();
            ++j;
        }
    }

    private void slicePrivateNames() {
        int i = 1;
        while (i <= s_maxArray) {
            int j = 1;
            while (j <= i) {
                this.d_lw.print(this.getPrivateName("slice" + j, i));
                if (i < s_maxArray || j < s_maxArray) {
                    this.d_lw.println(", &");
                }
                ++j;
            }
            ++i;
        }
        this.d_lw.println();
    }

    private void writeSliceInterface() {
        this.d_lw.println("private :: &");
        this.d_lw.increaseTabLevel();
        this.slicePrivateNames();
        this.d_lw.decreaseTabLevel();
        this.d_lw.println();
        this.d_lw.println("interface slice");
        this.d_lw.increaseTabLevel();
        this.d_lw.println("module procedure &");
        this.d_lw.increaseTabLevel();
        this.slicePrivateNames();
        this.d_lw.decreaseTabLevel();
        this.d_lw.decreaseTabLevel();
        this.d_lw.println("end interface");
        this.d_lw.println();
    }

    private void generateQuery(String func, String returnType, int dim) throws UnsupportedEncodingException {
        String function = this.d_mang.shortArrayName(this.d_implID.getFullName(), func, "_m");
        this.d_lw.println(returnType + " function  " + this.getPrivateName(func, dim) + "(array)");
        this.d_lw.increaseTabLevel();
        this.d_lw.println(this.getImplArrayType(dim) + ", intent(in)  :: array");
        this.d_lw.println("external " + function);
        this.d_lw.println("call " + function + "(array, " + this.getPrivateName(func, dim) + ")");
        this.d_lw.decreaseTabLevel();
        this.d_lw.println("end function " + this.getPrivateName(func, dim));
        this.d_lw.println();
    }

    private void generateOrderingTests(int dim) throws UnsupportedEncodingException {
        this.generateQuery("isColumnOrder", "logical", dim);
        this.generateQuery("isRowOrder", "logical", dim);
    }

    private void generateIndexedQuery(String func, int dim) throws UnsupportedEncodingException {
        String function = this.d_mang.shortArrayName(this.d_implID.getFullName(), func, "_m");
        this.d_lw.println(this.d_intType + " function  " + this.getPrivateName(func, dim) + "(array, index)");
        this.d_lw.increaseTabLevel();
        this.d_lw.println(this.getImplArrayType(dim) + ", intent(in)  :: array");
        this.d_lw.println(this.d_intType + ", intent(in) :: index");
        this.d_lw.println("external " + function);
        this.d_lw.println("call " + function + "(array, index, " + this.getPrivateName(func, dim) + ")");
        this.d_lw.decreaseTabLevel();
        this.d_lw.println("end function " + this.getPrivateName(func, dim));
        this.d_lw.println();
    }

    private void generateSizeQueries(int dim) throws UnsupportedEncodingException {
        this.generateQuery("dimen", this.d_intType, dim);
        this.generateIndexedQuery("stride", dim);
        this.generateIndexedQuery("lower", dim);
        this.generateIndexedQuery("upper", dim);
    }

    private void generateGenericGet(int dim) throws UnsupportedEncodingException {
        String function = this.d_mang.shortArrayName(this.d_implID.getFullName(), "get", "_m");
        this.d_lw.println("subroutine " + this.getPrivateName("getg", dim) + "(array, index, value)");
        this.d_lw.increaseTabLevel();
        this.d_lw.println(this.getImplArrayType(dim) + ", intent(in)  :: array");
        this.d_lw.println(this.d_intType + ", intent(in), dimension(" + dim + ") :: index");
        this.d_lw.println(this.d_implDataType + ", intent(out) :: value");
        this.d_lw.println("external " + function);
        this.d_lw.println("call " + function + "(array, index, value)");
        this.d_lw.decreaseTabLevel();
        this.d_lw.println("end subroutine " + this.getPrivateName("getg", dim));
        this.d_lw.println();
    }

    private void generateGet(int dim) throws UnsupportedEncodingException {
        String func = "get";
        String function = this.d_mang.shortArrayName(this.d_implID.getFullName(), "get" + dim, "_m");
        this.d_lw.println("subroutine " + this.getPrivateName("get", dim) + "(array, &");
        this.d_lw.increaseTabLevel();
        this.d_lw.increaseTabLevel();
        int i = 1;
        while (i <= dim) {
            this.d_lw.println("i" + i + ", &");
            ++i;
        }
        this.d_lw.println("value)");
        this.d_lw.decreaseTabLevel();
        this.d_lw.println(this.getImplArrayType(dim) + ", intent(in)  :: array");
        i = 1;
        while (i <= dim) {
            this.d_lw.println(this.d_intType + ", intent(in) :: i" + i);
            ++i;
        }
        this.d_lw.println(this.d_implDataType + ", intent(out) :: value");
        this.d_lw.println("external " + function);
        this.d_lw.println("call " + function + "(array, &");
        this.d_lw.increaseTabLevel();
        i = 1;
        while (i <= dim) {
            this.d_lw.println("i" + i + ", &");
            ++i;
        }
        this.d_lw.println("value)");
        this.d_lw.decreaseTabLevel();
        this.d_lw.decreaseTabLevel();
        this.d_lw.println("end subroutine " + this.getPrivateName("get", dim));
        this.d_lw.println();
    }

    private void generateGenericSet(int dim) throws UnsupportedEncodingException {
        String function = this.d_mang.shortArrayName(this.d_implID.getFullName(), "set", "_m");
        this.d_lw.println("subroutine " + this.getPrivateName("setg", dim) + "(array, index, value)");
        this.d_lw.increaseTabLevel();
        this.d_lw.println(this.getImplArrayType(dim) + ", intent(in)  :: array");
        this.d_lw.println(this.d_intType + ", intent(in), dimension(" + dim + ") :: index");
        this.d_lw.println(this.d_implDataType + ", intent(in) :: value");
        this.d_lw.println("external " + function);
        this.d_lw.println("call " + function + "(array, index, value)");
        this.d_lw.decreaseTabLevel();
        this.d_lw.println("end subroutine " + this.getPrivateName("setg", dim));
        this.d_lw.println();
    }

    private void generateSet(int dim) throws UnsupportedEncodingException {
        String func = "set";
        String function = this.d_mang.shortArrayName(this.d_implID.getFullName(), "set" + dim, "_m");
        this.d_lw.println("subroutine " + this.getPrivateName("set", dim) + "(array, &");
        this.d_lw.increaseTabLevel();
        this.d_lw.increaseTabLevel();
        int i = 1;
        while (i <= dim) {
            this.d_lw.println("i" + i + ", &");
            ++i;
        }
        this.d_lw.println("value)");
        this.d_lw.decreaseTabLevel();
        this.d_lw.println(this.getImplArrayType(dim) + ", intent(in)  :: array");
        i = 1;
        while (i <= dim) {
            this.d_lw.println(this.d_intType + ", intent(in) :: i" + i);
            ++i;
        }
        this.d_lw.println(this.d_implDataType + ", intent(in) :: value");
        this.d_lw.println("external " + function);
        this.d_lw.println("call " + function + "(array, &");
        this.d_lw.increaseTabLevel();
        i = 1;
        while (i <= dim) {
            this.d_lw.println("i" + i + ", &");
            ++i;
        }
        this.d_lw.println("value)");
        this.d_lw.decreaseTabLevel();
        this.d_lw.decreaseTabLevel();
        this.d_lw.println("end subroutine " + this.getPrivateName("set", dim));
        this.d_lw.println();
    }

    private void generateGetSet(int dim) throws UnsupportedEncodingException {
        this.generateGenericGet(dim);
        this.generateGenericSet(dim);
        this.generateGet(dim);
        this.generateSet(dim);
    }

    private void writePrivate(String method) {
        this.d_lw.println("private :: &");
        this.d_lw.increaseTabLevel();
        this.d_lw.print(this.getPrivateName(method, 1));
        int i = 2;
        while (i <= s_maxArray) {
            this.d_lw.println(", &");
            this.d_lw.print(this.getPrivateName(method, i));
            ++i;
        }
        this.d_lw.println();
        this.d_lw.decreaseTabLevel();
        this.d_lw.println();
    }

    private void writeInterface(String method) {
        String generic = method + "g";
        this.writePrivate(generic);
        this.writePrivate(method);
        this.d_lw.println("interface " + method);
        this.d_lw.increaseTabLevel();
        this.d_lw.println("module procedure &");
        this.d_lw.increaseTabLevel();
        int i = 1;
        while (i <= s_maxArray) {
            this.d_lw.println(this.getPrivateName(generic, i) + ", &");
            this.d_lw.print(this.getPrivateName(method, i));
            if (i < s_maxArray) {
                this.d_lw.println(", &");
            }
            ++i;
        }
        this.d_lw.decreaseTabLevel();
        this.d_lw.println();
        this.d_lw.decreaseTabLevel();
        this.d_lw.println("end interface");
        this.d_lw.println();
    }

    private void writeSingleInterface(String func, int dim) {
        this.d_lw.println("private :: " + this.getPrivateName(func, dim));
        this.d_lw.println();
        this.d_lw.println("interface " + func);
        this.d_lw.increaseTabLevel();
        this.d_lw.println("module procedure " + this.getPrivateName(func, dim));
        this.d_lw.decreaseTabLevel();
        this.d_lw.println("end interface");
        this.d_lw.println();
    }

    private void writeGenericInterface(String func) {
        this.writePrivate(func);
        this.d_lw.println("interface " + func);
        this.d_lw.increaseTabLevel();
        this.d_lw.println("module procedure &");
        this.d_lw.increaseTabLevel();
        this.d_lw.print(this.getPrivateName(func, 1));
        int i = 2;
        while (i <= s_maxArray) {
            this.d_lw.println(", &");
            this.d_lw.print(this.getPrivateName(func, i));
            ++i;
        }
        this.d_lw.println();
        this.d_lw.decreaseTabLevel();
        this.d_lw.decreaseTabLevel();
        this.d_lw.println("end interface");
        this.d_lw.println();
    }

    private void generateAccess(int dim) throws UnsupportedEncodingException {
        String function = this.d_mang.shortArrayName(this.d_implID.getFullName(), "access", "_m");
        this.d_lw.println("subroutine " + this.getPrivateName("access", dim) + "(array, ref, low, up, str, index)");
        this.d_lw.increaseTabLevel();
        this.d_lw.println("implicit none");
        this.d_lw.println(this.getImplArrayType(dim) + ", intent(in) :: array");
        this.d_lw.println(this.d_implDataType + ", dimension(1), intent(in) :: ref");
        this.d_lw.println(this.d_intType + ", intent(out), dimension(:) :: low, up, str");
        this.d_lw.println(this.d_intType + ", intent(out) :: index");
        this.d_lw.println("external " + function);
        this.d_lw.println("call " + function + "(array, ref, low, up, str, index)");
        this.d_lw.decreaseTabLevel();
        this.d_lw.println("end subroutine " + this.getPrivateName("access", dim));
    }

    private void generateBorrow(int dim) throws UnsupportedEncodingException {
        String func = "borrow";
        String function = this.d_mang.shortArrayName(this.d_implID.getFullName(), "borrow", "_m");
        this.d_lw.println("subroutine " + this.getPrivateName("borrow", dim) + "(first, low, up, astr, result)");
        this.d_lw.increaseTabLevel();
        this.d_lw.println(this.d_implDataType + ", intent(in) :: first");
        this.d_lw.println(this.d_intType + ", dimension(" + dim + "), intent(in) :: low, up, astr");
        this.d_lw.println(this.getImplArrayType(dim) + ", intent(out) :: result");
        this.d_lw.println("external " + function);
        this.d_lw.println("call " + function + "(first, " + dim + ", low, up, astr, result)");
        this.d_lw.decreaseTabLevel();
        this.d_lw.println("end subroutine " + this.getPrivateName("borrow", dim));
        this.d_lw.println();
    }

    private void generateDeclarations() throws UnsupportedEncodingException {
        if (this.d_is_base_type) {
            TypeModule.writeArrayType(this.d_lw, this.d_id, this.d_access ? this.d_implDataType : null);
        }
        int i = 0;
        while (i < s_constant_methods.length) {
            this.writeGenericInterface(s_constant_methods[i]);
            ++i;
        }
        this.writeSingleInterface("create1d", 1);
        this.writeSingleInterface("create2dRow", 2);
        this.writeSingleInterface("create2dCol", 2);
        this.writeSliceInterface();
        this.writeInterface("get");
        this.writeInterface("set");
        if (this.d_access) {
            this.writeGenericInterface("access");
        }
        if (this.d_borrow) {
            this.writeGenericInterface("borrow");
        }
    }

    private void generateRef(String func, int dim) throws UnsupportedEncodingException {
        String function = this.d_mang.shortArrayName(this.d_implID.getFullName(), func, "_m");
        this.d_lw.println("subroutine  " + this.getPrivateName(func, dim) + "(array)");
        this.d_lw.increaseTabLevel();
        this.d_lw.println(this.getImplArrayType(dim) + ", intent(in)  :: array");
        this.d_lw.println("external " + function);
        this.d_lw.println("call " + function + "(array)");
        this.d_lw.decreaseTabLevel();
        this.d_lw.println("end subroutine " + this.getPrivateName(func, dim));
        this.d_lw.println();
    }

    private void generateRefCounting(int dim) throws UnsupportedEncodingException {
        this.generateRef("addRef", dim);
        this.generateRef("deleteRef", dim);
    }

    private void generateImplementations() throws UnsupportedEncodingException {
        int i = 1;
        while (i <= s_maxArray) {
            this.generateCreates(i);
            this.generateCopies(i);
            this.generateEnsure(i);
            this.generateSlice(i);
            this.generateOrderingTests(i);
            this.generateSizeQueries(i);
            this.generateGetSet(i);
            this.generateRefCounting(i);
            this.generateNullRelated(i);
            if (this.d_access) {
                this.generateAccess(i);
            }
            if (this.d_borrow) {
                this.generateBorrow(i);
            }
            ++i;
        }
    }

    public void generateStub() throws CodeGenerationException {
        try {
            if (!this.d_is_base_type) {
                this.d_lw.printlnUnformatted("#include \"" + Fortran.getStubNameFile(this.d_id) + "\"");
            }
            this.d_lw.println("module " + Fortran.getArrayModule(this.d_id));
            this.d_lw.increaseTabLevel();
            if (!this.d_is_base_type) {
                this.d_lw.println("use " + Fortran.getTypeModule(this.d_id));
            }
            this.d_lw.println();
            this.generateDeclarations();
            this.d_lw.println();
            this.d_lw.decreaseTabLevel();
            this.d_lw.println("contains");
            this.d_lw.increaseTabLevel();
            this.d_lw.println();
            this.d_lw.println();
            this.generateImplementations();
            this.d_lw.decreaseTabLevel();
            this.d_lw.println("end module " + Fortran.getArrayModule(this.d_id));
        }
        catch (UnsupportedEncodingException uee) {
            throw new CodeGenerationException(uee.getMessage());
        }
    }
}

