/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.jdk;

import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.CodeGenerator;
import gov.llnl.babel.backend.FileManager;
import gov.llnl.babel.backend.jdk.ClientJNI;
import gov.llnl.babel.backend.jdk.ClientJava;
import gov.llnl.babel.backend.jdk.Java;
import gov.llnl.babel.backend.writers.LanguageWriterForC;
import gov.llnl.babel.backend.writers.LanguageWriterForJava;
import gov.llnl.babel.symbols.Extendable;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.SymbolTable;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class GenerateClientJava
implements CodeGenerator {
    public void generateCode(Set symbols) throws CodeGenerationException {
        Iterator s = symbols.iterator();
        while (s.hasNext()) {
            SymbolID id = (SymbolID)s.next();
            Symbol symbol = SymbolTable.getInstance().lookupSymbol(id);
            if (symbol == null) continue;
            this.generateJava(symbol);
            this.generateJNI(symbol);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateJava(Symbol symbol) throws CodeGenerationException {
        SymbolID id = symbol.getSymbolID();
        int type = symbol.getSymbolType();
        if (type != 14) {
            PrintWriter pw = null;
            try {
                String file = Java.getClientJavaFile(id);
                boolean f = FileManager.getInstance().getJavaStylePackageGeneration();
                FileManager.getInstance().setJavaStylePackageGeneration(true);
                pw = FileManager.getInstance().createFile(id, type, "STUBJAVA", file);
                FileManager.getInstance().setJavaStylePackageGeneration(f);
                LanguageWriterForJava writer = new LanguageWriterForJava(pw);
                ClientJava.generateCode(symbol, writer);
                Object var9_8 = null;
                if (pw != null) {
                    pw.close();
                }
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (pw != null) {
                    pw.close();
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateJNI(Symbol symbol) throws CodeGenerationException {
        int type = symbol.getSymbolType();
        SymbolID id = symbol.getSymbolID();
        if (symbol instanceof Extendable) {
            PrintWriter pw = null;
            try {
                String file = Java.getClientJNIFile(id);
                pw = FileManager.getInstance().createFile(id, type, "STUBSRCS", file);
                LanguageWriterForC writer = new LanguageWriterForC(pw);
                ClientJNI.generateCode((Extendable)symbol, writer);
                Object var8_7 = null;
                if (pw != null) {
                    pw.close();
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (pw != null) {
                    pw.close();
                }
                throw throwable;
            }
        }
    }

    public String getType() {
        return "stub";
    }

    public boolean getUserSymbolsOnly() {
        return false;
    }

    public Set getLanguages() {
        TreeSet<String> result = new TreeSet<String>();
        result.add("java");
        return result;
    }
}

