/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.jdk;

import gov.llnl.babel.BabelConfiguration;
import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.FileManager;
import gov.llnl.babel.backend.IOR;
import gov.llnl.babel.backend.jdk.Java;
import gov.llnl.babel.backend.writers.LanguageWriterForC;
import gov.llnl.babel.symbols.Argument;
import gov.llnl.babel.symbols.Extendable;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ServerJNI {
    private LanguageWriterForC d_writer;
    private Extendable d_ext;
    private static final String JPREFIX = "_j_";
    private static final String JRETURN = "_j_retval";
    private static final String CRETURN = "_retval";
    private static final String JPTR = "_jptr_";
    private static final String JCLS = "_jCls_";
    private static final String JCTORMID = "_jCtorMID_";

    public ServerJNI(Extendable ext, LanguageWriterForC writer) throws CodeGenerationException {
        if (ext == null) {
            throw new CodeGenerationException("Unexpected null extendable object");
        }
        this.d_ext = ext;
        this.d_writer = writer;
        SymbolID id = this.d_ext.getSymbolID();
        int type = this.d_ext.getSymbolType();
        String filename = Java.getServerJNIFile(id);
        System.out.println("JNISkel file: " + filename);
        this.d_writer.setLineBreakString(", ");
        this.d_writer.writeBanner(this.d_ext, filename, true, "Client-side JNI glue code for " + id.getFullName());
    }

    public ServerJNI(Extendable ext) throws CodeGenerationException {
        if (ext == null) {
            throw new CodeGenerationException("Unexpected null extendable object");
        }
        this.d_ext = ext;
        SymbolID id = this.d_ext.getSymbolID();
        int type = this.d_ext.getSymbolType();
        String filename = Java.getServerJNIFile(id);
        System.out.println("JNISkel file: " + filename);
        this.d_writer = new LanguageWriterForC(FileManager.getInstance().createFile(id, type, "SKELSRCS", filename));
        this.d_writer.setLineBreakString(", ");
        this.d_writer.writeBanner(this.d_ext, filename, true, "Client-side JNI glue code for " + id.getFullName());
    }

    public static void generateCode(Extendable symbol, LanguageWriterForC writer) throws CodeGenerationException {
        ServerJNI jni = new ServerJNI(symbol, writer);
        jni.generateCode();
    }

    public static void generateCode(Extendable symbol) throws CodeGenerationException {
        ServerJNI jni = new ServerJNI(symbol);
        jni.generateCode();
    }

    public synchronized void generateCode() throws CodeGenerationException {
        System.out.println("******************* Generate code - JNI Skel **************************");
        this.generateIncludes();
        this.generatePointerJLongConv();
        this.generateJNISkelData();
        this.generateInitData();
        this.generateCtor();
        this.generateDtor();
        List methods = (List)this.d_ext.getMethods(this.d_ext.isInterface());
        Iterator m = methods.iterator();
        while (m.hasNext()) {
            Method method = (Method)m.next();
            if (!this.d_ext.isInterface() && method.isAbstract()) continue;
            this.generateMethod(method);
            this.d_writer.println();
        }
        this.generateSetEPV();
        this.d_writer.close();
    }

    private void generateIncludes() {
        SymbolID id = this.d_ext.getSymbolID();
        this.d_writer.generateInclude("SIDL_Java.h", false);
        this.d_writer.generateInclude("SIDL_Loader.h", false);
        this.d_writer.generateInclude("SIDL_String.h", false);
        this.d_writer.generateInclude(IOR.getHeaderFile(id), false);
        this.d_writer.generateInclude("babel_config.h", false);
        this.d_writer.println();
    }

    private void generatePointerJLongConv() {
        this.d_writer.writeComment("Convert between jlong and void* pointers.", false);
        this.d_writer.disableLineBreak();
        this.d_writer.println("#if (SIZEOF_VOID_P == 8)");
        this.d_writer.println("#define JLONG_TO_POINTER(x) ((void*)(x))");
        this.d_writer.println("#define POINTER_TO_JLONG(x) ((jlong)(x))");
        this.d_writer.println("#else");
        this.d_writer.println("#define JLONG_TO_POINTER(x) ((void*)(int32_t)(x))");
        this.d_writer.println("#define POINTER_TO_JLONG(x) ((jlong)(int32_t)(x))");
        this.d_writer.println("#endif");
        this.d_writer.println();
        this.d_writer.println("#ifndef NULL");
        this.d_writer.println("#define NULL 0");
        this.d_writer.println("#endif");
        this.d_writer.println();
        this.d_writer.enableLineBreak();
    }

    private void generateJNISkelData() {
        this.d_writer.writeComment("JNISkel data struct to cache JNIEnv, class, and needed MID's", true);
        this.d_writer.print("static struct ");
        this.d_writer.println(this.d_ext.getSymbolID().getFullName().replace('.', '_') + "_jniSkel__data");
        this.d_writer.println("{");
        this.d_writer.increaseTabLevel();
        this.d_writer.println("JNIEnv *env;");
        this.d_writer.println("jclass thisCls;");
        this.d_writer.println("jmethodID ctorMID;");
        this.d_writer.println("jmethodID dtorMID;");
        List methods = (List)this.d_ext.getMethods(this.d_ext.isInterface());
        Iterator m = methods.iterator();
        while (m.hasNext()) {
            Method method = (Method)m.next();
            this.d_writer.println("jmethodID " + method.getShortMethodName() + "MID;");
        }
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("} data;");
        this.d_writer.println();
    }

    private void generateInitData() {
        this.d_writer.writeComment("Method to initialize struct members", true);
        this.d_writer.println("static void");
        this.d_writer.println("init_data(void)");
        this.d_writer.println("{");
        this.d_writer.increaseTabLevel();
        this.generateInitEnv();
        this.generateInitCls();
        this.generateJNIMethodID("ctor", null, false);
        this.generateJNIMethodID("dtor", "()V", false);
        List methods = (List)this.d_ext.getMethods(this.d_ext.isInterface());
        Iterator m = methods.iterator();
        while (m.hasNext()) {
            Method method = (Method)m.next();
            String name = method.getLongMethodName();
            String descriptor = Java.getJavaSignature(method);
            this.generateJNIMethodID(name, descriptor, method.isStatic());
        }
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void generateCtor() {
        SymbolID id = this.d_ext.getSymbolID();
        this.d_writer.writeComment("Constructor", true);
        this.d_writer.println("static void");
        this.d_writer.print(Java.getJNIFunction(IOR.getBuiltinMethod(2, id)) + "(");
        this.d_writer.println("struct " + id.getFullName().replace('.', '_') + "__object *self)");
        this.d_writer.println("{");
        this.d_writer.increaseTabLevel();
        this.d_writer.print("jobject this = ");
        String[] args1 = new String[]{"data.env", "data.thisCls", "data.ctorMID"};
        this.printCallToJNIMethod("NewObject", args1);
        this.d_writer.println(";");
        this.generateJNIException("");
        this.d_writer.print("self->d_data = ");
        String[] args2 = new String[]{"data.env", "this"};
        this.printCallToJNIMethod("NewGlobalRef", args2);
        this.d_writer.println(";");
        this.printCallToJNIMethod("DeleteLocalRef", args2);
        this.d_writer.println(";\n");
        this.generateJNIException("");
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("}\n");
    }

    private void generateDtor() {
        SymbolID id = this.d_ext.getSymbolID();
        this.d_writer.writeComment("Deconstructing method", true);
        this.d_writer.println("static void");
        this.d_writer.print(Java.getJNIFunction(IOR.getBuiltinMethod(3, id)) + "(");
        this.d_writer.println("struct " + id.getFullName().replace('.', '_') + "__object *self)");
        this.d_writer.println("{");
        this.d_writer.increaseTabLevel();
        String[] args1 = new String[]{"data.env", "(jobject)self->d_data, data.dtorMID"};
        this.printCallToJNIMethod("CallVoidMethod", args1);
        this.d_writer.println(";");
        this.generateJNIException("");
        String[] args2 = new String[]{"data.env", "(jobject)self->d_data"};
        this.printCallToJNIMethod("DeleteGlobalRef", args2);
        this.d_writer.println(";");
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("}\n");
    }

    private void generateMethod(Method method) throws CodeGenerationException {
        System.out.println("Generating method: jni_" + method.getShortMethodName());
        this.generateMethodHeader(method);
        this.generateMethodBody(method);
    }

    private void generateSetEPV() {
        SymbolID id = this.d_ext.getSymbolID();
        this.d_writer.println("void");
        this.d_writer.print(IOR.getSetEPVName(id));
        this.d_writer.print("(");
        this.d_writer.print(IOR.getEPVName(id));
        this.d_writer.println(" *epv) {");
        this.d_writer.increaseTabLevel();
        this.d_writer.writeCommentLine("initialize skel data struct");
        this.d_writer.println("init_data();");
        this.d_writer.println();
        this.d_writer.writeCommentLine("initialize builtin methods");
        this.initializeEPVMethodPointer(IOR.getBuiltinMethod(2, id), id);
        this.initializeEPVMethodPointer(IOR.getBuiltinMethod(3, id), id);
        this.d_writer.println();
        this.d_writer.writeCommentLine("initialize local methods");
        Iterator i = this.d_ext.getMethods(false).iterator();
        while (i.hasNext()) {
            Method m = (Method)i.next();
            if (m.isAbstract()) continue;
            this.initializeEPVMethodPointer(m, id);
        }
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void generateInitEnv() {
        this.d_writer.println("data.env = SIDL_Java_getEnv();");
        this.d_writer.println("if (data.env == NULL) {");
        this.d_writer.increaseTabLevel();
        this.d_writer.println("return;");
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("}");
    }

    private void generateInitCls() {
        this.d_writer.print("data.thisCls = ");
        String fullFilename = "\"" + this.d_ext.getSymbolID().getFullName().replace('.', '/') + "_Impl\"";
        String[] args = new String[]{"data.env", fullFilename};
        this.printCallToJNIMethod("FindClass", args);
        this.d_writer.println(";");
        this.generateJNIException("");
    }

    private void generateJNIMethodID(String name, String descriptor, boolean isStatic) {
        this.d_writer.print("data." + name + "MID = ");
        if (name.equals("ctor")) {
            String[] args1;
            String[] args = args1 = new String[]{"data.env", "data.thisCls", "\"<init>\"", "\"()V\""};
            this.printCallToJNIMethod("GetMethodID", args);
        } else {
            String[] args1;
            String[] args = args1 = new String[]{"data.env", "data.thisCls", "\"" + name + "\"", "\"" + descriptor + "\""};
            if (isStatic) {
                this.printCallToJNIMethod("GetStaticMethodID", args);
            } else {
                this.printCallToJNIMethod("GetMethodID", args);
            }
        }
        this.d_writer.println(";");
        this.generateJNIException("");
    }

    private void generateMethodHeader(Method m) throws CodeGenerationException {
        this.d_writer.writeComment(m, false);
        this.d_writer.print("static ");
        this.d_writer.println(IOR.getReturnString(m.getReturnType()));
        this.d_writer.println(Java.getJNIFunction(m) + "(");
        this.d_writer.increaseTabLevel();
        this.d_writer.print("struct " + this.d_ext.getSymbolID().getFullName().replace('.', '_') + "__object *self");
        ArrayList args = m.getArgumentList();
        if (args.isEmpty()) {
            this.d_writer.println(")");
        } else {
            this.d_writer.println(",");
            Iterator a = args.iterator();
            while (a.hasNext()) {
                Argument arg = (Argument)a.next();
                this.d_writer.print(IOR.getArgumentWithFormal(arg));
                this.d_writer.println(a.hasNext() ? "," : ")");
            }
        }
        this.d_writer.decreaseTabLevel();
    }

    private void generateMethodBody(Method m) throws CodeGenerationException {
        this.d_writer.println("{");
        this.d_writer.increaseTabLevel();
        String[] methodArgs = this.generateSetUpForCallback(m);
        this.generateCallback(m, methodArgs);
        this.generateJNIException(Java.getDefaultJNIReturnValue(m));
        this.processOutInout(m, methodArgs);
        this.generateReturn(m);
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("}");
    }

    private String[] generateSetUpForCallback(Method m) throws CodeGenerationException {
        ArrayList args = m.getArgumentList();
        String[] methodArgs = new String[args.size()];
        if (!m.isStatic()) {
            this.d_writer.writeCommentLine("Reference to the object");
            this.d_writer.println("jobject this = (jobject)(self->d_data);");
            this.d_writer.println();
        }
        this.declareJNIArgsList(args, methodArgs);
        this.declareJNIReturn(m.getReturnType());
        if (!args.isEmpty()) {
            this.d_writer.writeCommentLine("Initialize JNI variables");
            int i = 0;
            Iterator a = args.iterator();
            while (a.hasNext()) {
                Argument arg = (Argument)a.next();
                this.printInitJVariable(arg, methodArgs[i]);
                ++i;
            }
            this.d_writer.println();
        }
        return methodArgs;
    }

    private void declareJNIArgsList(List args, String[] methodArgs) {
        if (!args.isEmpty()) {
            this.d_writer.writeCommentLine("JNI variables for parameters");
            int i = 0;
            Iterator a = args.iterator();
            while (a.hasNext()) {
                String jID;
                String jtype;
                Argument arg = (Argument)a.next();
                if (arg.getMode() == 0 && arg.getType().getType() < 9 && arg.getType().getType() != 5 && arg.getType().getType() != 3) {
                    jtype = Java.getJNIReturnType(arg.getType());
                } else {
                    jtype = "jobject";
                    this.d_writer.println("static jclass _jCls_" + arg.getFormalName() + " = NULL;");
                    this.d_writer.println("static jmethodID _jCtorMID_" + arg.getFormalName() + " = NULL;");
                    if (arg.getType().getType() == 15) {
                        this.d_writer.println("jlong _jptr_" + arg.getFormalName() + " = POINTER_TO_JLONG(" + arg.getFormalName() + ");");
                    }
                }
                methodArgs[i] = jID = JPREFIX + arg.getFormalName();
                ++i;
                if (jtype.equals("jobject") || jtype.equals("jstring")) {
                    this.d_writer.println(jtype + " " + jID + " = NULL;");
                    continue;
                }
                this.d_writer.println(jtype + " " + jID + ";");
            }
            this.d_writer.println();
        }
    }

    private void declareJNIReturn(Type t) throws CodeGenerationException {
        if (t.getType() != 0) {
            this.d_writer.writeCommentLine("Return variables");
            String jrtype = Java.getJNIReturnType(t);
            this.d_writer.println(jrtype + " " + JRETURN + ";");
            if (t.getType() == 10) {
                this.d_writer.println("const char* _temp_str;");
            }
            String rtype = IOR.getReturnString(t);
            this.d_writer.println(rtype + " " + CRETURN + ";");
            this.d_writer.println();
        }
    }

    private void printInitJVariable(Argument arg, String varname) throws CodeGenerationException {
        switch (arg.getType().getType()) {
            case 0: {
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 16: {
                break;
            }
            case 3: 
            case 5: {
                if (arg.getMode() == 0) {
                    this.printInitInComplex(arg, varname);
                    break;
                }
                this.printInitInoutOut(arg, varname);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                if (arg.getMode() == 0) {
                    this.d_writer.print(varname + " = ");
                    this.d_writer.print("(" + Java.getJNIReturnType(arg.getType()) + ")");
                    this.d_writer.println(arg.getFormalName() + ";");
                    break;
                }
                this.printInitInoutOut(arg, varname);
                break;
            }
            case 10: {
                if (arg.getMode() == 0) {
                    String[] args = new String[]{"data.env", arg.getFormalName()};
                    this.d_writer.print(varname + " = ");
                    this.printCallToJNIMethod("NewStringUTF", args);
                    this.d_writer.println(";");
                    break;
                }
                this.printInitInoutOut(arg, varname);
                break;
            }
            case 15: {
                this.printInitObject(arg, varname);
                break;
            }
        }
    }

    private void printInitInoutOut(Argument arg, String varname) {
        String holderType = this.getSIDLHolderTypeName(arg.getType());
        String callSymbol = this.getSIDLConversionName(arg.getType());
        this.d_writer.print("if (_jCls_" + arg.getFormalName() + " == NULL");
        this.d_writer.println(") {");
        this.d_writer.increaseTabLevel();
        String fullFilename = "\"SIDL/" + holderType + "$Holder\"";
        String[] ctorargs = new String[]{"data.env", fullFilename};
        this.d_writer.print(JCLS + arg.getFormalName() + " = ");
        this.printCallToJNIMethod("FindClass", ctorargs);
        this.d_writer.println(";");
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("}");
        this.d_writer.print("if (_jCtorMID_" + arg.getFormalName() + " == NULL");
        this.d_writer.println(") {");
        this.d_writer.increaseTabLevel();
        this.d_writer.print(JCTORMID + arg.getFormalName() + " = ");
        String[] midargs = new String[]{"data.env", JCLS + arg.getFormalName(), "\"<init>\"", "\"()V\""};
        this.printCallToJNIMethod("GetMethodID", midargs);
        this.d_writer.println(";");
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("}");
        this.d_writer.print(varname + " = ");
        String[] initargs = new String[]{"data.env", JCLS + arg.getFormalName(), JCTORMID + arg.getFormalName()};
        this.printCallToJNIMethod("NewObject", initargs);
        this.d_writer.println(";");
        this.d_writer.print("SIDL_Java_I2J_" + callSymbol + "_holder");
        if (arg.getType().getType() == 5 || arg.getType().getType() == 3) {
            this.d_writer.println("(data.env," + varname + ", " + arg.getFormalName() + ");");
        } else {
            this.d_writer.println("(data.env," + varname + ", *" + arg.getFormalName() + ");");
        }
        this.d_writer.println();
    }

    private void printInitInComplex(Argument arg, String varname) {
        String holderType = this.getSIDLHolderTypeName(arg.getType());
        String callSymbol = this.getSIDLConversionName(arg.getType());
        this.d_writer.print("if (_jCls_" + arg.getFormalName() + " == NULL");
        this.d_writer.println(") {");
        this.d_writer.increaseTabLevel();
        String fullFilename = "\"SIDL/" + holderType + "\"";
        String[] ctorargs = new String[]{"data.env", fullFilename};
        this.d_writer.print(JCLS + arg.getFormalName() + " = ");
        this.printCallToJNIMethod("FindClass", ctorargs);
        this.d_writer.println(";");
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("}");
        this.d_writer.print("if (_jCtorMID_" + arg.getFormalName() + " == NULL");
        this.d_writer.println(") {");
        this.d_writer.increaseTabLevel();
        this.d_writer.print(JCTORMID + arg.getFormalName() + " = ");
        String[] midargs = new String[]{"data.env", JCLS + arg.getFormalName(), "\"<init>\"", "\"()V\""};
        this.printCallToJNIMethod("GetMethodID", midargs);
        this.d_writer.println(";");
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("}");
        this.d_writer.print(varname + " = ");
        this.d_writer.print("SIDL_Java_I2J_" + callSymbol);
        this.d_writer.println("(data.env, &" + arg.getFormalName() + ");");
    }

    private void printInitObject(Argument arg, String varname) {
        this.d_writer.print("if (_jCls_" + arg.getFormalName() + " == NULL");
        this.d_writer.println(") {");
        this.d_writer.increaseTabLevel();
        String fullFilename = ("\"" + arg.getType().getTypeString()).replace('.', '/') + "\"";
        String[] ctorargs = new String[]{"data.env", fullFilename};
        this.d_writer.print(JCLS + arg.getFormalName() + " = ");
        this.printCallToJNIMethod("FindClass", ctorargs);
        this.d_writer.println(";");
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("}");
        this.d_writer.print("if (_jCtorMID_" + arg.getFormalName() + " == NULL");
        this.d_writer.println(") {");
        this.d_writer.increaseTabLevel();
        this.d_writer.print(JCTORMID + arg.getFormalName() + " = ");
        String[] midargs = new String[]{"data.env", JCLS + arg.getFormalName(), "\"<init>\"", "\"(J)V\""};
        this.printCallToJNIMethod("GetMethodID", midargs);
        this.d_writer.println(";");
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("}");
        this.d_writer.print(varname + " = ");
        String[] objargs = new String[]{"data.env", JCLS + arg.getFormalName(), JCTORMID + arg.getFormalName(), JPTR + arg.getFormalName()};
        this.printCallToJNIMethod("NewObject", objargs);
        this.d_writer.println(";");
    }

    private String getSIDLHolderTypeName(Type t) {
        String holderType = null;
        switch (t.getType()) {
            case 0: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                break;
            }
            case 5: {
                holderType = "FloatComplex";
                break;
            }
            case 3: {
                holderType = "DoubleComplex";
                break;
            }
            case 7: {
                holderType = "Integer";
                break;
            }
            case 2: {
                holderType = "Character";
                break;
            }
            case 1: {
                holderType = "Boolean";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 16: {
                StringBuffer sb = new StringBuffer(t.getTypeString());
                sb.setCharAt(0, (char)(sb.charAt(0) - 32));
                holderType = sb.toString();
            }
        }
        return holderType;
    }

    private String getSIDLConversionName(Type t) {
        String callSymbol = null;
        switch (t.getType()) {
            case 0: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 16: {
                callSymbol = "array";
                break;
            }
            case 2: {
                callSymbol = "character";
                break;
            }
            case 1: {
                callSymbol = "boolean";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 15: {
                callSymbol = t.getTypeString();
            }
        }
        return callSymbol;
    }

    private void generateCallback(Method m, String[] methodArgs) throws CodeGenerationException {
        this.d_writer.writeCommentLine("Callback to java method");
        Type t = m.getReturnType();
        System.out.println("Return type number is: " + t.getType());
        String jniCallType = this.getJNICallbackType(t);
        if (t.getType() != 0) {
            this.d_writer.print("_j_retval = ");
        }
        String[] args = new String[3 + methodArgs.length];
        args[0] = "data.env";
        args[2] = "data." + m.getShortMethodName() + "MID";
        int i = 0;
        while (i < methodArgs.length) {
            args[i + 3] = methodArgs[i];
            ++i;
        }
        if (m.isStatic()) {
            args[1] = "data.thisCls";
            this.printCallToJNIMethod("CallStatic" + jniCallType + "Method", args);
        } else {
            args[1] = "this";
            this.printCallToJNIMethod("Call" + jniCallType + "Method", args);
        }
        this.d_writer.println(";");
    }

    private String getJNICallbackType(Type t) {
        String jniCallType = null;
        switch (t.getType()) {
            case 0: {
                jniCallType = "Void";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                jniCallType = "Object";
                break;
            }
            case 1: {
                jniCallType = "Boolean";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                StringBuffer sb = new StringBuffer(t.getTypeString());
                sb.setCharAt(0, (char)(sb.charAt(0) - 32));
                jniCallType = sb.toString();
                break;
            }
        }
        return jniCallType;
    }

    private void processOutInout(Method m, String[] methodArgs) {
        ArrayList args = m.getArgumentList();
        if (!args.isEmpty()) {
            this.d_writer.writeCommentLine("Postprocess inout/out args");
            int i = 0;
            Iterator a = args.iterator();
            while (a.hasNext()) {
                Argument arg = (Argument)a.next();
                if ((arg.getMode() == 2 || arg.getMode() == 1) && arg.getType().getType() != 15) {
                    if (arg.getType().getType() != 5 || arg.getType().getType() != 3) {
                        this.d_writer.print("*");
                    }
                    this.d_writer.print(arg.getFormalName() + " = ");
                    this.d_writer.print("SIDL_Java_J2I_" + this.getSIDLConversionName(arg.getType()) + "_holder");
                    this.d_writer.println("(data.env," + methodArgs[i] + ");");
                }
                ++i;
            }
            this.d_writer.println();
        }
    }

    private void generateReturn(Method m) throws CodeGenerationException {
        switch (m.getReturnType().getType()) {
            case 0: {
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 16: {
                this.d_writer.println("_retval = _j_retval;");
                break;
            }
            case 15: {
                break;
            }
            case 3: 
            case 5: {
                this.d_writer.print("_retval = ");
                this.d_writer.print("SIDL_Java_J2I_" + this.getSIDLConversionName(m.getReturnType()));
                this.d_writer.println("(data.env,_j_retval);");
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                this.d_writer.println("_retval = (" + IOR.getReturnString(m.getReturnType()) + ")" + JRETURN + ";");
                break;
            }
            case 10: {
                this.generateNullCheckImmediateReturn(JRETURN, Java.getDefaultJNIReturnValue(m));
                String[] args = new String[]{"data.env", JRETURN, "NULL"};
                this.d_writer.print("_temp_str = ");
                this.printCallToJNIMethod("GetStringUTFChars", args);
                this.d_writer.println(";");
                this.d_writer.println("_retval = SIDL_String_strdup(_temp_str);");
                break;
            }
        }
        if (m.getReturnType().getType() >= 9 || m.getReturnType().getType() == 5 || m.getReturnType().getType() == 3) {
            String[] args2 = new String[]{"data.env", JRETURN};
            this.printCallToJNIMethod("DeleteLocalRef", args2);
            this.d_writer.println(";");
            this.generateJNIException(Java.getDefaultJNIReturnValue(m));
        }
        if (m.getReturnType().getType() != 0) {
            this.d_writer.println("return _retval;");
        }
    }

    private void generateNullCheckImmediateReturn(String var, String defaultReturn) {
        this.d_writer.print("if (" + var + " == NULL");
        this.d_writer.println(") {");
        this.d_writer.increaseTabLevel();
        this.d_writer.println("return " + defaultReturn + ";");
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("}");
    }

    private void generateJNIException(String defaultReturn) {
        this.d_writer.print("if (");
        String[] args = new String[]{"data.env"};
        this.printCallToJNIMethod("ExceptionOccurred", args);
        this.d_writer.println(") {");
        this.d_writer.increaseTabLevel();
        this.printCallToJNIMethod("ExceptionDescribe", args);
        this.d_writer.println(";");
        this.d_writer.println("return " + defaultReturn + ";");
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("}");
    }

    private void printCallToJNIMethod(String name, String[] args) {
        this.d_writer.print("(*data.env)->");
        this.d_writer.print(name + "(");
        int i = 0;
        while (i < args.length - 1) {
            this.d_writer.print(args[i] + ", ");
            ++i;
        }
        this.d_writer.print(args[args.length - 1] + ")");
    }

    private void initializeEPVMethodPointer(Method m, SymbolID id) {
        String methodName = m.getLongMethodName();
        switch (m.getDefinitionModifier()) {
            case 0: 
            case 2: {
                this.d_writer.print("epv->");
                this.d_writer.print(IOR.getVectorEntry(methodName));
                this.d_writer.print(" = ");
                this.d_writer.print(Java.getJNIFunction(m));
                this.d_writer.println(";");
                break;
            }
            case 1: {
                this.d_writer.print("epv->");
                this.d_writer.print(IOR.getVectorEntry(methodName));
                this.d_writer.println(" = NULL;");
                break;
            }
        }
    }

    private int countMethods() {
        int count;
        boolean isInterface = this.d_ext.isInterface();
        Collection methods = this.d_ext.getMethods(isInterface);
        if (isInterface) {
            count = methods.size();
        } else {
            count = 0;
            Iterator i = methods.iterator();
            while (i.hasNext()) {
                Method m = (Method)i.next();
                if (m.isAbstract()) continue;
                ++count;
            }
        }
        return count;
    }

    private void generateCodeOld(Extendable ext) throws CodeGenerationException {
        if (this.d_ext == null) {
            throw new CodeGenerationException("Unexpected null extendable object");
        }
        SymbolID id = this.d_ext.getSymbolID();
        String file = Java.getServerJNIFile(id);
        this.d_writer.writeBanner(this.d_ext, file, false, "Client-side JNI glue code for " + id.getFullName());
        this.d_writer.generateInclude("SIDL_Java.h", false);
        this.d_writer.generateInclude("SIDL_Loader.h", false);
        this.d_writer.generateInclude("SIDL_String.h", false);
        this.d_writer.generateInclude(IOR.getHeaderFile(id), false);
        this.d_writer.generateInclude("babel_config.h", false);
        this.d_writer.println();
        this.d_writer.writeComment("Convert between jlong and void* pointers.", false);
        this.d_writer.disableLineBreak();
        this.d_writer.println("#if (SIZEOF_VOID_P == 8)");
        this.d_writer.println("#define JLONG_TO_POINTER(x) ((void*)(x))");
        this.d_writer.println("#define POINTER_TO_JLONG(x) ((jlong)(x))");
        this.d_writer.println("#else");
        this.d_writer.println("#define JLONG_TO_POINTER(x) ((void*)(int32_t)(x))");
        this.d_writer.println("#define POINTER_TO_JLONG(x) ((jlong)(int32_t)(x))");
        this.d_writer.println("#endif");
        this.d_writer.println();
        this.d_writer.println("#ifndef NULL");
        this.d_writer.println("#define NULL 0");
        this.d_writer.println("#endif");
        this.d_writer.println();
        this.d_writer.enableLineBreak();
        boolean need_ior_function = this.d_ext.isInterface();
        if (!need_ior_function) {
            Iterator m = this.d_ext.getMethods(false).iterator();
            while (m.hasNext()) {
                Method method = (Method)m.next();
                if (method.isAbstract() || method.isStatic()) continue;
                need_ior_function = true;
                break;
            }
        }
        if (need_ior_function) {
            this.d_writer.writeComment("Function to extract IOR reference from the Java object.", false);
            this.d_writer.println("static " + IOR.getObjectName(id) + "* _get_ior(");
            this.d_writer.increaseTabLevel();
            this.d_writer.println("JNIEnv* env,");
            this.d_writer.println("jobject obj)");
            this.d_writer.decreaseTabLevel();
            this.d_writer.println("{");
            this.d_writer.increaseTabLevel();
            this.d_writer.println("void* ptr = NULL;");
            this.d_writer.println("static jmethodID mid = (jmethodID) NULL;");
            this.d_writer.println();
            this.d_writer.println("if (mid == (jmethodID) NULL) {");
            this.d_writer.increaseTabLevel();
            this.d_writer.println("jclass cls = (*env)->GetObjectClass(env, obj);");
            this.d_writer.println("mid = (*env)->GetMethodID(env, cls, \"_get_ior\", \"()J\");");
            this.d_writer.println("(*env)->DeleteLocalRef(env, cls);");
            this.d_writer.decreaseTabLevel();
            this.d_writer.println("}");
            this.d_writer.println();
            this.d_writer.println("ptr = JLONG_TO_POINTER((*env)->CallLongMethod(env, obj, mid));");
            this.d_writer.println("return (" + IOR.getObjectName(id) + "*) ptr;");
            this.d_writer.decreaseTabLevel();
            this.d_writer.println("}");
            this.d_writer.println();
        }
        if (!this.d_ext.isAbstract()) {
            this.d_writer.writeComment("External reference to IOR methods.", false);
            this.d_writer.println("static const " + IOR.getExternalName(id) + "* s_external = NULL;");
            this.d_writer.println();
        }
        if (this.d_ext.hasStaticMethod(false)) {
            this.d_writer.writeComment("External reference to static EPV.", false);
            this.d_writer.println("static const " + IOR.getSEPVName(id) + "* s_sepv = NULL;");
            this.d_writer.println();
        }
        if (!this.d_ext.isAbstract()) {
            this.d_writer.writeComment("Create object instance and return reference.", false);
            this.d_writer.println("static jlong jni__create_ior(");
            this.d_writer.increaseTabLevel();
            this.d_writer.println("JNIEnv* env,");
            this.d_writer.println("jclass  cls)");
            this.d_writer.decreaseTabLevel();
            this.d_writer.println("{");
            this.d_writer.increaseTabLevel();
            this.d_writer.println("(void) env;");
            this.d_writer.println("(void) cls;");
            this.d_writer.println("return POINTER_TO_JLONG((*s_external->createObject)());");
            this.d_writer.decreaseTabLevel();
            this.d_writer.println("}");
            this.d_writer.println();
        }
        List methods = (List)this.d_ext.getMethods(this.d_ext.isInterface());
        Iterator m = methods.iterator();
        while (m.hasNext()) {
            Method method = (Method)m.next();
            if (!this.d_ext.isInterface() && method.isAbstract()) continue;
            this.generateMethod(method);
            this.d_writer.println();
        }
        int nmethods = this.countMethods() + (this.d_ext.isAbstract() ? 0 : 1);
        this.d_writer.writeComment("Register JNI methods with the Java JVM.", false);
        this.d_writer.println("void " + Java.getRegisterFunction(id) + "(JNIEnv* env)");
        this.d_writer.println("{");
        this.d_writer.increaseTabLevel();
        if (nmethods > 0) {
            this.d_writer.println("JNINativeMethod methods[" + Integer.toString(nmethods) + "];");
            this.d_writer.println("jclass cls;");
            this.d_writer.println();
            if (!this.d_ext.isAbstract()) {
                if (BabelConfiguration.isSIDLBaseClass(id)) {
                    this.d_writer.println("s_external = " + IOR.getExternalFunc(id) + "();");
                } else {
                    this.d_writer.printlnUnformatted("#ifdef SIDL_STATIC_LIBRARY");
                    this.d_writer.println("s_external = " + IOR.getExternalFunc(id) + "();");
                    this.d_writer.printlnUnformatted("#else");
                    this.d_writer.println("void* address = SIDL_Loader_lookupSymbol(\"" + IOR.getExternalFunc(id) + "\");");
                    this.d_writer.println("if (address != NULL) {");
                    this.d_writer.increaseTabLevel();
                    this.d_writer.println("s_external = (*((" + IOR.getExternalName(id) + "* (*)(void)) address))();");
                    this.d_writer.decreaseTabLevel();
                    this.d_writer.println("} else {");
                    this.d_writer.increaseTabLevel();
                    this.d_writer.println("jclass e = (*env)->FindClass(env, \"java/lang/UnsatisfiedLinkError\");");
                    this.d_writer.println("if (e != NULL) {");
                    this.d_writer.increaseTabLevel();
                    this.d_writer.disableLineBreak();
                    this.d_writer.println("(*env)->ThrowNew(env, e, \"Could not find implementation for SIDL class " + id.getFullName() + "\");");
                    this.d_writer.enableLineBreak();
                    this.d_writer.println("(*env)->DeleteLocalRef(env, e);");
                    this.d_writer.decreaseTabLevel();
                    this.d_writer.println("}");
                    this.d_writer.decreaseTabLevel();
                    this.d_writer.println("}");
                    this.d_writer.printlnUnformatted("#endif");
                    this.d_writer.println();
                }
            }
            if (this.d_ext.hasStaticMethod(false)) {
                this.d_writer.println("s_sepv = (*(s_external->getStaticEPV))();");
                this.d_writer.println();
            }
            int idx = 0;
            if (!this.d_ext.isAbstract()) {
                this.d_writer.println("methods[0].name      = \"_create_ior\";");
                this.d_writer.println("methods[0].signature = \"()J\";");
                this.d_writer.println("methods[0].fnPtr     = (void *)jni__create_ior;");
                ++idx;
            }
            Iterator m2 = methods.iterator();
            while (m2.hasNext()) {
                Method method = (Method)m2.next();
                if (!this.d_ext.isInterface() && method.isAbstract()) continue;
                String prefix = "methods[" + Integer.toString(idx) + "].";
                this.d_writer.println(prefix + "name      = \"" + method.getShortMethodName() + "\";");
                this.d_writer.disableLineBreak();
                this.d_writer.println(prefix + "signature = \"" + Java.getJavaSignature(method) + "\";");
                this.d_writer.enableLineBreak();
                this.d_writer.println(prefix + "fnPtr     = (void *)" + Java.getJNIFunction(method) + ";");
                ++idx;
            }
            this.d_writer.println();
            String lookup_name = Java.getFullJavaSymbolName(id).replace('.', '/');
            if (this.d_ext.isInterface()) {
                lookup_name = lookup_name + "$Wrapper";
            }
            this.d_writer.println("cls = (*env)->FindClass(env, \"" + lookup_name + "\");");
            this.d_writer.println("if (cls) {");
            this.d_writer.increaseTabLevel();
            this.d_writer.println("(*env)->RegisterNatives(env, cls, methods, " + String.valueOf(nmethods) + ");");
            this.d_writer.println("(*env)->DeleteLocalRef(env, cls);");
            this.d_writer.decreaseTabLevel();
            this.d_writer.println("}");
        } else {
            this.d_writer.writeComment("Intentionally empty: no methods to register", false);
        }
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("}");
    }

    static {
        JPREFIX = JPREFIX;
        JRETURN = JRETURN;
        CRETURN = CRETURN;
        JPTR = JPTR;
        JCLS = JCLS;
        JCTORMID = JCTORMID;
    }
}

